/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.thaumcraft.research.frontend.domain.model;

import elan.tweaks.thaumcraft.research.frontend.domain.failures.DuplicationFailure;
import elan.tweaks.thaumcraft.research.frontend.domain.failures.MissingResearchFailure;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.ResearchProcessPort;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.ResearcherKnowledgePort;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.AspectPool;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.KnowledgeBase;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.PlayerInventory;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.ResearchNotes;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.ScribeTools;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.lib.research.ResearchNoteData;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001b\u001a\u00020\u0012H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001f\u0010 J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\"\u001a\u00020#H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b$\u0010%J\b\u0010&\u001a\u00020\u0012H\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\b\u0010(\u001a\u00020\u0012H\u0016J\b\u0010)\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0017H\u0016J.\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0017H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b-\u0010.R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006/"}, d2={"Lelan/tweaks/thaumcraft/research/frontend/domain/model/ResearchProcess;", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearchProcessPort;", "notes", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/ResearchNotes;", "pool", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/AspectPool;", "knowledgeBase", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/KnowledgeBase;", "scribeTools", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/ScribeTools;", "playerInventory", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/PlayerInventory;", "(Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/ResearchNotes;Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/AspectPool;Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/KnowledgeBase;Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/ScribeTools;Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/PlayerInventory;)V", "data", "Lthaumcraft/common/lib/research/ResearchNoteData;", "getData", "()Lthaumcraft/common/lib/research/ResearchNoteData;", "requiresInkToContinue", "", "getRequiresInkToContinue", "()Z", "usedAspectAmounts", "", "Lthaumcraft/api/aspects/Aspect;", "", "getUsedAspectAmounts", "()Ljava/util/Map;", "complete", "duplicate", "Lkotlin/Result;", "", "duplicate-d1pmJ48", "()Ljava/lang/Object;", "erase", "hexKey", "", "erase-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "notEditable", "notesCorrupted", "notesPresent", "readyToDuplicate", "shouldObfuscate", "aspect", "write", "write-gIAlu-s", "(Ljava/lang/String;Lthaumcraft/api/aspects/Aspect;)Ljava/lang/Object;", "ThaumcraftResearchTweaks"})
public final class ResearchProcess
implements ResearchProcessPort {
    @NotNull
    private final ResearchNotes notes;
    @NotNull
    private final AspectPool pool;
    @NotNull
    private final KnowledgeBase knowledgeBase;
    @NotNull
    private final ScribeTools scribeTools;
    @NotNull
    private final PlayerInventory playerInventory;

    public ResearchProcess(@NotNull ResearchNotes notes, @NotNull AspectPool pool, @NotNull KnowledgeBase knowledgeBase, @NotNull ScribeTools scribeTools, @NotNull PlayerInventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)notes, (String)"notes");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)knowledgeBase, (String)"knowledgeBase");
        Intrinsics.checkNotNullParameter((Object)scribeTools, (String)"scribeTools");
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        this.notes = notes;
        this.pool = pool;
        this.knowledgeBase = knowledgeBase;
        this.scribeTools = scribeTools;
        this.playerInventory = playerInventory;
    }

    @Override
    @NotNull
    public Map<Aspect, Integer> getUsedAspectAmounts() {
        return this.notes.findUsedAspectAmounts();
    }

    @Override
    public boolean getRequiresInkToContinue() {
        return this.scribeTools.areMissingOrEmpty();
    }

    @Override
    @Nullable
    public ResearchNoteData getData() {
        return this.notes.getData();
    }

    @Override
    @NotNull
    public Object duplicate-d1pmJ48() {
        return this.knowledgeBase.hasNotDiscovered(ResearcherKnowledgePort.Knowledge.ResearchDuplication) ? MissingResearchFailure.Companion.missingResearchDuplication-d1pmJ48() : (this.notReadyToDuplicate() ? DuplicationFailure.Companion.researchNotReady-d1pmJ48() : this.notes.duplicate-d1pmJ48());
    }

    @Override
    public boolean readyToDuplicate() {
        return this.notes.getPresent() && this.notes.getComplete() && this.pool.contains(this.getUsedAspectAmounts()) && this.playerInventory.containsPaper() && this.playerInventory.containsBlackDye();
    }

    @Override
    public boolean notEditable() {
        return this.missingNotes() || this.notes.getComplete() || this.notesCorrupted();
    }

    @Override
    public boolean notesPresent() {
        return this.notes.getPresent();
    }

    @Override
    public boolean notesCorrupted() {
        return !this.notes.getValid();
    }

    @Override
    public boolean complete() {
        return this.notes.getPresent() && this.notes.getComplete();
    }

    @Override
    public boolean shouldObfuscate(@NotNull Aspect aspect) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        return !this.pool.hasDiscovered(aspect);
    }

    @Override
    @NotNull
    public Object erase-IoAF18A(@NotNull String hexKey) {
        Intrinsics.checkNotNullParameter((Object)hexKey, (String)"hexKey");
        return this.notes.erase-IoAF18A(hexKey);
    }

    @Override
    @NotNull
    public Object write-gIAlu-s(@NotNull String hexKey, @NotNull Aspect aspect) {
        Intrinsics.checkNotNullParameter((Object)hexKey, (String)"hexKey");
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        return this.notes.write-gIAlu-s(hexKey, aspect);
    }

    @Override
    public boolean incomplete() {
        return ResearchProcessPort.DefaultImpls.incomplete(this);
    }

    @Override
    public boolean missingNotes() {
        return ResearchProcessPort.DefaultImpls.missingNotes(this);
    }

    @Override
    public boolean notReadyToDuplicate() {
        return ResearchProcessPort.DefaultImpls.notReadyToDuplicate(this);
    }
}

