/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.thaumcraft.research.frontend.domain.model;

import elan.tweaks.thaumcraft.research.frontend.domain.failures.AspectCombinationFailure;
import elan.tweaks.thaumcraft.research.frontend.domain.failures.MissingResearchFailure;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.AspectPalletPort;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.ResearcherKnowledgePort;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.AspectCombiner;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.AspectPool;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.KnowledgeBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import thaumcraft.api.aspects.Aspect;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\u0004\b\u0000\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00100\u0013H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ.\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001bJ&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u001f\u001a\u00020\u000eH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b \u0010!J&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u001f\u001a\u00020\u000eH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b#\u0010!J\u0010\u0010$\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010&\u001a\u00020%2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006)"}, d2={"Lelan/tweaks/thaumcraft/research/frontend/domain/model/AspectPallet;", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/AspectPalletPort;", "base", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/KnowledgeBase;", "pool", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/AspectPool;", "combiner", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/AspectCombiner;", "batchSize", "", "(Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/KnowledgeBase;Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/AspectPool;Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/AspectCombiner;I)V", "amountAndBonusOf", "Lkotlin/Pair;", "aspect", "Lthaumcraft/api/aspects/Aspect;", "batch", "Lkotlin/Result;", "ResultT", "function", "Lkotlin/Function0;", "batch-IoAF18A", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "combine", "", "firstAspect", "secondAspect", "combine-gIAlu-s", "(Lthaumcraft/api/aspects/Aspect;Lthaumcraft/api/aspects/Aspect;)Ljava/lang/Object;", "combineBatch", "combineBatch-gIAlu-s", "derive", "desiredAspect", "derive-IoAF18A", "(Lthaumcraft/api/aspects/Aspect;)Ljava/lang/Object;", "deriveBatch", "deriveBatch-IoAF18A", "isDrainedOf", "", "missing", "aspectAmounts", "", "ThaumcraftResearchTweaks"})
public final class AspectPallet
implements AspectPalletPort {
    @NotNull
    private final KnowledgeBase base;
    @NotNull
    private final AspectPool pool;
    @NotNull
    private final AspectCombiner combiner;
    private final int batchSize;

    public AspectPallet(@NotNull KnowledgeBase base, @NotNull AspectPool pool, @NotNull AspectCombiner combiner, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)combiner, (String)"combiner");
        this.base = base;
        this.pool = pool;
        this.combiner = combiner;
        this.batchSize = batchSize;
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> amountAndBonusOf(@NotNull Aspect aspect) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        return TuplesKt.to((Object)this.pool.amountOf(aspect), (Object)this.pool.bonusAmountOf(aspect));
    }

    @Override
    public boolean missing(@NotNull Map<Aspect, Integer> aspectAmounts) {
        Intrinsics.checkNotNullParameter(aspectAmounts, (String)"aspectAmounts");
        return this.pool.missing(aspectAmounts);
    }

    @Override
    @NotNull
    public Object deriveBatch-IoAF18A(@NotNull Aspect desiredAspect) {
        Intrinsics.checkNotNullParameter((Object)desiredAspect, (String)"desiredAspect");
        return this.batch-IoAF18A((Function0)new Function0<Result<? extends Unit>>(this, desiredAspect){
            final /* synthetic */ AspectPallet this$0;
            final /* synthetic */ Aspect $desiredAspect;
            {
                this.this$0 = $receiver;
                this.$desiredAspect = $desiredAspect;
                super(0);
            }

            @NotNull
            public final Object invoke-d1pmJ48() {
                return this.this$0.derive-IoAF18A(this.$desiredAspect);
            }
        });
    }

    @Override
    @NotNull
    public Object derive-IoAF18A(@NotNull Aspect desiredAspect) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)desiredAspect, (String)"desiredAspect");
        if (this.base.hasNotDiscovered(ResearcherKnowledgePort.Knowledge.ResearchMastery)) {
            object = MissingResearchFailure.Companion.missingResearchMastery-d1pmJ48();
        } else if (desiredAspect.isPrimal()) {
            object = AspectCombinationFailure.Companion.cannotDerivePrimalAspect-d1pmJ48();
        } else if (this.pool.anyComponentMissingFor(desiredAspect)) {
            object = AspectCombinationFailure.Companion.missingComponents-d1pmJ48();
        } else {
            Aspect aspect = desiredAspect.getComponents()[0];
            Intrinsics.checkNotNullExpressionValue((Object)aspect, (String)"desiredAspect.components[0]");
            Aspect aspect2 = aspect;
            aspect = desiredAspect.getComponents()[1];
            Intrinsics.checkNotNullExpressionValue((Object)aspect, (String)"desiredAspect.components[1]");
            object = this.combiner.combine-gIAlu-s(aspect2, aspect);
        }
        return object;
    }

    @Override
    @NotNull
    public Object combineBatch-gIAlu-s(@NotNull Aspect firstAspect, @NotNull Aspect secondAspect) {
        Intrinsics.checkNotNullParameter((Object)firstAspect, (String)"firstAspect");
        Intrinsics.checkNotNullParameter((Object)secondAspect, (String)"secondAspect");
        return this.base.hasDiscovered(ResearcherKnowledgePort.Knowledge.ResearchExpertise) ? this.batch-IoAF18A((Function0)new Function0<Result<? extends Unit>>(this, firstAspect, secondAspect){
            final /* synthetic */ AspectPallet this$0;
            final /* synthetic */ Aspect $firstAspect;
            final /* synthetic */ Aspect $secondAspect;
            {
                this.this$0 = $receiver;
                this.$firstAspect = $firstAspect;
                this.$secondAspect = $secondAspect;
                super(0);
            }

            @NotNull
            public final Object invoke-d1pmJ48() {
                return this.this$0.combine-gIAlu-s(this.$firstAspect, this.$secondAspect);
            }
        }) : this.combine-gIAlu-s(firstAspect, secondAspect);
    }

    @Override
    @NotNull
    public Object combine-gIAlu-s(@NotNull Aspect firstAspect, @NotNull Aspect secondAspect) {
        Intrinsics.checkNotNullParameter((Object)firstAspect, (String)"firstAspect");
        Intrinsics.checkNotNullParameter((Object)secondAspect, (String)"secondAspect");
        return this.isDrainedOf(firstAspect) || this.isDrainedOf(secondAspect) ? AspectCombinationFailure.Companion.missingComponents-d1pmJ48() : this.combiner.combine-gIAlu-s(firstAspect, secondAspect);
    }

    @Override
    public boolean isDrainedOf(@NotNull Aspect aspect) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        return this.pool.totalAmountOf(aspect) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    private final <ResultT> Object batch-IoAF18A(Function0<? extends Result<? extends ResultT>> function) {
        Object v0;
        List batchResults;
        block2: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)new IntRange(1, this.batchSize);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Result result = Result.box-impl((Object)((Result)function.invoke()).unbox-impl());
                collection.add(result);
            }
            batchResults = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = batchResults;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Object it = ((Result)element$iv).unbox-impl();
                boolean bl = false;
                if (!Result.isSuccess-impl((Object)it)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Result result = v0;
        return result == null ? ((Result)CollectionsKt.first((List)batchResults)).unbox-impl() : result.unbox-impl();
    }
}

