/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.common.gui.rendering;

import elan.tweaks.common.gui.dto.Scale;
import elan.tweaks.common.gui.dto.Vector2D;
import elan.tweaks.common.gui.dto.VectorXY;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.FontRenderer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003$%&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J3\u0010\u0012\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ3\u0010\u0014\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u0015\u001a\u00020\u0016*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\u0017J7\u0010\u0003\u001a\u00020\u0004*\u00020\f2\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0019J\"\u0010\u001a\u001a\u00020\u0004*\u00020\f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b2\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u001c\u001a\u00020\u0004*\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0019\u0010\u001f\u001a\u00020\u0016*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\u0017J!\u0010 \u001a\u00020\u0016*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010!J\u0019\u0010\"\u001a\u00020\u0016*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u00020\u0010*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010#\u00a8\u0006'"}, d2={"Lelan/tweaks/common/gui/rendering/TooltipRenderer;", "", "()V", "draw", "", "lines", "", "", "origin", "Lelan/tweaks/common/gui/dto/VectorXY;", "subTipColorColorHex", "fontRenderer", "Lnet/minecraft/client/gui/FontRenderer;", "([Ljava/lang/String;Lelan/tweaks/common/gui/dto/VectorXY;Ljava/lang/String;Lnet/minecraft/client/gui/FontRenderer;)V", "drawBackground", "scale", "Lelan/tweaks/common/gui/dto/Scale;", "drawBorders", "drawCentered", "center", "drawVerticallyCentered", "bodyHeight", "", "([Ljava/lang/String;)I", "textScale", "(Lnet/minecraft/client/gui/FontRenderer;[Ljava/lang/String;Lelan/tweaks/common/gui/dto/Scale;Lelan/tweaks/common/gui/dto/VectorXY;Ljava/lang/String;)V", "drawBody", "", "drawHeader", "line", "colorHex", "headerHeight", "maxOfPixelWidth", "([Ljava/lang/String;Lnet/minecraft/client/gui/FontRenderer;)I", "textHeight", "([Ljava/lang/String;Lnet/minecraft/client/gui/FontRenderer;)Lelan/tweaks/common/gui/dto/Scale;", "ColorsHexValues", "Distances", "TextColors", "ThaumcraftResearchTweaks"})
@SourceDebugExtension(value={"SMAP\nTooltipRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipRenderer.kt\nelan/tweaks/common/gui/rendering/TooltipRenderer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n11065#2:173\n11400#2,3:174\n1864#3,3:177\n*S KotlinDebug\n*F\n+ 1 TooltipRenderer.kt\nelan/tweaks/common/gui/rendering/TooltipRenderer\n*L\n53#1:173\n53#1:174,3\n85#1:177,3\n*E\n"})
public final class TooltipRenderer {
    @NotNull
    public static final TooltipRenderer INSTANCE = new TooltipRenderer();

    private TooltipRenderer() {
    }

    public final void drawCentered(@NotNull String[] lines, @NotNull VectorXY center, @NotNull String subTipColorColorHex, @NotNull FontRenderer fontRenderer) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)subTipColorColorHex, (String)"subTipColorColorHex");
        Intrinsics.checkNotNullParameter((Object)fontRenderer, (String)"fontRenderer");
        Scale textScale = this.textScale(lines, fontRenderer);
        Vector2D offset = new Vector2D(textScale.getWidth() / 2, textScale.getHeight() / 2);
        this.draw(fontRenderer, lines, textScale, center.minus(offset), subTipColorColorHex);
    }

    public final void drawVerticallyCentered(@NotNull String[] lines, @NotNull VectorXY center, @NotNull String subTipColorColorHex, @NotNull FontRenderer fontRenderer) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)subTipColorColorHex, (String)"subTipColorColorHex");
        Intrinsics.checkNotNullParameter((Object)fontRenderer, (String)"fontRenderer");
        Scale textScale = this.textScale(lines, fontRenderer);
        Vector2D offset = new Vector2D(0, textScale.getHeight() / 2);
        this.draw(fontRenderer, lines, textScale, center.minus(offset), subTipColorColorHex);
    }

    public final void draw(@NotNull String[] lines, @NotNull VectorXY origin, @NotNull String subTipColorColorHex, @NotNull FontRenderer fontRenderer) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)subTipColorColorHex, (String)"subTipColorColorHex");
        Intrinsics.checkNotNullParameter((Object)fontRenderer, (String)"fontRenderer");
        this.draw(fontRenderer, lines, this.textScale(lines, fontRenderer), origin, subTipColorColorHex);
    }

    private final Scale textScale(String[] $this$textScale, FontRenderer fontRenderer) {
        return new Scale(this.maxOfPixelWidth($this$textScale, fontRenderer), this.textHeight($this$textScale));
    }

    /*
     * WARNING - void declaration
     */
    private final int maxOfPixelWidth(String[] $this$maxOfPixelWidth, FontRenderer fontRenderer) {
        void $this$mapTo$iv$iv;
        String[] $this$map$iv = $this$maxOfPixelWidth;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void line;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(fontRenderer.func_78256_a((String)line));
        }
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        return n2 != null ? n2 : 0;
    }

    private final int textHeight(String[] $this$textHeight) {
        return 4 + this.headerHeight($this$textHeight) + this.bodyHeight($this$textHeight) + 4;
    }

    private final int headerHeight(String[] $this$headerHeight) {
        return $this$headerHeight.length > 1 ? 12 : 10;
    }

    private final int bodyHeight(String[] $this$bodyHeight) {
        return ($this$bodyHeight.length - 2) * 10;
    }

    public final void draw(@NotNull FontRenderer $this$draw, @NotNull String[] lines, @NotNull Scale textScale, @NotNull VectorXY origin, @NotNull String subTipColorColorHex) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)textScale, (String)"textScale");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)subTipColorColorHex, (String)"subTipColorColorHex");
        if (lines.length == 0) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        this.drawBackground(origin, textScale);
        this.drawBorders(origin, textScale);
        this.drawHeader($this$draw, (String)ArraysKt.first((Object[])lines), subTipColorColorHex, origin);
        this.drawBody($this$draw, ArraysKt.drop((Object[])lines, (int)1), origin);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    /*
     * WARNING - void declaration
     */
    private final void drawBody(FontRenderer $this$drawBody, List<String> lines, VectorXY origin) {
        Iterable $this$forEachIndexed$iv = lines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            int yOffset = 2 + 10 * (index + 1);
            $this$drawBody.func_78261_a('\u00a7' + TextColors.INSTANCE.getGRAY() + (String)line, origin.getX(), origin.getY() + yOffset, -1);
        }
    }

    private final void drawHeader(FontRenderer $this$drawHeader, String line, String colorHex, VectorXY origin) {
        $this$drawHeader.func_78261_a('\u00a7' + colorHex + line, origin.getX(), origin.getY(), -1);
    }

    private final void drawBorders(VectorXY origin, Scale scale) {
        int topColor = 0x505000FF;
        int bottomColor = -267386864;
        UtilsFX.drawGradientRect((int)(origin.getX() - 3), (int)(origin.getY() - 3 + 1), (int)(origin.getX() - 3 + 1), (int)(origin.getY() + scale.getHeight() + 3 - 1), (int)topColor, (int)bottomColor);
        UtilsFX.drawGradientRect((int)(origin.getX() + scale.getWidth() + 2), (int)(origin.getY() - 3 + 1), (int)(origin.getX() + scale.getWidth() + 3), (int)(origin.getY() + scale.getHeight() + 3 - 1), (int)topColor, (int)bottomColor);
        UtilsFX.drawGradientRect((int)(origin.getX() - 3), (int)(origin.getY() - 3), (int)(origin.getX() + scale.getWidth() + 3), (int)(origin.getY() - 3 + 1), (int)topColor, (int)topColor);
        UtilsFX.drawGradientRect((int)(origin.getX() - 3), (int)(origin.getY() + scale.getHeight() + 2), (int)(origin.getX() + scale.getWidth() + 3), (int)(origin.getY() + scale.getHeight() + 3), (int)bottomColor, (int)bottomColor);
    }

    private final void drawBackground(VectorXY origin, Scale scale) {
        UtilsFX.drawGradientRect((int)(origin.getX() - 3), (int)(origin.getY() - 4), (int)(origin.getX() + scale.getWidth() + 3), (int)(origin.getY() - 3), (int)-267386864, (int)-267386864);
        UtilsFX.drawGradientRect((int)(origin.getX() - 3), (int)(origin.getY() + scale.getHeight() + 3), (int)(origin.getX() + scale.getWidth() + 3), (int)(origin.getY() + scale.getHeight() + 4), (int)-267386864, (int)-267386864);
        UtilsFX.drawGradientRect((int)(origin.getX() - 3), (int)(origin.getY() - 3), (int)(origin.getX() + scale.getWidth() + 3), (int)(origin.getY() + scale.getHeight() + 3), (int)-267386864, (int)-267386864);
        UtilsFX.drawGradientRect((int)(origin.getX() - 4), (int)(origin.getY() - 3), (int)(origin.getX() - 3), (int)(origin.getY() + scale.getHeight() + 3), (int)-267386864, (int)-267386864);
        UtilsFX.drawGradientRect((int)(origin.getX() + scale.getWidth() + 3), (int)(origin.getY() - 3), (int)(origin.getX() + scale.getWidth() + 4), (int)(origin.getY() + scale.getHeight() + 3), (int)-267386864, (int)-267386864);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lelan/tweaks/common/gui/rendering/TooltipRenderer$TextColors;", "", "()V", "GRAY", "", "getGRAY", "()Ljava/lang/String;", "LIGHT_BLUE", "getLIGHT_BLUE", "ThaumcraftResearchTweaks"})
    public static final class TextColors {
        @NotNull
        public static final TextColors INSTANCE = new TextColors();
        @NotNull
        private static final String LIGHT_BLUE;
        @NotNull
        private static final String GRAY;

        private TextColors() {
        }

        @NotNull
        public final String getLIGHT_BLUE() {
            return LIGHT_BLUE;
        }

        @NotNull
        public final String getGRAY() {
            return GRAY;
        }

        static {
            String string = Integer.toHexString(11);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(11)");
            LIGHT_BLUE = string;
            String string2 = Integer.toHexString(7);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(7)");
            GRAY = string2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lelan/tweaks/common/gui/rendering/TooltipRenderer$ColorsHexValues;", "", "()V", "BLACK", "", "PURPLE", "ThaumcraftResearchTweaks"})
    public static final class ColorsHexValues {
        @NotNull
        public static final ColorsHexValues INSTANCE = new ColorsHexValues();
        public static final int BLACK = -267386864;
        public static final int PURPLE = 0x505000FF;

        private ColorsHexValues() {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lelan/tweaks/common/gui/rendering/TooltipRenderer$Distances;", "", "()V", "BORDER_HEIGHT", "", "HEADER_SPACING", "LINE_HEIGHT", "ThaumcraftResearchTweaks"})
    public static final class Distances {
        @NotNull
        public static final Distances INSTANCE = new Distances();
        public static final int LINE_HEIGHT = 10;
        public static final int HEADER_SPACING = 2;
        public static final int BORDER_HEIGHT = 4;

        private Distances() {
        }
    }
}

