/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.thaumcraftmobaspects;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import iguanaman.thaumcraftmobaspects.AspectPlugin;
import iguanaman.thaumcraftmobaspects.ModFileCache;
import iguanaman.thaumcraftmobaspects.PluginLycanitesMobs;
import iguanaman.thaumcraftmobaspects.PluginMoCreatures;
import iguanaman.thaumcraftmobaspects.PluginSpecialMobs;
import iguanaman.thaumcraftmobaspects.PluginTwilightForest;
import iguanaman.thaumcraftmobaspects.ThaumcraftEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityList;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

@Mod(modid="ThaumcraftMobAspects", name="Thaumcraft Mob Aspects", version="1.1.0-GTNH", dependencies="required-after:Forge@[10.12.2.1121,);required-after:Thaumcraft@[4.1.1,);")
public class ThaumcraftMobAspects {
    @Mod.Instance(value="ThaumcraftMobAspects")
    public static ThaumcraftMobAspects instance;
    private File configDirectory;

    @Mod.EventHandler
    public void pre(FMLPreInitializationEvent event) {
        this.configDirectory = event.getModConfigurationDirectory();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void post(FMLPostInitializationEvent event) {
        ModFileCache files = new ModFileCache(this.configDirectory);
        HashSet<String> modIds = files.getModIds();
        HashMultimap modIdToMobs = HashMultimap.create();
        for (String modId : modIds) {
            Optional<File> file = files.getFile(modId);
            if (!file.isPresent()) continue;
            this.readFromFile((File)file.get(), modIdToMobs.get((Object)modId));
        }
        modIdToMobs.put((Object)"unknown", (Object)new ThaumcraftEntity("the_iguana_man", ThaumcraftMobAspects.bossAspects(5, Aspect.MAN, Aspect.MIND, Aspect.SOUL, Aspect.LIFE, Aspect.MAGIC, Aspect.ELDRITCH, Aspect.ENERGY, Aspect.HUNGER)));
        modIdToMobs.put((Object)"unknown", (Object)new ThaumcraftEntity("XanderGryphon", ThaumcraftMobAspects.bossAspects(5, Aspect.MAN, Aspect.MIND, Aspect.SOUL, Aspect.LIFE, Aspect.MAGIC, Aspect.ELDRITCH, Aspect.ENERGY, Aspect.HUNGER)));
        AspectPlugin[] plugins = new AspectPlugin[]{new PluginLycanitesMobs(), new PluginMoCreatures(), new PluginSpecialMobs(), new PluginTwilightForest()};
        for (AspectPlugin aspectPlugin : plugins) {
            if (!this.shouldLoadPlugin(aspectPlugin)) continue;
            for (ThaumcraftEntity mob : aspectPlugin.getThaumcraftMobs()) {
                modIdToMobs.put((Object)files.guessModId(mob.entityName), (Object)mob);
            }
        }
        for (Object object : EntityList.field_75625_b.keySet()) {
            String entityName = (String)object;
            modIdToMobs.put((Object)files.guessModId(entityName), (Object)new ThaumcraftEntity(entityName));
        }
        for (String modId : modIdToMobs.keySet()) {
            Optional<File> file = files.getFile(modId);
            if (!file.isPresent()) continue;
            this.saveToFile((File)file.get(), modIdToMobs.get((Object)modId));
        }
        for (ThaumcraftEntity mob : modIdToMobs.values()) {
            AspectList aspectList = new AspectList();
            for (Map.Entry<String, Integer> entry : mob.aspects.entrySet()) {
                Aspect aspect = (Aspect)Aspect.aspects.get(entry.getKey());
                if (aspect == null) continue;
                aspectList.add(aspect, entry.getValue().intValue());
            }
            if (aspectList.size() <= 0) continue;
            ThaumcraftApi.registerEntityTag((String)mob.entityName, (AspectList)aspectList, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        }
    }

    private boolean shouldLoadPlugin(AspectPlugin plugin) {
        for (String modID : plugin.getRequiredMods()) {
            if (Loader.isModLoaded((String)modID)) continue;
            return false;
        }
        return true;
    }

    private void readFromFile(File configFile, Set<ThaumcraftEntity> mobs) {
        try {
            InputStreamReader reader = new InputStreamReader(new FileInputStream(configFile));
            Gson gson = new GsonBuilder().create();
            ThaumcraftEntity[] readMobs = (ThaumcraftEntity[])gson.fromJson((Reader)reader, ThaumcraftEntity[].class);
            if (readMobs != null) {
                for (ThaumcraftEntity thaumcraftMob : readMobs) {
                    mobs.add(thaumcraftMob);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveToFile(File configFile, Set<ThaumcraftEntity> mobs) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            OutputStreamWriter output = new OutputStreamWriter(new FileOutputStream(configFile));
            gson.toJson(mobs, (Appendable)output);
            ((Writer)output).close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static AspectList creatureAspects(int size, Aspect ... aspects) {
        int sizeMod = Math.max(Math.round((float)size / (float)aspects.length), 1);
        AspectList result = new AspectList().add(Aspect.BEAST, size);
        for (Aspect aspect : aspects) {
            result.add(aspect, sizeMod);
        }
        return result;
    }

    public static AspectList bossAspects(int amount, Aspect ... aspects) {
        AspectList result = new AspectList().add(Aspect.EARTH, amount).add(Aspect.AIR, amount).add(Aspect.FIRE, amount).add(Aspect.ENTROPY, amount).add(Aspect.WATER, amount).add(Aspect.ORDER, amount);
        for (Aspect aspect : aspects) {
            result.add(aspect, amount);
        }
        return result;
    }
}

