/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class FXBeamPowerVisitor
extends ClassVisitor {
    public FXBeamPowerVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("func_70539_a") || name.equals("renderParticle") || name.equals("renderFlare")) {
            TC4Transformer.log.debug("Visiting {}#{}", new Object[]{name, desc});
            return new AddEnableBlendVisitor(this.api, mv);
        }
        return mv;
    }

    private static class AddEnableBlendVisitor
    extends MethodVisitor {
        private int order;

        public AddEnableBlendVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            boolean isBlendFunc = opcode == 184 && name.equals("glBlendFunc");
            int order = this.order;
            if (isBlendFunc && order >= 2) {
                TC4Transformer.log.warn("Unexpected glBlendFunc call. Occurred {} times so far.", new Object[]{order});
            }
            if (isBlendFunc && order == 0) {
                TC4Transformer.log.trace("Injecting GL11.glEnable(GL11.GL_BLEND)");
                this.mv.visitIntInsn(17, 3042);
                this.mv.visitMethodInsn(184, owner, "glEnable", "(I)V", false);
                this.order = 1;
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (isBlendFunc && order == 1) {
                TC4Transformer.log.trace("Injecting GL11.glDisable(GL11.GL_BLEND)");
                this.mv.visitIntInsn(17, 3042);
                this.mv.visitMethodInsn(184, owner, "glDisable", "(I)V", false);
                this.order = 2;
            }
        }
    }
}

