/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.ModItems;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import ru.timeconqueror.tcneiadditions.client.DrawUtils;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;

public class AspectCombinationHandler
extends TemplateRecipeHandler {
    private static final int SPACE_DECREASE = -25;
    private String userName = Minecraft.func_71410_x().func_110432_I().func_111285_a();

    public String getGuiTexture() {
        return null;
    }

    public int recipiesPerPage() {
        return 5;
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"tcneiadditions.aspect_combination.title", (Object[])new Object[0]);
    }

    public void loadCraftingRecipes(ItemStack result) {
        Aspect aspect;
        if (result.func_77973_b() instanceof ItemAspect && Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(this.userName, aspect = ItemAspect.getAspects((ItemStack)result).getAspects()[0])) {
            new AspectCombinationRecipe(result);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() instanceof ItemAspect) {
            Aspect aspect = ItemAspect.getAspects((ItemStack)ingredient).getAspects()[0];
            if (Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(Minecraft.func_71410_x().func_110432_I().func_111285_a(), aspect)) {
                for (Aspect compoundAspect : Aspect.getCompoundAspects()) {
                    if (!ArrayUtils.contains((Object[])compoundAspect.getComponents(), (Object)aspect) || !Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(this.userName, compoundAspect)) continue;
                    ItemStack result = new ItemStack(ModItems.itemAspect);
                    ItemAspect.setAspect((ItemStack)result, (Aspect)compoundAspect);
                    new AspectCombinationRecipe(result);
                }
            }
        }
    }

    public void drawBackground(int recipe) {
        AspectCombinationRecipe cachedRecipe = (AspectCombinationRecipe)((Object)this.arecipes.get(recipe));
        if (cachedRecipe.getIngredients().isEmpty()) {
            int startY = this.calculateOffsetY(recipe, -25) + 25;
            GuiDraw.drawStringC((String)I18n.func_135052_a((String)"tc.aspect.primal", (Object[])new Object[0]), (int)83, (int)startY, (int)0x404040, (boolean)false);
        } else {
            int spaceX = 16;
            int startX = 83 - (16 + (16 + spaceX) * 2) / 2;
            int startY = this.calculateOffsetY(recipe, -25) + 6;
            DrawUtils.drawXYCenteredString("=", startX + 24, startY + 8, 0x404040, false);
            DrawUtils.drawXYCenteredString("+", startX + 56, startY + 8, 0x404040, false);
        }
    }

    public void drawForeground(int recipe) {
    }

    private int calculateOffsetY(int recipeIndex, int spaceIncrease) {
        return -(65 + spaceIncrease) * (recipeIndex % this.recipiesPerPage());
    }

    private class AspectCombinationRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private List<PositionedStack> ingredients;
        private PositionedStack result;

        public AspectCombinationRecipe(ItemStack aspectStack) {
            super((TemplateRecipeHandler)AspectCombinationHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            int recipeIndex = AspectCombinationHandler.this.arecipes.size();
            AspectCombinationHandler.this.arecipes.add(this);
            int startY = AspectCombinationHandler.this.calculateOffsetY(recipeIndex, -25);
            Aspect aspect = ItemAspect.getAspects((ItemStack)aspectStack).getAspects()[0];
            aspectStack = new ItemStack(ModItems.itemAspect);
            ItemAspect.setAspect((ItemStack)aspectStack, (Aspect)aspect);
            if (aspect.isPrimal()) {
                this.result = new PositionedStack((Object)aspectStack, 75, startY + 6);
            } else {
                int spaceX = 16;
                int startX = 83 - (16 + (16 + spaceX) * 2) / 2;
                this.result = new PositionedStack((Object)aspectStack, startX, startY + 6);
                Aspect[] components = aspect.getComponents();
                ItemStack firstIngred = new ItemStack(ModItems.itemAspect);
                ItemAspect.setAspect((ItemStack)firstIngred, (Aspect)components[0]);
                ItemStack secondIngred = new ItemStack(ModItems.itemAspect);
                ItemAspect.setAspect((ItemStack)secondIngred, (Aspect)components[1]);
                this.ingredients.add(new PositionedStack((Object)firstIngred, startX + (spaceX + 16), startY + 6));
                this.ingredients.add(new PositionedStack((Object)secondIngred, startX + (spaceX + 16) * 2, startY + 6));
            }
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            return this.ingredients;
        }
    }
}

