/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.util.Timer;
import ru.timeconqueror.tcneiadditions.TCNEIAdditions;
import ru.timeconqueror.tcneiadditions.client.TCNAClient;

public class StuffRemovingThread
extends Thread {
    private static final Field configLoadedField;
    private static ArrayList<Class<? extends ICraftingHandler>> recipeHandlersForRemoving;
    private static ArrayList<Class<? extends IUsageHandler>> usageHandlersForRemoving;
    private boolean stop = false;
    private Timer timer = new Timer(1.0f);

    public StuffRemovingThread() {
        this.setDaemon(true);
    }

    public static void removeRecipeHandler(Class<? extends ICraftingHandler> handlerClass) {
        recipeHandlersForRemoving.add(handlerClass);
    }

    public static void removeUsageHandler(Class<? extends IUsageHandler> handlerClass) {
        usageHandlersForRemoving.add(handlerClass);
    }

    @Override
    public void run() {
        while (!this.stop) {
            this.timer.func_74275_a();
            for (int i = 0; i < this.timer.field_74280_b; ++i) {
                this.onTick();
            }
        }
    }

    private void onTick() {
        TCNAClient.getInstance().addScheduledTask(() -> {
            try {
                boolean configLoaded = (Boolean)configLoadedField.get(null);
                if (configLoaded) {
                    Iterator craftingIterator = GuiCraftingRecipe.craftinghandlers.iterator();
                    while (craftingIterator.hasNext()) {
                        ICraftingHandler next = (ICraftingHandler)craftingIterator.next();
                        for (Class<? extends ICraftingHandler> craftingHandlerClass : recipeHandlersForRemoving) {
                            if (next.getClass() != craftingHandlerClass) continue;
                            craftingIterator.remove();
                            TCNEIAdditions.LOGGER.info("Crafting Recipes: found and removed standard " + craftingHandlerClass.getSimpleName() + " from Thaumcraft NEI Plugin");
                        }
                    }
                    Iterator usageIterator = GuiUsageRecipe.usagehandlers.iterator();
                    while (usageIterator.hasNext()) {
                        IUsageHandler next = (IUsageHandler)usageIterator.next();
                        for (Class<? extends IUsageHandler> usageHandlerClass : usageHandlersForRemoving) {
                            if (next.getClass() != usageHandlerClass) continue;
                            usageIterator.remove();
                            TCNEIAdditions.LOGGER.info("Usage Recipes: found and removed standard " + usageHandlerClass.getSimpleName() + " from Thaumcraft NEI Plugin");
                        }
                    }
                    this.stop = true;
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    static {
        recipeHandlersForRemoving = new ArrayList();
        usageHandlersForRemoving = new ArrayList();
        Field configLoaded = null;
        try {
            configLoaded = NEIClientConfig.class.getDeclaredField("configLoaded");
            configLoaded.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        configLoadedField = configLoaded;
    }
}

