/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.recipe.EyeOfHarmonyRecipe;
import com.github.technus.tectech.recipe.TecTechRecipeMaps;
import com.github.technus.tectech.thing.CustomItemList;
import com.github.technus.tectech.thing.block.TileEyeOfHarmony;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.FluidStackLong;
import com.github.technus.tectech.util.ItemStackLong;
import com.github.technus.tectech.util.TT_Utility;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IGlobalWirelessEnergy;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_InputBus_ME;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_OutputBus_ME;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_Output_ME;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_EM_EyeOfHarmony
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable,
IGlobalWirelessEnergy,
ISurvivalConstructable {
    public static final boolean EOH_DEBUG_MODE = false;
    private static final long MOLTEN_SPACETIME_PER_FAILURE_TIER = 14400L;
    private static final double SPACETIME_FAILURE_BASE = 2.0;
    private static final String TOOLTIP_BAR = EnumChatFormatting.GOLD + "---------------------------------------------------------------------------------------";
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private int spacetimeCompressionFieldMetadata = -1;
    private int timeAccelerationFieldMetadata = -1;
    private int stabilisationFieldMetadata = -1;
    private static final double SPACETIME_CASING_DIFFERENCE_DISCOUNT_PERCENTAGE = 0.03;
    private static final double TIME_ACCEL_DECREASE_CHANCE_PER_TIER = 0.0925;
    private static final double STABILITY_INCREASE_PROBABILITY_DECREASE_YIELD_PER_TIER = 0.05;
    private static final double LOG_CONSTANT;
    private static final double PARALLEL_MULTIPLIER_CONSTANT = 1.63;
    private static final long POWER_DIVISION_CONSTANT = 9L;
    private static final int TOTAL_CASING_TIERS_WITH_POWER_PENALTY = 8;
    private static final long PRECISION_MULTIPLIER = 1000000L;
    private String userUUID = "";
    private BigInteger outputEU_BigInt = BigInteger.ZERO;
    private long startEU = 0L;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_EM_EyeOfHarmony> STRUCTURE_DEFINITION;
    private double hydrogenOverflowProbabilityAdjustment;
    private double heliumOverflowProbabilityAdjustment;
    private double stellarPlasmaOverflowProbabilityAdjustment;
    private static final long TICKS_BETWEEN_HATCH_DRAIN = 20L;
    private List<ItemStackLong> outputItems = new ArrayList<ItemStackLong>();
    private List<FluidStackLong> outputFluids = new ArrayList<FluidStackLong>();
    private boolean animationsEnabled = true;
    private final Map<Fluid, Long> validFluidMap = new HashMap<Fluid, Long>(){
        private static final long serialVersionUID = -8452610443191188130L;
        {
            this.put(Materials.Hydrogen.mGas, 0L);
            this.put(Materials.Helium.mGas, 0L);
            this.put(MaterialsUEVplus.RawStarMatter.mFluid, 0L);
        }
    };
    private EyeOfHarmonyRecipe currentRecipe;
    private long lagPreventer = 0L;
    private static final long RECIPE_CHECK_INTERVAL = 60L;
    private long currentCircuitMultiplier = 0L;
    private long astralArrayAmount = 0L;
    private long parallelAmount = 1L;
    private long successfulParallelAmount = 0L;
    private double yield = 0.0;
    private BigInteger usedEU = BigInteger.ZERO;
    private FluidStackLong stellarPlasma;
    private FluidStackLong starMatter;
    private double successChance;
    private long currentRecipeRocketTier;
    private boolean recipeRunning = false;
    private static final String EYE_OF_HARMONY = "eyeOfHarmonyOutput";
    private static final String NUMBER_OF_ITEMS_NBT_TAG = "eyeOfHarmonyOutputnumberOfItems";
    private static final String NUMBER_OF_FLUIDS_NBT_TAG = "eyeOfHarmonyOutputnumberOfFluids";
    private static final String ITEM_OUTPUT_NBT_TAG = "eyeOfHarmonyOutputitemOutput";
    private static final String FLUID_OUTPUT_NBT_TAG = "eyeOfHarmonyOutputfluidOutput";
    private static final String RECIPE_RUNNING_NBT_TAG = "eyeOfHarmonyOutputrecipeRunning";
    private static final String CURRENT_RECIPE_STAR_MATTER_TAG = "eyeOfHarmonyOutputrecipeStarMatter";
    private static final String CURRENT_RECIPE_STELLAR_PLASMA_TAG = "eyeOfHarmonyOutputrecipeStellarPlasma";
    private static final String CURRENT_RECIPE_FIXED_OUTPUTS_TAG = "eyeOfHarmonyOutputrecipeFixedOutputs";
    private static final String RECIPE_SUCCESS_CHANCE_NBT_TAG = "eyeOfHarmonyOutputrecipeSuccessChance";
    private static final String ROCKET_TIER_NBT_TAG = "eyeOfHarmonyOutputrocketTier";
    private static final String CURRENT_CIRCUIT_MULTIPLIER_TAG = "eyeOfHarmonyOutputcurrentCircuitMultiplier";
    private static final String ANIMATIONS_ENABLED = "eyeOfHarmonyOutputanimationsEnabled";
    private static final String CALCULATED_EU_OUTPUT_NBT_TAG = "eyeOfHarmonyOutputoutputEU_BigInt";
    private static final String PARALLEL_AMOUNT_NBT_TAG = "eyeOfHarmonyOutputparallelAmount";
    private static final String YIELD_NBT_TAG = "eyeOfHarmonyOutputyield";
    private static final String SUCCESSFUL_PARALLEL_AMOUNT_NBT_TAG = "eyeOfHarmonyOutputsuccessfulParallelAmount";
    private static final String ASTRAL_ARRAY_AMOUNT_NBT_TAG = "eyeOfHarmonyOutputastralArrayAmount";
    private static final String CALCULATED_EU_INPUT_NBT_TAG = "eyeOfHarmonyOutputusedEU";
    private static final String STACK_SIZE = "stackSize";
    private static final String ITEM_STACK_NBT_TAG = "itemStack";
    private static final String FLUID_AMOUNT = "fluidAmount";
    private static final String FLUID_STACK_NBT_TAG = "fluidStack";

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 16, 16, 0, realBudget, source, actor, false, true);
    }

    private void calculateInputFluidExcessValues(long hydrogenRecipeRequirement, long heliumRecipeRequirement) {
        double hydrogenStored = this.getHydrogenStored();
        double heliumStored = this.getHeliumStored();
        double stellarPlasmaStored = this.getStellarPlasmaStored();
        double hydrogenExcessPercentage = hydrogenStored / (double)hydrogenRecipeRequirement - 1.0;
        double heliumExcessPercentage = heliumStored / (double)heliumRecipeRequirement - 1.0;
        double stellarPlasmaExcessPercentage = stellarPlasmaStored / ((double)heliumRecipeRequirement * 1.24E-5 * (double)this.parallelAmount) - 1.0;
        this.hydrogenOverflowProbabilityAdjustment = 1.0 - Math.exp(-Math.pow(30.0 * hydrogenExcessPercentage, 2.0));
        this.heliumOverflowProbabilityAdjustment = 1.0 - Math.exp(-Math.pow(30.0 * heliumExcessPercentage, 2.0));
        this.stellarPlasmaOverflowProbabilityAdjustment = 1.0 - Math.exp(-Math.pow(30.0 * stellarPlasmaExcessPercentage, 2.0));
    }

    private double recipeChanceCalculator() {
        double chance = this.currentRecipe.getBaseRecipeSuccessChance() - (double)this.timeAccelerationFieldMetadata * 0.0925 + (double)this.stabilisationFieldMetadata * 0.05;
        chance = this.parallelAmount > 1L ? (chance -= this.stellarPlasmaOverflowProbabilityAdjustment) : (chance -= this.hydrogenOverflowProbabilityAdjustment + this.heliumOverflowProbabilityAdjustment);
        return MathHelper.func_151237_a((double)chance, (double)0.0, (double)1.0);
    }

    private double recipeYieldCalculator() {
        double yield = 1.0 - (double)this.stabilisationFieldMetadata * 0.05;
        yield = this.parallelAmount > 1L ? (yield -= this.stellarPlasmaOverflowProbabilityAdjustment) : (yield -= this.hydrogenOverflowProbabilityAdjustment + this.heliumOverflowProbabilityAdjustment);
        return MathHelper.func_151237_a((double)yield, (double)0.0, (double)1.0);
    }

    private int recipeProcessTimeCalculator(long recipeTime, long recipeSpacetimeCasingRequired) {
        long spacetimeCasingDifference = recipeSpacetimeCasingRequired - (long)this.spacetimeCompressionFieldMetadata;
        double recipeTimeDiscounted = (double)recipeTime * Math.pow(2.0, -this.timeAccelerationFieldMetadata) * Math.pow(0.97, -spacetimeCasingDifference) / Math.max(1.0, Math.pow(2.0, this.currentCircuitMultiplier));
        return (int)Math.max(recipeTimeDiscounted, 1.0);
    }

    public IStructureDefinition<GT_MetaTileEntity_EM_EyeOfHarmony> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public GT_MetaTileEntity_EM_EyeOfHarmony(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_EyeOfHarmony(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_EyeOfHarmony(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.spacetimeCompressionFieldMetadata = -1;
        this.timeAccelerationFieldMetadata = -1;
        this.stabilisationFieldMetadata = -1;
        if (!this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 16, 16, 0)) {
            return false;
        }
        if (!this.mDualInputHatches.isEmpty()) {
            return false;
        }
        if (this.mOutputBusses.size() != 1) {
            return false;
        }
        if (!(this.mOutputBusses.get(0) instanceof GT_MetaTileEntity_Hatch_OutputBus_ME)) {
            return false;
        }
        if (this.mOutputHatches.size() != 1) {
            return false;
        }
        if (!(this.mOutputHatches.get(0) instanceof GT_MetaTileEntity_Hatch_Output_ME)) {
            return false;
        }
        if (this.mInputBusses.size() != 1) {
            return false;
        }
        if (this.mInputBusses.get(0) instanceof GT_MetaTileEntity_Hatch_InputBus_ME) {
            return false;
        }
        if (this.mEnergyHatches.size() > 0) {
            return false;
        }
        if (this.mExoticEnergyHatches.size() > 0) {
            return false;
        }
        if (this.mInputHatches.size() != 2) {
            return false;
        }
        this.mHardHammer = true;
        this.mSoftHammer = true;
        this.mScrewdriver = true;
        this.mCrowbar = true;
        this.mSolderingTool = true;
        this.mWrench = true;
        return true;
    }

    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.animationsEnabled = !this.animationsEnabled;
        aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Animations are now " + (this.animationsEnabled ? "enabled" : "disabled") + "."));
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Spacetime Manipulator, EOH").addInfo(TOOLTIP_BAR).addInfo("Creates a pocket of spacetime that is bigger on the inside using transdimensional").addInfo("engineering. Certified Time Lord regulation compliant. This multi uses too much EU").addInfo("to be handled with conventional means. All EU requirements are handled directly by").addInfo("your wireless EU network.").addInfo(TOOLTIP_BAR).addInfo("This multiblock will constantly consume hydrogen and helium when it is not running a").addInfo("recipe once per second. It will store this internally, you can see the totals by").addInfo("using a scanner. This multi also has three tiered blocks with " + EnumChatFormatting.RED + 9 + EnumChatFormatting.GRAY + " tiers").addInfo("each. They are as follows and have the associated effects on the multi.").addInfo(EnumChatFormatting.BLUE + "Spacetime Compression Field Generator:").addInfo("- The tier of this block determines what recipes can be run. If the multiblocks").addInfo("  spacetime compression field block exceeds the requirements of the recipe it").addInfo("  will decrease the processing time by " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)3.0) + "%" + EnumChatFormatting.GRAY + " per tier over the requirement (multiplicative).").addInfo(EnumChatFormatting.BLUE + "Time Dilation Field Generator:").addInfo("- Decreases the time required for a recipe by " + EnumChatFormatting.RED + "50%" + EnumChatFormatting.GRAY + " per tier of block (multiplicative).").addInfo("  Decreases the probability of a recipe succeeding by " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)9.25) + "%" + EnumChatFormatting.GRAY + " per tier (additive)").addInfo(EnumChatFormatting.BLUE + "Stabilisation Field Generator:").addInfo("- Increases the probability of a recipe succeeding by " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)5.0) + "%" + EnumChatFormatting.GRAY + " per tier (additive).").addInfo("  Decreases the yield of a recipe by " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)5.0) + "%" + EnumChatFormatting.GRAY + " per tier (additive). ").addInfo("  > Low tier stabilisation field generators have a power output penalty.").addInfo("     The power output penalty for using Crude Stabilisation Field Generators is " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)40.0) + "%" + EnumChatFormatting.GRAY + ".").addInfo("     This penalty decreases by " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)5.0) + "%" + EnumChatFormatting.GRAY + " per tier (additive).").addInfo(TOOLTIP_BAR).addInfo("Going over a recipe requirement on hydrogen or helium has a penalty on yield and recipe chance.").addInfo("All stored hydrogen and helium is consumed during a craft. The associated formulas are:").addInfo(EnumChatFormatting.GREEN + "Overflow ratio = (Stored fluid / Recipe requirement) - 1").addInfo(EnumChatFormatting.GREEN + "Adjustment value = 1 - exp(-(30 * Overflow ratio)^2)").addInfo("The Adjustment value is then subtracted from the total yield and recipe chance.").addInfo(TOOLTIP_BAR).addInfo("It should be noted that base recipe chance is determined per recipe and yield always starts").addInfo("at 1 and subtracts depending on penalties. All fluid/item outputs are multiplied by the").addInfo("yield. Failure fluid is exempt.").addInfo(TOOLTIP_BAR).addInfo("This multiblock can only output to ME output buses/hatches.").addInfo(TOOLTIP_BAR).addInfo("This multiblock can be overclocked by placing a programmed circuit into the input bus.").addInfo("E.g. A circuit of 2 will provide 2 OCs, 16x EU input and 0.25x the time. EU output is unaffected.").addInfo("All outputs are equal. All item and fluid output chances & amounts per recipe are unaffected.").addInfo(TOOLTIP_BAR).addInfo("If a recipe fails the EOH will output " + EnumChatFormatting.GREEN + "Success chance * " + GT_Utility.formatNumbers((long)14400L) + " * (" + 2.0 + ")^(Recipe tier)" + EnumChatFormatting.GRAY + "L of molten").addInfo(MaterialsUEVplus.SpaceTime.getLocalizedNameForItem("%material") + " instead of fluid/item outputs and output as much EU as a successful recipe.").addInfo(TOOLTIP_BAR).addInfo("This multiblock can perform parallel processing by placing Astral Array Fabricators into the input bus.").addInfo("The amount of parallel is calculated via these formulas:").addInfo(EnumChatFormatting.GREEN + "Parallel exponent = floor(log(8 * Astral Array amount) / log(1.7))").addInfo(EnumChatFormatting.GREEN + "Parallel = 2^(Parallel exponent)").addInfo("If the EOH is running parallel recipes, the power calculation changes.").addInfo("The power needed for parallel processing is calculated as follows:").addInfo(EnumChatFormatting.GREEN + "total EU = ((EU output - EU input * 1.63) / 9) * 2.3^(Parallel exponent - 1)").addInfo("Furthermore, if parallel recipes are run, the recipes consume " + MaterialsUEVplus.RawStarMatter.getLocalizedNameForItem("%material")).addInfo("instead of helium and hydrogen. Overflow penalties still apply.").addInfo("The required amount of fluid to start a recipe is " + EnumChatFormatting.GREEN + "12.4 / 10^6 * Helium amount * Parallel" + EnumChatFormatting.GRAY + ".").addInfo("The success or failure of each parallel is determined independently.").addInfo(TOOLTIP_BAR).addInfo("Animations can be disabled by using a screwdriver on the multiblock.").addSeparator().addStructureInfo("Eye of Harmony structure is too complex! See schematic for details.").addStructureInfo(EnumChatFormatting.GOLD + "896" + EnumChatFormatting.GRAY + " Reinforced Spatial Structure Casing.").addStructureInfo(EnumChatFormatting.GOLD + "534" + EnumChatFormatting.GRAY + " Reinforced Temporal Structure Casing.").addStructureInfo(EnumChatFormatting.GOLD + "31" + EnumChatFormatting.GRAY + " Infinite SpaceTime Energy Boundary Casing.").addStructureInfo(EnumChatFormatting.GOLD + "168" + EnumChatFormatting.GRAY + " Time Dilation Field Generator.").addStructureInfo(EnumChatFormatting.GOLD + "48" + EnumChatFormatting.GRAY + " Stabilisation Field Generator.").addStructureInfo(EnumChatFormatting.GOLD + "138" + EnumChatFormatting.GRAY + " Spacetime Compression Field Generator.").addStructureInfo("--------------------------------------------").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 2 + EnumChatFormatting.GRAY + " input hatches.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " ME output hatch.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " input bus.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " ME output bus.").addStructureInfo("--------------------------------------------").beginStructureBlock(33, 33, 33, false).toolTipFinisher(GT_Values.AuthorColen.substring(8) + EnumChatFormatting.GRAY + "&" + CommonValues.TEC_MARK_EM);
        return tt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_BHG");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_BHG_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12]};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 16, 16, 0, stackSize, hintsOnly);
    }

    private void drainFluidFromHatchesAndStoreInternally() {
        ArrayList fluidStacks = this.getStoredFluids();
        for (FluidStack fluidStack : fluidStacks) {
            if (!this.validFluidMap.containsKey(fluidStack.getFluid())) continue;
            this.validFluidMap.merge(fluidStack.getFluid(), Long.valueOf(fluidStack.amount), Long::sum);
            fluidStack.amount = 0;
        }
        this.updateSlots();
    }

    public RecipeMap<?> getRecipeMap() {
        return TecTechRecipeMaps.eyeOfHarmonyRecipes;
    }

    @Override
    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        ItemStack controllerStack = this.getControllerSlot();
        if (controllerStack == null) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_planet_block");
        }
        ++this.lagPreventer;
        if (this.lagPreventer < 60L) {
            this.lagPreventer = 0L;
            this.currentRecipe = TecTech.eyeOfHarmonyRecipeStorage.recipeLookUp(controllerStack);
            if (this.currentRecipe == null) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            CheckRecipeResult result = this.processRecipe(this.currentRecipe);
            if (!result.wasSuccessful()) {
                this.currentRecipe = null;
            }
            return result;
        }
        return CheckRecipeResultRegistry.NO_RECIPE;
    }

    private long getHydrogenStored() {
        return this.validFluidMap.get(Materials.Hydrogen.mGas);
    }

    private long getHeliumStored() {
        return this.validFluidMap.get(Materials.Helium.mGas);
    }

    private long getStellarPlasmaStored() {
        return this.validFluidMap.get(MaterialsUEVplus.RawStarMatter.mFluid);
    }

    public CheckRecipeResult processRecipe(EyeOfHarmonyRecipe recipeObject) {
        this.currentCircuitMultiplier = 0L;
        if (!this.mInputBusses.isEmpty()) {
            for (ItemStack itemStack : ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(0)).getRealInventory()) {
                if (!GT_Utility.isAnyIntegratedCircuit((ItemStack)itemStack)) continue;
                this.currentCircuitMultiplier = MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)24);
                break;
            }
        }
        this.astralArrayAmount = 0L;
        for (ItemStack itemStack : ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(0)).getRealInventory()) {
            if (itemStack == null || !itemStack.func_77969_a(CustomItemList.astralArrayFabricator.get(1L, new Object[0]))) continue;
            this.astralArrayAmount += (long)itemStack.field_77994_a;
        }
        long parallelExponent = 1L;
        if (this.astralArrayAmount != 0L) {
            parallelExponent = (long)Math.floor(Math.log(8L * this.astralArrayAmount) / LOG_CONSTANT);
            this.parallelAmount = (long)Math.pow(2.0, parallelExponent);
        } else {
            this.parallelAmount = 1L;
        }
        if (this.parallelAmount > 1L && (double)this.getStellarPlasmaStored() < (double)this.currentRecipe.getHeliumRequirement() * 1.24E-5 * (double)this.parallelAmount) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_stellar_plasma");
        }
        if (this.parallelAmount == 1L) {
            if (this.getHydrogenStored() < this.currentRecipe.getHydrogenRequirement() * this.parallelAmount) {
                return SimpleCheckRecipeResult.ofFailure((String)"no_hydrogen");
            }
            if (this.getHeliumStored() < this.currentRecipe.getHeliumRequirement() * this.parallelAmount) {
                return SimpleCheckRecipeResult.ofFailure((String)"no_helium");
            }
        }
        if (this.spacetimeCompressionFieldMetadata == -1) {
            return CheckRecipeResultRegistry.insufficientMachineTier((int)((int)recipeObject.getSpacetimeCasingTierRequired()));
        }
        if ((long)(this.spacetimeCompressionFieldMetadata + 1) < recipeObject.getSpacetimeCasingTierRequired()) {
            return CheckRecipeResultRegistry.insufficientMachineTier((int)((int)recipeObject.getSpacetimeCasingTierRequired()));
        }
        double powerMultiplier = Math.max(1.0, Math.pow(2.3, parallelExponent - 1L));
        this.startEU = recipeObject.getEUStartCost();
        double outputEUPenalty = (double)(8 - this.stabilisationFieldMetadata) * 0.05;
        this.outputEU_BigInt = BigInteger.valueOf((long)((double)recipeObject.getEUOutput() * (1.0 - outputEUPenalty)));
        this.usedEU = BigInteger.valueOf(-this.startEU).multiply(BigInteger.valueOf((long)Math.pow(4.0, this.currentCircuitMultiplier)));
        if (this.parallelAmount > 1L) {
            this.outputEU_BigInt = this.outputEU_BigInt.multiply(BigInteger.valueOf((long)(powerMultiplier * 1000000.0))).divide(BigInteger.valueOf(9000000L));
            this.usedEU = this.usedEU.multiply(BigInteger.valueOf((long)(powerMultiplier * 1.63 * 1000000.0))).divide(BigInteger.valueOf(9000000L));
        }
        if (!this.addEUToGlobalEnergyMap(this.userUUID, this.usedEU)) {
            return SimpleCheckRecipeResult.ofFailure((String)"insufficient_power_no_val");
        }
        this.mMaxProgresstime = this.recipeProcessTimeCalculator(recipeObject.getRecipeTimeInTicks(), recipeObject.getSpacetimeCasingTierRequired());
        this.calculateInputFluidExcessValues(recipeObject.getHydrogenRequirement(), recipeObject.getHeliumRequirement());
        this.successChance = this.recipeChanceCalculator();
        this.currentRecipeRocketTier = this.currentRecipe.getRocketTier();
        if (this.parallelAmount > 1L) {
            this.validFluidMap.put(MaterialsUEVplus.RawStarMatter.mFluid, 0L);
        } else {
            this.validFluidMap.put(Materials.Hydrogen.mGas, 0L);
            this.validFluidMap.put(Materials.Helium.mGas, 0L);
        }
        this.yield = this.recipeYieldCalculator();
        this.outputFluids = recipeObject.getOutputFluids();
        this.outputItems = recipeObject.getOutputItems();
        this.starMatter = new FluidStackLong(this.outputFluids.get(this.outputFluids.size() - 1));
        this.stellarPlasma = new FluidStackLong(this.outputFluids.get(this.outputFluids.size() - 2));
        this.successfulParallelAmount = (long)GT_ParallelHelper.calculateChancedOutputMultiplier((int)((int)(10000.0 * this.successChance)), (int)((int)this.parallelAmount));
        for (ItemStackLong itemStackLong : this.outputItems) {
            itemStackLong.stackSize = (long)((double)itemStackLong.stackSize * (this.yield * (double)this.successfulParallelAmount));
        }
        for (FluidStackLong fluidStackLong : this.outputFluids) {
            fluidStackLong.amount = (long)((double)fluidStackLong.amount * (this.yield * (double)this.successfulParallelAmount));
        }
        this.updateSlots();
        if (this.animationsEnabled) {
            this.createRenderBlock(this.currentRecipe);
        }
        this.recipeRunning = true;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private void createRenderBlock(EyeOfHarmonyRecipe currentRecipe) {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        double xOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double zOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        double yOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), Blocks.field_150350_a);
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), TT_Container_Casings.eyeOfHarmonyRenderBlock);
        TileEyeOfHarmony rendererTileEntity = (TileEyeOfHarmony)this.getBaseMetaTileEntity().getWorld().func_147438_o((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset));
        rendererTileEntity.setTier(currentRecipe.getRocketTier());
        int recipeSpacetimeTier = (int)currentRecipe.getSpacetimeCasingTierRequired();
        rendererTileEntity.setSize(1 + recipeSpacetimeTier);
        rendererTileEntity.setRotationSpeed((float)(1 + this.timeAccelerationFieldMetadata) / 2.0f);
    }

    private void outputFailedChance() {
        long failedParallelAmount = this.parallelAmount - this.successfulParallelAmount;
        if (failedParallelAmount > 0L) {
            this.outputFluidToAENetwork(MaterialsUEVplus.SpaceTime.getMolten(1L), (long)(this.successChance * 14400.0 * Math.pow(2.0, this.currentRecipeRocketTier + 1L) * (double)failedParallelAmount));
        }
        super.outputAfterRecipe_EM();
    }

    @Override
    public void stopMachine() {
        super.stopMachine();
        this.destroyRenderBlock();
        this.recipeRunning = false;
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        this.destroyRenderBlock();
    }

    private void destroyRenderBlock() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        double xOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double zOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        double yOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), Blocks.field_150350_a);
    }

    @Override
    public void outputAfterRecipe_EM() {
        this.recipeRunning = false;
        this.eRequiredData = 0L;
        this.destroyRenderBlock();
        this.addEUToGlobalEnergyMap(this.userUUID, this.outputEU_BigInt);
        this.startEU = 0L;
        this.outputEU_BigInt = BigInteger.ZERO;
        this.outputFailedChance();
        if (this.successfulParallelAmount > 0L) {
            for (ItemStackLong itemStack : this.outputItems) {
                this.outputItemToAENetwork(itemStack.itemStack, itemStack.stackSize);
            }
            for (FluidStackLong fluidStack : this.outputFluids) {
                this.outputFluidToAENetwork(fluidStack.fluidStack, fluidStack.amount);
            }
        }
        this.outputItems = new ArrayList<ItemStackLong>();
        this.outputFluids = new ArrayList<FluidStackLong>();
        super.outputAfterRecipe_EM();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aTick == 1L) {
            this.userUUID = String.valueOf(this.getBaseMetaTileEntity().getOwnerUuid());
            String userName = this.getBaseMetaTileEntity().getOwnerName();
            this.strongCheckOrAddUser(this.userUUID, userName);
        }
        if (!this.recipeRunning && this.mMachine && aTick % 20L == 0L) {
            this.drainFluidFromHatchesAndStoreInternally();
        }
    }

    private void outputItemToAENetwork(ItemStack item, long amount) {
        if (item == null || amount <= 0L) {
            return;
        }
        if (amount < Integer.MAX_VALUE) {
            ItemStack tmpItem = item.func_77946_l();
            tmpItem.field_77994_a = (int)amount;
            ((GT_MetaTileEntity_Hatch_OutputBus_ME)this.mOutputBusses.get(0)).store(tmpItem);
        } else {
            ItemStack tmpItem;
            while (amount >= Integer.MAX_VALUE) {
                tmpItem = item.func_77946_l();
                tmpItem.field_77994_a = Integer.MAX_VALUE;
                ((GT_MetaTileEntity_Hatch_OutputBus_ME)this.mOutputBusses.get(0)).store(tmpItem);
                amount -= Integer.MAX_VALUE;
            }
            tmpItem = item.func_77946_l();
            tmpItem.field_77994_a = (int)amount;
            ((GT_MetaTileEntity_Hatch_OutputBus_ME)this.mOutputBusses.get(0)).store(tmpItem);
        }
    }

    private void outputFluidToAENetwork(FluidStack fluid, long amount) {
        if (fluid == null || amount <= 0L) {
            return;
        }
        if (amount < Integer.MAX_VALUE) {
            FluidStack tmpFluid = fluid.copy();
            tmpFluid.amount = (int)amount;
            ((GT_MetaTileEntity_Hatch_Output_ME)this.mOutputHatches.get(0)).tryFillAE(tmpFluid);
        } else {
            FluidStack tmpFluid;
            while (amount >= Integer.MAX_VALUE) {
                tmpFluid = fluid.copy();
                tmpFluid.amount = Integer.MAX_VALUE;
                ((GT_MetaTileEntity_Hatch_Output_ME)this.mOutputHatches.get(0)).tryFillAE(tmpFluid);
                amount -= Integer.MAX_VALUE;
            }
            tmpFluid = fluid.copy();
            tmpFluid.amount = (int)amount;
            ((GT_MetaTileEntity_Hatch_Output_ME)this.mOutputHatches.get(0)).tryFillAE(tmpFluid);
        }
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        str.add(EnumChatFormatting.GOLD + "---------------- Control Block Statistics ----------------");
        if (this.spacetimeCompressionFieldMetadata < 0) {
            str.add("Spacetime Compression Field Grade: None");
        } else {
            str.add("Spacetime Compression Field Grade: " + CommonValues.EOH_TIER_FANCY_NAMES[this.spacetimeCompressionFieldMetadata] + EnumChatFormatting.RESET + " (" + EnumChatFormatting.YELLOW + this.spacetimeCompressionFieldMetadata + EnumChatFormatting.RESET + ")");
        }
        if (this.timeAccelerationFieldMetadata < 0) {
            str.add("Time Dilation Field Grade: None");
        } else {
            str.add("Time Dilation Field Grade: " + CommonValues.EOH_TIER_FANCY_NAMES[this.timeAccelerationFieldMetadata] + EnumChatFormatting.RESET + " (" + EnumChatFormatting.YELLOW + this.timeAccelerationFieldMetadata + EnumChatFormatting.RESET + ")");
        }
        if (this.stabilisationFieldMetadata < 0) {
            str.add("Stabilisation Field Grade: None");
        } else {
            str.add("Stabilisation Field Grade: " + CommonValues.EOH_TIER_FANCY_NAMES[this.stabilisationFieldMetadata] + EnumChatFormatting.RESET + " (" + EnumChatFormatting.YELLOW + this.stabilisationFieldMetadata + EnumChatFormatting.RESET + ")");
        }
        str.add(EnumChatFormatting.GOLD + "----------------- Internal Fluids Stored ----------------");
        this.validFluidMap.forEach((key, value) -> str.add(EnumChatFormatting.BLUE + key.getLocalizedName() + EnumChatFormatting.RESET + " : " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)value)));
        if (this.recipeRunning) {
            str.add(EnumChatFormatting.GOLD + "---------------------- Other Stats ---------------");
            str.add("Recipe Success Chance: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)(100.0 * this.successChance)) + EnumChatFormatting.RESET + "%");
            str.add("Recipe Yield: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)(100.0 * this.yield)) + EnumChatFormatting.RESET + "%");
            str.add("Astral Array Fabricators detected: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.astralArrayAmount));
            str.add("Total Parallel: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.parallelAmount));
            str.add("EU Output: " + EnumChatFormatting.RED + TT_Utility.toStandardForm(this.outputEU_BigInt) + EnumChatFormatting.RESET + " EU");
            str.add("EU Input:  " + EnumChatFormatting.RED + TT_Utility.toStandardForm(this.usedEU.abs()) + EnumChatFormatting.RESET + " EU");
            int currentMaxProgresstime = Math.max(this.maxProgresstime(), 1);
            if (this.starMatter != null && this.starMatter.fluidStack != null) {
                FluidStackLong starMatterOutput = new FluidStackLong(this.starMatter.fluidStack, (long)((double)this.starMatter.amount * this.yield * this.successChance * (double)this.parallelAmount));
                str.add("Average " + starMatterOutput.fluidStack.getLocalizedName() + " Output: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)starMatterOutput.amount) + EnumChatFormatting.RESET + " L, " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((double)((double)starMatterOutput.amount * 20.0 / (double)currentMaxProgresstime)) + EnumChatFormatting.RESET + " L/s");
                FluidStackLong stellarPlasmaOutput = new FluidStackLong(MaterialsUEVplus.RawStarMatter.getFluid(0L), (long)((double)this.stellarPlasma.amount * this.yield * this.successChance * (double)this.parallelAmount));
                str.add("Average " + stellarPlasmaOutput.fluidStack.getLocalizedName() + " Output: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)stellarPlasmaOutput.amount) + EnumChatFormatting.RESET + " L, " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((double)((double)stellarPlasmaOutput.amount * 20.0 / (double)currentMaxProgresstime)) + EnumChatFormatting.RESET + " L/s");
            }
            BigInteger euPerTick = this.outputEU_BigInt.subtract(this.usedEU.abs()).divide(BigInteger.valueOf(currentMaxProgresstime));
            str.add("Estimated EU/t: " + EnumChatFormatting.RED + TT_Utility.toStandardForm(euPerTick) + EnumChatFormatting.RESET + " EU/t");
        }
        str.add(EnumChatFormatting.GOLD + "-----------------------------------------------------");
        return str.toArray(new String[0]);
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return new String[]{"Eye of Harmony multiblock"};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        this.validFluidMap.forEach((key, value) -> aNBT.func_74772_a("stored." + key.getUnlocalizedName(), value.longValue()));
        aNBT.func_74757_a(RECIPE_RUNNING_NBT_TAG, this.recipeRunning);
        aNBT.func_74780_a(RECIPE_SUCCESS_CHANCE_NBT_TAG, this.successChance);
        aNBT.func_74772_a(ROCKET_TIER_NBT_TAG, this.currentRecipeRocketTier);
        aNBT.func_74772_a(CURRENT_CIRCUIT_MULTIPLIER_TAG, this.currentCircuitMultiplier);
        aNBT.func_74757_a(ANIMATIONS_ENABLED, this.animationsEnabled);
        aNBT.func_74772_a(PARALLEL_AMOUNT_NBT_TAG, this.parallelAmount);
        aNBT.func_74772_a(SUCCESSFUL_PARALLEL_AMOUNT_NBT_TAG, this.successfulParallelAmount);
        aNBT.func_74780_a(YIELD_NBT_TAG, this.yield);
        aNBT.func_74772_a(ASTRAL_ARRAY_AMOUNT_NBT_TAG, this.astralArrayAmount);
        aNBT.func_74773_a(CALCULATED_EU_OUTPUT_NBT_TAG, this.outputEU_BigInt.toByteArray());
        aNBT.func_74773_a(CALCULATED_EU_INPUT_NBT_TAG, this.usedEU.toByteArray());
        NBTTagCompound itemStackListNBTTag = new NBTTagCompound();
        itemStackListNBTTag.func_74772_a(NUMBER_OF_ITEMS_NBT_TAG, (long)this.outputItems.size());
        int index = 0;
        for (ItemStackLong itemStackLong : this.outputItems) {
            itemStackListNBTTag.func_74772_a(index + STACK_SIZE, itemStackLong.stackSize);
            aNBT.func_74782_a(index + ITEM_STACK_NBT_TAG, (NBTBase)itemStackLong.itemStack.func_77955_b(new NBTTagCompound()));
            ++index;
        }
        aNBT.func_74782_a(ITEM_OUTPUT_NBT_TAG, (NBTBase)itemStackListNBTTag);
        NBTTagCompound fluidStackListNBTTag = new NBTTagCompound();
        fluidStackListNBTTag.func_74772_a(NUMBER_OF_FLUIDS_NBT_TAG, (long)this.outputFluids.size());
        int indexFluids = 0;
        for (FluidStackLong fluidStackLong : this.outputFluids) {
            fluidStackListNBTTag.func_74772_a(indexFluids + FLUID_AMOUNT, fluidStackLong.amount);
            aNBT.func_74782_a(indexFluids + FLUID_STACK_NBT_TAG, (NBTBase)fluidStackLong.fluidStack.writeToNBT(new NBTTagCompound()));
            ++indexFluids;
        }
        aNBT.func_74782_a(FLUID_OUTPUT_NBT_TAG, (NBTBase)fluidStackListNBTTag);
        if (this.starMatter != null && this.starMatter.fluidStack != null) {
            NBTTagCompound fixedRecipeOutputs = new NBTTagCompound();
            fixedRecipeOutputs.func_74772_a("0fluidAmount", this.starMatter.amount);
            aNBT.func_74782_a(CURRENT_RECIPE_STAR_MATTER_TAG, (NBTBase)this.starMatter.fluidStack.writeToNBT(new NBTTagCompound()));
            fixedRecipeOutputs.func_74772_a("1fluidAmount", this.stellarPlasma.amount);
            aNBT.func_74782_a(CURRENT_RECIPE_STELLAR_PLASMA_TAG, (NBTBase)this.stellarPlasma.fluidStack.writeToNBT(new NBTTagCompound()));
            aNBT.func_74782_a(CURRENT_RECIPE_FIXED_OUTPUTS_TAG, (NBTBase)fixedRecipeOutputs);
        }
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.validFluidMap.forEach((key, value) -> this.validFluidMap.put((Fluid)key, aNBT.func_74763_f("stored." + key.getUnlocalizedName())));
        this.recipeRunning = aNBT.func_74767_n(RECIPE_RUNNING_NBT_TAG);
        this.successChance = aNBT.func_74769_h(RECIPE_SUCCESS_CHANCE_NBT_TAG);
        this.currentRecipeRocketTier = aNBT.func_74763_f(ROCKET_TIER_NBT_TAG);
        this.currentCircuitMultiplier = aNBT.func_74763_f(CURRENT_CIRCUIT_MULTIPLIER_TAG);
        this.animationsEnabled = aNBT.func_74767_n(ANIMATIONS_ENABLED);
        this.parallelAmount = aNBT.func_74763_f(PARALLEL_AMOUNT_NBT_TAG);
        this.yield = aNBT.func_74769_h(YIELD_NBT_TAG);
        this.successfulParallelAmount = aNBT.func_74763_f(SUCCESSFUL_PARALLEL_AMOUNT_NBT_TAG);
        this.astralArrayAmount = aNBT.func_74763_f(ASTRAL_ARRAY_AMOUNT_NBT_TAG);
        this.outputEU_BigInt = new BigInteger(aNBT.func_74770_j(CALCULATED_EU_OUTPUT_NBT_TAG));
        this.usedEU = new BigInteger(aNBT.func_74770_j(CALCULATED_EU_INPUT_NBT_TAG));
        NBTTagCompound tempItemTag = aNBT.func_74775_l(ITEM_OUTPUT_NBT_TAG);
        for (int index = 0; index < tempItemTag.func_74762_e(NUMBER_OF_ITEMS_NBT_TAG); ++index) {
            long stackSize = tempItemTag.func_74763_f(index + STACK_SIZE);
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l(index + ITEM_STACK_NBT_TAG));
            this.outputItems.add(new ItemStackLong(itemStack, stackSize));
        }
        NBTTagCompound tempFluidTag = aNBT.func_74775_l(FLUID_OUTPUT_NBT_TAG);
        for (int indexFluids = 0; indexFluids < tempFluidTag.func_74762_e(NUMBER_OF_FLUIDS_NBT_TAG); ++indexFluids) {
            long fluidAmount = tempFluidTag.func_74763_f(indexFluids + FLUID_AMOUNT);
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l(indexFluids + FLUID_STACK_NBT_TAG));
            this.outputFluids.add(new FluidStackLong(fluidStack, fluidAmount));
        }
        tempFluidTag = aNBT.func_74775_l(CURRENT_RECIPE_FIXED_OUTPUTS_TAG);
        this.starMatter = new FluidStackLong(FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l(CURRENT_RECIPE_STAR_MATTER_TAG)), tempFluidTag.func_74763_f("0fluidAmount"));
        this.stellarPlasma = new FluidStackLong(FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l(CURRENT_RECIPE_STELLAR_PLASMA_TAG)), tempFluidTag.func_74763_f("1fluidAmount"));
        super.loadNBTData(aNBT);
    }

    static {
        LOG_CONSTANT = Math.log(1.7);
        STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "            CCCCCCCCC            ", "               C C               ", "            CCCCCCCCC            ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "               C C               ", "              DDDDD              ", "             DDCDCDD             ", "         CCCCDCCDCCDCCCC         ", "             DDDDDDD             ", "         CCCCDCCDCCDCCCC         ", "             DDCDCDD             ", "              DDDDD              ", "               C C               ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "                D                ", "                D                ", "             DDDDDDD             ", "            DD     DD            ", "            D  EEE  D            ", "       CCC  D EAAAE D  CCC       ", "          DDD EAAAE DDD          ", "       CCC  D EAAAE D  CCC       ", "            D  EEE  D            ", "            DD     DD            ", "             DDDDDDD             ", "                D                ", "                D                ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "      CC                 CC      ", "        DD             DD        ", "      CC                 CC      ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "              CCCCC              ", "                D                ", "                A                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "      C                   C      ", "     CC                   CC     ", "      CDAA             AADC      ", "     CC                   CC     ", "      C                   C      ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                A                ", "                D                ", "              CCCCC              ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "             SEEAEES             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "       S                 S       ", "       E                 E       ", "    CC E                 E CC    ", "      DA                 AD      ", "    CC E                 E CC    ", "       E                 E       ", "       S                 S       ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             SEEAEES             ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "               C C               ", "              CCCCC              ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "    C                       C    ", "   CC                       CC   ", "    CDA                   ADC    ", "   CC                       CC   ", "    C                       C    ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "              CCCCC              ", "               C C               ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "             SEEAEES             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "     S                     S     ", "     E                     E     ", "  CC E                     E CC  ", "    DA                     AD    ", "  CC E                     E CC  ", "     E                     E     ", "     S                     S     ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             SEEAEES             ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 "}, {"                                 ", "                                 ", "               C C               ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  C                           C  ", "   DA                       AD   ", "  C                           C  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "               C C               ", "                                 ", "                                 "}, {"                                 ", "               C C               ", "               C C               ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " CC                           CC ", "   DA                       AD   ", " CC                           CC ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "               C C               ", "               C C               ", "                                 "}, {"                                 ", "               C C               ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " C                             C ", "  D                           D  ", " C                             C ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "               C C               ", "                                 "}, {"                                 ", "               C C               ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " C                             C ", "  D                           D  ", " C                             C ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "               C C               ", "                                 "}, {"             CCCCCCC             ", "               C C               ", "             DDDDDDD             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", "  D                           D  ", "CCD                           DCC", "  D                           D  ", "CCD                           DCC", "  D                           D  ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             DDDDDDD             ", "               C C               ", "               C C               "}, {"            CCHHHHHCC            ", "              DDDDD              ", "            DD     DD            ", "                                 ", "                                 ", "       S                 S       ", "                                 ", "     S                     S     ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", "  D                           D  ", " D                             D ", "CD                             DC", " D                             D ", "CD                             DC", " D                             D ", "  D                           D  ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "     S                     S     ", "                                 ", "       S                 S       ", "                                 ", "                                 ", "            DD     DD            ", "              DDDDD              ", "               C C               "}, {"            CHHHHHHHC            ", "             DDCDCDD             ", "            D  EEE  D            ", "                                 ", "      C                   C      ", "       E                 E       ", "    C                       C    ", "     E                     E     ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", " D                             D ", " D                             D ", "CCE                           ECC", " DE                           ED ", "CCE                           ECC", " D                             D ", " D                             D ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "     E                     E     ", "    C                       C    ", "       E                 E       ", "      C                   C      ", "                                 ", "            D  EEE  D            ", "             DDCDCDD             ", "               C C               "}, {"            CHHCCCHHC            ", "         CCCCDCCDCCDCCCC         ", "       CCC  D EAAAE D  CCC       ", "      CC                 CC      ", "     CC                   CC     ", "    CC E                 E CC    ", "   CC                       CC   ", "  CC E                     E CC  ", "  C                           C  ", " CC                           CC ", " C                             C ", " C                             C ", "CCD                           DCC", "CD                             DC", "CCE                           ECC", "CCA                           ACC", "CDA                           ADC", "CCA                           ACC", "CCE                           ECC", "CD                             DC", "CCD                           DCC", " C                             C ", " C                             C ", " CC                           CC ", "  C                           C  ", "  CC E                     E CC  ", "   CC                       CC   ", "    CC E                 E CC    ", "     CC                   CC     ", "      CC                 CC      ", "       CCC  D EAAAE D  CCC       ", "         CCCCDCCDCCDCCCC         ", "            CCCCCCCCC            "}, {"            CHHC~CHHC            ", "             DDDDDDD             ", "          DDD EAAAE DDD          ", "        DD             DD        ", "      CDAA             AADC      ", "      DA                 AD      ", "    CDA                   ADC    ", "    DA                     AD    ", "   DA                       AD   ", "   DA                       AD   ", "  D                           D  ", "  D                           D  ", "  D                           D  ", " D                             D ", " DE                           ED ", "CDA                           ADC", " DA                           AD ", "CDA                           ADC", " DE                           ED ", " D                             D ", "  D                           D  ", "  D                           D  ", "  D                           D  ", "   DA                       AD   ", "   DA                       AD   ", "    DA                     AD    ", "    CDA                   ADC    ", "      DA                 AD      ", "      CDAA             AADC      ", "        DD             DD        ", "          DDD EAAAE DDD          ", "             DDDDDDD             ", "               C C               "}, {"            CHHCCCHHC            ", "         CCCCDCCDCCDCCCC         ", "       CCC  D EAAAE D  CCC       ", "      CC                 CC      ", "     CC                   CC     ", "    CC E                 E CC    ", "   CC                       CC   ", "  CC E                     E CC  ", "  C                           C  ", " CC                           CC ", " C                             C ", " C                             C ", "CCD                           DCC", "CD                             DC", "CCE                           ECC", "CCA                           ACC", "CDA                           ADC", "CCA                           ACC", "CCE                           ECC", "CD                             DC", "CCD                           DCC", " C                             C ", " C                             C ", " CC                           CC ", "  C                           C  ", "  CC E                     E CC  ", "   CC                       CC   ", "    CC E                 E CC    ", "     CC                   CC     ", "      CC                 CC      ", "       CCC  D EAAAE D  CCC       ", "         CCCCDCCDCCDCCCC         ", "            CCCCCCCCC            "}, {"            CHHHHHHHC            ", "             DDCDCDD             ", "            D  EEE  D            ", "                                 ", "      C                   C      ", "       E                 E       ", "    C                       C    ", "     E                     E     ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", " D                             D ", " D                             D ", "CCE                           ECC", " DE                           ED ", "CCE                           ECC", " D                             D ", " D                             D ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "     E                     E     ", "    C                       C    ", "       E                 E       ", "      C                   C      ", "                                 ", "            D  EEE  D            ", "             DDCDCDD             ", "               C C               "}, {"            CCHHHHHCC            ", "              DDDDD              ", "            DD     DD            ", "                                 ", "                                 ", "       S                 S       ", "                                 ", "     S                     S     ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", "  D                           D  ", " D                             D ", "CD                             DC", " D                             D ", "CD                             DC", " D                             D ", "  D                           D  ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "     S                     S     ", "                                 ", "       S                 S       ", "                                 ", "                                 ", "            DD     DD            ", "              DDDDD              ", "               C C               "}, {"             CCCCCCC             ", "               C C               ", "             DDDDDDD             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", "  D                           D  ", "CCD                           DCC", "  D                           D  ", "CCD                           DCC", "  D                           D  ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             DDDDDDD             ", "               C C               ", "               C C               "}, {"                                 ", "               C C               ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " C                             C ", "  D                           D  ", " C                             C ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "               C C               ", "                                 "}, {"                                 ", "               C C               ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " C                             C ", "  D                           D  ", " C                             C ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "               C C               ", "                                 "}, {"                                 ", "               C C               ", "               C C               ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " CC                           CC ", "   DA                       AD   ", " CC                           CC ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "               C C               ", "               C C               ", "                                 "}, {"                                 ", "                                 ", "               C C               ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  C                           C  ", "   DA                       AD   ", "  C                           C  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "               C C               ", "                                 ", "                                 "}, {"                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "             SEEAEES             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "     S                     S     ", "     E                     E     ", "  CC E                     E CC  ", "    DA                     AD    ", "  CC E                     E CC  ", "     E                     E     ", "     S                     S     ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             SEEAEES             ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "               C C               ", "              CCCCC              ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "    C                       C    ", "   CC                       CC   ", "    CDA                   ADC    ", "   CC                       CC   ", "    C                       C    ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "              CCCCC              ", "               C C               ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "             SEEAEES             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "       S                 S       ", "       E                 E       ", "    CC E                 E CC    ", "      DA                 AD      ", "    CC E                 E CC    ", "       E                 E       ", "       S                 S       ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             SEEAEES             ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "              CCCCC              ", "                D                ", "                A                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "      C                   C      ", "     CC                   CC     ", "      CDAA             AADC      ", "     CC                   CC     ", "      C                   C      ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                A                ", "                D                ", "              CCCCC              ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "      CC                 CC      ", "        DD             DD        ", "      CC                 CC      ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "                D                ", "                D                ", "             DDDDDDD             ", "            DD     DD            ", "            D  EEE  D            ", "       CCC  D EAAAE D  CCC       ", "          DDD EAAAE DDD          ", "       CCC  D EAAAE D  CCC       ", "            D  EEE  D            ", "            DD     DD            ", "             DDDDDDD             ", "                D                ", "                D                ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "               C C               ", "              DDDDD              ", "             DDCDCDD             ", "         CCCCDCCDCCDCCCC         ", "             DDDDDDD             ", "         CCCCDCCDCCDCCCC         ", "             DDCDCDD             ", "              DDDDD              ", "               C C               ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "            CCCCCCCCC            ", "               C C               ", "            CCCCCCCCC            ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}})).addElement('A', StructureUtility.withChannel((String)"spacetime compression", (IStructureElement)StructureUtility.ofBlocksTiered((block, meta) -> block == TT_Container_Casings.SpacetimeCompressionFieldGenerators ? Integer.valueOf(meta) : null, (List)ImmutableList.of((Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)0), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)1), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)2), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)3), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)4), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)5), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)6), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)7), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)8)), (Object)-1, (t, meta) -> {
            t.spacetimeCompressionFieldMetadata = meta;
        }, t -> t.spacetimeCompressionFieldMetadata))).addElement('S', StructureUtility.withChannel((String)"stabilisation", (IStructureElement)StructureUtility.ofBlocksTiered((block, meta) -> block == TT_Container_Casings.StabilisationFieldGenerators ? Integer.valueOf(meta) : null, (List)ImmutableList.of((Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)0), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)1), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)2), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)3), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)4), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)5), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)6), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)7), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)8)), (Object)-1, (t, meta) -> {
            t.stabilisationFieldMetadata = meta;
        }, t -> t.stabilisationFieldMetadata))).addElement('C', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsBA0, (int)11)).addElement('D', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsBA0, (int)10)).addElement('H', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_EM_EyeOfHarmony.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus}).casingIndex(1024).dot(1).buildAndChain(TT_Container_Casings.sBlockCasingsBA0, 12)).addElement('E', StructureUtility.withChannel((String)"time dilation", (IStructureElement)StructureUtility.ofBlocksTiered((block, meta) -> block == TT_Container_Casings.TimeAccelerationFieldGenerator ? Integer.valueOf(meta) : null, (List)ImmutableList.of((Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)0), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)1), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)2), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)3), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)4), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)5), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)6), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)7), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)8)), (Object)-1, (t, meta) -> {
            t.timeAccelerationFieldMetadata = meta;
        }, t -> t.timeAccelerationFieldMetadata))).build();
    }
}

