/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.recipe;

import com.github.technus.tectech.recipe.EyeOfHarmonyRecipeStorage;
import com.github.technus.tectech.util.FluidStackLong;
import com.github.technus.tectech.util.ItemStackLong;
import com.google.common.math.IntMath;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import pers.gwyog.gtneioreplugin.plugin.block.BlockDimensionDisplay;
import pers.gwyog.gtneioreplugin.util.GT5OreLayerHelper;
import pers.gwyog.gtneioreplugin.util.GT5OreSmallHelper;

public class EyeOfHarmonyRecipe {
    static final FluidStackLong[] SPECIAL_FLUIDS = new FluidStackLong[]{new FluidStackLong(MaterialsUEVplus.WhiteDwarfMatter.getMolten(1152L), 1152L), new FluidStackLong(MaterialsUEVplus.WhiteDwarfMatter.getMolten(1152L), 1152L), new FluidStackLong(MaterialsUEVplus.WhiteDwarfMatter.getMolten(4608L), 4608L), new FluidStackLong(MaterialsUEVplus.WhiteDwarfMatter.getMolten(18432L), 18432L), new FluidStackLong(MaterialsUEVplus.BlackDwarfMatter.getMolten(1152L), 1152L), new FluidStackLong(MaterialsUEVplus.BlackDwarfMatter.getMolten(4608L), 4608L), new FluidStackLong(MaterialsUEVplus.BlackDwarfMatter.getMolten(18432L), 18432L), new FluidStackLong(MaterialsUEVplus.Universium.getMolten(1152L), 1152L), new FluidStackLong(MaterialsUEVplus.Universium.getMolten(4608L), 4608L), new FluidStackLong(MaterialsUEVplus.Universium.getMolten(18432L), 18432L)};
    HashingStrategy<ItemStack> itemStackHashingStrategy = new HashingStrategy<ItemStack>(){
        private static final long serialVersionUID = -3966004160368229212L;

        public int computeHashCode(ItemStack stack) {
            int result = stack.func_77973_b().hashCode();
            result = 31 * result + stack.func_77960_j();
            return result;
        }

        public boolean equals(ItemStack item1, ItemStack item2) {
            return item1.func_77977_a().equals(item2.func_77977_a());
        }
    };
    private final TMap<ItemStack, Double> itemStackToProbabilityMap = new TCustomHashMap(this.itemStackHashingStrategy);
    private final TMap<ItemStack, Long> itemStackToTrueStackSizeMap = new TCustomHashMap(this.itemStackHashingStrategy);
    private final ArrayList<ItemStackLong> outputItems;
    private final ArrayList<FluidStackLong> outputFluids;
    private final long hydrogenRequirement;
    private final long heliumRequirement;
    private final long euOutput;
    private final long euStartCost;
    private final double baseSuccessChance;
    private final long spacetimeCasingTierRequired;
    private final long miningTimeSeconds;
    private final double recipeEnergyEfficiency;
    private final ItemStack recipeTriggerItem;
    private final long sumOfItems;
    private final long rocketTier;
    private final long standardRecipeEUOutPerTick = 100L * EyeOfHarmonyRecipeStorage.BILLION;
    private static final double PRIMARY_MULTIPLIER = 0.2111111111111111;
    private static final double SECONDARY_MULTIPLIER = 0.1111111111111111;
    private static final double TERTIARY_MULTIPLIER = 0.1;
    private static final double QUATERNARY_MULTIPLIER = 0.7;
    private static final double[] ORE_MULTIPLIER = new double[]{0.2111111111111111, 0.1111111111111111, 0.1, 0.7};
    private static final List<Materials> VALID_PLASMAS = Stream.of(Materials.Helium, Materials.Iron, Materials.Calcium, Materials.Niobium, Materials.Nitrogen, Materials.Zinc, Materials.Silver, Materials.Titanium, Materials.Radon, Materials.Nickel, Materials.Boron, Materials.Sulfur, Materials.Americium, Materials.Bismuth, Materials.Oxygen, Materials.Tin).collect(Collectors.toList());
    private static final HashMap<String, Long> plasmaEnergyMap = new HashMap<String, Long>(){
        private static final long serialVersionUID = 7933945171103801933L;
        {
            VALID_PLASMAS.forEach((? super T material) -> this.put(material.getPlasma(1L).getFluid().getUnlocalizedName(), (long)((double)GT_Utility.getPlasmaFuelValueInEUPerLiterFromMaterial((Materials)material) * EyeOfHarmonyRecipe.getMaxPlasmaTurbineEfficiency())));
        }
    };

    public TMap<ItemStack, Double> getItemStackToProbabilityMap() {
        return this.itemStackToProbabilityMap;
    }

    public TMap<ItemStack, Long> getItemStackToTrueStackSizeMap() {
        return this.itemStackToTrueStackSizeMap;
    }

    public double getRecipeEnergyEfficiency() {
        return this.recipeEnergyEfficiency;
    }

    public long getSumOfItems() {
        return this.sumOfItems;
    }

    public long getRocketTier() {
        return this.rocketTier;
    }

    public EyeOfHarmonyRecipe(ArrayList<Pair<Materials, Long>> materialList, BlockDimensionDisplay block, double recipeEnergyEfficiency, long hydrogenRequirement, long heliumRequirement, long miningTimeSeconds, long rocketTierOfRecipe, double baseSuccessChance) {
        this.rocketTier = rocketTierOfRecipe;
        this.spacetimeCasingTierRequired = Math.min(8L, rocketTierOfRecipe);
        this.recipeTriggerItem = new ItemStack((Block)block);
        this.outputItems = EyeOfHarmonyRecipe.validDustGenerator(materialList);
        this.sumOfItems = this.outputItems.stream().map(ItemStackLong::getStackSize).reduce(0L, Long::sum);
        this.outputItems.add(new ItemStackLong(this.getStoneDustType(block.getDimension()), this.sumOfItems * 3L));
        this.outputItems.sort(Comparator.comparingLong(ItemStackLong::getStackSize));
        Collections.reverse(this.outputItems);
        for (ItemStackLong itemStackLong : this.outputItems) {
            double stackSize = itemStackLong.getStackSize();
            double probability = (double)Math.round(100000.0 * stackSize / (double)this.sumOfItems) / 1000.0;
            this.itemStackToProbabilityMap.put((Object)itemStackLong.itemStack, (Object)probability);
            this.itemStackToTrueStackSizeMap.put((Object)itemStackLong.itemStack, (Object)itemStackLong.stackSize);
        }
        ArrayList<FluidStackLong> fluidStackLongArrayList = new ArrayList<FluidStackLong>();
        int plasmaAmount = (int)((this.spacetimeCasingTierRequired + 1L) * 8000000L);
        if (this.rocketTier == 9L) {
            for (Materials material : VALID_PLASMAS) {
                fluidStackLongArrayList.add(new FluidStackLong(material.getPlasma((long)plasmaAmount), plasmaAmount));
            }
        } else {
            ArrayList<FluidStack> fluidStackArrayList = new ArrayList<FluidStack>(EyeOfHarmonyRecipe.validPlasmaGenerator(materialList));
            for (FluidStack fluidStack : fluidStackArrayList) {
                fluidStack = new FluidStack(fluidStack, plasmaAmount);
                fluidStackLongArrayList.add(new FluidStackLong(fluidStack, plasmaAmount));
            }
        }
        fluidStackLongArrayList.add(new FluidStackLong(MaterialsUEVplus.RawStarMatter.getFluid((this.spacetimeCasingTierRequired + 1L) * 100000L), (this.spacetimeCasingTierRequired + 1L) * 100000L));
        int spacetimeTier = (int)rocketTierOfRecipe;
        if (spacetimeTier == 0 || spacetimeTier == 9) {
            --spacetimeTier;
        }
        fluidStackLongArrayList.add(SPECIAL_FLUIDS[spacetimeTier + 1]);
        this.outputFluids = fluidStackLongArrayList;
        this.hydrogenRequirement = hydrogenRequirement;
        this.heliumRequirement = heliumRequirement;
        this.baseSuccessChance = baseSuccessChance;
        this.miningTimeSeconds = miningTimeSeconds;
        this.recipeEnergyEfficiency = recipeEnergyEfficiency;
        long plasmaEU = EyeOfHarmonyRecipe.plasmaCostCalculator(this.outputFluids);
        long VM3EU = miningTimeSeconds * (long)IntMath.pow((int)2, (int)19) * 20L;
        this.euStartCost = plasmaEU + VM3EU + this.standardRecipeEUOutPerTick * 20L * miningTimeSeconds;
        this.euOutput = (long)((double)this.euStartCost * recipeEnergyEfficiency);
    }

    private ItemStack getStoneDustType(String key) {
        switch (key) {
            case "Ne": {
                return GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Netherrack, (long)1L);
            }
            case "ED": 
            case "VA": 
            case "EA": {
                return GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Endstone, (long)1L);
            }
            case "Mo": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.MoonStoneDust", (long)1L);
            }
            case "De": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.DeimosStoneDust", (long)1L);
            }
            case "Ma": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.MarsStoneDust", (long)1L);
            }
            case "Ph": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.PhobosStoneDust", (long)1L);
            }
            case "As": 
            case "KB": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.AsteroidsStoneDust", (long)1L);
            }
            case "Ca": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.CallistoStoneDust", (long)1L);
            }
            case "Ce": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.CeresStoneDust", (long)1L);
            }
            case "Eu": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.EuropaStoneDust", (long)1L);
            }
            case "Ga": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.GanymedeStoneDust", (long)1L);
            }
            case "Io": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.IoStoneDust", (long)1L);
            }
            case "Me": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.MercuryStoneDust", (long)1L);
            }
            case "Ve": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.VenusStoneDust", (long)1L);
            }
            case "En": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.EnceladusStoneDust", (long)1L);
            }
            case "Mi": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.MirandaStoneDust", (long)1L);
            }
            case "Ob": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.OberonStoneDust", (long)1L);
            }
            case "Ti": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.TitanStoneDust", (long)1L);
            }
            case "Pr": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.ProteusStoneDust", (long)1L);
            }
            case "Tr": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.TritonStoneDust", (long)1L);
            }
            case "Ha": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.HaumeaStoneDust", (long)1L);
            }
            case "MM": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.MakeMakeStoneDust", (long)1L);
            }
            case "Pl": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.PlutoStoneDust", (long)1L);
            }
            case "BE": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.BarnardaEStoneDust", (long)1L);
            }
            case "BF": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.BarnardaFStoneDust", (long)1L);
            }
            case "CB": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.CentauriAStoneDust", (long)1L);
            }
            case "TE": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.TCetiEStoneDust", (long)1L);
            }
            case "VB": {
                return GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.VegaBStoneDust", (long)1L);
            }
        }
        return GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Stone, (long)1L);
    }

    public EyeOfHarmonyRecipe(GT5OreLayerHelper.NormalOreDimensionWrapper normalOreDimensionWrapper, GT5OreSmallHelper.SmallOreDimensionWrapper smallOreDimensionWrapper, BlockDimensionDisplay block, double recipeEnergyEfficiency, long hydrogenRequirement, long heliumRequirement, long miningTimeSeconds, long spacetimeCasingTierRequired, double baseSuccessChance) {
        this(EyeOfHarmonyRecipe.processDimension(normalOreDimensionWrapper, smallOreDimensionWrapper, miningTimeSeconds), block, recipeEnergyEfficiency, hydrogenRequirement, heliumRequirement, miningTimeSeconds, spacetimeCasingTierRequired, baseSuccessChance);
    }

    public ArrayList<ItemStackLong> getOutputItems() {
        ArrayList<ItemStackLong> copyOutputList = new ArrayList<ItemStackLong>();
        for (ItemStackLong itemStackLong : this.outputItems) {
            copyOutputList.add(new ItemStackLong(itemStackLong));
        }
        return copyOutputList;
    }

    public ArrayList<FluidStackLong> getOutputFluids() {
        ArrayList<FluidStackLong> copyOutputList = new ArrayList<FluidStackLong>();
        for (FluidStackLong fluidStackLong : this.outputFluids) {
            copyOutputList.add(new FluidStackLong(fluidStackLong));
        }
        return copyOutputList;
    }

    public long getHydrogenRequirement() {
        return this.hydrogenRequirement;
    }

    public long getHeliumRequirement() {
        return this.heliumRequirement;
    }

    public long getEUOutput() {
        return this.euOutput;
    }

    public long getEUStartCost() {
        return this.euStartCost;
    }

    public long getRecipeTimeInTicks() {
        return this.miningTimeSeconds * 20L;
    }

    public double getBaseRecipeSuccessChance() {
        return this.baseSuccessChance;
    }

    public long getSpacetimeCasingTierRequired() {
        return this.spacetimeCasingTierRequired;
    }

    public ItemStack getRecipeTriggerItem() {
        return this.recipeTriggerItem;
    }

    public static void processHelper(HashMapHelper outputMap, Materials material, double mainMultiplier, double probability) {
        if (material == null) {
            return;
        }
        outputMap.add(material.mDirectSmelting, (double)(material.mOreMultiplier * 2) * mainMultiplier * probability);
        int index = 0;
        for (Materials byProductMaterial : material.mOreByProducts) {
            outputMap.add(byProductMaterial.mDirectSmelting, mainMultiplier * (ORE_MULTIPLIER[index++] * 2.0) * probability);
        }
    }

    private static ArrayList<Pair<Materials, Long>> processDimension(GT5OreLayerHelper.NormalOreDimensionWrapper normalOreDimWrapper, GT5OreSmallHelper.SmallOreDimensionWrapper smallOreDimWrapper, long timeInSeconds) {
        HashMapHelper outputMap = new HashMapHelper();
        double mainMultiplier = (double)timeInSeconds * 384.0;
        if (normalOreDimWrapper != null) {
            normalOreDimWrapper.oreVeinToProbabilityInDimension.forEach((veinInfo, probability) -> {
                EyeOfHarmonyRecipe.processHelper(outputMap, veinInfo.mPrimaryVeinMaterial, mainMultiplier, probability);
                EyeOfHarmonyRecipe.processHelper(outputMap, veinInfo.mSecondaryMaterial, mainMultiplier, probability);
                EyeOfHarmonyRecipe.processHelper(outputMap, veinInfo.mBetweenMaterial, mainMultiplier / 8.0, probability);
                EyeOfHarmonyRecipe.processHelper(outputMap, veinInfo.mSporadicMaterial, mainMultiplier / 8.0, probability);
            });
        }
        if (smallOreDimWrapper != null) {
            smallOreDimWrapper.oreVeinToProbabilityInDimension.forEach((veinInfo, probability) -> EyeOfHarmonyRecipe.processHelper(outputMap, veinInfo.getOreMaterial(), mainMultiplier, probability));
        }
        ArrayList<Pair<Materials, Long>> outputList = new ArrayList<Pair<Materials, Long>>();
        outputMap.forEach((material, quantity) -> outputList.add(Pair.of((Object)material, (Object)((long)Math.floor(quantity)))));
        return outputList;
    }

    private static ArrayList<FluidStack> validPlasmaGenerator(List<Pair<Materials, Long>> planetList) {
        ArrayList<FluidStack> plasmaList = new ArrayList<FluidStack>();
        for (Pair<Materials, Long> pair : planetList) {
            if (!VALID_PLASMAS.contains(pair.getLeft())) continue;
            plasmaList.add(((Materials)pair.getLeft()).getPlasma(1L));
        }
        return plasmaList;
    }

    private static ArrayList<ItemStackLong> validDustGenerator(ArrayList<Pair<Materials, Long>> planetList) {
        ArrayList<ItemStackLong> dustList = new ArrayList<ItemStackLong>();
        for (Pair<Materials, Long> pair : planetList) {
            ItemStack dust = GregTech_API.getUnificatedOreDictStack((ItemStack)((Materials)pair.getLeft()).getDust(1));
            if (dust == null) continue;
            dustList.add(new ItemStackLong(dust, (Long)pair.getRight()));
        }
        return dustList;
    }

    private static long plasmaCostCalculator(ArrayList<FluidStackLong> plasmas) {
        long total = 0L;
        for (FluidStackLong plasma : plasmas) {
            FluidStack plasmaFluid = plasma.getRegularFluidStack(plasma, 1);
            try {
                String plasmaName = plasmaFluid.getFluid().getUnlocalizedName();
                total += plasmaEnergyMap.getOrDefault(plasmaName, 0L) * plasma.amount;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (long)((double)total * EyeOfHarmonyRecipe.getMaxPlasmaTurbineEfficiency());
    }

    private static double getMaxPlasmaTurbineEfficiency() {
        return 3.85;
    }

    public static class HashMapHelper
    extends HashMap<Materials, Double> {
        private static final long serialVersionUID = 2297018142561480614L;

        void add(Materials material, double value) {
            if (this.containsKey(material)) {
                this.put(material, value + (Double)this.get(material));
                return;
            }
            this.put(material, value);
        }
    }
}

