/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.util;

import com.github.technus.tectech.thing.metaTileEntity.multi.GT_MetaTileEntity_EM_ForgeOfGods;
import com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules.GT_MetaTileEntity_EM_BaseModule;
import com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules.GT_MetaTileEntity_EM_MoltenModule;
import com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules.GT_MetaTileEntity_EM_PlasmaModule;
import com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules.GT_MetaTileEntity_EM_SmeltingModule;

public class GodforgeMath {
    public static int getRandomIntInRange(int min, int max) {
        return (int)(Math.random() * (double)(max - min)) + min;
    }

    public static double calculateFuelConsumption(GT_MetaTileEntity_EM_ForgeOfGods godforge) {
        double upgradeFactor = 1.0;
        if (godforge.isUpgradeActive(2).booleanValue()) {
            upgradeFactor = 0.8;
        }
        if (godforge.getFuelType() == 0) {
            return Math.max((double)(godforge.getFuelFactor() * 300) * Math.pow(1.15, godforge.getFuelFactor().intValue()) * upgradeFactor, 1.0);
        }
        if (godforge.getFuelType() == 1) {
            return Math.max((double)(godforge.getFuelFactor() * 2) * Math.pow(1.08, godforge.getFuelFactor().intValue()) * upgradeFactor, 1.0);
        }
        return Math.max((double)(godforge.getFuelFactor() / 25) * upgradeFactor, 1.0);
    }

    public static int calculateMaxFuelFactor(GT_MetaTileEntity_EM_ForgeOfGods godforge) {
        if (godforge.isUpgradeActive(27).booleanValue()) {
            return Integer.MAX_VALUE;
        }
        int fuelCap = 5;
        if (godforge.isUpgradeActive(9).booleanValue()) {
            fuelCap += godforge.getTotalActiveUpgrades().intValue();
        }
        if (godforge.isUpgradeActive(3).booleanValue()) {
            fuelCap = (int)((double)fuelCap * 1.2);
        }
        return fuelCap;
    }

    public static int calculateMaxHeatForModules(GT_MetaTileEntity_EM_BaseModule module, GT_MetaTileEntity_EM_ForgeOfGods godforge) {
        double logBase = 1.5;
        int baseHeat = 12601;
        if (godforge.isUpgradeActive(12).booleanValue()) {
            logBase = module instanceof GT_MetaTileEntity_EM_SmeltingModule ? 1.12 : 1.18;
        }
        return baseHeat + (int)(Math.log(godforge.getFuelFactor().intValue()) / Math.log(logBase) * 1000.0);
    }

    public static float calucateSpeedBonusForModules(GT_MetaTileEntity_EM_BaseModule module, GT_MetaTileEntity_EM_ForgeOfGods godforge) {
        double speedBonus = 1.0;
        if (godforge.isUpgradeActive(1).booleanValue()) {
            speedBonus = Math.pow(module.getHeat().intValue(), -0.01);
        }
        if (godforge.isUpgradeActive(22).booleanValue()) {
            speedBonus = module instanceof GT_MetaTileEntity_EM_PlasmaModule ? (speedBonus /= Math.pow(module.getMaxParallel().intValue(), 0.02)) : (speedBonus /= Math.pow(module.getMaxParallel().intValue(), 0.012));
        }
        return (float)speedBonus;
    }

    public static int calculateEffectiveFuelFactor(GT_MetaTileEntity_EM_ForgeOfGods godforge) {
        int fuelFactor = godforge.getFuelFactor();
        if (fuelFactor <= 43) {
            return fuelFactor;
        }
        return 43 + (int)Math.floor(Math.pow(fuelFactor - 43, 0.4));
    }

    public static int calucateMaxParallelForModules(GT_MetaTileEntity_EM_BaseModule module, GT_MetaTileEntity_EM_ForgeOfGods godforge) {
        int baseParallel = 0;
        float fuelFactorMultiplier = 1.0f;
        float heatMultiplier = 1.0f;
        float upgradeAmountMultiplier = 1.0f;
        int node53 = 1;
        boolean isMoltenOrSmeltingWithUpgrade = false;
        if (module instanceof GT_MetaTileEntity_EM_SmeltingModule) {
            baseParallel = 1024;
        }
        if (module instanceof GT_MetaTileEntity_EM_MoltenModule) {
            baseParallel = 512;
        }
        if (module instanceof GT_MetaTileEntity_EM_PlasmaModule) {
            baseParallel = 256;
        }
        if (module instanceof GT_MetaTileEntity_EM_MoltenModule || module instanceof GT_MetaTileEntity_EM_SmeltingModule && godforge.isUpgradeActive(16).booleanValue()) {
            isMoltenOrSmeltingWithUpgrade = true;
        }
        if (godforge.isUpgradeActive(10).booleanValue()) {
            node53 = 2;
        }
        if (godforge.isUpgradeActive(6).booleanValue()) {
            fuelFactorMultiplier = godforge.isUpgradeActive(13).booleanValue() ? (isMoltenOrSmeltingWithUpgrade ? 1.0f + (float)GodforgeMath.calculateEffectiveFuelFactor(godforge) / 15.0f * 3.0f : 1.0f + (float)GodforgeMath.calculateEffectiveFuelFactor(godforge) / 15.0f * 2.0f) : 1.0f + (float)GodforgeMath.calculateEffectiveFuelFactor(godforge) / 15.0f;
        }
        if (godforge.isUpgradeActive(18).booleanValue()) {
            heatMultiplier = isMoltenOrSmeltingWithUpgrade ? 1.0f + (float)module.getHeat().intValue() / 15000.0f : 1.0f + (float)module.getHeat().intValue() / 25000.0f;
        }
        if (godforge.isUpgradeActive(21).booleanValue()) {
            upgradeAmountMultiplier = isMoltenOrSmeltingWithUpgrade ? 1.0f + (float)godforge.getTotalActiveUpgrades().intValue() / 5.0f : 1.0f + (float)godforge.getTotalActiveUpgrades().intValue() / 8.0f;
        }
        return (int)((float)(baseParallel * node53) * fuelFactorMultiplier * heatMultiplier * upgradeAmountMultiplier);
    }
}

