/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.hatch;

import com.github.technus.tectech.mechanics.dataTransport.InventoryDataPacket;
import com.github.technus.tectech.mechanics.pipe.IConnectsToDataPipe;
import com.github.technus.tectech.recipe.TT_recipeAdder;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DataConnector;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.TT_Utility;
import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_DataAccess;
import gregtech.api.objects.GT_RenderedTexture;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GT_MetaTileEntity_Hatch_InputDataItems
extends GT_MetaTileEntity_Hatch_DataAccess
implements IConnectsToDataPipe {
    public boolean delDelay = true;
    private ItemStack[] stacks;
    private String clientLocale = "en_US";

    public GT_MetaTileEntity_Hatch_InputDataItems(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
        TT_Utility.setTier(aTier, this);
    }

    public GT_MetaTileEntity_Hatch_InputDataItems(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)GT_MetaTileEntity_Hatch_DataConnector.EM_D_ACTIVE, Dyes.getModulation((int)this.getBaseMetaTileEntity().getColorization(), (short[])Dyes.MACHINE_METAL.getRGBA())), new GT_RenderedTexture((IIconContainer)GT_MetaTileEntity_Hatch_DataConnector.EM_D_CONN)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)GT_MetaTileEntity_Hatch_DataConnector.EM_D_SIDES, Dyes.getModulation((int)this.getBaseMetaTileEntity().getColorization(), (short[])Dyes.MACHINE_METAL.getRGBA())), new GT_RenderedTexture((IIconContainer)GT_MetaTileEntity_Hatch_DataConnector.EM_D_CONN)};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_InputDataItems(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        try {
            EntityPlayerMP player = (EntityPlayerMP)aPlayer;
            this.clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
        }
        catch (Exception e) {
            this.clientLocale = "en_US";
        }
        return true;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    public boolean isInputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isDataInputFacing(byte side) {
        return this.isInputFacing(side);
    }

    @Override
    public boolean canConnectData(byte side) {
        return this.isInputFacing(side);
    }

    @Override
    public IConnectsToDataPipe getNext(IConnectsToDataPipe source) {
        return null;
    }

    public void setContents(InventoryDataPacket iIn) {
        if (iIn == null) {
            this.stacks = null;
        } else if (((ItemStack[])iIn.getContent()).length > 0) {
            this.stacks = (ItemStack[])iIn.getContent();
            this.delDelay = true;
        } else {
            this.stacks = null;
        }
    }

    public void onRemoval() {
        this.stacks = null;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        NBTTagCompound stacksTag = new NBTTagCompound();
        if (this.stacks != null) {
            stacksTag.func_74768_a("count", this.stacks.length);
            for (int i = 0; i < this.stacks.length; ++i) {
                stacksTag.func_74782_a(Integer.toString(i), (NBTBase)this.stacks[i].func_77955_b(new NBTTagCompound()));
            }
        }
        aNBT.func_74782_a("data_stacks", (NBTBase)stacksTag);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        NBTTagCompound stacksTag = aNBT.func_74775_l("data_stacks");
        int count = stacksTag.func_74762_e("count");
        if (count > 0) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < count; ++i) {
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)stacksTag.func_74775_l(Integer.toString(i)));
                if (stack == null) continue;
                stacks.add(stack);
            }
            if (stacks.size() > 0) {
                this.stacks = stacks.toArray(TT_recipeAdder.nullItem);
            }
        }
    }

    public int func_70302_i_() {
        return this.stacks != null ? this.stacks.length : 0;
    }

    public ItemStack func_70301_a(int aIndex) {
        return this.stacks != null && aIndex < this.stacks.length ? this.stacks[aIndex] : null;
    }

    public boolean shouldDropItemAt(int index) {
        return false;
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (4L == aTick % 20L) {
            if (this.stacks == null) {
                this.getBaseMetaTileEntity().setActive(false);
            } else {
                this.getBaseMetaTileEntity().setActive(true);
                if (this.delDelay) {
                    this.delDelay = false;
                } else {
                    this.setContents(null);
                }
            }
        }
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainass.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainass.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainass.desc.2")};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.Content_Stack_Count", (Object[])new Object[]{this.clientLocale}) + ": " + (this.stacks == null ? 0 : this.stacks.length)};
    }

    @Override
    public byte getColorization() {
        return this.getBaseMetaTileEntity().getColorization();
    }
}

