/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.block;

import com.github.technus.tectech.thing.block.TileEyeOfHarmony;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class RenderEyeOfHarmony
extends TileEntitySpecialRenderer {
    private static final ResourceLocation STAR_LAYER_0 = new ResourceLocation("tectech", "models/StarLayer0.png");
    private static final ResourceLocation STAR_LAYER_1 = new ResourceLocation("tectech", "models/StarLayer1.png");
    private static final ResourceLocation STAR_LAYER_2 = new ResourceLocation("tectech", "models/StarLayer2.png");
    private static IModelCustom starModel;
    private static IModelCustom spaceModel;
    private static final float STAR_RESCALE = 0.2f;

    public RenderEyeOfHarmony() {
        starModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("tectech", "models/Star.obj"));
        spaceModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("tectech", "models/Space.obj"));
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (!(tile instanceof TileEyeOfHarmony)) {
            return;
        }
        TileEyeOfHarmony EOHRenderTile = (TileEyeOfHarmony)tile;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        RenderEyeOfHarmony.renderOuterSpaceShell();
        this.renderOrbitObjects(EOHRenderTile);
        this.renderStarLayer(EOHRenderTile, 0, STAR_LAYER_0, 1.0f);
        this.renderStarLayer(EOHRenderTile, 1, STAR_LAYER_1, 0.4f);
        this.renderStarLayer(EOHRenderTile, 2, STAR_LAYER_2, 0.2f);
        GL11.glPopMatrix();
    }

    private void renderOrbitObjects(TileEyeOfHarmony EOHRenderTile) {
        if (EOHRenderTile.getOrbitingObjects() != null) {
            if (EOHRenderTile.getOrbitingObjects().size() == 0) {
                EOHRenderTile.generateImportantInfo();
            }
            for (TileEyeOfHarmony.OrbitingObject t : EOHRenderTile.getOrbitingObjects()) {
                this.renderOrbit(EOHRenderTile, t);
            }
        }
    }

    void renderOrbit(TileEyeOfHarmony EOHRenderTile, TileEyeOfHarmony.OrbitingObject orbitingObject) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)orbitingObject.zAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)orbitingObject.xAngle, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(orbitingObject.rotationSpeed * 0.1f * EOHRenderTile.angle % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)(-0.2 - (double)orbitingObject.distance - (double)(0.2f * EOHRenderTile.getSize())), (double)0.0, (double)0.0);
        GL11.glRotatef((float)(orbitingObject.orbitSpeed * 0.1f * EOHRenderTile.angle % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderBlockInWorld(orbitingObject.block, 0, orbitingObject.scale);
        GL11.glPopMatrix();
    }

    private static void renderOuterSpaceShell() {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(new ResourceLocation("tectech", "models/spaceLayer.png"));
        float scale = 0.175f;
        GL11.glScalef((float)0.175f, (float)0.175f, (float)0.175f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        spaceModel.renderAll();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void renderStarLayer(TileEyeOfHarmony EOHRenderTile, int layer, ResourceLocation texture, float alpha) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(texture);
        float scale = 0.002f * EOHRenderTile.getSize();
        scale = (float)((double)scale * Math.pow(1.04f, layer));
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        switch (layer) {
            case 0: {
                GL11.glRotatef((float)130.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case 1: {
                GL11.glRotatef((float)-49.0f, (float)1.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)67.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL11.glRotatef((float)(0.03f * EOHRenderTile.angle * EOHRenderTile.getRotationSpeed() % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        starModel.renderAll();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void renderBlockInWorld(Block block, int meta, float blockSize) {
        Tessellator tes = Tessellator.field_78398_a;
        this.func_147499_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        tes.func_78386_a(1.0f, 1.0f, 1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        tes.func_78386_a(1.0f, 1.0f, 1.0f);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] X = new double[]{x - 0.5, x - 0.5, x + 0.5, x + 0.5, x + 0.5, x + 0.5, x - 0.5, x - 0.5};
        double[] Y = new double[]{y + 0.5, y - 0.5, y - 0.5, y + 0.5, y + 0.5, y - 0.5, y - 0.5, y + 0.5};
        double[] Z = new double[]{z + 0.5, z + 0.5, z + 0.5, z + 0.5, z - 0.5, z - 0.5, z - 0.5, z - 0.5};
        tes.func_78382_b();
        GL11.glScalef((float)blockSize, (float)blockSize, (float)blockSize);
        IIcon texture = block.func_149691_a(4, meta);
        double minU = texture.func_94209_e();
        double maxU = texture.func_94212_f();
        double minV = texture.func_94206_g();
        double maxV = texture.func_94210_h();
        tes.func_78374_a(X[1], Y[1], Z[1], maxU, maxV);
        tes.func_78374_a(X[0], Y[0], Z[0], maxU, minV);
        tes.func_78374_a(X[7], Y[7], Z[7], minU, minV);
        tes.func_78374_a(X[6], Y[6], Z[6], minU, maxV);
        texture = block.func_149691_a(0, meta);
        minU = texture.func_94209_e();
        maxU = texture.func_94212_f();
        minV = texture.func_94206_g();
        maxV = texture.func_94210_h();
        tes.func_78374_a(X[2], Y[2], Z[2], maxU, maxV);
        tes.func_78374_a(X[5], Y[5], Z[5], maxU, minV);
        tes.func_78374_a(X[6], Y[6], Z[6], minU, minV);
        tes.func_78374_a(X[1], Y[1], Z[1], minU, maxV);
        texture = block.func_149691_a(2, meta);
        minU = texture.func_94209_e();
        maxU = texture.func_94212_f();
        minV = texture.func_94206_g();
        maxV = texture.func_94210_h();
        tes.func_78374_a(X[6], Y[6], Z[6], maxU, maxV);
        tes.func_78374_a(X[7], Y[7], Z[7], maxU, minV);
        tes.func_78374_a(X[4], Y[4], Z[4], minU, minV);
        tes.func_78374_a(X[5], Y[5], Z[5], minU, maxV);
        texture = block.func_149691_a(5, meta);
        minU = texture.func_94209_e();
        maxU = texture.func_94212_f();
        minV = texture.func_94206_g();
        maxV = texture.func_94210_h();
        tes.func_78374_a(X[5], Y[5], Z[5], maxU, maxV);
        tes.func_78374_a(X[4], Y[4], Z[4], maxU, minV);
        tes.func_78374_a(X[3], Y[3], Z[3], minU, minV);
        tes.func_78374_a(X[2], Y[2], Z[2], minU, maxV);
        texture = block.func_149691_a(1, meta);
        minU = texture.func_94209_e();
        maxU = texture.func_94212_f();
        minV = texture.func_94206_g();
        maxV = texture.func_94210_h();
        tes.func_78374_a(X[3], Y[3], Z[3], maxU, maxV);
        tes.func_78374_a(X[4], Y[4], Z[4], maxU, minV);
        tes.func_78374_a(X[7], Y[7], Z[7], minU, minV);
        tes.func_78374_a(X[0], Y[0], Z[0], minU, maxV);
        texture = block.func_149691_a(3, meta);
        minU = texture.func_94209_e();
        maxU = texture.func_94212_f();
        minV = texture.func_94206_g();
        maxV = texture.func_94210_h();
        tes.func_78374_a(X[2], Y[2], Z[2], maxU, maxV);
        tes.func_78374_a(X[3], Y[3], Z[3], maxU, minV);
        tes.func_78374_a(X[0], Y[0], Z[0], minU, minV);
        tes.func_78374_a(X[1], Y[1], Z[1], minU, maxV);
        tes.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2884);
    }
}

