/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry;

import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.EMException;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMIndirectType;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMType;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.IEMMapRead;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMPrimitiveDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import net.minecraft.nbt.NBTTagCompound;

public class EMDefinitionsRegistry {
    private static final String TAG_NAME = "EM";
    private final NavigableSet<IEMDefinition> stacksRegistered = new TreeSet<IEMDefinition>();
    private final Map<Integer, IEMDefinition> hashMap = new HashMap<Integer, IEMDefinition>();
    private final Map<Integer, IEMDefinition> hashMapR = Collections.unmodifiableMap(this.hashMap);
    private final Map<Class<? extends IEMDefinition>, EMType> types = new HashMap<Class<? extends IEMDefinition>, EMType>();
    private final Map<Class<? extends IEMDefinition>, EMType> typesR = Collections.unmodifiableMap(this.types);
    private final Map<Class<? extends IEMDefinition>, EMType> directTypes = new HashMap<Class<? extends IEMDefinition>, EMType>();
    private final Map<Class<? extends IEMDefinition>, EMType> directTypesR = Collections.unmodifiableMap(this.directTypes);
    private final Map<Class<? extends IEMDefinition>, EMIndirectType> indirectTypes = new HashMap<Class<? extends IEMDefinition>, EMIndirectType>();
    private final Map<Class<? extends IEMDefinition>, EMIndirectType> indirectTypesR = Collections.unmodifiableMap(this.indirectTypes);
    private final Map<String, EMType> binds = new HashMap<String, EMType>();
    private final Map<String, EMType> bindsR = Collections.unmodifiableMap(this.binds);
    private final Map<String, IEMDefinition> directBinds = new HashMap<String, IEMDefinition>();
    private final Map<String, IEMDefinition> directBindsR = Collections.unmodifiableMap(this.directBinds);
    private final Map<String, EMIndirectType> indirectBinds = new HashMap<String, EMIndirectType>();
    private final Map<String, EMIndirectType> indirectBindsR = Collections.unmodifiableMap(this.indirectBinds);

    public NBTTagCompound directToNBT(String bind) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a(TAG_NAME, bind);
        return nbt;
    }

    public NBTTagCompound indirectToNBT(String bind, IEMMapRead<EMDefinitionStack> content) {
        NBTTagCompound nbt = content.toNBT(this);
        nbt.func_74778_a(TAG_NAME, bind);
        return nbt;
    }

    public IEMDefinition fromNBT(NBTTagCompound nbt) {
        IEMDefinition definition;
        try {
            String bind = nbt.func_74779_i(TAG_NAME);
            definition = this.directBinds.get(bind);
            if (definition == null) {
                definition = this.indirectBinds.get(bind).create(this, nbt);
            }
        }
        catch (Exception e) {
            EMException emException = new EMException("Failed to create from: " + nbt.toString(), e);
            if (TecTechConfig.DEBUG_MODE) {
                emException.printStackTrace();
                return EMPrimitiveDefinition.nbtE__;
            }
            throw emException;
        }
        if (!TecTechConfig.DEBUG_MODE) {
            if (definition == EMPrimitiveDefinition.nbtE__) {
                throw new EMException("Deserialized to NBT ERROR!");
            }
            if (definition == null) {
                throw new EMException("Deserialized to NULL POINTER!");
            }
            if (definition == EMPrimitiveDefinition.null__) {
                throw new EMException("Deserialized to NULL!");
            }
        }
        if (definition == null) {
            return EMPrimitiveDefinition.null__;
        }
        return definition;
    }

    public boolean isOccupied(String bind) {
        return this.binds.containsKey(bind);
    }

    protected void addType(EMType emType) {
        if (this.types.put(emType.getClazz(), emType) != null) {
            EMException e = new EMException("Class collision! " + emType.getClazz().getName());
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            } else {
                throw e;
            }
        }
    }

    protected void bindType(String bind, EMType emType) {
        if (this.binds.put(bind, emType) != null) {
            EMException e = new EMException("NBT Bind collision! " + bind);
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            } else {
                throw e;
            }
        }
    }

    public void registerDefinitionClass(String bind, EMIndirectType emIndirectType) {
        this.addType(emIndirectType);
        this.indirectTypes.put(emIndirectType.getClazz(), emIndirectType);
        this.bindType(bind, emIndirectType);
        this.indirectBinds.put(bind, emIndirectType);
    }

    public void registerDefinitionClass(EMType emDirectType) {
        this.addType(emDirectType);
    }

    public void registerDirectDefinition(String bind, IEMDefinition definition) {
        EMType emType;
        if (this.hashMap.put(definition.hashCode(), definition) != null) {
            EMException e = new EMException("Hash collision! " + definition.hashCode());
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            } else {
                throw e;
            }
        }
        if ((emType = this.directTypes.get(definition.getClass())) == null) {
            emType = this.types.get(definition.getClass());
            if (emType != null) {
                this.directTypes.put(definition.getClass(), emType);
            } else {
                EMException e = new EMException("Direct Type bind missing! " + definition.getClass().getName());
                if (TecTechConfig.DEBUG_MODE) {
                    e.printStackTrace();
                } else {
                    throw e;
                }
            }
        }
        if (emType != null) {
            this.directTypes.put(definition.getClass(), emType);
            this.bindType(bind, emType);
            emType.addDefinition(bind, definition);
            this.directBinds.put(bind, definition);
        }
    }

    public void registerForDisplay(IEMDefinition definition) {
        this.stacksRegistered.add(definition);
        IEMDefinition anti = definition.getAnti();
        if (anti != null) {
            this.stacksRegistered.add(anti);
        }
    }

    @Deprecated
    public Map<Integer, IEMDefinition> getHashMapping() {
        return this.hashMapR;
    }

    public NavigableSet<IEMDefinition> getStacksRegisteredForDisplay() {
        return this.stacksRegistered;
    }

    public Map<String, EMType> getBinds() {
        return this.bindsR;
    }

    public Map<String, IEMDefinition> getDirectBinds() {
        return this.directBindsR;
    }

    public Map<String, EMIndirectType> getIndirectBinds() {
        return this.indirectBindsR;
    }

    public Map<Class<? extends IEMDefinition>, EMType> getTypes() {
        return this.typesR;
    }

    public Map<Class<? extends IEMDefinition>, EMType> getDirectTypes() {
        return this.directTypesR;
    }

    public Map<Class<? extends IEMDefinition>, EMIndirectType> getIndirectTypes() {
        return this.indirectTypesR;
    }
}

