/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.data;

import com.github.technus.tectech.mechanics.data.IChunkMetaDataHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkDataHandler {
    private final String BASE_TAG_NAME = "TecTechData";
    private final HashMap<Integer, HashMap<ChunkCoordIntPair, NBTChunk>> dimensionWiseChunkData = new HashMap();
    private final HashMap<String, HashMap<Integer, ChunkHashMap>> dimensionWiseMetaChunkData = new HashMap();
    private final HashMap<String, IChunkMetaDataHandler> metaDataHandlerHashMap = new HashMap();
    private final ArrayList<IChunkMetaDataHandler> pushSyncHandlers = new ArrayList();
    private final ArrayList<IChunkMetaDataHandler> pullSyncHandlers = new ArrayList();
    private final ArrayList<IChunkMetaDataHandler> serverHandlers = new ArrayList();
    private final ArrayList<IChunkMetaDataHandler> worldHandlers = new ArrayList();
    private final ArrayList<IChunkMetaDataHandler> playerHandlers = new ArrayList();
    private final ArrayList<IChunkMetaDataHandler> clientHandlers = new ArrayList();
    private final ArrayList<IChunkMetaDataHandler> renderHandlers = new ArrayList();

    private HashMap<ChunkCoordIntPair, NBTChunk> getOrCreateDimensionWiseChunkData(int dim) {
        return this.dimensionWiseChunkData.computeIfAbsent(dim, m -> {
            HashMap map = new HashMap();
            for (Map.Entry<String, IChunkMetaDataHandler> meta : this.metaDataHandlerHashMap.entrySet()) {
                this.dimensionWiseMetaChunkData.get(meta.getKey()).put(dim, new ChunkHashMap(meta.getValue(), map));
            }
            return map;
        });
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        int dim = event.world.field_73011_w.field_76574_g;
        this.getOrCreateDimensionWiseChunkData(dim);
    }

    @SubscribeEvent
    public void handleChunkSaveEvent(ChunkDataEvent.Save event) {
        NBTChunk chunkData;
        HashMap<ChunkCoordIntPair, NBTChunk> dimensionData = this.dimensionWiseChunkData.get(event.world.field_73011_w.field_76574_g);
        NBTChunk nBTChunk = chunkData = dimensionData != null ? dimensionData.get(event.getChunk().func_76632_l()) : null;
        if (chunkData == null) {
            event.getData().func_82580_o("TecTechData");
        } else {
            chunkData.isLoaded = true;
            event.getData().func_74782_a("TecTechData", chunkData.data.func_74737_b());
        }
    }

    @SubscribeEvent
    public void handleChunkLoadEvent(ChunkDataEvent.Load event) {
        block8: {
            NBTChunk chunkMemory;
            Set loadedKeys;
            ChunkCoordIntPair chunkCoordIntPair;
            int dimId;
            NBTTagCompound loadedTag;
            block7: {
                loadedTag = event.getData().func_74775_l("TecTechData");
                if (loadedTag.func_82582_d()) {
                    return;
                }
                dimId = event.world.field_73011_w.field_76574_g;
                HashMap<ChunkCoordIntPair, NBTChunk> dimensionMemory = this.getOrCreateDimensionWiseChunkData(dimId);
                chunkCoordIntPair = event.getChunk().func_76632_l();
                loadedKeys = loadedTag.func_150296_c();
                chunkMemory = dimensionMemory.get(chunkCoordIntPair);
                if (chunkMemory != null) break block7;
                chunkMemory = new NBTChunk(loadedTag, true);
                dimensionMemory.put(chunkCoordIntPair, chunkMemory);
                for (String s : loadedKeys) {
                    this.dimensionWiseMetaChunkData.get(s).get(dimId).putLoaded(chunkCoordIntPair, loadedTag.func_74775_l(s));
                }
                break block8;
            }
            if (chunkMemory.isLoaded) break block8;
            chunkMemory.isLoaded = true;
            HashSet tagsDuplicated = new HashSet(loadedKeys);
            tagsDuplicated.retainAll(chunkMemory.data.func_150296_c());
            if (tagsDuplicated.isEmpty()) {
                for (String s : loadedKeys) {
                    NBTTagCompound tag = loadedTag.func_74775_l(s);
                    chunkMemory.data.func_74782_a(s, (NBTBase)tag);
                    this.dimensionWiseMetaChunkData.get(s).get(dimId).putLoaded(chunkCoordIntPair, tag);
                }
            } else {
                for (String s : loadedKeys) {
                    NBTTagCompound memory = chunkMemory.data.func_74775_l(s);
                    if (tagsDuplicated.contains(s)) {
                        this.metaDataHandlerHashMap.get(s).mergeData(memory, loadedTag.func_74775_l(s));
                        continue;
                    }
                    chunkMemory.data.func_74782_a(s, (NBTBase)loadedTag.func_74775_l(s));
                    this.dimensionWiseMetaChunkData.get(s).get(dimId).putLoaded(chunkCoordIntPair, memory);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onLoadChunk(ChunkEvent.Load aEvent) {
        if (aEvent.world.field_72995_K && !Minecraft.func_71410_x().func_71356_B()) {
            this.pullSyncHandlers.forEach(chunkMetaDataHandler -> chunkMetaDataHandler.pullData(aEvent));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onUnloadChunk(ChunkEvent.Unload aEvent) {
        if (aEvent.world.field_72995_K && !Minecraft.func_71410_x().func_71356_B()) {
            this.pullSyncHandlers.forEach(chunkMetaDataHandler -> this.dimensionWiseMetaChunkData.get(chunkMetaDataHandler.getTagName()).get(aEvent.world.field_73011_w.field_76574_g).remove(aEvent.getChunk().func_76632_l()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent aEvent) {
        this.clientHandlers.forEach(chunkMetaDataHandler -> chunkMetaDataHandler.tickClient(this.dimensionWiseMetaChunkData.get(chunkMetaDataHandler.getTagName()), aEvent));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTickEvent(TickEvent.RenderTickEvent aEvent) {
        this.renderHandlers.forEach(chunkMetaDataHandler -> chunkMetaDataHandler.tickRender(this.dimensionWiseMetaChunkData.get(chunkMetaDataHandler.getTagName()), aEvent));
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent aEvent) {
        this.serverHandlers.forEach(chunkMetaDataHandler -> chunkMetaDataHandler.tickServer(this.dimensionWiseMetaChunkData.get(chunkMetaDataHandler.getTagName()), aEvent));
    }

    @SubscribeEvent
    public void onWorldTickEvent(TickEvent.WorldTickEvent aEvent) {
        int dim = aEvent.world.field_73011_w.field_76574_g;
        this.pushSyncHandlers.forEach(chunkMetaDataHandler -> {
            ArrayList work;
            ChunkHashMap data = this.dimensionWiseMetaChunkData.get(chunkMetaDataHandler.getTagName()).get(dim);
            int cycle = chunkMetaDataHandler.pushPayloadSpreadPeriod();
            int epoch = (int)(aEvent.world.func_82737_E() % (long)cycle);
            if (epoch == 0) {
                int per = data.dirtyBoys.size() / cycle;
                int mod = data.dirtyBoys.size() % cycle;
                Iterator iter = data.dirtyBoys.iterator();
                for (int periodWork = 0; periodWork < cycle; ++periodWork) {
                    work = (ArrayList)data.workLoad.get(periodWork);
                    for (int i = 0; i < per; ++i) {
                        work.add(iter.next());
                    }
                    if (periodWork >= mod) continue;
                    work.add(iter.next());
                }
                data.dirtyBoys.clear();
            }
            work = (ArrayList)data.workLoad.get(epoch);
            chunkMetaDataHandler.pushPayload(aEvent.world, work);
            work.clear();
        });
        this.worldHandlers.forEach(chunkMetaDataHandler -> chunkMetaDataHandler.tickWorld(this.dimensionWiseMetaChunkData.get(chunkMetaDataHandler.getTagName()), aEvent));
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent aEvent) {
        this.playerHandlers.forEach(chunkMetaDataHandler -> chunkMetaDataHandler.tickPlayer(this.dimensionWiseMetaChunkData.get(chunkMetaDataHandler.getTagName()), aEvent));
    }

    public void clearData() {
        this.dimensionWiseChunkData.clear();
        this.dimensionWiseMetaChunkData.forEach((k, v) -> v.clear());
    }

    public IChunkMetaDataHandler getChunkMetaDataHandler(String s) {
        return this.metaDataHandlerHashMap.get(s);
    }

    public void registerChunkMetaDataHandler(IChunkMetaDataHandler handler) {
        this.metaDataHandlerHashMap.put(handler.getTagName(), handler);
        this.dimensionWiseMetaChunkData.put(handler.getTagName(), new HashMap());
        Class<?> clazz = handler.getClass();
        try {
            if (clazz.getMethod("tickServer", HashMap.class, TickEvent.ServerTickEvent.class).getDeclaringClass() != IChunkMetaDataHandler.class) {
                this.serverHandlers.add(handler);
            }
            if (clazz.getMethod("tickPlayer", HashMap.class, TickEvent.PlayerTickEvent.class).getDeclaringClass() != IChunkMetaDataHandler.class) {
                this.playerHandlers.add(handler);
            }
            if (clazz.getMethod("pushData", World.class, ChunkCoordIntPair.class).getDeclaringClass() != IChunkMetaDataHandler.class) {
                this.pushSyncHandlers.add(handler);
            }
            if (clazz.getMethod("tickWorld", HashMap.class, TickEvent.WorldTickEvent.class).getDeclaringClass() != IChunkMetaDataHandler.class) {
                this.worldHandlers.add(handler);
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Cannot register common event handlers!", e);
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            try {
                if (clazz.getMethod("pullData", ChunkEvent.Load.class).getDeclaringClass() != IChunkMetaDataHandler.class) {
                    this.pullSyncHandlers.add(handler);
                }
                if (clazz.getMethod("tickClient", HashMap.class, TickEvent.ClientTickEvent.class).getDeclaringClass() != IChunkMetaDataHandler.class) {
                    this.clientHandlers.add(handler);
                }
                if (clazz.getMethod("tickRender", HashMap.class, TickEvent.RenderTickEvent.class).getDeclaringClass() != IChunkMetaDataHandler.class) {
                    this.renderHandlers.add(handler);
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Cannot register client event handlers!", e);
            }
        }
    }

    public NBTTagCompound removeChunkData(IChunkMetaDataHandler handler, int world, ChunkCoordIntPair chunk) {
        return this.dimensionWiseMetaChunkData.get(handler.getTagName()).get(world).remove(chunk);
    }

    public NBTTagCompound getChunkData(IChunkMetaDataHandler handler, int world, ChunkCoordIntPair chunk) {
        return this.dimensionWiseMetaChunkData.get(handler.getTagName()).get(world).get(chunk);
    }

    public NBTTagCompound putChunkData(IChunkMetaDataHandler handler, int world, ChunkCoordIntPair chunk, NBTTagCompound data) {
        return this.dimensionWiseMetaChunkData.get(handler.getTagName()).get(world).put(chunk, data);
    }

    public NBTTagCompound createIfAbsentChunkData(IChunkMetaDataHandler handler, int world, ChunkCoordIntPair chunk) {
        return this.dimensionWiseMetaChunkData.get(handler.getTagName()).get(world).computeIfAbsent(chunk, chunkCoordIntPair -> handler.createData());
    }

    public HashMap<Integer, ChunkHashMap> getChunkData(IChunkMetaDataHandler chunkMetaDataHandler) {
        return this.dimensionWiseMetaChunkData.get(chunkMetaDataHandler.getTagName());
    }

    public ChunkHashMap getChunkData(IChunkMetaDataHandler chunkMetaDataHandler, int world) {
        return this.dimensionWiseMetaChunkData.get(chunkMetaDataHandler.getTagName()).get(world);
    }

    private static final class NBTChunk {
        private final NBTTagCompound data;
        private boolean isLoaded;

        private NBTChunk(NBTTagCompound data, boolean isLoaded) {
            if (data == null) {
                data = new NBTTagCompound();
            }
            this.data = data;
            this.isLoaded = isLoaded;
        }
    }

    public static final class ChunkHashMap
    implements Map<ChunkCoordIntPair, NBTTagCompound> {
        private final HashMap<ChunkCoordIntPair, NBTChunk> storage;
        private final HashMap<ChunkCoordIntPair, NBTTagCompound> storageMeta = new HashMap(1024);
        private final HashSet<ChunkCoordIntPair> dirtyBoys = new HashSet(1024);
        private final ArrayList<ArrayList<ChunkCoordIntPair>> workLoad = new ArrayList();
        private final String meta;

        private ChunkHashMap(IChunkMetaDataHandler meta, HashMap<ChunkCoordIntPair, NBTChunk> storage) {
            this.storage = storage;
            this.meta = meta.getTagName();
            for (int i = 0; i < meta.pushPayloadSpreadPeriod(); ++i) {
                this.workLoad.add(new ArrayList(128));
            }
        }

        public void markForTransmissionToClient(ChunkCoordIntPair chunk) {
            this.dirtyBoys.add(chunk);
        }

        private void putLoaded(ChunkCoordIntPair key, NBTTagCompound value) {
            this.storageMeta.put(key, value);
        }

        @Override
        public NBTTagCompound remove(Object key) {
            NBTTagCompound compound = this.storageMeta.remove(key);
            if (compound != null) {
                NBTChunk chunk = this.storage.get(key);
                chunk.data.func_82580_o(this.meta);
                if (chunk.data.func_82582_d()) {
                    this.storage.remove(key);
                }
            }
            return compound;
        }

        @Override
        public NBTTagCompound put(ChunkCoordIntPair key, NBTTagCompound value) {
            if (value == null) {
                return this.remove(key);
            }
            NBTChunk chunk = this.storage.get(key);
            if (chunk == null) {
                NBTTagCompound base = new NBTTagCompound();
                base.func_74782_a(this.meta, (NBTBase)value);
                this.storage.put(key, new NBTChunk(base, false));
            } else {
                chunk.data.func_74782_a(this.meta, (NBTBase)value);
            }
            return this.storageMeta.put(key, value);
        }

        @Override
        public int size() {
            return this.storageMeta.size();
        }

        @Override
        public boolean isEmpty() {
            return this.storageMeta.isEmpty();
        }

        @Override
        public NBTTagCompound get(Object key) {
            return this.storageMeta.get(key);
        }

        @Override
        public void clear() {
            this.storageMeta.entrySet().forEach(this::remove);
        }

        @Override
        public void putAll(Map<? extends ChunkCoordIntPair, ? extends NBTTagCompound> m) {
            m.forEach(this::put);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.storageMeta.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.storageMeta.containsValue(value);
        }

        @Override
        public Set<ChunkCoordIntPair> keySet() {
            return this.storageMeta.keySet();
        }

        @Override
        public Collection<NBTTagCompound> values() {
            return this.storageMeta.values();
        }

        @Override
        public Set<Map.Entry<ChunkCoordIntPair, NBTTagCompound>> entrySet() {
            return this.storageMeta.entrySet();
        }
    }
}

