/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.font;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TecTechFontRender
extends FontRenderer {
    public static final TecTechFontRender INSTANCE = new TecTechFontRender();
    private static final float DISTANCE_L = 0.125f;
    private static final float DISTANCE_L2 = 0.25f;
    private static final float DISTANCE_M = 0.06f;
    private static final float DISTANCE_M2 = 0.12f;
    private static final float DISTANCE_A = 0.06f;
    private static final float DISTANCE_A2 = 0.12f;

    private TecTechFontRender() {
        super(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
    }

    private void resetStyles() {
        this.field_78303_s = false;
        this.field_78302_t = false;
        this.field_78301_u = false;
        this.field_78300_v = false;
        this.field_78299_w = false;
    }

    private int renderString(String p_78258_1_, int p_78258_2_, int p_78258_3_, int p_78258_4_, boolean p_78258_5_) {
        if (p_78258_1_ == null) {
            return 0;
        }
        if (this.field_78294_m) {
            p_78258_1_ = this.bidiReorder(p_78258_1_);
        }
        if ((p_78258_4_ & 0xFC000000) == 0) {
            p_78258_4_ |= 0xFF000000;
        }
        if (p_78258_5_) {
            p_78258_4_ = (p_78258_4_ & 0xFCFCFC) >> 2 | p_78258_4_ & 0xFF000000;
        }
        this.field_78291_n = (float)(p_78258_4_ >> 16 & 0xFF) / 255.0f;
        this.field_78292_o = (float)(p_78258_4_ >> 8 & 0xFF) / 255.0f;
        this.field_78306_p = (float)(p_78258_4_ & 0xFF) / 255.0f;
        this.field_78305_q = (float)(p_78258_4_ >> 24 & 0xFF) / 255.0f;
        this.setColor(this.field_78291_n, this.field_78292_o, this.field_78306_p, this.field_78305_q);
        this.field_78295_j = p_78258_2_;
        this.field_78296_k = p_78258_3_;
        this.renderStringAtPos(p_78258_1_, p_78258_5_);
        return (int)this.field_78295_j;
    }

    private String bidiReorder(String p_147647_1_) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(p_147647_1_), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException var3) {
            return p_147647_1_;
        }
    }

    private void renderStringAtPos(String p_78255_1_, boolean p_78255_2_) {
        for (int i = 0; i < p_78255_1_.length(); ++i) {
            boolean flag1;
            int k;
            int j;
            char c0 = p_78255_1_.charAt(i);
            if (c0 == '\u00a7' && i + 1 < p_78255_1_.length()) {
                j = "0123456789abcdefklmnor".indexOf(p_78255_1_.toLowerCase().charAt(i + 1));
                if (j < 16) {
                    this.field_78303_s = false;
                    this.field_78302_t = false;
                    this.field_78299_w = false;
                    this.field_78300_v = false;
                    this.field_78301_u = false;
                    if (j < 0 || j > 15) {
                        j = 15;
                    }
                    if (p_78255_2_) {
                        j += 16;
                    }
                    this.field_78304_r = k = this.field_78285_g[j];
                    this.setColor((float)(k >> 16) / 255.0f, (float)(k >> 8 & 0xFF) / 255.0f, (float)(k & 0xFF) / 255.0f, this.field_78305_q);
                } else if (j == 16) {
                    this.field_78303_s = true;
                } else if (j == 17) {
                    this.field_78302_t = true;
                } else if (j == 18) {
                    this.field_78299_w = true;
                } else if (j == 19) {
                    this.field_78300_v = true;
                } else if (j == 20) {
                    this.field_78301_u = true;
                } else if (j == 21) {
                    this.field_78303_s = false;
                    this.field_78302_t = false;
                    this.field_78299_w = false;
                    this.field_78300_v = false;
                    this.field_78301_u = false;
                    this.setColor(this.field_78291_n, this.field_78292_o, this.field_78306_p, this.field_78305_q);
                }
                ++i;
                continue;
            }
            j = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(c0);
            if (this.field_78303_s && j != -1) {
                while (this.field_78286_d[j] != this.field_78286_d[k = this.field_78289_c.nextInt(this.field_78286_d.length)]) {
                }
                j = k;
            }
            float f1 = this.field_78293_l ? 0.5f : 1.0f;
            boolean bl = flag1 = (c0 == '\u0000' || j == -1 || this.field_78293_l) && p_78255_2_;
            if (flag1) {
                this.field_78295_j -= f1;
                this.field_78296_k -= f1;
            }
            float f = this.renderCharAtPos(j, c0, this.field_78301_u);
            if (flag1) {
                this.field_78295_j += f1;
                this.field_78296_k += f1;
            }
            if (this.field_78302_t) {
                this.field_78295_j += f1;
                if (flag1) {
                    this.field_78295_j -= f1;
                    this.field_78296_k -= f1;
                }
                this.renderCharAtPos(j, c0, this.field_78301_u);
                this.field_78295_j -= f1;
                if (flag1) {
                    this.field_78295_j += f1;
                    this.field_78296_k += f1;
                }
                f += 1.0f;
            }
            this.doDraw(f);
        }
    }

    protected void doDraw(float f) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (this.field_78299_w) {
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            tessellator.func_78377_a((double)this.field_78295_j, (double)(this.field_78296_k + (float)(this.field_78288_b / 2)), 0.0);
            tessellator.func_78377_a((double)(this.field_78295_j + f), (double)(this.field_78296_k + (float)(this.field_78288_b / 2)), 0.0);
            tessellator.func_78377_a((double)(this.field_78295_j + f), (double)(this.field_78296_k + (float)(this.field_78288_b / 2) - 1.0f), 0.0);
            tessellator.func_78377_a((double)this.field_78295_j, (double)(this.field_78296_k + (float)(this.field_78288_b / 2) - 1.0f), 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
        }
        if (this.field_78300_v) {
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            int l = this.field_78300_v ? -1 : 0;
            tessellator.func_78377_a((double)(this.field_78295_j + (float)l), (double)(this.field_78296_k + (float)this.field_78288_b), 0.0);
            tessellator.func_78377_a((double)(this.field_78295_j + f), (double)(this.field_78296_k + (float)this.field_78288_b), 0.0);
            tessellator.func_78377_a((double)(this.field_78295_j + f), (double)(this.field_78296_k + (float)this.field_78288_b - 1.0f), 0.0);
            tessellator.func_78377_a((double)(this.field_78295_j + (float)l), (double)(this.field_78296_k + (float)this.field_78288_b - 1.0f), 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
        }
        this.field_78295_j += (float)((int)f);
    }

    private float renderCharAtPos(int p_78278_1_, char p_78278_2_, boolean p_78278_3_) {
        return p_78278_2_ == ' ' ? 4.0f : ("\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(p_78278_2_) != -1 && !this.field_78293_l ? this.func_78266_a(p_78278_1_, p_78278_3_) : this.func_78277_a(p_78278_2_, p_78278_3_));
    }

    protected float func_78266_a(int p_78266_1_, boolean p_78266_2_) {
        return super.func_78266_a(p_78266_1_, p_78266_2_);
    }

    protected float func_78277_a(char p_78277_1_, boolean p_78277_2_) {
        return super.func_78277_a(p_78277_1_, p_78277_2_);
    }

    public int func_85187_a(String str, int x, int y, int color, boolean dropShadow) {
        switch (Minecraft.func_71410_x().field_71474_y.field_74335_Z) {
            case 0: {
                this.func_78264_a(true);
                --y;
                GL11.glPushMatrix();
                if (dropShadow) {
                    GL11.glTranslatef((float)0.06f, (float)0.06f, (float)0.0f);
                    this.drawStringBack(str, x, y, color);
                    GL11.glTranslatef((float)-0.12f, (float)0.0f, (float)0.0f);
                    this.drawStringBack(str, x, y, color);
                    GL11.glTranslatef((float)0.0f, (float)-0.12f, (float)0.0f);
                    this.drawStringBack(str, x, y, color);
                    GL11.glTranslatef((float)0.12f, (float)0.0f, (float)0.0f);
                }
                GL11.glTranslatef((float)0.06f, (float)0.06f, (float)0.0f);
                this.drawStringFront(str, x, y, color);
                GL11.glTranslatef((float)-0.12f, (float)0.0f, (float)0.0f);
                this.drawStringFront(str, x, y, color);
                GL11.glTranslatef((float)0.0f, (float)-0.12f, (float)0.0f);
                this.drawStringFront(str, x, y, color);
                GL11.glTranslatef((float)0.12f, (float)0.0f, (float)0.0f);
                GL11.glPopMatrix();
                break;
            }
            case 1: {
                return Minecraft.func_71410_x().field_71466_p.func_85187_a(str, x, y, color, dropShadow);
            }
            case 2: {
                this.func_78264_a(true);
                --y;
                GL11.glPushMatrix();
                if (dropShadow) {
                    GL11.glTranslatef((float)0.06f, (float)0.06f, (float)0.0f);
                    this.drawStringBack(str, x, y, color);
                    GL11.glTranslatef((float)-0.12f, (float)0.0f, (float)0.0f);
                    this.drawStringBack(str, x, y, color);
                    GL11.glTranslatef((float)0.0f, (float)-0.12f, (float)0.0f);
                    this.drawStringBack(str, x, y, color);
                    GL11.glTranslatef((float)0.12f, (float)0.0f, (float)0.0f);
                }
                GL11.glTranslatef((float)0.06f, (float)0.06f, (float)0.0f);
                this.drawStringFront(str, x, y, color);
                GL11.glTranslatef((float)-0.12f, (float)0.0f, (float)0.0f);
                this.drawStringFront(str, x, y, color);
                GL11.glTranslatef((float)0.0f, (float)-0.12f, (float)0.0f);
                this.drawStringFront(str, x, y, color);
                GL11.glTranslatef((float)0.12f, (float)0.0f, (float)0.0f);
                GL11.glPopMatrix();
                break;
            }
            case 3: {
                this.func_78264_a(true);
                --y;
                GL11.glPushMatrix();
                if (dropShadow) {
                    GL11.glTranslatef((float)0.125f, (float)0.125f, (float)0.0f);
                    this.drawStringBack(str, x, y, color);
                    GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.0f);
                    this.drawStringBack(str, x, y, color);
                    GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                    this.drawStringBack(str, x, y, color);
                    GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.0f);
                }
                GL11.glTranslatef((float)0.125f, (float)0.125f, (float)0.0f);
                this.drawStringFront(str, x, y, color);
                GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.0f);
                this.drawStringFront(str, x, y, color);
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                this.drawStringFront(str, x, y, color);
                GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.0f);
                GL11.glPopMatrix();
            }
        }
        return this.drawStringFront(str, x, y, color);
    }

    public void func_78279_b(String str, int x, int y, int maxWidth, int color) {
        switch (Minecraft.func_71410_x().field_71474_y.field_74335_Z) {
            case 0: {
                this.func_78264_a(true);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.06f, (float)0.06f, (float)0.0f);
                super.func_78279_b(str, x, --y, maxWidth, color);
                GL11.glTranslatef((float)-0.12f, (float)0.0f, (float)0.0f);
                super.func_78279_b(str, x, y, maxWidth, color);
                GL11.glTranslatef((float)0.0f, (float)-0.12f, (float)0.0f);
                super.func_78279_b(str, x, y, maxWidth, color);
                GL11.glTranslatef((float)0.12f, (float)0.0f, (float)0.0f);
                GL11.glPopMatrix();
                break;
            }
            case 1: {
                Minecraft.func_71410_x().field_71466_p.func_78279_b(str, x, y, maxWidth, color);
                break;
            }
            case 2: {
                this.func_78264_a(true);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.06f, (float)0.06f, (float)0.0f);
                super.func_78279_b(str, x, --y, maxWidth, color);
                GL11.glTranslatef((float)-0.12f, (float)0.0f, (float)0.0f);
                super.func_78279_b(str, x, y, maxWidth, color);
                GL11.glTranslatef((float)0.0f, (float)-0.12f, (float)0.0f);
                super.func_78279_b(str, x, y, maxWidth, color);
                GL11.glTranslatef((float)0.12f, (float)0.0f, (float)0.0f);
                GL11.glPopMatrix();
                break;
            }
            case 3: {
                this.func_78264_a(true);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.125f, (float)0.125f, (float)0.0f);
                super.func_78279_b(str, x, --y, maxWidth, color);
                GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.0f);
                super.func_78279_b(str, x, y, maxWidth, color);
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                super.func_78279_b(str, x, y, maxWidth, color);
                GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.0f);
                GL11.glPopMatrix();
            }
        }
    }

    protected void setColor(float r, float g, float b, float a) {
        super.setColor(r, g, b, a);
    }

    protected void enableAlpha() {
        super.enableAlpha();
    }

    protected void bindTexture(ResourceLocation location) {
        super.bindTexture(location);
    }

    protected InputStream getResourceInputStream(ResourceLocation location) throws IOException {
        return super.getResourceInputStream(location);
    }

    private int drawStringFront(String p_85187_1_, int p_85187_2_, int p_85187_3_, int p_85187_4_) {
        GL11.glEnable((int)3008);
        this.resetStyles();
        return this.renderString(p_85187_1_, p_85187_2_, p_85187_3_, p_85187_4_, false);
    }

    private int drawStringBack(String p_85187_1_, int p_85187_2_, int p_85187_3_, int p_85187_4_) {
        GL11.glEnable((int)3008);
        this.resetStyles();
        return this.renderString(p_85187_1_, p_85187_2_ + 1, p_85187_3_ + 1, p_85187_4_, true);
    }

    public int func_78256_a(String p_78256_1_) {
        if (Minecraft.func_71410_x().field_71474_y.field_74335_Z == 1) {
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(p_78256_1_);
        }
        if (p_78256_1_ == null) {
            return 0;
        }
        int i = 0;
        boolean flag = false;
        for (int j = 0; j < p_78256_1_.length(); ++j) {
            char c0 = p_78256_1_.charAt(j);
            int k = this.func_78263_a(c0);
            if (k < 0 && j < p_78256_1_.length() - 1) {
                if ((c0 = p_78256_1_.charAt(++j)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0;
            }
            i += k;
            if (!flag || k <= 0) continue;
            ++i;
        }
        return i;
    }
}

