/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.maps;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMTransformationRegistry;
import com.github.technus.tectech.util.DoubleCount;
import com.github.technus.tectech.util.TT_Utility;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public interface IEMMapRead<T extends IEMStack>
extends Comparable<IEMMapRead<? extends IEMStack>>,
Cloneable {
    public NavigableMap<IEMDefinition, T> getBackingMap();

    public IEMMapRead<T> clone();

    default public Set<Map.Entry<IEMDefinition, T>> entrySet() {
        return this.getBackingMap().entrySet();
    }

    default public Set<IEMDefinition> keySet() {
        return this.getBackingMap().keySet();
    }

    default public IEMDefinition[] keySetToArray() {
        return this.keySetToArray(new IEMDefinition[this.size()]);
    }

    default public IEMDefinition[] keySetToArray(IEMDefinition[] array) {
        return this.keySet().toArray(array);
    }

    default public Collection<T> values() {
        return this.getBackingMap().values();
    }

    default public T[] valuesToArray() {
        return this.valuesToArray((IEMStack[])Array.newInstance(this.getType(), this.size()));
    }

    default public T[] valuesToArray(T[] array) {
        return (IEMStack[])this.values().toArray(array);
    }

    public Class<T> getType();

    default public T getFirst() {
        return (T)((IEMStack)this.getBackingMap().firstEntry().getValue());
    }

    default public T getLast() {
        return (T)((IEMStack)this.getBackingMap().lastEntry().getValue());
    }

    default public T get(IEMStack stack) {
        return this.get(stack.getDefinition());
    }

    default public T get(IEMDefinition def) {
        return (T)((IEMStack)this.getBackingMap().get(def));
    }

    default public T getNaturallySorted(int pos) {
        if (pos < 0 || pos >= this.size()) {
            throw new IndexOutOfBoundsException("Index was: " + pos + " size was: " + this.size());
        }
        for (Map.Entry<IEMDefinition, T> entry : this.entrySet()) {
            if (pos == 0) {
                return (T)((IEMStack)entry.getValue());
            }
            --pos;
        }
        return null;
    }

    default public T getRandom() {
        return this.getNaturallySorted(TecTech.RANDOM.nextInt(this.size()));
    }

    default public String[] getShortSymbolsInfo() {
        String[] info = new String[this.size()];
        int i = 0;
        for (Map.Entry<IEMDefinition, T> instance : this.entrySet()) {
            info[i++] = ((IEMStack)instance.getValue()).getDefinition().getShortSymbol();
        }
        return info;
    }

    default public String[] getElementalInfo() {
        String[] info = new String[this.size()];
        int i = 0;
        for (Map.Entry<IEMDefinition, T> entry : this.entrySet()) {
            IEMStack instance = (IEMStack)entry.getValue();
            info[i++] = EnumChatFormatting.BLUE + instance.getDefinition().getLocalizedName() + " " + EnumChatFormatting.AQUA + instance.getDefinition().getSymbol() + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"tt.keyword.short.amount") + ": " + EnumChatFormatting.GREEN + TT_Utility.formatNumberExp(instance.getAmount() / 6.02214076E23) + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.mol") + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"tt.keyword.short.charge") + ": " + EnumChatFormatting.GREEN + TT_Utility.formatNumberExp(instance.getCharge()) + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.charge") + EnumChatFormatting.RESET;
        }
        return info;
    }

    default public NBTTagCompound toNBT(EMDefinitionsRegistry registry) {
        return TT_Utility.packNBT(t -> t.toNBT(registry), this.valuesToArray());
    }

    @Override
    default public int compareTo(IEMMapRead<? extends IEMStack> o) {
        int sizeDiff = this.size() - o.size();
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        Iterator<Map.Entry<IEMDefinition, T>> iterator = this.entrySet().iterator();
        Iterator<Map.Entry<IEMDefinition, ? extends IEMStack>> iteratorO = o.entrySet().iterator();
        while (iterator.hasNext()) {
            int result = ((IEMStack)iterator.next().getValue()).compareTo(iteratorO.next().getValue());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    default public int compareWithAmountsInternal(IEMMapRead<? extends IEMStack> o) {
        if (o == null) {
            return 1;
        }
        int lenDiff = this.size() - o.size();
        if (lenDiff != 0) {
            return lenDiff;
        }
        Iterator<Map.Entry<IEMDefinition, T>> iterator = this.entrySet().iterator();
        Iterator<Map.Entry<IEMDefinition, ? extends IEMStack>> iteratorO = o.entrySet().iterator();
        while (iterator.hasNext()) {
            IEMStack second;
            IEMStack first = (IEMStack)iterator.next().getValue();
            int result = first.compareTo(second = iteratorO.next().getValue());
            if (result != 0) {
                return result;
            }
            result = Double.compare(first.getAmount(), second.getAmount());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    default public double getMass() {
        double mass = 0.0;
        for (Map.Entry<IEMDefinition, T> entry : this.entrySet()) {
            mass += ((IEMStack)entry.getValue()).getMass();
        }
        return mass;
    }

    default public long getCharge() {
        long charge = 0L;
        for (Map.Entry<IEMDefinition, T> entry : this.entrySet()) {
            charge = (long)((double)charge + ((IEMStack)entry.getValue()).getCharge());
        }
        return charge;
    }

    default public boolean containsKey(IEMDefinition def) {
        return this.getBackingMap().containsKey(def);
    }

    default public boolean containsKey(IEMStack def) {
        return this.containsKey(def.getDefinition());
    }

    default public boolean containsAllKeys(IEMDefinition ... definitions) {
        for (IEMDefinition def : definitions) {
            if (this.containsKey(def)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAllKeys(IEMStack ... hasElementalDefinition) {
        for (IEMStack has : hasElementalDefinition) {
            if (this.containsKey(has)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAmountExact(IEMDefinition def, double amount) {
        T target = this.get(def);
        return target != null && target.getAmount() >= amount;
    }

    default public boolean containsAmountExact(IEMStack stack) {
        return this.containsAmountExact(stack.getDefinition(), stack.getAmount());
    }

    default public boolean containsAllAmountsExact(IEMStack ... stacks) {
        for (IEMStack stack : stacks) {
            if (this.containsAmountExact(stack)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAllAmountsExact(IEMMapRead<? extends IEMStack> container) {
        for (Map.Entry<IEMDefinition, ? extends IEMStack> entry : container.entrySet()) {
            if (this.containsAmountExact(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAmount(IEMDefinition def, double amountToConsume) {
        double amountRequired = amountToConsume - EMTransformationRegistry.EM_COUNT_EPSILON;
        if (amountRequired == amountToConsume) {
            amountRequired -= DoubleCount.ulpSigned(amountRequired);
        }
        return this.containsAmountExact(def, amountRequired);
    }

    default public boolean containsAmount(IEMStack stack) {
        return this.containsAmount(stack.getDefinition(), stack.getAmount());
    }

    default public boolean containsAllAmounts(IEMStack ... stacks) {
        for (IEMStack stack : stacks) {
            if (this.containsAmount(stack)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAllAmounts(IEMMapRead<? extends IEMStack> container) {
        for (Map.Entry<IEMDefinition, ? extends IEMStack> entry : container.entrySet()) {
            if (this.containsAmount(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    default public int size() {
        return this.getBackingMap().size();
    }

    default public boolean hasStacks() {
        return !this.isEmpty();
    }

    default public boolean isEmpty() {
        return this.getBackingMap().isEmpty();
    }
}

