/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.loader;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.transformations.AspectDefinitionCompat;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.transformations.AspectDefinitionCompatEnabled;
import com.github.technus.tectech.compatibility.thaumcraft.thing.metaTileEntity.multi.EssentiaCompat;
import com.github.technus.tectech.compatibility.thaumcraft.thing.metaTileEntity.multi.EssentiaCompatEnabled;
import com.github.technus.tectech.loader.ElementalLoader;
import com.github.technus.tectech.loader.EntityLoader;
import com.github.technus.tectech.loader.NetworkDispatcher;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.loader.gui.CreativeTabEM;
import com.github.technus.tectech.loader.gui.CreativeTabTecTech;
import com.github.technus.tectech.loader.gui.ModGuiHandler;
import com.github.technus.tectech.loader.recipe.BaseRecipeLoader;
import com.github.technus.tectech.loader.thing.ComponentLoader;
import com.github.technus.tectech.loader.thing.CoverLoader;
import com.github.technus.tectech.loader.thing.MachineLoader;
import com.github.technus.tectech.loader.thing.ThingsLoader;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMTransformationRegistry;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.Textures;
import com.github.technus.tectech.thing.metaTileEntity.multi.em_collider.GT_MetaTileEntity_EM_collider;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class MainLoader {
    public static DamageSource microwaving;
    public static DamageSource elementalPollution;
    public static DamageSource subspace;

    private MainLoader() {
    }

    public static void staticLoad() {
        new ComponentLoader();
    }

    public static void preLoad() {
        TecTech.creativeTabTecTech = new CreativeTabTecTech("TecTech");
        TecTech.creativeTabEM = new CreativeTabEM("EM");
        try {
            Textures.run();
        }
        catch (Throwable t) {
            TecTech.LOGGER.error("Loading textures...", (Object)t);
        }
    }

    public static void load(EMDefinitionsRegistry definitionsRegistry) {
        ProgressManager.ProgressBar progressBarLoad = ProgressManager.push((String)"TecTech Loader", (int)9);
        progressBarLoad.step("Elemental Things");
        new ElementalLoader().run(definitionsRegistry);
        TecTech.LOGGER.info((Object)"Elemental Init Done");
        progressBarLoad.step("Thaumcraft Compatibility");
        EssentiaCompat.essentiaContainerCompat = Loader.isModLoaded((String)"Thaumcraft") ? new EssentiaCompatEnabled() : new EssentiaCompat();
        TecTech.LOGGER.info((Object)"Thaumcraft Compatibility Done");
        progressBarLoad.step("Regular Things");
        new ThingsLoader().run();
        TecTech.LOGGER.info((Object)"Block/Item Init Done");
        progressBarLoad.step("Machine Things");
        new MachineLoader().run();
        TecTech.LOGGER.info((Object)"Machine Init Done");
        progressBarLoad.step("Cover Things");
        new CoverLoader().run();
        TecTech.LOGGER.info((Object)"Cover Init Done");
        progressBarLoad.step("Register entities");
        new EntityLoader().run();
        TecTech.LOGGER.info((Object)"Entities registered");
        progressBarLoad.step("Add damage types");
        microwaving = new DamageSource("microwaving").func_76348_h();
        elementalPollution = new DamageSource("elementalPollution").func_76348_h();
        subspace = new DamageSource("subspace").func_76348_h().func_151518_m();
        TecTech.LOGGER.info((Object)"Damage types addition Done");
        progressBarLoad.step("Register Packet Dispatcher");
        new NetworkDispatcher();
        TecTech.LOGGER.info((Object)"Packet Dispatcher registered");
        progressBarLoad.step("Register GUI Handler");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)TecTech.instance, (IGuiHandler)new ModGuiHandler());
        TecTech.proxy.registerRenderInfo();
        TecTech.LOGGER.info((Object)"GUI Handler registered");
        ProgressManager.pop((ProgressManager.ProgressBar)progressBarLoad);
    }

    public static void postLoad(EMDefinitionsRegistry definitionsRegistry, EMTransformationRegistry transformationInfo) {
        ProgressManager.ProgressBar progressBarPostLoad = ProgressManager.push((String)"TecTech Post Loader", (int)4);
        progressBarPostLoad.step("Dreamcraft Compatibility");
        if (Loader.isModLoaded((String)"dreamcraft")) {
            try {
                Class<?> clazz = Class.forName("com.dreammaster.gthandler.casings.GT_Container_CasingsNH");
                TT_Container_Casings.sBlockCasingsNH = (Block)clazz.getField("sBlockCasingsNH").get(null);
                if (TT_Container_Casings.sBlockCasingsNH == null) {
                    throw new NullPointerException("sBlockCasingsNH Is not set at this time");
                }
            }
            catch (Exception e) {
                throw new Error("Unable to get NH casings", e);
            }
        }
        progressBarPostLoad.step("Thaumcraft Compatibility");
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            AspectDefinitionCompat.aspectDefinitionCompat = new AspectDefinitionCompatEnabled();
            AspectDefinitionCompat.aspectDefinitionCompat.run(definitionsRegistry);
        } else {
            AspectDefinitionCompat.aspectDefinitionCompat = new AspectDefinitionCompat();
        }
        progressBarPostLoad.step("Recipes");
        new BaseRecipeLoader().run(transformationInfo);
        TecTech.LOGGER.info((Object)"Recipe Init Done");
        if (!TecTech.configTecTech.DISABLE_BLOCK_HARDNESS_NERF) {
            progressBarPostLoad.step("Nerf blocks blast resistance");
            MainLoader.adjustTwilightBlockResistance();
            TecTech.LOGGER.info((Object)"Blocks nerf done");
        } else {
            progressBarPostLoad.step("Do not nerf blocks blast resistance");
            TecTech.LOGGER.info((Object)"Blocks were not nerfed");
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBarPostLoad);
    }

    private static void registerExtraHazmats() {
        ItemStack EMT_iqC = GT_ModHandler.getModItem((String)"EMT", (String)"itemArmorQuantumChestplate", (long)1L, (int)Short.MAX_VALUE);
        ItemStack GRAVI_gC = GT_ModHandler.getModItem((String)"GraviSuite", (String)"graviChestPlate", (long)1L, (int)Short.MAX_VALUE);
        ItemStack GRAVI_anC = GT_ModHandler.getModItem((String)"GraviSuite", (String)"advNanoChestPlate", (long)1L, (int)Short.MAX_VALUE);
        ItemStack IC2_qH = GT_ModHandler.getIC2Item((String)"quantumHelmet", (long)1L, (int)Short.MAX_VALUE);
        ItemStack IC2_qC = GT_ModHandler.getIC2Item((String)"quantumBodyarmor", (long)1L, (int)Short.MAX_VALUE);
        ItemStack IC2_qL = GT_ModHandler.getIC2Item((String)"quantumLeggings", (long)1L, (int)Short.MAX_VALUE);
        ItemStack IC2_qB = GT_ModHandler.getIC2Item((String)"quantumBoots", (long)1L, (int)Short.MAX_VALUE);
        ItemStack IC2_nH = GT_ModHandler.getIC2Item((String)"nanoHelmet", (long)1L, (int)Short.MAX_VALUE);
        ItemStack IC2_nC = GT_ModHandler.getIC2Item((String)"nanoBodyarmor", (long)1L, (int)Short.MAX_VALUE);
        ItemStack IC2_nL = GT_ModHandler.getIC2Item((String)"nanoLeggings", (long)1L, (int)Short.MAX_VALUE);
        ItemStack IC2_nB = GT_ModHandler.getIC2Item((String)"nanoBoots", (long)1L, (int)Short.MAX_VALUE);
        GregTech_API.sFrostHazmatList.add(EMT_iqC);
        GregTech_API.sFrostHazmatList.add(GRAVI_gC);
        GregTech_API.sFrostHazmatList.add(IC2_qH);
        GregTech_API.sFrostHazmatList.add(IC2_qC);
        GregTech_API.sFrostHazmatList.add(IC2_qL);
        GregTech_API.sFrostHazmatList.add(IC2_qB);
        GregTech_API.sHeatHazmatList.add(EMT_iqC);
        GregTech_API.sHeatHazmatList.add(GRAVI_gC);
        GregTech_API.sHeatHazmatList.add(IC2_qH);
        GregTech_API.sHeatHazmatList.add(IC2_qC);
        GregTech_API.sHeatHazmatList.add(IC2_qL);
        GregTech_API.sHeatHazmatList.add(IC2_qB);
        GregTech_API.sBioHazmatList.add(EMT_iqC);
        GregTech_API.sBioHazmatList.add(GRAVI_gC);
        GregTech_API.sBioHazmatList.add(IC2_qH);
        GregTech_API.sBioHazmatList.add(IC2_qC);
        GregTech_API.sBioHazmatList.add(IC2_qL);
        GregTech_API.sBioHazmatList.add(IC2_qB);
        GregTech_API.sBioHazmatList.add(GRAVI_anC);
        GregTech_API.sBioHazmatList.add(IC2_nH);
        GregTech_API.sBioHazmatList.add(IC2_nC);
        GregTech_API.sBioHazmatList.add(IC2_nL);
        GregTech_API.sBioHazmatList.add(IC2_nB);
        GregTech_API.sGasHazmatList.add(EMT_iqC);
        GregTech_API.sGasHazmatList.add(GRAVI_gC);
        GregTech_API.sGasHazmatList.add(IC2_qH);
        GregTech_API.sGasHazmatList.add(IC2_qC);
        GregTech_API.sGasHazmatList.add(IC2_qL);
        GregTech_API.sGasHazmatList.add(IC2_qB);
        GregTech_API.sGasHazmatList.add(GRAVI_anC);
        GregTech_API.sGasHazmatList.add(IC2_nH);
        GregTech_API.sGasHazmatList.add(IC2_nC);
        GregTech_API.sGasHazmatList.add(IC2_nL);
        GregTech_API.sGasHazmatList.add(IC2_nB);
        GregTech_API.sRadioHazmatList.add(EMT_iqC);
        GregTech_API.sRadioHazmatList.add(GRAVI_gC);
        GregTech_API.sRadioHazmatList.add(IC2_qH);
        GregTech_API.sRadioHazmatList.add(IC2_qC);
        GregTech_API.sRadioHazmatList.add(IC2_qL);
        GregTech_API.sRadioHazmatList.add(IC2_qB);
        GregTech_API.sElectroHazmatList.add(EMT_iqC);
        GregTech_API.sElectroHazmatList.add(GRAVI_gC);
        GregTech_API.sElectroHazmatList.add(IC2_qH);
        GregTech_API.sElectroHazmatList.add(IC2_qC);
        GregTech_API.sElectroHazmatList.add(IC2_qL);
        GregTech_API.sElectroHazmatList.add(IC2_qB);
    }

    public static void addAfterGregTechPostLoadRunner() {
        GregTech_API.sAfterGTPostload.add(() -> {
            if (TecTech.configTecTech.NERF_FUSION) {
                MainLoader.FixBrokenFusionRecipes();
            }
            GT_MetaTileEntity_EM_collider.setValues(MainLoader.getFuelValue(Materials.Helium.getPlasma(125L)));
        });
    }

    private static void FixBrokenFusionRecipes() {
        HashMap<Fluid, Fluid> binds = new HashMap<Fluid, Fluid>();
        for (Materials material : Materials.values()) {
            FluidStack p = material.getPlasma(1L);
            if (p == null) continue;
            if (TecTechConfig.DEBUG_MODE) {
                TecTech.LOGGER.info((Object)("Found Plasma of " + material.mName));
            }
            if (material.mElement == null || material.mElement.mProtons < Materials.Iron.mElement.mProtons && -material.mElement.mProtons < Materials.Iron.mElement.mProtons && material.mElement.mNeutrons < Materials.Iron.mElement.mNeutrons && -material.mElement.mNeutrons < Materials.Iron.mElement.mNeutrons) continue;
            if (TecTechConfig.DEBUG_MODE) {
                TecTech.LOGGER.info((Object)("Attempting to bind " + material.mName));
            }
            if (material.getMolten(1L) != null) {
                binds.put(p.getFluid(), material.getMolten(1L).getFluid());
                continue;
            }
            if (material.getGas(1L) != null) {
                binds.put(p.getFluid(), material.getGas(1L).getFluid());
                continue;
            }
            if (material.getFluid(1L) != null) {
                binds.put(p.getFluid(), material.getFluid(1L).getFluid());
                continue;
            }
            binds.put(p.getFluid(), Materials.Iron.getMolten(1L).getFluid());
        }
        for (GT_Recipe r : GT_Recipe.GT_Recipe_Map.sFusionRecipes.mRecipeList) {
            Fluid fluid = (Fluid)binds.get(r.mFluidOutputs[0].getFluid());
            if (fluid != null) {
                if (TecTechConfig.DEBUG_MODE) {
                    TecTech.LOGGER.info((Object)("Nerfing Recipe " + r.mFluidOutputs[0].getUnlocalizedName()));
                }
                r.mFluidOutputs[0] = new FluidStack(fluid, r.mFluidOutputs[0].amount);
            }
            if ((fluid = (Fluid)binds.get(r.mFluidInputs[0].getFluid())) != null) {
                if (TecTechConfig.DEBUG_MODE) {
                    TecTech.LOGGER.info((Object)("Fixing plasma use in Recipe " + r.mFluidInputs[0].getUnlocalizedName()));
                }
                r.mFluidInputs[0] = new FluidStack(fluid, r.mFluidInputs[0].amount);
            }
            if ((fluid = (Fluid)binds.get(r.mFluidInputs[1].getFluid())) == null) continue;
            if (TecTechConfig.DEBUG_MODE) {
                TecTech.LOGGER.info((Object)("Fixing plasma use in Recipe " + r.mFluidInputs[1].getUnlocalizedName()));
            }
            r.mFluidInputs[1] = new FluidStack(fluid, r.mFluidInputs[1].amount);
        }
    }

    public static int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null || GT_Recipe.GT_Recipe_Map.sTurbineFuels == null) {
            return 0;
        }
        Collection tRecipeList = GT_Recipe.GT_Recipe_Map.sPlasmaFuels.mRecipeList;
        if (tRecipeList != null) {
            for (GT_Recipe tFuel : tRecipeList) {
                FluidStack tLiquid = GT_Utility.getFluidForFilledItem((ItemStack)tFuel.getRepresentativeInput(0), (boolean)true);
                if (tLiquid == null || !aLiquid.isFluidEqual(tLiquid)) continue;
                return tFuel.mSpecialValue;
            }
        }
        return 0;
    }

    private static void safeSetResistance(Block block, float resistance) {
        if (block != null) {
            block.func_149752_b(resistance);
        }
    }

    private static void adjustTwilightBlockResistance() {
        if (Loader.isModLoaded((String)"TwilightForest")) {
            MainLoader.safeSetResistance(GameRegistry.findBlock((String)"TwilightForest", (String)"tile.TFShield"), 30.0f);
            MainLoader.safeSetResistance(GameRegistry.findBlock((String)"TwilightForest", (String)"tile.TFThorns"), 10.0f);
            MainLoader.safeSetResistance(GameRegistry.findBlock((String)"TwilightForest", (String)"tile.TFTowerTranslucent"), 30.0f);
            MainLoader.safeSetResistance(GameRegistry.findBlock((String)"TwilightForest", (String)"tile.TFDeadrock"), 5.0f);
        }
    }
}

