/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.hatch;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.thing.metaTileEntity.hatch.gui.GT_Container_Uncertainty;
import com.github.technus.tectech.thing.metaTileEntity.hatch.gui.GT_GUIContainer_Uncertainty;
import com.github.technus.tectech.thing.metaTileEntity.hatch.gui.GT_GUIContainer_UncertaintyAdv;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.TT_Utility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GT_MetaTileEntity_Hatch_Uncertainty
extends GT_MetaTileEntity_Hatch {
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    public short[] matrix = new short[]{500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500};
    public byte selection = (byte)-1;
    public byte mode = 0;
    public byte status = (byte)-128;
    private String clientLocale = "en_US";

    public GT_MetaTileEntity_Hatch_Uncertainty(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "", new ITexture[0]);
        TT_Utility.setTier(aTier, (Object)this);
        this.regenerate();
    }

    public GT_MetaTileEntity_Hatch_Uncertainty(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        this.regenerate();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/UC");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/UC_ACTIVE");
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_Uncertainty(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mTier > 7) {
            return new GT_GUIContainer_UncertaintyAdv(aPlayerInventory, aBaseMetaTileEntity);
        }
        return new GT_GUIContainer_Uncertainty(aPlayerInventory, aBaseMetaTileEntity);
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)ScreenON)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)ScreenOFF)};
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (aTick & 0xFL) == 0L) {
            if (this.mode == 0) {
                aBaseMetaTileEntity.setActive(false);
                this.status = (byte)-128;
            } else {
                aBaseMetaTileEntity.setActive(true);
                this.shift();
                this.compute();
            }
        }
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_MetaTileEntity_Hatch_Uncertainty(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        return new String[]{StatCollector.func_74837_a((String)"tt.keyword.Status", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.GOLD + this.status};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mSel", this.selection);
        aNBT.func_74774_a("mMode", this.mode);
        aNBT.func_74774_a("mStatus", this.status);
        NBTTagCompound mat = new NBTTagCompound();
        for (int i = 0; i < 16; ++i) {
            mat.func_74777_a(Integer.toString(i), this.matrix[i]);
        }
        aNBT.func_74782_a("mMat", (NBTBase)mat);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.selection = aNBT.func_74771_c("mSel");
        this.mode = aNBT.func_74771_c("mMode");
        this.status = aNBT.func_74771_c("mStatus");
        NBTTagCompound mat = aNBT.func_74775_l("mMat");
        for (int i = 0; i < 16; ++i) {
            this.matrix[i] = mat.func_74765_d(Integer.toString(i));
        }
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public boolean isLiquidInput(byte aSide) {
        return false;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return false;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        try {
            EntityPlayerMP player = (EntityPlayerMP)aPlayer;
            this.clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
        }
        catch (Exception e) {
            this.clientLocale = "en_US";
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.certain.desc.0"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.hatch.certain.desc.1")};
    }

    private boolean balanceCheck(int sideLenY, short ... masses) {
        float inequality = 0.0f;
        for (int i = 0; i < masses.length >> 1; ++i) {
            inequality += (float)Math.abs(masses[i] - masses[masses.length - i - 1]);
        }
        return inequality < (float)(masses.length << 7);
    }

    public void regenerate() {
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = (short)TecTech.RANDOM.nextInt(1000);
        }
    }

    public byte compute() {
        int result = 0;
        switch (this.mode) {
            case 1: {
                result = this.balanceCheck(4, this.matrix) ? 0 : 1;
                break;
            }
            case 2: {
                result += this.balanceCheck(4, this.matrix[0], this.matrix[4], this.matrix[1], this.matrix[5], this.matrix[2], this.matrix[6], this.matrix[3], this.matrix[7]) ? 0 : 1;
                result += this.balanceCheck(4, this.matrix[8], this.matrix[12], this.matrix[9], this.matrix[13], this.matrix[10], this.matrix[14], this.matrix[11], this.matrix[15]) ? 0 : 2;
                break;
            }
            case 3: {
                result += this.balanceCheck(2, this.matrix[0], this.matrix[4], this.matrix[8], this.matrix[12], this.matrix[1], this.matrix[5], this.matrix[9], this.matrix[13]) ? 0 : 1;
                result += this.balanceCheck(4, this.matrix[0], this.matrix[4], this.matrix[1], this.matrix[5], this.matrix[2], this.matrix[6], this.matrix[3], this.matrix[7]) ? 0 : 2;
                result += this.balanceCheck(4, this.matrix[8], this.matrix[12], this.matrix[9], this.matrix[13], this.matrix[10], this.matrix[14], this.matrix[11], this.matrix[15]) ? 0 : 4;
                result += this.balanceCheck(2, this.matrix[2], this.matrix[6], this.matrix[10], this.matrix[14], this.matrix[3], this.matrix[7], this.matrix[11], this.matrix[15]) ? 0 : 8;
                break;
            }
            case 4: {
                result += this.balanceCheck(2, this.matrix[0], this.matrix[4], this.matrix[1], this.matrix[5]) ? 0 : 1;
                result += this.balanceCheck(2, this.matrix[8], this.matrix[12], this.matrix[9], this.matrix[13]) ? 0 : 2;
                result += this.balanceCheck(2, this.matrix[2], this.matrix[6], this.matrix[3], this.matrix[7]) ? 0 : 4;
                result += this.balanceCheck(2, this.matrix[10], this.matrix[14], this.matrix[11], this.matrix[15]) ? 0 : 8;
                break;
            }
            case 5: {
                result += this.balanceCheck(2, this.matrix[0], this.matrix[4], this.matrix[1], this.matrix[5]) ? 0 : 1;
                result += this.balanceCheck(2, this.matrix[8], this.matrix[12], this.matrix[9], this.matrix[13]) ? 0 : 2;
                result += this.balanceCheck(4, this.matrix) ? 0 : 4;
                result += this.balanceCheck(2, this.matrix[2], this.matrix[6], this.matrix[3], this.matrix[7]) ? 0 : 8;
                result += this.balanceCheck(2, this.matrix[10], this.matrix[14], this.matrix[11], this.matrix[15]) ? 0 : 16;
            }
        }
        this.status = (byte)result;
        return this.status;
    }

    private void shift() {
        int i = TecTech.RANDOM.nextInt(16);
        int j = TecTech.RANDOM.nextInt(128);
        int n = i;
        this.matrix[n] = (short)(this.matrix[n] + (((this.matrix[i] & 1) == 0 ? 2 : -2) * j >> 5));
        int n2 = i;
        this.matrix[n2] = (short)(this.matrix[n2] + (j == 0 ? (short)1 : 0));
        if (this.matrix[i] < 0) {
            this.matrix[i] = 0;
        } else if (this.matrix[i] > 1000) {
            this.matrix[i] = 999;
        }
    }

    public byte update(int newMode) {
        if (newMode == this.mode) {
            return this.status;
        }
        if (newMode < 0 || newMode > 5) {
            newMode = 0;
        }
        this.mode = (byte)newMode;
        this.regenerate();
        this.compute();
        return this.status;
    }
}

