/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.recipe;

import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMConstantStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.IEMMapRead;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.util.GT_Recipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TT_recipe
extends GT_Recipe {
    public static final String E_RECIPE_ID = "eRecipeID";
    public final EMConstantStackMap[] input;
    public final IEMMapRead<? extends IEMStack>[] output;
    public final EMConstantStackMap[] eCatalyst;
    public final IAdditionalCheck additionalCheck;

    public TT_recipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue, EMConstantStackMap[] in, IEMMapRead<? extends IEMStack>[] out, EMConstantStackMap[] catalyst, IAdditionalCheck check) {
        super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
        this.input = in;
        this.output = out;
        this.eCatalyst = catalyst;
        this.additionalCheck = check;
    }

    public boolean EMisRecipeInputEqual(boolean consume, boolean doNotCheckStackSizes, ItemStack[] itemStacks, FluidStack[] fluidStacks) {
        return this.EMisRecipeInputEqual(consume, doNotCheckStackSizes, itemStacks, fluidStacks, null, null);
    }

    public boolean EMisRecipeInputEqual(boolean consume, boolean doNotCheckStackSizes, ItemStack[] itemStacks, FluidStack[] fluidStacks, EMInstanceStackMap[] in) {
        return this.EMisRecipeInputEqual(consume, doNotCheckStackSizes, itemStacks, fluidStacks, in, null);
    }

    public boolean EMisRecipeInputEqual(boolean consume, boolean doNotCheckStackSizes, ItemStack[] itemStacks, FluidStack[] fluidStacks, EMInstanceStackMap[] in, EMInstanceStackMap[] catalyst) {
        int i;
        if (this.additionalCheck != null && !this.additionalCheck.check(this, consume, doNotCheckStackSizes, itemStacks, fluidStacks, in, catalyst)) {
            return false;
        }
        if (this.eCatalyst != null) {
            if (catalyst != null && catalyst.length >= this.eCatalyst.length) {
                for (i = 0; i < this.eCatalyst.length; ++i) {
                    if (this.eCatalyst[i] == null || !this.eCatalyst[i].hasStacks()) continue;
                    if (catalyst[i] != null && catalyst[i].hasStacks()) {
                        if (catalyst[i].containsAllAmounts(this.eCatalyst[i])) continue;
                        return false;
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.input != null) {
            if (in != null && in.length >= this.input.length) {
                for (i = 0; i < this.input.length; ++i) {
                    if (this.input[i] == null || !this.input[i].hasStacks()) continue;
                    if (in[i] != null && in[i].hasStacks()) {
                        if (!(consume ? !in[i].removeAllAmounts(this.input[i]) : !in[i].containsAllAmounts(this.input[i]))) continue;
                        return false;
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        return super.isRecipeInputEqual(consume, doNotCheckStackSizes, fluidStacks, itemStacks);
    }

    @Deprecated
    public boolean EMisRecipeInputEqualConsumeFromOne(boolean consume, boolean doNotCheckStackSizes, ItemStack[] itemStacks, FluidStack[] fluidStacks, EMInstanceStackMap in) {
        return this.EMisRecipeInputEqualConsumeFromOne(consume, doNotCheckStackSizes, itemStacks, fluidStacks, in, null);
    }

    @Deprecated
    public boolean EMisRecipeInputEqualConsumeFromOne(boolean consume, boolean doNotCheckStackSizes, ItemStack[] itemStacks, FluidStack[] fluidStacks, EMInstanceStackMap in, EMInstanceStackMap[] catalyst) {
        if (this.additionalCheck != null && !this.additionalCheck.check(this, consume, doNotCheckStackSizes, itemStacks, fluidStacks, in, catalyst)) {
            return false;
        }
        if (this.eCatalyst != null) {
            if (catalyst != null && catalyst.length >= this.eCatalyst.length) {
                for (int i = 0; i < this.eCatalyst.length; ++i) {
                    if (this.eCatalyst[i] == null || !this.eCatalyst[i].hasStacks()) continue;
                    if (catalyst[i] != null && catalyst[i].hasStacks()) {
                        if (catalyst[i].containsAllAmounts(this.eCatalyst[i])) continue;
                        return false;
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.input != null) {
            if (in != null) {
                for (EMConstantStackMap anInput : this.input) {
                    if (anInput == null || !anInput.hasStacks()) continue;
                    if (in.hasStacks()) {
                        if (!(consume ? !in.removeAllAmounts(anInput) : !in.containsAllAmounts(anInput))) continue;
                        return false;
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        return super.isRecipeInputEqual(consume, doNotCheckStackSizes, fluidStacks, itemStacks);
    }

    public static class TT_Recipe_Map_EM<T extends TT_EMRecipe> {
        public static TT_Recipe_Map_EM<TT_EMRecipe> sCrafterRecipesEM = new TT_Recipe_Map_EM("EM Crafter Recipes", "gt.recipe.em_crafter", null);
        public static TT_Recipe_Map_EM<TT_EMRecipe> sMachineRecipesEM = new TT_Recipe_Map_EM("EM Machinert Recipe", "gt.recipe.em_machinery", null);
        private final HashMap<IEMDefinition, T> mRecipeMap = new HashMap(16);
        public final String mNEIName;
        public final String mUnlocalizedName;
        public final String mNEIGUIPath;

        public TT_Recipe_Map_EM(String mNEIName, String mUnlocalizedName, String mNEIGUIPath) {
            this.mNEIName = mNEIName;
            this.mUnlocalizedName = mUnlocalizedName;
            this.mNEIGUIPath = mNEIGUIPath;
        }

        public T findRecipe(IEMDefinition stack) {
            return (T)((Object)((TT_EMRecipe)((Object)this.mRecipeMap.get(stack))));
        }

        public void add(T recipe) {
            this.mRecipeMap.put(((TT_EMRecipe)((Object)recipe)).mResearchEM, recipe);
        }

        public Collection<T> recipeList() {
            return this.mRecipeMap.values();
        }
    }

    public static class TT_EMRecipe
    extends TT_recipe {
        public final IEMDefinition mResearchEM;
        public final GT_Recipe scannerRecipe;

        public TT_EMRecipe(boolean aOptimize, GT_Recipe scannerRecipe, IEMDefinition researchEM, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, FluidStack[] aFluidInputs, int aDuration, int aEUt, int aSpecialValue, EMConstantStackMap[] in, EMConstantStackMap[] out, EMConstantStackMap[] catalyst, IAdditionalCheck check) {
            super(aOptimize, aInputs, aOutputs, aSpecialItems, null, aFluidInputs, null, aDuration, aEUt, aSpecialValue, in, out, catalyst, check);
            this.mResearchEM = researchEM;
            this.scannerRecipe = scannerRecipe;
        }

        public TT_EMRecipe(boolean aOptimize, GT_Recipe scannerRecipe, IEMDefinition researchEM, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, FluidStack[] aFluidInputs, int aDuration, int aEUt, int aSpecialValue, EMConstantStackMap[] in) {
            this(aOptimize, scannerRecipe, researchEM, aInputs, aOutputs, aSpecialItems, aFluidInputs, aDuration, aEUt, aSpecialValue, in, null, null, null);
        }
    }

    public static class TT_assLineRecipe
    extends TT_recipe {
        public final ItemStack mResearchItem;

        public TT_assLineRecipe(boolean aOptimize, ItemStack researchItem, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, FluidStack[] aFluidInputs, int aDuration, int aEUt, int aSpecialValue, EMConstantStackMap[] in, EMConstantStackMap[] out, EMConstantStackMap[] catalyst, IAdditionalCheck check) {
            super(aOptimize, aInputs, aOutputs, aSpecialItems, null, aFluidInputs, null, aDuration, aEUt, aSpecialValue, in, out, catalyst, check);
            this.mResearchItem = researchItem;
        }

        public TT_assLineRecipe(boolean aOptimize, ItemStack researchItem, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, FluidStack[] aFluidInputs, int aDuration, int aEUt, int aSpecialValue, EMConstantStackMap[] in) {
            this(aOptimize, researchItem, aInputs, aOutputs, aSpecialItems, aFluidInputs, aDuration, aEUt, aSpecialValue, in, null, null, null);
        }
    }

    public static class GT_Recipe_MapTT
    extends GT_Recipe.GT_Recipe_Map {
        public static GT_Recipe_MapTT sResearchableFakeRecipes = new GT_Recipe_MapTT(new HashSet<GT_Recipe>(32), "gt.recipe.researchStation", "Research station", null, "gregtech:textures/gui/multimachines/ResearchFake", 1, 1, 1, 0, 1, "", 1, "", true, false);
        public static GT_Recipe_MapTT sScannableFakeRecipes = new GT_Recipe_MapTT(new HashSet<GT_Recipe>(32), "gt.recipe.em_scanner", "EM Scanner Research", null, "gregtech:textures/gui/multimachines/ResearchFake", 1, 1, 1, 0, 1, "", 1, "", true, false);
        public static ArrayList<GT_Recipe.GT_Recipe_AssemblyLine> sAssemblylineRecipes = new ArrayList();

        public GT_Recipe_MapTT(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }
    }

    public static class TT_Recipe_Map<T extends TT_recipe> {
        public static TT_Recipe_Map<TT_assLineRecipe> sCrafterRecipes = new TT_Recipe_Map();
        public static TT_Recipe_Map<TT_assLineRecipe> sMachineRecipes = new TT_Recipe_Map();
        private final HashMap<String, T> mRecipeMap = new HashMap(16);

        public T findRecipe(String identifier) {
            return (T)((Object)((TT_recipe)((Object)this.mRecipeMap.get(identifier))));
        }

        public T findRecipe(ItemStack dataHandler) {
            if (dataHandler == null || dataHandler.field_77990_d == null) {
                return null;
            }
            return (T)((Object)((TT_recipe)((Object)this.mRecipeMap.get(dataHandler.field_77990_d.func_74779_i(TT_recipe.E_RECIPE_ID)))));
        }

        public void add(T recipe) {
            GameRegistry.UniqueIdentifier uid = GameRegistry.findUniqueIdentifierFor((Item)((TT_recipe)((Object)recipe)).mOutputs[0].func_77973_b());
            this.mRecipeMap.put(uid + ":" + ((TT_recipe)((Object)recipe)).mOutputs[0].func_77960_j(), recipe);
        }

        public Collection<T> recipeList() {
            return this.mRecipeMap.values();
        }
    }

    public static interface IAdditionalCheck {
        public boolean check(TT_recipe var1, boolean var2, boolean var3, ItemStack[] var4, FluidStack[] var5, EMInstanceStackMap[] var6, EMInstanceStackMap[] var7);

        public boolean check(TT_recipe var1, boolean var2, boolean var3, ItemStack[] var4, FluidStack[] var5, EMInstanceStackMap var6, EMInstanceStackMap[] var7);
    }
}

