/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.stacks;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.elementalMatter.core.decay.EMDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.decay.EMDecayResult;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMConstantStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMGaugeBosonDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMPrimitiveDefinition;
import com.github.technus.tectech.util.DoubleCount;
import com.github.technus.tectech.util.TT_Utility;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public final class EMInstanceStack
implements IEMStack {
    public static int MIN_MULTIPLE_DECAY_CALLS = 4;
    public static int MAX_MULTIPLE_DECAY_CALLS = 16;
    public static double DECAY_CALL_PER = 6.3892311304012354E28;
    private final IEMDefinition definition;
    private double amount;
    private double age;
    private long energy;
    private int color;
    private double lifeTime;
    private double lifeTimeMult;

    public EMInstanceStack(IEMStack stackSafe) {
        this(stackSafe.getDefinition(), stackSafe.getAmount(), 1.0, 0.0, 0L);
    }

    public EMInstanceStack(IEMStack stackSafe, double lifeTimeMult, double age, long energy) {
        this(stackSafe.getDefinition(), stackSafe.getAmount(), lifeTimeMult, age, energy);
    }

    public EMInstanceStack(IEMDefinition defSafe, double amount) {
        this(defSafe, amount, 1.0, 0.0, 0L);
    }

    public EMInstanceStack(IEMDefinition defSafe, double amount, double lifeTimeMult, double age, long energy) {
        this.definition = defSafe == null ? EMPrimitiveDefinition.null__ : defSafe;
        this.color = this.getDefinition().hasColor() ? (int)((byte)TecTech.RANDOM.nextInt(this.getDefinition().getMaxColors())) : this.getDefinition().getMaxColors();
        this.lifeTimeMult = lifeTimeMult;
        this.lifeTime = this.getDefinition().getRawTimeSpan(energy) * this.lifeTimeMult;
        this.setEnergy(energy);
        this.setAge(age);
        this.setAmount(amount);
    }

    private EMInstanceStack(EMInstanceStack stack) {
        this.definition = stack.getDefinition();
        this.color = stack.color;
        this.setAge(stack.getAge());
        this.setAmount(stack.getAmount());
        this.lifeTime = stack.lifeTime;
        this.lifeTimeMult = stack.lifeTimeMult;
        this.energy = stack.energy;
    }

    @Override
    public EMInstanceStack clone() {
        return new EMInstanceStack(this);
    }

    @Override
    public EMInstanceStack mutateAmount(double newAmount) {
        this.setAmount(newAmount);
        return this;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    public long getEnergy() {
        return this.energy;
    }

    public void setEnergy(long newEnergyLevel) {
        this.energy = newEnergyLevel;
        this.setLifeTimeMultiplier(this.getLifeTimeMultiplier());
    }

    public double getEnergySettingCost(long currentEnergyLevel, long newEnergyLevel) {
        return this.getDefinition().getEnergyDiffBetweenStates(currentEnergyLevel, newEnergyLevel) * this.getAmount();
    }

    public double getEnergySettingCost(long newEnergyLevel) {
        return this.getEnergySettingCost(this.energy, newEnergyLevel) * this.getAmount();
    }

    public EMDefinitionStack getDefinitionStack() {
        return new EMDefinitionStack(this.getDefinition(), this.getAmount());
    }

    @Override
    public IEMDefinition getDefinition() {
        return this.definition;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        if (this.color < 0 || this.color > 2 || color < 0 || color >= 3) {
            return;
        }
        this.color = color;
    }

    public void nextColor() {
        if (this.definition.hasColor()) {
            this.color = (byte)TecTech.RANDOM.nextInt(this.definition.getMaxColors());
        }
    }

    public double getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTimeMultiplier(double mult) {
        if (mult <= 0.0) {
            throw new IllegalArgumentException("multiplier must be >0");
        }
        this.lifeTimeMult = mult;
        if (this.getDefinition().getRawTimeSpan(this.energy) <= 0.0) {
            return;
        }
        this.lifeTime = this.getDefinition().getRawTimeSpan(this.energy) * this.lifeTimeMult;
    }

    public double getLifeTimeMultiplier() {
        return this.lifeTimeMult;
    }

    public EMDecayResult tickStackByOneSecond(double lifeTimeMult, int postEnergize) {
        return this.tickStack(lifeTimeMult, postEnergize, 1.0);
    }

    public EMDecayResult tickStack(double lifeTimeMult, int postEnergize, double seconds) {
        this.setAge(this.getAge() + seconds);
        EMDecayResult newInstances = this.decay(lifeTimeMult, this.getAge(), postEnergize);
        if (newInstances == null) {
            this.nextColor();
        } else {
            for (EMInstanceStack newInstance : (EMInstanceStack[])newInstances.getOutput().valuesToArray()) {
                newInstance.nextColor();
            }
        }
        return newInstances;
    }

    public EMDecayResult decay() {
        return this.decay(1.0, this.getAge(), 0L);
    }

    public EMDecayResult decay(double apparentAge, long postEnergize) {
        return this.decay(1.0, apparentAge, postEnergize);
    }

    public EMDecayResult decay(double lifeTimeMult, double apparentAge, long postEnergize) {
        EMDecayResult output;
        long newEnergyLevel = postEnergize + this.energy;
        if (newEnergyLevel > 0L) {
            --newEnergyLevel;
        } else if (newEnergyLevel < 0L) {
            ++newEnergyLevel;
        }
        if (this.getDefinition().usesMultipleDecayCalls(this.energy)) {
            double amountTemp = this.getAmount();
            int decayCnt = (int)Math.min((double)MAX_MULTIPLE_DECAY_CALLS, Math.max(this.getAmount() / DECAY_CALL_PER, (double)MIN_MULTIPLE_DECAY_CALLS));
            this.setAmount(DoubleCount.div(this.getAmount(), decayCnt));
            --decayCnt;
            output = this.decayMechanics(lifeTimeMult, apparentAge, newEnergyLevel);
            if (output == null) {
                this.setAmount(amountTemp);
                return null;
            }
            for (int i = 0; i < decayCnt; ++i) {
                EMDecayResult map = this.decayMechanics(lifeTimeMult, apparentAge, newEnergyLevel);
                if (map == null) continue;
                output.getOutput().putUnifyAll(map.getOutput());
                output.setMassDiff(DoubleCount.add(output.getMassDiff(), map.getMassDiff()));
                output.setMassAffected(output.getMassDiff() + map.getMassDiff());
            }
            this.setAmount(amountTemp);
        } else {
            output = this.decayMechanics(lifeTimeMult, apparentAge, newEnergyLevel);
        }
        if (output != null) {
            output.getOutput().cleanUp();
        }
        return output;
    }

    private EMDecayResult decayMechanics(double lifeTimeMult, double apparentAge, long newEnergyLevel) {
        if (this.energy > 0L && !this.getDefinition().usesSpecialEnergeticDecayHandling()) {
            this.setLifeTimeMultiplier(this.getLifeTimeMultiplier());
            return this.decayCompute(this.getDefinition().getEnergyInducedDecay(this.energy), lifeTimeMult, -1.0, newEnergyLevel);
        }
        if (this.getDefinition().getRawTimeSpan(this.energy) < 0.0) {
            return null;
        }
        if (this.getDefinition().isTimeSpanHalfLife()) {
            return this.exponentialDecayCompute(this.energy > 0L ? this.getDefinition().getEnergyInducedDecay(this.energy) : this.getDefinition().getDecayArray(), lifeTimeMult, -1.0, newEnergyLevel);
        }
        if (1.0 > this.lifeTime) {
            return this.decayCompute(this.energy > 0L ? this.getDefinition().getEnergyInducedDecay(this.energy) : this.getDefinition().getNaturalDecayInstant(), lifeTimeMult, 0.0, newEnergyLevel);
        }
        if (apparentAge > this.lifeTime) {
            return this.decayCompute(this.energy > 0L ? this.getDefinition().getEnergyInducedDecay(this.energy) : this.getDefinition().getDecayArray(), lifeTimeMult, 0.0, newEnergyLevel);
        }
        return null;
    }

    private EMDecayResult exponentialDecayCompute(EMDecay[] decays, double lifeTimeMult, double newProductsAge, long newEnergyLevel) {
        double newAmount = DoubleCount.div(this.getAmount(), Math.pow(2.0, 1.0 / this.lifeTime));
        if (newAmount == this.getAmount()) {
            newAmount -= DoubleCount.ulpSigned(newAmount);
        } else if (newAmount < 1.0) {
            return this.decayCompute(decays, lifeTimeMult, newProductsAge, newEnergyLevel);
        }
        double amount = this.getAmount();
        this.setAmount(this.getAmount() - newAmount);
        EMDecayResult products = this.decayCompute(decays, lifeTimeMult, newProductsAge, newEnergyLevel);
        this.setAmount(newAmount);
        if (products != null) {
            products.getOutput().putUnify(this.clone());
        }
        this.setAmount(amount);
        return products;
    }

    private EMDecayResult decayCompute(EMDecay[] decays, double lifeTimeMult, double newProductsAge, long newEnergyLevel) {
        EMInstanceStackMap results;
        int i;
        double[] qttyOfDecay;
        if (decays == null) {
            return null;
        }
        boolean makesEnergy = this.getDefinition().decayMakesEnergy(this.energy);
        double mass = this.getMass();
        if (decays.length == 0) {
            return makesEnergy ? null : new EMDecayResult(new EMInstanceStackMap(), mass, 0.0);
        }
        if (decays.length == 1) {
            if (decays[0] == EMGaugeBosonDefinition.deadEnd) {
                return makesEnergy ? null : new EMDecayResult(decays[0].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, this.getAmount()), mass, 0.0);
            }
            EMInstanceStackMap output = decays[0].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, this.getAmount());
            if (newProductsAge < 0.0) {
                if (output.size() == 1) {
                    if (output.size() == 1 && ((EMInstanceStack)output.getFirst()).getDefinition().equals(this.getDefinition())) {
                        ((EMInstanceStack)output.getFirst()).setEnergy(this.energy);
                        ((EMInstanceStack)output.getFirst()).setAge(this.getAge());
                    }
                } else {
                    for (EMInstanceStack stack : (EMInstanceStack[])output.valuesToArray()) {
                        if (!stack.getDefinition().equals(this.getDefinition())) continue;
                        stack.setAge(this.getAge());
                    }
                }
            } else if (output.size() == 1 && ((EMInstanceStack)output.getFirst()).getDefinition().equals(this.getDefinition())) {
                ((EMInstanceStack)output.getFirst()).setEnergy(this.energy);
            }
            if (this.energy <= 0L && output.getMass() > mass) {
                return null;
            }
            return new EMDecayResult(new EMInstanceStackMap(), mass, makesEnergy ? output.getMass() - mass : 0.0);
        }
        EMDecayResult totalOutput = new EMDecayResult(new EMInstanceStackMap(), this.getMass(), 0.0);
        EMInstanceStackMap output = totalOutput.getOutput();
        int differentDecays = decays.length;
        double[] probabilities = new double[differentDecays];
        for (int i2 = 0; i2 < probabilities.length; ++i2) {
            probabilities[i2] = decays[i2].getProbability();
        }
        try {
            qttyOfDecay = DoubleCount.distribute(this.getAmount(), probabilities);
        }
        catch (ArithmeticException e) {
            Minecraft.func_71410_x().func_71404_a(new CrashReport("Decay failed for: " + this, (Throwable)e));
            return null;
        }
        if (this.getDefinition().decayMakesEnergy(this.energy)) {
            for (i = differentDecays - 1; i >= 0; --i) {
                if (decays[i] == EMGaugeBosonDefinition.deadEnd) {
                    EMInstanceStack clone = this.clone();
                    clone.setAmount(qttyOfDecay[i]);
                    output.putUnify(clone);
                    continue;
                }
                results = decays[i].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, qttyOfDecay[i]);
                output.putUnifyAll(results);
                totalOutput.setMassDiff(DoubleCount.add(totalOutput.getMassDiff(), results.getMass() - mass));
            }
        } else {
            for (i = differentDecays - 1; i >= 0; --i) {
                results = decays[i].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, qttyOfDecay[i]);
                output.putUnifyAll(results);
            }
        }
        if (newProductsAge < 0.0) {
            if (output.size() == 1 && ((EMInstanceStack)output.getFirst()).getDefinition().equals(this.getDefinition())) {
                ((EMInstanceStack)output.getFirst()).setEnergy(this.energy);
                ((EMInstanceStack)output.getFirst()).setAge(this.getAge());
            } else {
                for (EMInstanceStack stack : (EMInstanceStack[])output.valuesToArray()) {
                    if (!stack.getDefinition().equals(this.getDefinition())) continue;
                    stack.setAge(this.getAge());
                }
            }
        } else if (output.size() == 1 && ((EMInstanceStack)output.getFirst()).getDefinition().equals(this.getDefinition())) {
            ((EMInstanceStack)output.getFirst()).setEnergy(this.energy);
            ((EMInstanceStack)output.getFirst()).setAge(this.getAge());
        }
        if (this.energy <= 0L && output.getMass() > this.getMass()) {
            return null;
        }
        return totalOutput;
    }

    public EMInstanceStack unifyIntoThis(EMInstanceStack ... instances) {
        if (instances == null) {
            return this;
        }
        double energyTotal = this.getEnergySettingCost(0L, this.energy);
        long maxEnergy = this.energy;
        long minEnergy = this.energy;
        for (EMInstanceStack instance : instances) {
            this.setAmount(DoubleCount.add(this.getAmount(), instance.getAmount()));
            energyTotal += instance.getEnergySettingCost(0L, instance.energy);
            maxEnergy = Math.max(instance.energy, maxEnergy);
            minEnergy = Math.min(instance.energy, maxEnergy);
            this.lifeTimeMult = Math.min(this.lifeTimeMult, instance.lifeTimeMult);
            this.setAge(Math.max(this.getAge(), instance.getAge()));
        }
        if (energyTotal >= 0.0) {
            while (maxEnergy > 0L && !(this.getEnergySettingCost(0L, maxEnergy) < energyTotal)) {
                --maxEnergy;
            }
            this.setEnergy(maxEnergy);
        } else {
            while (minEnergy < 0L && !(this.getEnergySettingCost(minEnergy, 0L) < energyTotal)) {
                ++minEnergy;
            }
            this.setEnergy(minEnergy);
        }
        return this;
    }

    public EMInstanceStack unifyIntoThisExact(EMInstanceStack ... instances) {
        if (instances == null) {
            return this;
        }
        double energyTotal = this.getEnergySettingCost(0L, this.energy);
        long maxEnergy = this.energy;
        long minEnergy = this.energy;
        for (EMInstanceStack instance : instances) {
            this.setAmount(this.getAmount() + instance.getAmount());
            energyTotal += instance.getEnergySettingCost(0L, instance.energy);
            maxEnergy = Math.max(instance.energy, maxEnergy);
            minEnergy = Math.min(instance.energy, maxEnergy);
            this.lifeTimeMult = Math.min(this.lifeTimeMult, instance.lifeTimeMult);
            this.setAge(Math.max(this.getAge(), instance.getAge()));
        }
        if (energyTotal >= 0.0) {
            while (maxEnergy > 0L && !(this.getEnergySettingCost(0L, maxEnergy) < energyTotal)) {
                --maxEnergy;
            }
            this.setEnergy(maxEnergy);
        } else {
            while (minEnergy < 0L && !(this.getEnergySettingCost(minEnergy, 0L) < energyTotal)) {
                ++minEnergy;
            }
            this.setEnergy(minEnergy);
        }
        return this;
    }

    public void addScanResults(ArrayList<String> lines, int[] detailsOnDepthLevels) {
        int capabilities = detailsOnDepthLevels[0];
        if (TT_Utility.areBitsSet(2, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.depth") + " = " + 0);
        }
        this.getDefinition().addScanResults(lines, capabilities, this.energy, TecTech.definitionsRegistry);
        if (TT_Utility.areBitsSet(4096, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.life_mult") + " = " + this.lifeTimeMult);
        }
        if (TT_Utility.areBitsSet(2048, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.age") + " = " + this.getAge() + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.time"));
        }
        if (TT_Utility.areBitsSet(1024, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.color") + " = " + this.color);
        }
        if (TT_Utility.areBitsSet(32, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.energy") + " = " + this.getDefinition().getEnergyDiffBetweenStates(0L, this.energy) + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.energy"));
        }
        if (TT_Utility.areBitsSet(64, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.energyLevel") + " = " + this.energy);
        }
        if (TT_Utility.areBitsSet(4, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.amount") + " = " + this.getAmount() / 6.02214076E23 + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.mol"));
        }
        this.scanContents(lines, this.getDefinition().getSubParticles(), 1, detailsOnDepthLevels);
    }

    private void scanContents(ArrayList<String> lines, EMConstantStackMap definitions, int depth, int[] detailsOnDepthLevels) {
        if (definitions != null && depth < detailsOnDepthLevels.length) {
            int deeper = depth + 1;
            for (EMDefinitionStack definitionStack : (EMDefinitionStack[])definitions.valuesToArray()) {
                lines.add("");
                if (TT_Utility.areBitsSet(2, detailsOnDepthLevels[depth])) {
                    lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.depth") + " = " + depth);
                }
                this.getDefinition().addScanResults(lines, detailsOnDepthLevels[depth], this.energy, TecTech.definitionsRegistry);
                if (TT_Utility.areBitsSet(4, detailsOnDepthLevels[depth])) {
                    lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.count") + " = " + definitionStack.getAmount());
                }
                this.scanContents(lines, definitionStack.getDefinition().getSubParticles(), deeper, detailsOnDepthLevels);
            }
        }
    }

    @Override
    public NBTTagCompound toNBT(EMDefinitionsRegistry registry) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("d", (NBTBase)this.getDefinition().toNBT(registry));
        nbt.func_74780_a("Q", this.getAmount());
        nbt.func_74780_a("M", this.getLifeTimeMultiplier());
        nbt.func_74780_a("A", this.getAge());
        nbt.func_74772_a("e", this.getEnergy());
        nbt.func_74768_a("c", this.getColor());
        return nbt;
    }

    public static EMInstanceStack fromNBT(EMDefinitionsRegistry registry, NBTTagCompound nbt) {
        EMInstanceStack instance = new EMInstanceStack(registry.fromNBT(nbt.func_74775_l("d")), nbt.func_74769_h("Q"), nbt.func_74769_h("M"), nbt.func_74769_h("A"), nbt.func_74763_f("e"));
        instance.setColor(nbt.func_74762_e("c"));
        return instance;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IEMDefinition) {
            return this.getDefinition().compareTo((IEMDefinition)obj) == 0;
        }
        if (obj instanceof IEMStack) {
            return this.getDefinition().compareTo(((IEMStack)obj).getDefinition()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getDefinition().hashCode();
    }

    public String toString() {
        return this.getDefinition().toString() + ' ' + this.getAmount() / 6.02214076E23 + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.mol") + " " + this.getMass() + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.mass");
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getAge() {
        return this.age;
    }

    public void setAge(double age) {
        this.age = age;
    }
}

