/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.stacks;

import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMPrimitiveDefinition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class EMDefinitionStack
implements IEMStack {
    private final IEMDefinition definition;
    private final double amount;

    public EMDefinitionStack(IEMDefinition def, double amount) {
        this.definition = def == null ? EMPrimitiveDefinition.null__ : def;
        this.amount = amount;
    }

    @Override
    public EMDefinitionStack clone() {
        return this;
    }

    @Override
    public EMDefinitionStack mutateAmount(double newAmount) {
        if (this.getAmount() == newAmount) {
            return this;
        }
        return new EMDefinitionStack(this.getDefinition(), newAmount);
    }

    @Override
    public IEMDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    public NBTTagCompound toNBT(EMDefinitionsRegistry registry) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("d", (NBTBase)this.getDefinition().toNBT(registry));
        nbt.func_74780_a("Q", this.getAmount());
        return nbt;
    }

    public static EMDefinitionStack fromNBT(EMDefinitionsRegistry registry, NBTTagCompound nbt) {
        return new EMDefinitionStack(registry.fromNBT(nbt.func_74775_l("d")), (double)nbt.func_74763_f("q") + nbt.func_74769_h("Q"));
    }

    public boolean equals(Object obj) {
        if (obj instanceof IEMDefinition) {
            return this.getDefinition().compareTo((IEMDefinition)obj) == 0;
        }
        if (obj instanceof IEMStack) {
            return this.getDefinition().compareTo(((IEMStack)obj).getDefinition()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getDefinition().hashCode();
    }
}

