/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.enderStorage;

import java.io.Serializable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class EnderFluidContainer
implements IFluidHandler,
Serializable {
    private static final int CAPACITY = 64000;
    @Deprecated
    private int fluidID = -1;
    @Deprecated
    private int fluidQuantity = 0;
    private NBTTagCompound fluid;

    private FluidStack getFluidStack() {
        FluidStack fluidStack = null;
        if (this.fluidID >= 0) {
            this.fluid = new FluidStack(this.fluidID, this.fluidQuantity).writeToNBT(new NBTTagCompound());
            this.fluidID = -1;
            this.fluidQuantity = 0;
        }
        if (this.fluid != null) {
            fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)this.fluid);
        }
        return fluidStack;
    }

    private void setFluidStack(FluidStack fluidStack) {
        this.fluid = fluidStack != null ? fluidStack.writeToNBT(new NBTTagCompound()) : null;
    }

    public int fill(ForgeDirection side, FluidStack fluidStackIn, boolean doFill) {
        int filledFluid = 0;
        FluidStack fluidStackStored = this.getFluidStack();
        if (fluidStackIn != null) {
            if (fluidStackStored == null) {
                fluidStackStored = fluidStackIn.copy();
                fluidStackStored.amount = 0;
            }
            if (fluidStackStored.amount < 64000 && fluidStackIn.isFluidEqual(fluidStackStored)) {
                filledFluid = Math.min(64000 - fluidStackStored.amount, fluidStackIn.amount);
                if (doFill) {
                    fluidStackStored.amount += filledFluid;
                    this.setFluidStack(fluidStackStored);
                }
            }
        }
        return filledFluid;
    }

    public FluidStack drain(ForgeDirection side, FluidStack fluidStack, boolean doDrain) {
        FluidStack fluidStackOutput = null;
        if (fluidStack != null && fluidStack.isFluidEqual(this.getFluidStack())) {
            fluidStackOutput = this.drain(side, fluidStack.amount, doDrain);
        }
        return fluidStackOutput;
    }

    public FluidStack drain(ForgeDirection side, int amount, boolean doDrain) {
        FluidStack fluidStackOutput = null;
        FluidStack fluidStackStored = this.getFluidStack();
        if (fluidStackStored != null && fluidStackStored.amount > 0) {
            int drainedFluid = Math.min(fluidStackStored.amount, amount);
            fluidStackOutput = fluidStackStored.copy();
            fluidStackOutput.amount = drainedFluid;
            if (doDrain) {
                fluidStackStored.amount -= drainedFluid;
                if (fluidStackStored.amount == 0) {
                    fluidStackStored = null;
                }
                this.setFluidStack(fluidStackStored);
            }
        }
        return fluidStackOutput;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{new FluidTankInfo(this.getFluidStack(), 64000)};
    }
}

