/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.definitions.complex;

import com.github.technus.tectech.util.TT_Utility;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;

public final class EMNuclideIAEA {
    public static final double AMU_TO_EV_DIV_C_C = 9.31494061E8;
    public static final double MICRO_AMU_TO_EV_DIV_C_C = 931.494061;
    private static final HashMap<Integer, EMNuclideIAEA> NUCLIDES = new HashMap();
    private final short N;
    private final short Z;
    private final double halfTime;
    private final double mass;
    private final short discovery;
    private TreeMap<Double, energeticState> energeticStates;
    private energeticState[] energeticStatesArray;
    private static final energeticState[] empty = new energeticState[0];
    private static HashSet<String> decays = new HashSet();

    public static void run() {
        String[] split;
        BufferedReader reader;
        String line = "";
        try {
            reader = new BufferedReader(new InputStreamReader(EMNuclideIAEA.class.getResourceAsStream("nuclides.csv")));
            ArrayList<String[]> blockOfData = new ArrayList<String[]>(4);
            while ((line = reader.readLine()) != null) {
                String[] split2 = TT_Utility.splitButDifferent(line, ",");
                if (split2.length != 19) {
                    throw new Error("Invalid count (" + split2.length + ") of separators in IAEA nuclides database " + line);
                }
                if (!split2[1].isEmpty() && !blockOfData.isEmpty()) {
                    new EMNuclideIAEA((String[][])blockOfData.toArray((T[])new String[blockOfData.size()][]));
                    blockOfData.clear();
                }
                blockOfData.add(split2);
            }
            if (!blockOfData.isEmpty()) {
                new EMNuclideIAEA((String[][])blockOfData.toArray((T[])new String[blockOfData.size()][]));
                blockOfData.clear();
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println(line);
            e.printStackTrace();
        }
        try {
            reader = new BufferedReader(new InputStreamReader(EMNuclideIAEA.class.getResourceAsStream("nuclidesTable.csv")));
            while ((line = reader.readLine()) != null) {
                split = TT_Utility.splitButDifferent(line, ",");
                if (split.length != 47) {
                    throw new Error("Invalid count (" + split.length + ") of separators in IAEA nuclidesTable database " + line);
                }
                EMNuclideIAEA.get(Integer.parseInt(split[0]), Integer.parseInt(split[1])).getMoreData(split);
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println(line);
            e.printStackTrace();
        }
        try {
            reader = new BufferedReader(new InputStreamReader(EMNuclideIAEA.class.getResourceAsStream("energyLevels.csv")));
            while ((line = reader.readLine()) != null) {
                split = TT_Utility.splitButDifferent(line, ",");
                if (split.length != 27) {
                    throw new Error("Invalid count (" + split.length + ") of separators in IAEA energyLevels database " + line);
                }
                new energeticState(split);
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println(line);
            e.printStackTrace();
        }
        for (EMNuclideIAEA nuclide : NUCLIDES.values()) {
            nuclide.makeArrayOfEnergyStates();
        }
    }

    public static EMNuclideIAEA get(int protons, int neutrons) {
        return NUCLIDES.get((protons << 16) + neutrons);
    }

    private EMNuclideIAEA(String[][] rows) {
        this.N = Short.parseShort(rows[1][2]);
        this.Z = Short.parseShort(rows[1][0]);
        NUCLIDES.put((this.getZ() << 16) + this.getN(), this);
        String[] parts = TT_Utility.splitButDifferent(rows[0][16], "|");
        double Mass = this.doubleOrNaN(parts[0], "mass");
        this.mass = !Double.isNaN(Mass) ? Mass * 931.494061 : Double.NaN;
        this.discovery = (short)this.doubleOrNaN(rows[0][18], "discovery");
        if (rows[0][3].contains("STABLE")) {
            this.halfTime = 1.5E36;
        } else {
            parts = TT_Utility.splitButDifferent(rows[0][4], "|");
            this.halfTime = this.doubleOrNaN(parts[0], "half life");
        }
    }

    private void getMoreData(String[] cells) {
        new energeticState(this, this.getHalfTime(), EMNuclideIAEA.getDecaysFixed(cells[14], this.doubleOrNaN(cells[15], "chance1"), cells[17], this.doubleOrNaN(cells[18], "chance1"), cells[20], this.doubleOrNaN(cells[21], "chance1")));
    }

    private void makeArrayOfEnergyStates() {
        if (this.energeticStates == null || this.energeticStates.isEmpty()) {
            this.setEnergeticStatesArray(empty);
        } else {
            this.setEnergeticStatesArray(this.energeticStates.values().toArray(new energeticState[0]));
            double life = this.getHalfTime();
            for (energeticState energeticState2 : this.getEnergeticStatesArray()) {
                if (Double.isNaN(energeticState2.Thalf)) {
                    energeticState2.Thalf = life;
                    continue;
                }
                life = energeticState2.Thalf;
            }
        }
    }

    private double doubleOrNaN(String s, String name) {
        if (!(s = s.replaceAll("#", "")).isEmpty()) {
            try {
                double value = Double.parseDouble(s);
                if (Double.isNaN(value)) {
                    return Double.NaN;
                }
                return value != 0.0 ? value : Double.NaN;
            }
            catch (Exception e) {
                System.out.println("Invalid Value " + name + ' ' + this.getN() + ' ' + this.getZ() + ' ' + s);
                e.printStackTrace();
            }
        }
        return Double.NaN;
    }

    public short getN() {
        return this.N;
    }

    public short getZ() {
        return this.Z;
    }

    public double getHalfTime() {
        return this.halfTime;
    }

    public double getMass() {
        return this.mass;
    }

    public short getDiscovery() {
        return this.discovery;
    }

    public energeticState[] getEnergeticStatesArray() {
        return this.energeticStatesArray;
    }

    public void setEnergeticStatesArray(energeticState[] energeticStatesArray) {
        this.energeticStatesArray = energeticStatesArray;
    }

    private static boolean add(String s) {
        if (decays.add(s)) {
            System.out.println(s);
            return true;
        }
        return false;
    }

    private static iaeaDecay[] getDecaysFixed(String decay1, double chance1, String decay2, double chance2, String decay3, double chance3) {
        boolean do1 = !decay1.isEmpty() && !Double.isNaN(chance1);
        boolean do2 = !decay2.isEmpty() && !Double.isNaN(chance2);
        boolean do3 = !decay3.isEmpty() && !Double.isNaN(chance3);
        TreeMap<Double, iaeaDecay> decays = new TreeMap<Double, iaeaDecay>();
        if (do1 && do2 && chance1 == 100.0 && chance2 == 100.0 && chance3 != 100.0) {
            decays.put(1.0, new iaeaDecay(1.0, decay1));
            if (do3) {
                decays.put(chance3 /= 100.0, new iaeaDecay(chance3, decay2));
                chance2 = 1.0 - chance3;
            }
            decays.put(chance2 /= 2.0, new iaeaDecay(chance2, decay2));
        } else if (do1 && chance1 == 100.0) {
            decays.put(1.0, new iaeaDecay(1.0, decay1));
            if (do2) {
                decays.put(chance2 /= 100.0, new iaeaDecay(chance2, decay2));
            }
            if (do3) {
                chance3 /= 100.0;
                if (do2) {
                    chance3 *= chance2;
                }
                decays.put(chance3, new iaeaDecay(chance3, decay3));
            }
        } else {
            double normalization = (do1 ? chance1 : 0.0) + (do2 ? chance2 : 0.0) + (do3 ? chance3 : 0.0);
            if (do1) {
                decays.put(chance1 /= normalization, new iaeaDecay(chance1, decay1));
            }
            if (do2) {
                decays.put(chance2 /= normalization, new iaeaDecay(chance2, decay2));
            }
            if (do3) {
                decays.put(chance3 /= normalization, new iaeaDecay(chance3, decay3));
            }
            if (do1 || do2 || do3) {
                decays.put(1.0, iaeaDecay.DEAD_END);
            }
        }
        return decays.values().toArray(new iaeaDecay[0]);
    }

    public static final class iaeaDecay {
        public final double chance;
        public final String decayName;
        public static final iaeaDecay DEAD_END = new iaeaDecay(1.0, "DEAD_END");

        private iaeaDecay(double chance, String decayName) {
            this.chance = chance;
            this.decayName = decayName;
        }
    }

    public static final class energeticState {
        public final double energy;
        public double Thalf;
        public final iaeaDecay[] decaymodes;

        private energeticState(EMNuclideIAEA nuclide, double Thalf, iaeaDecay[] decaymodes) {
            this.energy = 0.0;
            this.Thalf = Thalf;
            this.decaymodes = decaymodes;
            if (nuclide.energeticStates == null) {
                nuclide.energeticStates = new TreeMap();
            }
            nuclide.energeticStates.put(this.energy, this);
        }

        private energeticState(String[] cells) {
            EMNuclideIAEA nuclide = EMNuclideIAEA.get((int)this.doubleOrNaN(cells[0], "protons"), (int)this.doubleOrNaN(cells[1], "neutrons"));
            if (nuclide == null) {
                throw new Error("Missing nuclide " + (int)this.doubleOrNaN(cells[0], "protons") + ' ' + (int)this.doubleOrNaN(cells[1], "neutrons"));
            }
            this.energy = this.doubleOrNaN(cells[3], "energy level", nuclide) * 1000.0;
            if (this.energy < 0.0) {
                throw new Error("Invalid energy " + nuclide.getN() + ' ' + nuclide.getZ() + ' ' + cells[3]);
            }
            this.Thalf = this.doubleOrNaN(cells[10], "half life", nuclide);
            if (nuclide.energeticStates == null) {
                new Exception("Should be initialized before doing this... " + nuclide.getN() + ' ' + nuclide.getZ()).printStackTrace();
                nuclide.energeticStates = new TreeMap();
            }
            nuclide.energeticStates.put(this.energy, this);
            this.decaymodes = EMNuclideIAEA.getDecaysFixed(cells[12], this.doubleOrNaN(cells[13], "chance 1", nuclide), cells[15], this.doubleOrNaN(cells[16], "chance 2", nuclide), cells[18], this.doubleOrNaN(cells[19], "chance 3", nuclide));
        }

        private double doubleOrNaN(String s, String name) {
            return this.doubleOrNaN(s, name, null);
        }

        private double doubleOrNaN(String s, String name, EMNuclideIAEA nuclide) {
            if (!(s = s.replaceAll("#", "")).isEmpty()) {
                try {
                    return Double.parseDouble(s);
                }
                catch (Exception e) {
                    if (nuclide == null) {
                        System.out.println("Invalid Value " + name + ' ' + s);
                    } else {
                        System.out.println("Invalid Value " + name + ' ' + nuclide.getN() + ' ' + nuclide.getZ() + ' ' + s);
                    }
                    e.printStackTrace();
                }
            }
            return Double.NaN;
        }
    }
}

