/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.maps;

import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.IEMMapRead;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.IEMMapWriteExact;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMTransformationRegistry;
import com.github.technus.tectech.util.DoubleCount;
import java.util.Map;

public interface IEMMapWrite<T extends IEMStack>
extends IEMMapWriteExact<T> {
    @Override
    public IEMMapWrite<T> clone();

    default public boolean removeAmount(IEMDefinition def, double amountToConsume) {
        double amountRequired = amountToConsume - EMTransformationRegistry.EM_COUNT_EPSILON;
        if (amountRequired == amountToConsume) {
            amountRequired -= DoubleCount.ulpSigned(amountRequired);
        }
        return this.removeAmount(def, amountToConsume, amountRequired);
    }

    default public boolean removeAmount(IEMDefinition def, double amountToConsume, double amountRequired) {
        Object current = this.get(def);
        if (current != null && current.getAmount() >= amountRequired) {
            double newAmount = DoubleCount.sub(current.getAmount(), amountToConsume);
            if (IEMStack.isValidAmount(newAmount)) {
                current = current.mutateAmount(newAmount);
                this.putReplace(current);
            } else {
                this.removeKey(current.getDefinition());
            }
            return true;
        }
        return false;
    }

    default public boolean removeAmount(IEMStack stack) {
        return this.removeAmount(stack.getDefinition(), stack.getAmount());
    }

    default public boolean removeAllAmounts(IEMStack ... stacks) {
        boolean test = true;
        for (IEMStack stack : stacks) {
            test &= this.containsAmount(stack);
        }
        if (!test) {
            return test;
        }
        for (IEMStack stack : stacks) {
            this.removeAmount(stack);
        }
        return true;
    }

    default public boolean removeAllAmounts(IEMMapRead<? extends IEMStack> map) {
        boolean test = true;
        for (Map.Entry<IEMDefinition, ? extends IEMStack> entry : map.entrySet()) {
            test &= this.containsAmount(entry.getValue());
        }
        if (!test) {
            return test;
        }
        for (Map.Entry<IEMDefinition, ? extends IEMStack> entry : map.entrySet()) {
            this.removeAmount(entry.getValue());
        }
        return true;
    }

    default public T putUnify(T stack) {
        Object target = this.get(stack.getDefinition());
        if (target == null) {
            this.putReplace(stack);
            return stack;
        }
        double newAmount = DoubleCount.add(target.getAmount(), stack.getAmount());
        if (IEMStack.isValidAmount(newAmount)) {
            stack = target.mutateAmount(newAmount);
            this.putReplace(stack);
            return stack;
        }
        this.removeKey(stack.getDefinition());
        return null;
    }

    default public void putUnifyAll(T ... defs) {
        for (T def : defs) {
            this.putUnify(def);
        }
    }

    default public void putUnifyAll(IEMMapRead<T> inTreeUnsafe) {
        for (Map.Entry<IEMDefinition, T> in : inTreeUnsafe.entrySet()) {
            this.putUnify((IEMStack)in.getValue());
        }
    }
}

