/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.definitions;

import com.github.technus.tectech.mechanics.elementalMatter.core.decay.EMDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.EMComplexTemplate;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMConstantStackMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public abstract class EMPrimitiveTemplate
extends EMComplexTemplate {
    private final String name;
    private final String symbol;
    private final double mass;
    private final int charge;
    private final int color;
    private final int generation;
    private IEMDefinition anti;
    private EMDecay[] elementalDecays;
    private byte naturalDecayInstant;
    private byte energeticDecayInstant;
    private double rawLifeTime;
    private final int ID;
    private final String bind;

    protected EMPrimitiveTemplate(String name, String symbol, int generation, double mass, int charge, int color, int ID, String bind) {
        this.name = name;
        this.symbol = symbol;
        this.generation = generation;
        this.mass = mass;
        this.charge = charge;
        this.color = color;
        this.ID = ID;
        this.bind = bind;
    }

    protected void init(EMDefinitionsRegistry registry, IEMDefinition antiParticle, double rawLifeTime, int naturalInstant, int energeticInstant, EMDecay ... elementalDecaysArray) {
        this.anti = antiParticle;
        this.rawLifeTime = rawLifeTime;
        this.naturalDecayInstant = (byte)naturalInstant;
        this.energeticDecayInstant = (byte)energeticInstant;
        this.elementalDecays = elementalDecaysArray;
        registry.registerForDisplay(this);
        registry.registerDirectDefinition(this.bind, this);
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public String getShortSymbol() {
        return this.getSymbol();
    }

    @Override
    public String getShortLocalizedName() {
        return StatCollector.func_74838_a((String)this.getUnlocalizedName());
    }

    @Override
    public IEMDefinition getAnti() {
        return this.anti;
    }

    @Override
    public int getCharge() {
        return this.charge;
    }

    @Override
    public int getMaxColors() {
        return this.color;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public EMDecay[] getNaturalDecayInstant() {
        if (this.naturalDecayInstant < 0) {
            return this.elementalDecays;
        }
        if (this.naturalDecayInstant >= this.elementalDecays.length) {
            return EMDecay.NO_PRODUCT;
        }
        return new EMDecay[]{this.elementalDecays[this.naturalDecayInstant]};
    }

    @Override
    public EMDecay[] getEnergyInducedDecay(long energyLevel) {
        if (this.energeticDecayInstant < 0) {
            return this.elementalDecays;
        }
        if (this.energeticDecayInstant >= this.elementalDecays.length) {
            return EMDecay.NO_PRODUCT;
        }
        return new EMDecay[]{this.elementalDecays[this.energeticDecayInstant]};
    }

    @Override
    public double getEnergyDiffBetweenStates(long currentEnergyLevel, long newEnergyLevel) {
        return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
    }

    @Override
    public boolean usesSpecialEnergeticDecayHandling() {
        return false;
    }

    @Override
    public boolean usesMultipleDecayCalls(long energyLevel) {
        return false;
    }

    @Override
    public boolean decayMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public boolean fusionMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public EMDecay[] getDecayArray() {
        return this.elementalDecays;
    }

    @Override
    public double getRawTimeSpan(long currentEnergy) {
        return this.rawLifeTime;
    }

    @Override
    public final EMConstantStackMap getSubParticles() {
        return null;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public final NBTTagCompound toNBT(EMDefinitionsRegistry registry) {
        return registry.directToNBT(this.bind);
    }

    @Override
    protected final String getTagValue() {
        return this.bind;
    }

    @Override
    public final int getMatterMassType() {
        return EMPrimitiveTemplate.getClassTypeStatic();
    }

    public static int getClassTypeStatic() {
        return Short.MIN_VALUE;
    }

    @Override
    public final int compareTo(IEMDefinition o) {
        if (this.getMatterMassType() == o.getMatterMassType()) {
            int oID = ((EMPrimitiveTemplate)o).ID;
            return Integer.compare(this.ID, oID);
        }
        return this.compareClassID(o);
    }

    @Override
    public final int hashCode() {
        return this.ID;
    }

    public String getUnlocalizedName() {
        return this.name;
    }
}

