/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.decay;

import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMConstantStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMInstanceStack;
import com.github.technus.tectech.util.DoubleCount;

public final class EMDecay {
    public static final EMDecay[] NO_DECAY = null;
    public static final EMDecay[] NO_PRODUCT = new EMDecay[0];
    private final EMConstantStackMap outputStacks;
    private final double probability;

    public EMDecay(IEMDefinition ... outSafe) {
        this(1.0, outSafe);
    }

    public EMDecay(double probability, IEMDefinition ... outSafe) {
        EMDefinitionStack[] outArr = new EMDefinitionStack[outSafe.length];
        for (int i = 0; i < outArr.length; ++i) {
            outArr[i] = new EMDefinitionStack(outSafe[i], 1.0);
        }
        this.outputStacks = new EMConstantStackMap(outArr);
        this.probability = probability;
    }

    public EMDecay(EMDefinitionStack ... outSafe) {
        this(1.0, outSafe);
    }

    public EMDecay(double probability, EMDefinitionStack ... out) {
        this.outputStacks = new EMConstantStackMap(out);
        this.probability = probability;
    }

    public EMDecay(EMConstantStackMap tree) {
        this(1.0, tree);
    }

    public EMDecay(double probability, EMConstantStackMap tree) {
        this.outputStacks = tree;
        this.probability = probability;
    }

    public EMInstanceStackMap getResults(double lifeMult, double age, long newEnergyLevel, double amountDecaying) {
        EMInstanceStackMap decayResult = new EMInstanceStackMap();
        if (this.getOutputStacks() == null) {
            return decayResult;
        }
        boolean empty = true;
        for (EMDefinitionStack stack : (EMDefinitionStack[])this.getOutputStacks().valuesToArray()) {
            if (!(stack.getAmount() > 0.0)) continue;
            empty = false;
            break;
        }
        if (empty) {
            return decayResult;
        }
        for (EMDefinitionStack stack : (EMDefinitionStack[])this.getOutputStacks().valuesToArray()) {
            decayResult.putUnify(new EMInstanceStack(stack.getDefinition(), DoubleCount.mul(amountDecaying, stack.getAmount()), lifeMult, age, (long)((double)newEnergyLevel / Math.max(1.0, Math.abs(stack.getAmount())))));
        }
        return decayResult;
    }

    public EMConstantStackMap getOutputStacks() {
        return this.outputStacks;
    }

    public double getProbability() {
        return this.probability;
    }
}

