/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.data;

import com.github.technus.tectech.TecTech;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import eu.usrv.yamcore.network.server.AbstractServerMessageHandler;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerDataMessage
implements IMessage {
    NBTTagCompound data;
    UUID uuid1;
    UUID uuid2;

    public void fromBytes(ByteBuf pBuffer) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)pBuffer);
        this.uuid1 = UUID.fromString(tag.func_74779_i("id1"));
        this.uuid2 = UUID.fromString(tag.func_74779_i("id2"));
        if (tag.func_74764_b("data")) {
            this.data = tag.func_74775_l("data");
        }
    }

    public void toBytes(ByteBuf pBuffer) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id1", this.uuid1.toString());
        tag.func_74778_a("id2", this.uuid2.toString());
        if (this.data != null) {
            tag.func_74782_a("data", (NBTBase)this.data);
        }
        ByteBufUtils.writeTag((ByteBuf)pBuffer, (NBTTagCompound)tag);
    }

    public static class ServerHandler
    extends AbstractServerMessageHandler<PlayerDataQuery> {
        public IMessage handleServerMessage(EntityPlayer pPlayer, PlayerDataQuery pMessage, MessageContext pCtx) {
            return new PlayerDataData(pMessage);
        }
    }

    public static class ClientHandler
    extends AbstractClientMessageHandler<PlayerDataData> {
        public IMessage handleClientMessage(EntityPlayer pPlayer, PlayerDataData pMessage, MessageContext pCtx) {
            TecTech.playerPersistence.putDataOrSetToNewTag(pMessage.uuid1, pMessage.uuid2, pMessage.data);
            return null;
        }
    }

    public static class PlayerDataData
    extends PlayerDataMessage {
        public PlayerDataData() {
        }

        public PlayerDataData(EntityPlayer player) {
            this.uuid1 = player.func_110124_au();
            this.uuid2 = UUID.nameUUIDFromBytes(player.func_70005_c_().getBytes(Charset.forName("UTF-8")));
            this.data = TecTech.playerPersistence.getDataOrSetToNewTag(player);
        }

        public PlayerDataData(PlayerDataQuery query) {
            this.uuid1 = query.uuid1;
            this.uuid2 = query.uuid2;
            this.data = TecTech.playerPersistence.getDataOrSetToNewTag(this.uuid1, this.uuid2);
        }
    }

    public static class PlayerDataQuery
    extends PlayerDataMessage {
        public PlayerDataQuery() {
        }

        public PlayerDataQuery(EntityPlayer player) {
            this.uuid1 = player.func_110124_au();
            this.uuid2 = UUID.nameUUIDFromBytes(player.func_70005_c_().getBytes(Charset.forName("UTF-8")));
        }
    }
}

