/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.avr;

import com.github.technus.tectech.shadow.com.github.technus.avrClone.AvrCore;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.registerPackages.IInterrupt;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.registerPackages.IRegister;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.registerPackages.IRegisterBit;
import com.github.technus.tectech.shadow.com.github.technus.avrClone.registerPackages.RegisterPackageSync;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;

public class SidedRedstone
extends RegisterPackageSync<IGregTechTileEntity, SidedRedstone> {
    public static final RSINT RSINT = new RSINT();

    public SidedRedstone(int offset) {
        super(offset, Register.values().length);
        this.addRegisters(Register.values());
        this.addBits(RegisterBitsPCMSK.values());
        this.addBits(RegisterBitsPCFR.values());
        this.addBits(RegisterBitsPCINT.values());
        this.addBits(RegisterBitsPNEW.values());
        this.addBits(RegisterBitsPOLD.values());
        this.addInterrupts(RSINT);
    }

    @Override
    public void preSync(AvrCore core, IGregTechTileEntity iGregTechTileEntity) {
        int addr = this.getOffset();
        int sides = 0;
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            byte val = iGregTechTileEntity.getInternalInputRedstoneSignal(i);
            sides |= (val > 0 ? (byte)1 : 0) << i;
            core.setDataValue(addr++, iGregTechTileEntity.getInputRedstoneSignal(i));
            core.setDataValue(addr++, val);
            ++addr;
        }
        int sidesOld = core.getDataValue(Register.PNEW.getAddress(this));
        core.setDataValue(Register.POLD.getAddress(this), sidesOld);
        core.setDataValue(Register.PNEW.getAddress(this), sides);
        if (core.getInterruptEnable()) {
            int pcint = core.getDataValue(Register.PCINT.getAddress(this));
            int changesDetected = 0;
            switch (pcint & 0xC) {
                case 0: {
                    changesDetected = ~sides & core.getDataValue(Register.PCMSK.getAddress(this));
                    break;
                }
                case 4: {
                    changesDetected = (sides ^ sidesOld) & core.getDataValue(Register.PCMSK.getAddress(this));
                    break;
                }
                case 8: {
                    changesDetected = ~sides & sidesOld & core.getDataValue(Register.PCMSK.getAddress(this));
                    break;
                }
                case 12: {
                    changesDetected = sides & ~sidesOld & core.getDataValue(Register.PCMSK.getAddress(this));
                }
            }
            core.setDataValue(Register.PCFR.getAddress(this), core.getDataValue(Register.PCFR.getAddress(this) | changesDetected));
            if (changesDetected > 0 && core.getDataBitsOr(Register.PCINT.getAddress(this), RegisterBitsPCINT.PCEN.mask)) {
                core.setDataBits(Register.PCINT.getAddress(this), RegisterBitsPCINT.PCIF.mask);
            }
        }
    }

    @Override
    public void postSync(AvrCore core, IGregTechTileEntity iGregTechTileEntity) {
        int addr = this.getOffset();
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            iGregTechTileEntity.setOutputRedstoneSignal(i, (byte)core.getDataValue(addr));
            addr += 3;
        }
    }

    public static class RSINT
    implements IInterrupt<SidedRedstone> {
        @Override
        public int getVector() {
            return 1;
        }

        @Override
        public boolean getTrigger(AvrCore core, SidedRedstone registerPackage) {
            return (core.getDataValue(Register.PCINT.getAddress(registerPackage)) & 1) == 1;
        }

        @Override
        public void setTrigger(AvrCore core, SidedRedstone registerPackage, boolean value) {
            int val = core.getDataValue(Register.PCINT.getAddress(registerPackage));
            core.setDataValue(Register.PCINT.getAddress(registerPackage), value ? val | RegisterBitsPCINT.PCIF.mask : val & ~RegisterBitsPCINT.PCIF.mask);
        }

        @Override
        public String name() {
            return "RSINT";
        }
    }

    public static enum RegisterBitsPOLD implements IRegisterBit<SidedRedstone>
    {
        POLD0,
        POLD1,
        POLD2,
        POLD3,
        POLD4,
        POLD5;

        private final int bit = this.ordinal();
        private final int mask = 1 << this.bit;

        @Override
        public int getBitPosition() {
            return this.bit;
        }

        @Override
        public int getBitMask() {
            return this.mask;
        }

        @Override
        public int getOffset(SidedRedstone registerPackage) {
            return 22;
        }
    }

    public static enum RegisterBitsPNEW implements IRegisterBit<SidedRedstone>
    {
        PNEW0,
        PNEW1,
        PNEW2,
        PNEW3,
        PNEW4,
        PNEW5;

        private final int bit = this.ordinal();
        private final int mask = 1 << this.bit;

        @Override
        public int getBitPosition() {
            return this.bit;
        }

        @Override
        public int getBitMask() {
            return this.mask;
        }

        @Override
        public int getOffset(SidedRedstone registerPackage) {
            return 21;
        }
    }

    public static enum RegisterBitsPCINT implements IRegisterBit<SidedRedstone>
    {
        PCIF,
        PCEN,
        PCISC0,
        PCISC1;

        private final int bit = this.ordinal();
        private final int mask = 1 << this.bit;

        @Override
        public int getBitPosition() {
            return this.bit;
        }

        @Override
        public int getBitMask() {
            return this.mask;
        }

        @Override
        public int getOffset(SidedRedstone registerPackage) {
            return 20;
        }
    }

    public static enum RegisterBitsPCFR implements IRegisterBit<SidedRedstone>
    {
        PCF0,
        PCF1,
        PCF2,
        PCF3,
        PCF4,
        PCF5;

        private final int bit = this.ordinal();
        private final int mask = 1 << this.bit;

        @Override
        public int getBitPosition() {
            return this.bit;
        }

        @Override
        public int getBitMask() {
            return this.mask;
        }

        @Override
        public int getOffset(SidedRedstone registerPackage) {
            return 19;
        }
    }

    public static enum RegisterBitsPCMSK implements IRegisterBit<SidedRedstone>
    {
        PCINT0,
        PCINT1,
        PCINT2,
        PCINT3,
        PCINT4,
        PCINT5;

        private final int bit = this.ordinal();
        private final int mask = 1 << this.bit;

        @Override
        public int getBitPosition() {
            return this.bit;
        }

        @Override
        public int getBitMask() {
            return this.mask;
        }

        @Override
        public int getOffset(SidedRedstone registerPackage) {
            return 18;
        }
    }

    public static enum Register implements IRegister<SidedRedstone>
    {
        PIN0,
        PINT0,
        PORT0,
        PIN1,
        PINT1,
        PORT1,
        PIN2,
        PINT2,
        PORT2,
        PIN3,
        PINT3,
        PORT3,
        PIN4,
        PINT4,
        PORT4,
        PIN5,
        PINT5,
        PORT5,
        PCMSK,
        PCFR,
        PCINT,
        PNEW,
        POLD;

        public final int relativeOffset = this.ordinal();

        @Override
        public int getAddress(SidedRedstone registerPackage) {
            return registerPackage.getOffset() + this.relativeOffset;
        }
    }
}

