/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.mechanics.constructable.IConstructable;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalInstanceStack;
import com.github.technus.tectech.mechanics.structure.Structure;
import com.github.technus.tectech.mechanics.structure.adders.IHatchAdder;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_InputElemental;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OutputElemental;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.util.CommonValues;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GT_MetaTileEntity_EM_decay
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    public static final double URANIUM_INGOT_MASS_DIFF = 9.704388363127216E33;
    private static final double URANIUM_MASS_TO_EU_PARTIAL;
    public static final double URANIUM_MASS_TO_EU_INSTANT;
    private String clientLocale = "en_US";
    private static final String[][] shape;
    private static final Block[] blockType;
    private static final byte[] blockMeta;
    private static final IHatchAdder<GT_MetaTileEntity_EM_decay>[] addingMethods;
    private static final short[] casingTextures;
    private static final Block[] blockTypeFallback;
    private static final byte[] blockMetaFallback;
    private static final String[] description;
    protected Parameters.Group.ParameterIn ampereFlow;
    private static final INameFunction<GT_MetaTileEntity_EM_decay> FLOW_NAME;
    private static final IStatusFunction<GT_MetaTileEntity_EM_decay> FLOW_STATUS;

    public GT_MetaTileEntity_EM_decay(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_decay(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_decay(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        return this.structureCheck_EM(shape, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 2, 2, 0);
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        cElementalInstanceStackMap map = this.getInputsClone_EM();
        if (map != null && map.hasStacks()) {
            for (GT_MetaTileEntity_Hatch_InputElemental i : this.eInputHatches) {
                i.getContainerHandler().clear();
            }
            return this.startRecipe(map);
        }
        return false;
    }

    private boolean startRecipe(cElementalInstanceStackMap input) {
        this.mMaxProgresstime = 20;
        this.mEfficiencyIncrease = 10000;
        this.outputEM = new cElementalInstanceStackMap[2];
        this.outputEM[0] = input;
        this.outputEM[1] = new cElementalInstanceStackMap();
        for (cElementalInstanceStack stack : this.outputEM[0].values()) {
            if (stack.getEnergy() == 0L && stack.definition.decayMakesEnergy(1L) && this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)(stack.getEnergySettingCost(1L) * URANIUM_MASS_TO_EU_INSTANT), false)) {
                stack.setEnergy(1L);
                continue;
            }
            if (stack.definition.decayMakesEnergy(stack.getEnergy())) continue;
            this.outputEM[0].remove(stack.definition);
            this.outputEM[1].putReplace(stack);
        }
        this.eAmpereFlow = (long)this.ampereFlow.get();
        if (this.eAmpereFlow <= 0L) {
            this.mEUt = 0;
            return false;
        }
        double energyDose = -this.outputEM[0].tickContent(1.0, 0, 1.0) * URANIUM_MASS_TO_EU_PARTIAL;
        this.mEUt = (int)(energyDose / (double)this.eAmpereFlow);
        return this.outputEM[0].hasStacks();
    }

    @Override
    public void outputAfterRecipe_EM() {
        for (int i = 0; i < 2 && i < this.eOutputHatches.size(); ++i) {
            ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(i)).getContainerHandler().putUnifyAll(this.outputEM[i]);
            this.outputEM[i] = null;
        }
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.decay.desc.0"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.decay.desc.1")};
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (Object tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        for (Object tHatch : this.eEnergyMulti) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74837_a((String)"tt.keyword.Progress", (Object[])new Object[]{this.clientLocale}) + ":", EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s", StatCollector.func_74837_a((String)"tt.keyphrase.Energy_Hatches", (Object[])new Object[]{this.clientLocale}) + ":", EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + maxEnergy + EnumChatFormatting.RESET + " EU", (this.mEUt <= 0 ? StatCollector.func_74837_a((String)"tt.keyphrase.Probably_uses", (Object[])new Object[]{this.clientLocale}) + ": " : StatCollector.func_74837_a((String)"tt.keyphrase.Probably_makes", (Object[])new Object[]{this.clientLocale}) + ": ") + EnumChatFormatting.RED + Math.abs(this.mEUt) + EnumChatFormatting.RESET + " EU/t at " + EnumChatFormatting.RED + this.eAmpereFlow + EnumChatFormatting.RESET + " A", StatCollector.func_74837_a((String)"tt.keyphrase.Tier_Rating", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.YELLOW + CommonValues.VN[this.getMaxEnergyInputTier_EM()] + EnumChatFormatting.RESET + " / " + EnumChatFormatting.GREEN + CommonValues.VN[this.getMinEnergyInputTier_EM()] + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyphrase.Amp_Rating", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.GREEN + this.eMaxAmpereFlow + EnumChatFormatting.RESET + " A", StatCollector.func_74837_a((String)"tt.keyword.Problems", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyword.Efficiency", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74837_a((String)"tt.keyword.PowerPass", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.BLUE + this.ePowerPass + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyword.SafeVoid", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.BLUE + this.eSafeVoid, StatCollector.func_74837_a((String)"tt.keyword.Computation", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.GREEN + this.eAvailableData + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + this.eRequiredData + EnumChatFormatting.RESET};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_DECAY");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_DECAY_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12]};
    }

    @Override
    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, true);
        this.ampereFlow = hatch_0.makeInParameter(0, 1.0, FLOW_NAME, FLOW_STATUS);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        super.onRightclick(aBaseMetaTileEntity, aPlayer);
        if (!aBaseMetaTileEntity.isClientSide() && aPlayer instanceof EntityPlayerMP) {
            try {
                EntityPlayerMP player = (EntityPlayerMP)aPlayer;
                this.clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
            }
            catch (Exception e) {
                this.clientLocale = "en_US";
            }
        } else {
            return true;
        }
        return true;
    }

    @Override
    public void construct(ItemStack stackSize, boolean hintsOnly) {
        Structure.builder(shape, blockType, blockMeta, 2, 2, 0, this.getBaseMetaTileEntity(), this.getExtendedFacing(), hintsOnly);
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    static {
        URANIUM_MASS_TO_EU_PARTIAL = (double)ConfigUtil.getFloat((Config)MainConfig.get(), (String)"balance/energy/generator/nuclear") * 3000000.0 / 9.704388363127216E33;
        URANIUM_MASS_TO_EU_INSTANT = URANIUM_MASS_TO_EU_PARTIAL * 20.0;
        shape = new String[][]{{"0C0", "A   ", "A . ", "A   ", "0C0"}, {"00000", "00000", "00000", "00000", "00000"}, {"0C0", "A!!!", "A!0!", "A!!!", "0C0"}, {"01110", "12221", "12221", "12221", "01110"}, {"01310", "12221", "32223", "12221", "01310"}, {"01110", "12221", "12221", "12221", "01110"}, {"0C0", "A!!!", "A!0!", "A!!!", "0C0"}, {"00000", "00000", "00000", "00000", "00000"}, {"0C0", "A   ", "A   ", "A   ", "0C0"}};
        blockType = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMeta = new byte[]{4, 5, 8, 6};
        addingMethods = Structure.adders(GT_MetaTileEntity_MultiblockBase_EM::addClassicToMachineList, GT_MetaTileEntity_MultiblockBase_EM::addElementalToMachineList);
        casingTextures = new short[]{1024, 1028};
        blockTypeFallback = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMetaFallback = new byte[]{0, 4};
        description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.decay.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.decay.hint.1")};
        FLOW_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.decay.conf");
        FLOW_STATUS = (base, p) -> {
            if (base.eAmpereFlow <= 0L) {
                return LedStatus.STATUS_TOO_LOW;
            }
            return LedStatus.STATUS_OK;
        };
    }
}

