/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.hatch;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.MainLoader;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GT_MetaTileEntity_Hatch_OverflowElemental
extends GT_MetaTileEntity_Hatch {
    private static Textures.BlockIcons.CustomIcon EM_T_SIDES;
    private static Textures.BlockIcons.CustomIcon EM_T_ACTIVE;
    public static Textures.BlockIcons.CustomIcon MufflerEM;
    public static Textures.BlockIcons.CustomIcon MufflerEMidle;
    private double overflowMatter;
    public final double overflowMax;
    private final double overflowDisperse;
    private String clientLocale = "en_US";

    public GT_MetaTileEntity_Hatch_OverflowElemental(int aID, String aName, String aNameRegional, int aTier, double max) {
        super(aID, aName, aNameRegional, aTier, 0, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.emmuffler.desc.0"), new ITexture[0]);
        this.overflowMatter = max / 2.0;
        this.overflowMax = max;
        this.overflowDisperse = this.overflowMax / (double)(30 - aTier);
        Util.setTier(aTier, (Object)this);
    }

    public GT_MetaTileEntity_Hatch_OverflowElemental(String aName, int aTier, double max, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        this.overflowMatter = max / 2.0;
        this.overflowMax = max;
        this.overflowDisperse = this.overflowMax / (double)(30 - aTier);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        EM_T_ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_EM_T_ACTIVE");
        EM_T_SIDES = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_EM_T_SIDES");
        MufflerEM = new Textures.BlockIcons.CustomIcon("iconsets/MUFFLER_EM");
        MufflerEMidle = new Textures.BlockIcons.CustomIcon("iconsets/MUFFLER_EM_IDLE");
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)EM_T_ACTIVE, Dyes.getModulation((int)this.getBaseMetaTileEntity().getColorization(), (short[])Dyes.MACHINE_METAL.getRGBA())), new GT_RenderedTexture((IIconContainer)MufflerEM)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)EM_T_SIDES, Dyes.getModulation((int)this.getBaseMetaTileEntity().getColorization(), (short[])Dyes.MACHINE_METAL.getRGBA())), new GT_RenderedTexture((IIconContainer)MufflerEMidle)};
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, this.mDescription, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.emmuffler.desc.1") + ": " + EnumChatFormatting.AQUA + String.format(Locale.ENGLISH, "%+.2E", this.overflowMax) + " eV/c\u00b2", StatCollector.func_74838_a((String)"gt.blockmachines.hatch.emmuffler.desc.2") + ": " + EnumChatFormatting.AQUA + String.format(Locale.ENGLISH, "%+.2E", this.overflowDisperse) + " (eV/c\u00b2)/s", StatCollector.func_74838_a((String)"gt.blockmachines.hatch.emmuffler.desc.3")};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_OverflowElemental(this.mName, this.mTier, this.overflowMax, this.mDescription, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74780_a("OverflowMatter", this.overflowMatter);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.overflowMatter = (double)aNBT.func_74760_g("overflowMatter") + aNBT.func_74769_h("OverflowMatter");
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 14L) {
            if (aBaseMetaTileEntity.isActive()) {
                if (this.overflowMatter > this.overflowDisperse) {
                    TecTech.anomalyHandler.addAnomaly(aBaseMetaTileEntity, this.overflowDisperse);
                    this.overflowMatter -= this.overflowDisperse;
                } else {
                    TecTech.anomalyHandler.addAnomaly(aBaseMetaTileEntity, this.overflowMatter);
                    this.overflowMatter = 0.0;
                    aBaseMetaTileEntity.setActive(false);
                    aBaseMetaTileEntity.setLightValue((byte)0);
                    aBaseMetaTileEntity.getWorld().func_147463_c(EnumSkyBlock.Block, aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
                }
                this.vapePollution(aBaseMetaTileEntity);
            } else if (this.overflowMatter > 0.0) {
                aBaseMetaTileEntity.setActive(true);
                aBaseMetaTileEntity.setLightValue((byte)15);
                aBaseMetaTileEntity.getWorld().func_147463_c(EnumSkyBlock.Block, aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
            }
        } else if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            TecTech.proxy.em_particle(aBaseMetaTileEntity, aBaseMetaTileEntity.getFrontFacing());
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    private void vapePollution(IGregTechTileEntity mte) {
        float xPos = (float)mte.getXCoord() + 0.5f;
        float yPos = (float)mte.getYCoord() + 0.5f;
        float zPos = (float)mte.getZCoord() + 0.5f;
        int xDirShift = ForgeDirection.getOrientation((int)mte.getFrontFacing()).offsetX;
        int yDirShift = ForgeDirection.getOrientation((int)mte.getFrontFacing()).offsetY;
        int zDirShift = ForgeDirection.getOrientation((int)mte.getFrontFacing()).offsetZ;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)xPos - 0.5 + (double)xDirShift), (double)((double)yPos - 0.5 + (double)yDirShift), (double)((double)zPos - 0.5 + (double)zDirShift), (double)((double)xPos + 0.5 + (double)xDirShift), (double)((double)yPos + 1.5 + (double)yDirShift), (double)((double)zPos + 0.5 + (double)zDirShift));
        for (Object entity : mte.getWorld().func_72872_a(EntityLivingBase.class, aabb)) {
            float damagingFactor = (float)Math.log(this.overflowDisperse);
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 1, (int)(damagingFactor * 20.0f)));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 2, (int)(damagingFactor * 15.0f)));
            ((EntityLivingBase)entity).func_70097_a(MainLoader.elementalPollution, damagingFactor);
        }
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        super.onRightclick(aBaseMetaTileEntity, aPlayer);
        if (!aBaseMetaTileEntity.isClientSide() && aPlayer instanceof EntityPlayerMP) {
            try {
                EntityPlayerMP player = (EntityPlayerMP)aPlayer;
                this.clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
            }
            catch (Exception e) {
                this.clientLocale = "en_US";
            }
        } else {
            return true;
        }
        return true;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.Contained_mass", (Object[])new Object[]{this.clientLocale}) + ":", EnumChatFormatting.RED + Double.toString(this.overflowMatter) + EnumChatFormatting.RESET + " eV/c\u00b2 /", EnumChatFormatting.GREEN + Double.toString(this.overflowMax) + EnumChatFormatting.RESET + " eV/c\u00b2", StatCollector.func_74837_a((String)"tt.keyphrase.Mass_Disposal_speed", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.BLUE + this.overflowDisperse + EnumChatFormatting.RESET + " (eV/c\u00b2)/s"};
    }

    public void onRemoval() {
        if (GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)this) && this.getBaseMetaTileEntity().isActive()) {
            TecTech.anomalyHandler.addAnomaly(this.getBaseMetaTileEntity(), this.overflowMatter * 8.0);
            if (TecTech.configTecTech.BOOM_ENABLE) {
                this.getBaseMetaTileEntity().doExplosion(CommonValues.V[15]);
            } else {
                TecTech.proxy.broadcast(StatCollector.func_74837_a((String)"tt.keyphrase.Muffler_BOOM", (Object[])new Object[]{this.clientLocale}) + " " + this.getBaseMetaTileEntity().getXCoord() + ' ' + this.getBaseMetaTileEntity().getYCoord() + ' ' + this.getBaseMetaTileEntity().getZCoord());
            }
        }
    }

    public boolean addOverflowMatter(double matter) {
        this.overflowMatter += matter;
        return this.overflowMatter > this.overflowMax;
    }

    public double getOverflowMatter() {
        return this.overflowMatter;
    }

    public boolean setOverflowMatter(double overflowMatter) {
        this.overflowMatter = overflowMatter;
        return overflowMatter > this.overflowMax;
    }
}

