/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.hatch;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.iElementalInstanceContainer;
import com.github.technus.tectech.mechanics.elementalMatter.core.tElementalException;
import com.github.technus.tectech.mechanics.pipe.IConnectsToElementalPipe;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OverflowElemental;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.reflect.FieldUtils;

public abstract class GT_MetaTileEntity_Hatch_ElementalContainer
extends GT_MetaTileEntity_Hatch
implements iElementalInstanceContainer,
IConnectsToElementalPipe {
    private static Textures.BlockIcons.CustomIcon EM_T_SIDES;
    private static Textures.BlockIcons.CustomIcon EM_T_ACTIVE;
    private static Textures.BlockIcons.CustomIcon EM_T_CONN;
    private String clientLocale = "en_US";
    protected cElementalInstanceStackMap content = new cElementalInstanceStackMap();
    public int postEnergize = 0;
    public double overflowMatter = 0.0;
    public short id = (short)-1;
    private byte deathDelay = (byte)2;

    protected GT_MetaTileEntity_Hatch_ElementalContainer(int aID, String aName, String aNameRegional, int aTier, String descr) {
        super(aID, aName, aNameRegional, aTier, 0, descr, new ITexture[0]);
        Util.setTier(aTier, this);
    }

    protected GT_MetaTileEntity_Hatch_ElementalContainer(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        EM_T_ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_EM_T_ACTIVE");
        EM_T_SIDES = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_EM_T_SIDES");
        EM_T_CONN = new Textures.BlockIcons.CustomIcon("iconsets/EM_PIPE_CONN");
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)EM_T_ACTIVE, Dyes.getModulation((int)this.getBaseMetaTileEntity().getColorization(), (short[])Dyes.MACHINE_METAL.getRGBA())), new GT_RenderedTexture((IIconContainer)EM_T_CONN)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)EM_T_SIDES, Dyes.getModulation((int)this.getBaseMetaTileEntity().getColorization(), (short[])Dyes.MACHINE_METAL.getRGBA())), new GT_RenderedTexture((IIconContainer)EM_T_CONN)};
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("postEnergize", this.postEnergize);
        aNBT.func_74780_a("OverflowMatter", this.overflowMatter);
        this.content.cleanUp();
        aNBT.func_74782_a("eM_Stacks", (NBTBase)this.content.toNBT());
        aNBT.func_74777_a("eID", this.id);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        block3: {
            super.loadNBTData(aNBT);
            this.postEnergize = aNBT.func_74762_e("postEnergize");
            this.overflowMatter = (double)aNBT.func_74760_g("overflowMatter") + aNBT.func_74769_h("OverflowMatter");
            this.id = aNBT.func_74765_d("eID");
            try {
                this.content = cElementalInstanceStackMap.fromNBT(aNBT.func_74775_l("eM_Stacks"));
            }
            catch (tElementalException e) {
                if (TecTechConfig.DEBUG_MODE) {
                    e.printStackTrace();
                }
                if (this.content != null) break block3;
                this.content = new cElementalInstanceStackMap();
            }
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            byte Tick = (byte)(aTick % 20L);
            if (0 == Tick) {
                this.purgeOverflow();
                this.content.tickContentByOneSecond(1.0, this.postEnergize);
                this.purgeOverflow();
            } else if (10 == Tick) {
                if (this.overflowMatter <= 0.0) {
                    this.deathDelay = (byte)3;
                } else {
                    if (this.deathDelay == 1) {
                        IGregTechTileEntity tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSide(aBaseMetaTileEntity.getBackFacing());
                        if (tGTTileEntity == null || !(tGTTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_OverflowElemental)) {
                            tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSide((byte)0);
                        }
                        if (tGTTileEntity == null || !(tGTTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_OverflowElemental)) {
                            tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSide((byte)1);
                        }
                        if (tGTTileEntity != null && tGTTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_OverflowElemental) {
                            GT_MetaTileEntity_Hatch_OverflowElemental aMetaTileEntity = (GT_MetaTileEntity_Hatch_OverflowElemental)tGTTileEntity.getMetaTileEntity();
                            if (aMetaTileEntity.addOverflowMatter(this.overflowMatter)) {
                                if (TecTech.configTecTech.BOOM_ENABLE) {
                                    tGTTileEntity.doExplosion(CommonValues.V[14]);
                                } else {
                                    TecTech.anomalyHandler.addAnomaly(aBaseMetaTileEntity, this.overflowMatter * 32.0);
                                    TecTech.proxy.broadcast("Container1 " + StatCollector.func_74838_a((String)"tt.keyword.BOOM") + " " + aBaseMetaTileEntity.getXCoord() + ' ' + aBaseMetaTileEntity.getYCoord() + ' ' + aBaseMetaTileEntity.getZCoord());
                                }
                            }
                            this.deathDelay = (byte)3;
                            this.overflowMatter = 0.0;
                        }
                    } else if (this.deathDelay < 1) {
                        if (TecTech.configTecTech.BOOM_ENABLE) {
                            aBaseMetaTileEntity.doExplosion(CommonValues.V[14]);
                        } else {
                            TecTech.anomalyHandler.addAnomaly(aBaseMetaTileEntity, this.overflowMatter * 32.0);
                            this.deathDelay = (byte)3;
                            this.overflowMatter = 0.0;
                            TecTech.proxy.broadcast("Container0 " + StatCollector.func_74838_a((String)"tt.keyword.BOOM") + " " + aBaseMetaTileEntity.getXCoord() + ' ' + aBaseMetaTileEntity.getYCoord() + ' ' + aBaseMetaTileEntity.getZCoord());
                        }
                    }
                    this.deathDelay = (byte)(this.deathDelay - 1);
                }
            } else if (4 == Tick) {
                if (this.content.hasStacks()) {
                    this.content.cleanUp();
                    this.moveAround(aBaseMetaTileEntity);
                }
                this.getBaseMetaTileEntity().setActive(this.content.hasStacks());
            }
        }
    }

    public void moveAround(IGregTechTileEntity aBaseMetaTileEntity) {
    }

    @Override
    public cElementalInstanceStackMap getContainerHandler() {
        return this.content;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isLiquidInput(byte aSide) {
        return false;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public int getMaxStacksCount() {
        return this.mTier * 128;
    }

    public double getMaxStackSize() {
        return (double)(this.mTier * (this.mTier - 7)) * 64.0 * 8.6718826944E25;
    }

    @Override
    public void purgeOverflow() {
        this.overflowMatter += this.content.removeOverflow(this.getMaxStacksCount(), this.getMaxStackSize());
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        super.onRightclick(aBaseMetaTileEntity, aPlayer);
        if (!aBaseMetaTileEntity.isClientSide() && aPlayer instanceof EntityPlayerMP) {
            try {
                EntityPlayerMP player = (EntityPlayerMP)aPlayer;
                this.clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
            }
            catch (Exception e) {
                this.clientLocale = "en_US";
            }
        } else {
            return true;
        }
        return true;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        if (TecTech.configTecTech.EASY_SCAN || TecTechConfig.DEBUG_MODE) {
            if (this.id > 0) {
                if (this.content == null || this.content.size() == 0) {
                    return new String[]{StatCollector.func_74837_a((String)"tt.keyword.ID", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.AQUA + this.id, StatCollector.func_74837_a((String)"tt.keyphrase.No_Stacks", (Object[])new Object[]{this.clientLocale})};
                }
                String[] lines = this.content.getElementalInfo();
                String[] output = new String[lines.length + 1];
                output[0] = StatCollector.func_74837_a((String)"tt.keyword.ID", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.AQUA + this.id;
                System.arraycopy(lines, 0, output, 1, lines.length);
                return output;
            }
            if (this.content == null || this.content.size() == 0) {
                return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.No_Stacks", (Object[])new Object[]{this.clientLocale})};
            }
            return this.content.getElementalInfo();
        }
        if (this.id > 0) {
            if (this.content == null || this.content.size() == 0) {
                return new String[]{StatCollector.func_74837_a((String)"tt.keyword.ID", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.AQUA + this.id, StatCollector.func_74837_a((String)"tt.keyphrase.No_Stacks", (Object[])new Object[]{this.clientLocale})};
            }
            return new String[]{StatCollector.func_74837_a((String)"tt.keyword.ID", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.AQUA + this.id, StatCollector.func_74837_a((String)"tt.keyphrase.Contains_EM", (Object[])new Object[]{this.clientLocale})};
        }
        if (this.content == null || this.content.size() == 0) {
            return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.No_Stacks", (Object[])new Object[]{this.clientLocale})};
        }
        return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.Contains_EM", (Object[])new Object[]{this.clientLocale})};
    }

    public void updateSlots() {
        this.purgeOverflow();
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, this.mDescription, StatCollector.func_74838_a((String)"tt.base.emhatch.desc.0") + " " + EnumChatFormatting.AQUA + this.getMaxStacksCount(), StatCollector.func_74838_a((String)"tt.base.emhatch.desc.1") + " " + EnumChatFormatting.AQUA + this.getMaxStackSize(), StatCollector.func_74838_a((String)"tt.base.emhatch.desc.2"), StatCollector.func_74838_a((String)"tt.base.emhatch.desc.3"), StatCollector.func_74838_a((String)"tt.base.emhatch.desc.4"), StatCollector.func_74838_a((String)"tt.base.emhatch.desc.5"), StatCollector.func_74838_a((String)"tt.base.emhatch.desc.6"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.base.emhatch.desc.7")};
    }

    public void onRemoval() {
        if (GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)this) && this.getBaseMetaTileEntity().isActive()) {
            TecTech.anomalyHandler.addAnomaly(this.getBaseMetaTileEntity(), (this.overflowMatter + this.content.getMass()) * 16.0);
            IGregTechTileEntity base = this.getBaseMetaTileEntity();
            if (TecTech.configTecTech.BOOM_ENABLE) {
                base.doExplosion(CommonValues.V[15]);
            } else {
                TecTech.proxy.broadcast(StatCollector.func_74838_a((String)"tt.keyword.BOOM") + " " + base.getXCoord() + ' ' + base.getYCoord() + ' ' + base.getZCoord());
            }
        }
    }
}

