/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.transformations;

import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aFluidDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aFluidQuantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aItemDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aItemQuantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aOredictDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aOredictQuantizationInfo;
import com.github.technus.tectech.thing.item.DebugElementalInstanceContainer_EM;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class bTransformationInfo {
    public static final double AVOGADRO_CONSTANT = 6.02214076E23;
    public static final double AVOGADRO_CONSTANT_UNCERTAINTY = 2.3911762567303394E-19;
    public static final double AVOGADRO_CONSTANT_144 = 8.6718826944E25;
    public static final Map<Integer, aFluidQuantizationInfo> fluidQuantization = new HashMap<Integer, aFluidQuantizationInfo>(32);
    public static final Map<aItemQuantizationInfo, aItemQuantizationInfo> itemQuantization = new HashMap<aItemQuantizationInfo, aItemQuantizationInfo>(32);
    public static final Map<Integer, aOredictQuantizationInfo> oredictQuantization = new HashMap<Integer, aOredictQuantizationInfo>(32);
    public Map<iElementalDefinition, aFluidDequantizationInfo> fluidDequantization;
    public Map<iElementalDefinition, aItemDequantizationInfo> itemDequantization;
    public Map<iElementalDefinition, aOredictDequantizationInfo> oredictDequantization;

    public bTransformationInfo(int fluidCap, int itemCap, int oreCap) {
        this.fluidDequantization = fluidCap > 0 ? new HashMap(fluidCap) : Collections.emptyMap();
        this.itemDequantization = itemCap > 0 ? new HashMap(itemCap) : Collections.emptyMap();
        this.oredictDequantization = oreCap > 0 ? new HashMap(oreCap) : Collections.emptyMap();
    }

    public void addFluid(iHasElementalDefinition em, FluidStack fluidStack) {
        fluidQuantization.put(fluidStack.getFluidID(), new aFluidQuantizationInfo(fluidStack, em));
        this.fluidDequantization.put(em.getDefinition(), new aFluidDequantizationInfo(em, fluidStack));
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition());
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition().getAnti());
    }

    public void addFluid(iHasElementalDefinition em, Fluid fluid, int fluidAmount) {
        fluidQuantization.put(fluid.getID(), new aFluidQuantizationInfo(fluid, fluidAmount, em));
        this.fluidDequantization.put(em.getDefinition(), new aFluidDequantizationInfo(em, fluid, fluidAmount));
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition());
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition().getAnti());
    }

    private void addItemQuantization(aItemQuantizationInfo aIQI) {
        itemQuantization.put(aIQI, aIQI);
    }

    public void addItem(iHasElementalDefinition em, ItemStack itemStack, boolean skipNBT) {
        this.addItemQuantization(new aItemQuantizationInfo(itemStack, skipNBT, em));
        this.itemDequantization.put(em.getDefinition(), new aItemDequantizationInfo(em, itemStack));
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition());
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition().getAnti());
    }

    public void addItem(iHasElementalDefinition em, OrePrefixes prefix, Materials material, int amount, boolean skipNBT) {
        this.addItemQuantization(new aItemQuantizationInfo(prefix, material, amount, skipNBT, em));
        this.itemDequantization.put(em.getDefinition(), new aItemDequantizationInfo(em, prefix, material, amount));
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition());
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition().getAnti());
    }

    public void addOredict(iHasElementalDefinition em, String name, int qty) {
        oredictQuantization.put(OreDictionary.getOreID((String)name), new aOredictQuantizationInfo(name, qty, em));
        this.oredictDequantization.put(em.getDefinition(), new aOredictDequantizationInfo(em, name, qty));
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition());
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition().getAnti());
    }

    public void addOredict(iHasElementalDefinition em, OrePrefixes prefix, Materials material, int qty) {
        oredictQuantization.put(OreDictionary.getOreID((String)(prefix.name() + material.mName)), new aOredictQuantizationInfo(prefix, material, qty, em));
        this.oredictDequantization.put(em.getDefinition(), new aOredictDequantizationInfo(em, prefix, material, qty));
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition());
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition().getAnti());
    }

    public void addOredict(iHasElementalDefinition em, OrePrefixes prefix, String materialName, int qty) {
        oredictQuantization.put(OreDictionary.getOreID((String)(prefix.name() + materialName)), new aOredictQuantizationInfo(prefix, materialName, qty, em));
        this.oredictDequantization.put(em.getDefinition(), new aOredictDequantizationInfo(em, prefix, materialName, qty));
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition());
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(em.getDefinition().getAnti());
    }
}

