/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.single;

import com.github.technus.avrClone.AvrCore;
import com.github.technus.avrClone.instructions.ExecutionEvent;
import com.github.technus.avrClone.instructions.Instruction;
import com.github.technus.avrClone.instructions.InstructionRegistry;
import com.github.technus.avrClone.instructions.exceptions.DelayEvent;
import com.github.technus.avrClone.memory.EepromMemory;
import com.github.technus.avrClone.memory.RemovableMemory;
import com.github.technus.avrClone.memory.program.ProgramMemory;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.avr.SidedRedstone;
import com.github.technus.tectech.thing.metaTileEntity.Textures;
import com.github.technus.tectech.thing.metaTileEntity.single.GT_MetaTileEntity_DataReader;
import com.github.technus.tectech.util.Util;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_MicroController
extends GT_MetaTileEntity_TieredMachineBlock {
    public static final int OPS_PER_TICK_MAX = 512;
    public AvrCore core;
    private int[] tempData;
    public boolean debugRun;
    private int delay;
    private int maxLoad;
    public static final SidedRedstone sidedRedstone;

    public GT_MetaTileEntity_MicroController(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "AVR Micro-controller", new ITexture[0]);
        Util.setTier(aTier, (Object)this);
    }

    public GT_MetaTileEntity_MicroController(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        Util.setTier(aTier, (Object)this);
        this.core = new AvrCore();
        this.core.setUsingImmersiveOperands(false);
        this.core.setInstructionRegistry(InstructionRegistry.INSTRUCTION_REGISTRY_OP);
        this.core.setDataMemory(Math.max(64, 1 << aTier), Math.max(64, 1 << aTier));
        this.core.setCpuRegisters(48);
        this.core.putDataBindings(sidedRedstone);
        this.maxLoad = Math.min(1 << this.mTier, 512);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_MetaTileEntity_MicroController(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public void loadNBTData(NBTTagCompound tag) {
        InstructionRegistry registry;
        NBTTagCompound avr = tag.func_74775_l("avr");
        this.debugRun = avr.func_74767_n("debugRun");
        this.delay = avr.func_74762_e("delay");
        this.core.active = avr.func_74767_n("active");
        this.core.awoken = avr.func_74767_n("awoken");
        this.core.programCounter = avr.func_74762_e("programCounter");
        if (avr.func_74764_b("instructions") && (registry = InstructionRegistry.REGISTRIES.get(avr.func_74779_i("instructionRegistry"))) != null) {
            this.core.setProgramMemory(new ProgramMemory(registry, avr.func_74767_n("immersive"), avr.func_74759_k("instructions"), avr.func_74759_k("param0"), avr.func_74759_k("param1")));
        }
        if (avr.func_74764_b("eepromSize")) {
            this.core.restoreEepromDefinition(EepromMemory.make(avr.func_74762_e("eepromSize")));
        }
        if (avr.func_74764_b("dataMemory")) {
            this.tempData = avr.func_74759_k("dataMemory");
        }
        this.core.checkValid();
    }

    public void saveNBTData(NBTTagCompound tag) {
        RemovableMemory<EepromMemory> eeprom;
        NBTTagCompound avr = new NBTTagCompound();
        avr.func_74757_a("debugRun", this.debugRun);
        avr.func_74768_a("delay", this.delay);
        avr.func_74757_a("active", this.core.active);
        avr.func_74757_a("awoken", this.core.awoken);
        avr.func_74768_a("programCounter", this.core.programCounter);
        ProgramMemory programMemory = this.core.getProgramMemory();
        if (programMemory != null) {
            avr.func_74783_a("instructions", programMemory.instructions);
            avr.func_74783_a("param0", programMemory.param0);
            avr.func_74783_a("param1", programMemory.param1);
            avr.func_74757_a("immersive", programMemory.immersiveOperands);
            avr.func_74778_a("instructionRegistry", programMemory.registry.toString());
        }
        if ((eeprom = this.core.getEepromMemory()) != null) {
            avr.func_74768_a("eepromSize", eeprom.getDefinition().getSize());
        }
        if (this.core.dataMemory != null) {
            avr.func_74783_a("dataMemory", this.core.dataMemory);
        }
        tag.func_74782_a("avr", (NBTBase)avr);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.tempData != null) {
            this.core.dataMemory = this.tempData;
            this.tempData = null;
        }
        if (aBaseMetaTileEntity.isActive()) {
            sidedRedstone.preSync(this.core, aBaseMetaTileEntity);
            this.core.interruptsHandle();
            if (this.core.awoken) {
                this.delay = 0;
                for (int load = 0; load < this.maxLoad; load += this.core.getInstruction().getCost(this.core)) {
                    ExecutionEvent executionEvent = this.core.cpuCycleForce();
                    if (executionEvent == null) continue;
                    if (!(executionEvent.throwable instanceof DelayEvent)) continue;
                    this.delay = executionEvent.data[0];
                    break;
                }
            } else if (this.delay > 0) {
                --this.delay;
                if (this.delay == 0) {
                    this.core.awoken = true;
                }
            }
            sidedRedstone.postSync(this.core, aBaseMetaTileEntity);
        }
        this.core.active = aBaseMetaTileEntity.isActive();
    }

    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return true;
    }

    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aBaseMetaTileEntity.getWorld() == null) {
            if (aSide == aFacing) {
                return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1], aActive ? GT_MetaTileEntity_DataReader.READER_ONLINE : GT_MetaTileEntity_DataReader.READER_OFFLINE};
            }
            return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1]};
        }
        if (aSide == aBaseMetaTileEntity.getFrontFacing()) {
            return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1], aActive ? GT_MetaTileEntity_DataReader.READER_ONLINE : GT_MetaTileEntity_DataReader.READER_OFFLINE};
        }
        if (aSide == aFacing) {
            return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT)};
        }
        return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1]};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    static {
        Instruction.random = TecTech.RANDOM;
        sidedRedstone = new SidedRedstone(22);
    }
}

