/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.definitions.complex;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.compatibility.gtpp.GtppAtomLoader;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.dComplexAspectDefinition;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalMutableDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.tElementalException;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.cElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aFluidDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aItemDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aOredictDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.bTransformationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.dHadronDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.iaeaNuclide;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eBosonDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eLeptonDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eNeutrinoDefinition;
import com.github.technus.tectech.util.Util;
import com.github.technus.tectech.util.XSTR;
import cpw.mods.fml.common.Loader;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.nbt.NBTTagCompound;

public final class dAtomDefinition
extends cElementalDefinition {
    public static final long ATOM_COMPLEXITY_LIMIT = 65536L;
    private static final byte BYTE_OFFSET = 32;
    private final int hash;
    public static final bTransformationInfo TRANSFORMATION_INFO = new bTransformationInfo(16, 0, 64);
    public static double refMass;
    public static double refUnstableMass;
    private static final byte nbtType = 97;
    private static final Random xstr;
    private static Map<Integer, TreeSet<Integer>> stableIsotopes;
    private static final Map<Integer, dAtomDefinition> stableAtoms;
    private static Map<Integer, TreeMap<Double, Integer>> mostStableUnstableIsotopes;
    private static final Map<Integer, dAtomDefinition> unstableAtoms;
    private static cElementalDefinitionStack alpha;
    private static cElementalDefinitionStack deuterium;
    private static cElementalDefinitionStack tritium;
    private static cElementalDefinitionStack helium_3;
    private static cElementalDefinitionStack beryllium_8;
    private static cElementalDefinitionStack carbon_14;
    private static cElementalDefinitionStack neon_24;
    private static cElementalDefinitionStack silicon_34;
    private static final HashMap<dAtomDefinition, Double> lifetimeOverrides;
    public final iaeaNuclide iaea;
    private static dAtomDefinition somethingHeavy;
    private static final ArrayList<Runnable> overrides;
    public final double mass;
    public final int charge;
    public final int chargeLeptons;
    private double rawLifeTime;
    public final byte type;
    public final byte decayMode;
    public final int neutralCount;
    public final int element;
    private final boolean iaeaDefinitionExistsAndHasEnergyLevels;
    private final cElementalDefinitionStackMap elementalStacks;

    public static dAtomDefinition getSomethingHeavy() {
        return somethingHeavy;
    }

    public static void addOverride(dAtomDefinition atom, double rawLifeTime) {
        lifetimeOverrides.put(atom, rawLifeTime);
    }

    @Deprecated
    public dAtomDefinition(iElementalDefinition ... things) throws tElementalException {
        this(true, new cElementalDefinitionStackMap(things));
    }

    @Deprecated
    private dAtomDefinition(boolean check, iElementalDefinition ... things) throws tElementalException {
        this(check, new cElementalDefinitionStackMap(things));
    }

    public dAtomDefinition(cElementalDefinitionStack ... things) throws tElementalException {
        this(true, new cElementalDefinitionStackMap(things));
    }

    private dAtomDefinition(boolean check, cElementalDefinitionStack ... things) throws tElementalException {
        this(check, new cElementalDefinitionStackMap(things));
    }

    public dAtomDefinition(cElementalDefinitionStackMap things) throws tElementalException {
        this(true, things);
    }

    private dAtomDefinition(boolean check, cElementalDefinitionStackMap things) throws tElementalException {
        Double overriddenLifeTime;
        if (check && !dAtomDefinition.canTheyBeTogether(things)) {
            throw new tElementalException("Atom Definition error");
        }
        this.elementalStacks = things;
        double mass = 0.0;
        int cLeptons = 0;
        int cNucleus = 0;
        int neutralCount = 0;
        int element = 0;
        int type = 0;
        boolean containsAnti = false;
        for (cElementalDefinitionStack stack : this.elementalStacks.values()) {
            iElementalDefinition def = stack.definition;
            int amount = (int)stack.amount;
            if ((double)((int)stack.amount) != stack.amount) {
                throw new ArithmeticException("Amount cannot be safely converted to int!");
            }
            mass += stack.getMass();
            if (def.getType() < 0) {
                containsAnti = true;
            }
            type = Math.max(type, Math.abs(def.getType()));
            if (def instanceof eLeptonDefinition) {
                cLeptons = (int)((double)cLeptons + stack.getCharge());
                continue;
            }
            cNucleus = (int)((double)cNucleus + stack.getCharge());
            if (def.getCharge() == 3) {
                element += amount;
                continue;
            }
            if (def.getCharge() == -3) {
                element -= amount;
                continue;
            }
            if (def.getCharge() != 0) continue;
            neutralCount += amount;
        }
        this.type = containsAnti ? (byte)(-type) : (byte)type;
        this.chargeLeptons = cLeptons;
        this.charge = cNucleus + cLeptons;
        this.neutralCount = neutralCount;
        this.element = element;
        element = Math.abs(element);
        int StableIsotope = dAtomDefinition.stableIzoCurve(element);
        int izoDiff = neutralCount - StableIsotope;
        int izoDiffAbs = Math.abs(izoDiff);
        xstr.setSeed(((long)element + 1L) * ((long)neutralCount + 100L));
        this.iaea = iaeaNuclide.get(element, neutralCount);
        if (this.iaea != null) {
            this.mass = Double.isNaN(this.iaea.mass) ? mass : this.iaea.mass;
            if (Double.isNaN(this.iaea.halfTime)) {
                overriddenLifeTime = lifetimeOverrides.get(this);
                double rawLifeTimeTemp = overriddenLifeTime != null ? overriddenLifeTime : dAtomDefinition.calculateLifeTime(izoDiff, izoDiffAbs, element, neutralCount, containsAnti);
                this.rawLifeTime = Math.min(rawLifeTimeTemp, 1.5E36);
            } else {
                this.rawLifeTime = containsAnti ? this.iaea.halfTime * 1.5514433E-21 * (1.0 + xstr.nextDouble() * 9.0) : this.iaea.halfTime;
            }
            this.iaeaDefinitionExistsAndHasEnergyLevels = this.iaea.energeticStatesArray.length > 1;
        } else {
            this.mass = mass;
            overriddenLifeTime = lifetimeOverrides.get(this);
            double rawLifeTimeTemp = overriddenLifeTime != null ? overriddenLifeTime : dAtomDefinition.calculateLifeTime(izoDiff, izoDiffAbs, element, neutralCount, containsAnti);
            this.rawLifeTime = Math.min(rawLifeTimeTemp, 1.5E36);
            this.iaeaDefinitionExistsAndHasEnergyLevels = false;
        }
        this.decayMode = this.iaea == null || this.iaea.energeticStatesArray[0].energy != 0.0 ? (izoDiff == 0 ? (byte)0 : (izoDiff > 0 ? (byte)Math.min(2, 1 + izoDiffAbs / 4) : (byte)(-Math.min(2, 1 + izoDiffAbs / 4)))) : (izoDiff > 0 ? (byte)(Math.min(2, 1 + izoDiffAbs / 4) + 32) : (byte)(-Math.min(2, 1 + izoDiffAbs / 4) + 32));
        this.hash = super.hashCode();
    }

    private static int stableIzoCurve(int element) {
        return (int)Math.round(-1.19561E-6 * Math.pow(element, 4.0) + 1.60885E-4 * Math.pow(element, 3.0) + 3.76604E-4 * Math.pow(element, 2.0) + 1.08418 * (double)element);
    }

    private static double calculateLifeTime(int izoDiff, int izoDiffAbs, int element, int isotope, boolean containsAnti) {
        double rawLifeTime;
        if (element <= 83 && isotope < 127 && (izoDiffAbs == 0 || element == 1 && isotope == 0 || element == 2 && isotope == 1 || izoDiffAbs == 1 && element > 2 && element % 2 == 1 || izoDiffAbs == 3 && element > 30 && element % 2 == 0 || izoDiffAbs == 5 && element > 30 && element % 2 == 0 || izoDiffAbs == 2 && element > 20 && element % 2 == 1)) {
            rawLifeTime = (1.0 + xstr.nextDouble() * 9.0) * (containsAnti ? 23810.0 : 1.5347E25);
        } else {
            double unstabilityEXP;
            if (element == 0) {
                return 1.0E-35;
            }
            if (element == 1) {
                unstabilityEXP = 1.743 - (double)Math.abs(izoDiff - 1) * 9.743;
            } else if (element == 2) {
                switch (isotope) {
                    case 4: {
                        unstabilityEXP = 1.61;
                        break;
                    }
                    case 5: {
                        unstabilityEXP = -7.523;
                        break;
                    }
                    case 6: {
                        unstabilityEXP = -1.51;
                        break;
                    }
                    default: {
                        unstabilityEXP = -((double)izoDiffAbs * 6.165);
                        break;
                    }
                }
            } else if (element <= 83 || isotope <= 127 && element <= 120) {
                double elementPow4 = Math.pow(element, 4.0);
                unstabilityEXP = Math.min((double)element / 2.4, 6.0 + (double)((element + 1) % 2) * 3000000.0 / elementPow4) + (double)(-izoDiff) * elementPow4 / 1.0E8 - Math.abs((double)(izoDiff - 1) + (double)element / 60.0) * (3.0 - (double)element / 12.5 + (double)(element * element) / 1500.0);
            } else if (element < 180) {
                unstabilityEXP = Math.min((double)((element - 85) * 2), 16.0 + (double)((isotope + 1) % 2) * 2.5 - (double)(element - 85) / 3.0) - (double)Math.abs(izoDiff) * (3.0 - (double)element / 13.0 + (double)(element * element) / 1600.0);
            } else {
                return -1.0;
            }
            if ((isotope == 127 || isotope == 128) && element < 120 && element > 83) {
                unstabilityEXP -= 1.8;
            }
            if (element > 83 && element < 93 && isotope % 2 == 0 && izoDiff == 3) {
                unstabilityEXP += 6.0;
            }
            if (element > 93 && element < 103 && isotope % 2 == 0 && izoDiff == 4) {
                unstabilityEXP += 6.0;
            }
            rawLifeTime = (containsAnti ? 1.0E-8 : 1.0) * Math.pow(10.0, unstabilityEXP) * (1.0 + xstr.nextDouble() * 9.0);
        }
        if (rawLifeTime < 8.0E-15) {
            return 1.0E-35;
        }
        if (rawLifeTime > 8.0E28) {
            return 8.0E30;
        }
        return rawLifeTime;
    }

    private static boolean canTheyBeTogether(cElementalDefinitionStackMap stacks) {
        boolean nuclei = false;
        long qty = 0L;
        for (cElementalDefinitionStack stack : stacks.values()) {
            if (stack.definition instanceof dHadronDefinition) {
                if (((dHadronDefinition)stack.definition).amount != 3) {
                    return false;
                }
                nuclei = true;
            } else if (!(stack.definition instanceof eLeptonDefinition)) {
                return false;
            }
            if ((double)((int)stack.amount) != stack.amount) {
                throw new ArithmeticException("Amount cannot be safely converted to int!");
            }
            qty = (long)((double)qty + stack.amount);
        }
        return nuclei && qty < 65536L;
    }

    @Override
    public int getCharge() {
        return this.charge;
    }

    public int getChargeLeptons() {
        return this.chargeLeptons;
    }

    public int getChargeHadrons() {
        return this.charge - this.chargeLeptons;
    }

    public int getIonizationElementWise() {
        return this.element * 3 + this.chargeLeptons;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public double getRawTimeSpan(long currentEnergy) {
        if (currentEnergy <= 0L) {
            return this.rawLifeTime;
        }
        if (this.iaeaDefinitionExistsAndHasEnergyLevels) {
            if (currentEnergy >= (long)this.iaea.energeticStatesArray.length) {
                return this.iaea.energeticStatesArray[this.iaea.energeticStatesArray.length - 1].Thalf / (double)(currentEnergy - (long)this.iaea.energeticStatesArray.length + 1L);
            }
            return this.iaea.energeticStatesArray[(int)currentEnergy].Thalf;
        }
        return this.rawLifeTime / (double)(currentEnergy + 1L);
    }

    @Override
    public boolean isTimeSpanHalfLife() {
        return true;
    }

    @Override
    public byte getColor() {
        return -10;
    }

    @Override
    public String getName() {
        int element = Math.abs(this.element);
        boolean negative = this.element < 0;
        try {
            if (Math.abs(this.type) != 1) {
                return (negative ? "~? " : "? ") + Nomenclature.NAME[element];
            }
            return negative ? '~' + Nomenclature.NAME[element] : Nomenclature.NAME[element];
        }
        catch (Exception e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return (negative ? "Element: ~" : "Element: ") + element;
        }
    }

    @Override
    public String getSymbol() {
        int element = Math.abs(this.element);
        boolean negative = this.element < 0;
        try {
            return (negative ? "~" : "") + Nomenclature.SYMBOL[element] + " N:" + this.neutralCount + " I:" + (this.neutralCount + element) + " C:" + this.getCharge();
        }
        catch (Exception e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            try {
                int s100 = element / 100;
                int s1 = element / 10 % 10;
                int s10 = element % 10;
                return (negative ? "~" : "") + Nomenclature.SYMBOL_IUPAC[10 + s100] + Nomenclature.SYMBOL_IUPAC[s10] + Nomenclature.SYMBOL_IUPAC[s1] + " N:" + this.neutralCount + " I:" + (this.neutralCount + element) + " C:" + this.getCharge();
            }
            catch (Exception E) {
                if (TecTechConfig.DEBUG_MODE) {
                    e.printStackTrace();
                }
                return (negative ? "~" : "") + "? N:" + this.neutralCount + " I:" + (this.neutralCount + element) + " C:" + this.getCharge();
            }
        }
    }

    @Override
    public String getShortSymbol() {
        int element = Math.abs(this.element);
        boolean negative = this.element < 0;
        try {
            return (negative ? "~" : "") + Nomenclature.SYMBOL[element];
        }
        catch (Exception e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            try {
                int s100 = element / 100;
                int s1 = element / 10 % 10;
                int s10 = element % 10;
                return (negative ? "~" : "") + Nomenclature.SYMBOL_IUPAC[10 + s100] + Nomenclature.SYMBOL_IUPAC[s10] + Nomenclature.SYMBOL_IUPAC[s1];
            }
            catch (Exception E) {
                if (TecTechConfig.DEBUG_MODE) {
                    e.printStackTrace();
                }
                return (negative ? "~" : "") + "?";
            }
        }
    }

    @Override
    public cElementalDefinitionStackMap getSubParticles() {
        return this.elementalStacks.clone();
    }

    @Override
    public cElementalDecay[] getDecayArray() {
        ArrayList<cElementalDecay> decaysList = new ArrayList<cElementalDecay>(4);
        return this.getDecayArray(decaysList, this.decayMode, true);
    }

    private cElementalDecay[] getDecayArray(ArrayList<cElementalDecay> decaysList, int decayMode, boolean tryAnti) {
        dAtomDefinition anti;
        if (this.type == 1) {
            switch (decayMode) {
                case -2: {
                    if (TecTech.RANDOM.nextBoolean() && this.ElectronCapture(decaysList)) {
                        return decaysList.toArray(cElementalDecay.noProduct);
                    }
                    if (!this.PbetaDecay(decaysList)) break;
                    return decaysList.toArray(cElementalDecay.noProduct);
                }
                case -1: {
                    if (!this.Emmision(decaysList, dHadronDefinition.hadron_p1)) break;
                    return decaysList.toArray(cElementalDecay.noProduct);
                }
                case 0: {
                    if (!this.alphaDecay(decaysList)) break;
                    return decaysList.toArray(cElementalDecay.noProduct);
                }
                case 1: {
                    if (!this.Emmision(decaysList, dHadronDefinition.hadron_n1)) break;
                    return decaysList.toArray(cElementalDecay.noProduct);
                }
                case 2: {
                    if (!this.MbetaDecay(decaysList)) break;
                    return decaysList.toArray(cElementalDecay.noProduct);
                }
                default: {
                    if (decayMode <= 8) break;
                    if (this.iaeaDecay(decaysList, 0L)) {
                        return decaysList.toArray(cElementalDecay.noProduct);
                    }
                    return this.getDecayArray(decaysList, decayMode - 32, false);
                }
            }
            return cElementalDecay.noDecay;
        }
        if (this.type == -1 && (anti = this.getAnti()) != null) {
            return anti.getDecayArray(decaysList, decayMode, false);
        }
        return this.getNaturalDecayInstant();
    }

    private boolean iaeaDecay(ArrayList<cElementalDecay> decaysList, long energy) {
        iaeaNuclide.energeticState state = energy > (long)this.iaea.energeticStatesArray.length ? this.iaea.energeticStatesArray[this.iaea.energeticStatesArray.length - 1] : (energy <= 0L ? this.iaea.energeticStatesArray[0] : this.iaea.energeticStatesArray[(int)energy]);
        for (int i = 0; i < state.decaymodes.length; ++i) {
            if (this.getDecayFromIaea(decaysList, state.decaymodes[i], energy)) continue;
            decaysList.clear();
            return false;
        }
        return !decaysList.isEmpty();
    }

    private boolean getDecayFromIaea(ArrayList<cElementalDecay> decaysList, iaeaNuclide.iaeaDecay decay, long energy) {
        cElementalMutableDefinitionStackMap withThis = this.elementalStacks.toMutable();
        cElementalMutableDefinitionStackMap newStuff = new cElementalMutableDefinitionStackMap();
        switch (decay.decayName) {
            case "D": {
                if (!withThis.removeAllAmounts(false, dAtomDefinition.deuterium.definition.getSubParticles())) break;
                withThis.putReplace(deuterium);
                decaysList.add(new cElementalDecay(decay.chance, withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                return true;
            }
            case "3H": {
                if (!withThis.removeAllAmounts(false, dAtomDefinition.tritium.definition.getSubParticles())) break;
                withThis.putReplace(tritium);
                decaysList.add(new cElementalDecay(decay.chance, withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                return true;
            }
            case "3HE": {
                if (!withThis.removeAllAmounts(false, dAtomDefinition.helium_3.definition.getSubParticles())) break;
                withThis.putReplace(helium_3);
                decaysList.add(new cElementalDecay(decay.chance, withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                return true;
            }
            case "8BE": {
                if (!withThis.removeAllAmounts(false, dAtomDefinition.beryllium_8.definition.getSubParticles())) break;
                withThis.putReplace(beryllium_8);
                decaysList.add(new cElementalDecay(decay.chance, withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                return true;
            }
            case "14C": {
                if (!withThis.removeAllAmounts(false, dAtomDefinition.carbon_14.definition.getSubParticles())) break;
                newStuff.putReplace(carbon_14);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "24NE": {
                if (!withThis.removeAllAmounts(false, dAtomDefinition.neon_24.definition.getSubParticles())) break;
                newStuff.putReplace(neon_24);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "34SI": {
                if (!withThis.removeAllAmounts(false, dAtomDefinition.silicon_34.definition.getSubParticles())) break;
                newStuff.putReplace(silicon_34);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "A": 
            case "A?": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n2, dHadronDefinition.hadron_p2)) break;
                newStuff.putReplace(alpha);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B+": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p1)) break;
                withThis.putUnify(dHadronDefinition.hadron_n1);
                newStuff.putReplace(eLeptonDefinition.lepton_e_1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve1);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "2B+": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p2)) break;
                withThis.putUnify(dHadronDefinition.hadron_n2);
                newStuff.putReplace(eLeptonDefinition.lepton_e_2);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve2);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B-": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n1)) break;
                withThis.putUnify(dHadronDefinition.hadron_p1);
                newStuff.putReplace(eLeptonDefinition.lepton_e1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve_1);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "2B-": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n2)) break;
                withThis.putUnify(dHadronDefinition.hadron_p2);
                newStuff.putReplace(eLeptonDefinition.lepton_e2);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve_2);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "EC": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p1, eLeptonDefinition.lepton_e1)) break;
                withThis.putUnify(dHadronDefinition.hadron_n1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve1);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "2EC": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p2, eLeptonDefinition.lepton_e2)) break;
                withThis.putUnify(dHadronDefinition.hadron_n2);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve2);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B++EC": 
            case "EC+B+": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p2, eLeptonDefinition.lepton_e1)) break;
                withThis.putUnify(dHadronDefinition.hadron_n2);
                newStuff.putReplace(eLeptonDefinition.lepton_e_1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve2);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B+A": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p3, dHadronDefinition.hadron_n1)) break;
                newStuff.putReplace(eLeptonDefinition.lepton_e_1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(alpha);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B+P": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p2)) break;
                withThis.putUnify(dHadronDefinition.hadron_n1);
                newStuff.putReplace(eLeptonDefinition.lepton_e_1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(dHadronDefinition.hadron_p1);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B+2P": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p3)) break;
                withThis.putUnify(dHadronDefinition.hadron_n1);
                newStuff.putReplace(eLeptonDefinition.lepton_e_1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(dHadronDefinition.hadron_p2);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B-A": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n3, dHadronDefinition.hadron_p1)) break;
                newStuff.putReplace(eLeptonDefinition.lepton_e1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve_1);
                newStuff.putReplace(alpha);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B-N": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n2)) break;
                withThis.putUnify(dHadronDefinition.hadron_p1);
                newStuff.putReplace(eLeptonDefinition.lepton_e1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve_1);
                newStuff.putReplace(dHadronDefinition.hadron_n1);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B-2N": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n3)) break;
                withThis.putUnify(dHadronDefinition.hadron_p1);
                newStuff.putReplace(eLeptonDefinition.lepton_e1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve_1);
                newStuff.putReplace(dHadronDefinition.hadron_n2);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B-P": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n1)) break;
                newStuff.putReplace(eLeptonDefinition.lepton_e1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve_1);
                newStuff.putReplace(dHadronDefinition.hadron_p1);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "ECA": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n1, eLeptonDefinition.lepton_e1, dHadronDefinition.hadron_p3)) break;
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(alpha);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "ECP": {
                if (!withThis.removeAllAmounts(false, eLeptonDefinition.lepton_e1, dHadronDefinition.hadron_p2)) break;
                withThis.putUnify(dHadronDefinition.hadron_n1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(dHadronDefinition.hadron_p1);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "EC2P": {
                if (!withThis.removeAllAmounts(false, eLeptonDefinition.lepton_e1, dHadronDefinition.hadron_p3)) break;
                withThis.putUnify(dHadronDefinition.hadron_n1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(dHadronDefinition.hadron_p2);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "ECP+EC2P": {
                if (!withThis.removeAllAmounts(false, eLeptonDefinition.lepton_e2, dHadronDefinition.hadron_p5)) break;
                withThis.putUnify(dHadronDefinition.hadron_n1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve2);
                newStuff.putReplace(dHadronDefinition.hadron_p3);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "N": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n1)) break;
                newStuff.putReplace(dHadronDefinition.hadron_n1);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "2N": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n2)) break;
                newStuff.putReplace(dHadronDefinition.hadron_n2);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "P": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p1)) break;
                newStuff.putReplace(dHadronDefinition.hadron_p1);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "2P": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p2)) break;
                newStuff.putReplace(dHadronDefinition.hadron_p2);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "SF": {
                if (!this.Fission(decaysList, withThis, newStuff, decay.chance, false)) break;
                return true;
            }
            case "B-F": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_n1)) break;
                withThis.putUnify(dHadronDefinition.hadron_p1);
                newStuff.putReplace(eLeptonDefinition.lepton_e1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve_1);
                try {
                    if (this.Fission(decaysList, withThis, newStuff, decay.chance, false)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                }
                break;
            }
            case "ECF": 
            case "ECSF": 
            case "EC(+SF)": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p1, eLeptonDefinition.lepton_e1)) break;
                withThis.putUnify(dHadronDefinition.hadron_n1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve1);
                try {
                    if (this.Fission(decaysList, withThis, newStuff, decay.chance, false)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                }
                break;
            }
            case "SF(+EC+B+)": 
            case "SF+EC+B+": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p2, eLeptonDefinition.lepton_e1)) break;
                withThis.putUnify(dHadronDefinition.hadron_n2);
                newStuff.putReplace(eLeptonDefinition.lepton_e_1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve2);
                try {
                    if (this.Fission(decaysList, withThis, newStuff, decay.chance, false)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                }
                break;
            }
            case "SF+EC+B-": {
                if (!withThis.removeAllAmounts(false, eLeptonDefinition.lepton_e1)) break;
                newStuff.putReplace(eLeptonDefinition.lepton_e1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve_1);
                try {
                    if (this.Fission(decaysList, withThis, newStuff, decay.chance, false)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                }
                break;
            }
            case "IT": 
            case "IT?": 
            case "G": {
                if (energy > 0L) {
                    decaysList.add(new cElementalDecay(decay.chance, this, eBosonDefinition.boson_Y__));
                } else {
                    if (TecTechConfig.DEBUG_MODE) {
                        TecTech.LOGGER.info((Object)"Tried to emit Gamma from ground state");
                    }
                    decaysList.add(new cElementalDecay(decay.chance, this));
                }
                return true;
            }
            case "IT+EC+B+": {
                if (!withThis.removeAllAmounts(false, dHadronDefinition.hadron_p2, eLeptonDefinition.lepton_e1)) break;
                withThis.putUnify(dHadronDefinition.hadron_n2);
                newStuff.putReplace(eLeptonDefinition.lepton_e_1);
                newStuff.putReplace(eNeutrinoDefinition.lepton_Ve2);
                newStuff.putReplace(eBosonDefinition.boson_Y__1);
                try {
                    newStuff.putReplace(new dAtomDefinition(withThis.toImmutable_optimized_unsafeLeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new cElementalDecay(decay.chance, newStuff.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "DEAD_END": {
                decaysList.add(eBosonDefinition.deadEnd);
                return true;
            }
            default: {
                throw new Error("Unsupported decay mode: " + decay.decayName + ' ' + this.neutralCount + ' ' + this.element);
            }
        }
        if (TecTechConfig.DEBUG_MODE) {
            TecTech.LOGGER.info((Object)("Failed to decay " + this.element + ' ' + this.neutralCount + ' ' + decay.decayName));
        }
        return false;
    }

    private boolean Emmision(ArrayList<cElementalDecay> decaysList, cElementalDefinitionStack emit) {
        block3: {
            cElementalMutableDefinitionStackMap tree = this.elementalStacks.toMutable();
            if (tree.removeAmount(false, emit)) {
                try {
                    decaysList.add(new cElementalDecay(1.0, new cElementalDefinitionStack(new dAtomDefinition(tree.toImmutable_optimized_unsafeLeavesExposedElementalTree()), 1.0), emit));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean alphaDecay(ArrayList<cElementalDecay> decaysList) {
        block3: {
            cElementalMutableDefinitionStackMap tree = this.elementalStacks.toMutable();
            if (tree.removeAllAmounts(false, dAtomDefinition.alpha.definition.getSubParticles())) {
                try {
                    decaysList.add(new cElementalDecay(1.0, new cElementalDefinitionStack(new dAtomDefinition(tree.toImmutable_optimized_unsafeLeavesExposedElementalTree()), 1.0), alpha));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean MbetaDecay(ArrayList<cElementalDecay> decaysList) {
        block3: {
            cElementalMutableDefinitionStackMap tree = this.elementalStacks.toMutable();
            if (tree.removeAmount(false, dHadronDefinition.hadron_n1)) {
                try {
                    tree.putUnify(dHadronDefinition.hadron_p1);
                    decaysList.add(new cElementalDecay(1.0, new cElementalDefinitionStack(new dAtomDefinition(tree.toImmutable_optimized_unsafeLeavesExposedElementalTree()), 1.0), eLeptonDefinition.lepton_e1, eNeutrinoDefinition.lepton_Ve_1));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean PbetaDecay(ArrayList<cElementalDecay> decaysList) {
        block3: {
            cElementalMutableDefinitionStackMap tree = this.elementalStacks.toMutable();
            if (tree.removeAmount(false, dHadronDefinition.hadron_p1)) {
                try {
                    tree.putUnify(dHadronDefinition.hadron_n1);
                    decaysList.add(new cElementalDecay(1.0, new cElementalDefinitionStack(new dAtomDefinition(tree.toImmutable_optimized_unsafeLeavesExposedElementalTree()), 1.0), eLeptonDefinition.lepton_e_1, eNeutrinoDefinition.lepton_Ve1));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean ElectronCapture(ArrayList<cElementalDecay> decaysList) {
        block3: {
            cElementalMutableDefinitionStackMap tree = this.elementalStacks.toMutable();
            if (tree.removeAllAmounts(false, dHadronDefinition.hadron_p1, eLeptonDefinition.lepton_e1)) {
                try {
                    tree.putUnify(dHadronDefinition.hadron_n1);
                    decaysList.add(new cElementalDecay(1.0, new cElementalDefinitionStack(new dAtomDefinition(tree.toImmutable_optimized_unsafeLeavesExposedElementalTree()), 1.0), eNeutrinoDefinition.lepton_Ve1));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean Fission(ArrayList<cElementalDecay> decaysList, cElementalMutableDefinitionStackMap fissile, cElementalMutableDefinitionStackMap particles, double probability, boolean spontaneousCheck) {
        cElementalMutableDefinitionStackMap heavy = new cElementalMutableDefinitionStackMap();
        double[] liquidDrop = dAtomDefinition.liquidDropFunction(Math.abs(this.element) <= 97);
        for (cElementalDefinitionStack stack : fissile.values()) {
            if (spontaneousCheck && stack.definition instanceof dHadronDefinition && (stack.amount <= 80.0 || stack.amount < 90.0 && (double)XSTR.XSTR_INSTANCE.nextInt(10) < stack.amount - 80.0)) {
                return false;
            }
            if (stack.definition.getCharge() == 0) {
                int neutrals_cnt;
                double neutrals = stack.amount * liquidDrop[2];
                particles.putUnify(new cElementalDefinitionStack(stack.definition, neutrals_cnt += neutrals - (double)(neutrals_cnt = (int)Math.floor(neutrals)) > XSTR.XSTR_INSTANCE.nextDouble() ? 1 : 0));
                int heavy_cnt = (int)Math.ceil(stack.amount * liquidDrop[1]);
                while ((double)(heavy_cnt + neutrals_cnt) > stack.amount) {
                    --heavy_cnt;
                }
                fissile.removeAmount(false, new cElementalDefinitionStack(stack.definition, heavy_cnt + neutrals_cnt));
                heavy.putReplace(new cElementalDefinitionStack(stack.definition, heavy_cnt));
                continue;
            }
            int heavy_cnt = (int)Math.ceil(stack.amount * liquidDrop[0]);
            if (heavy_cnt % 2 == 1 && XSTR.XSTR_INSTANCE.nextDouble() > 0.05) {
                --heavy_cnt;
            }
            cElementalDefinitionStack new_stack = new cElementalDefinitionStack(stack.definition, heavy_cnt);
            fissile.removeAmount(false, new_stack);
            heavy.putReplace(new_stack);
        }
        try {
            particles.putReplace(new cElementalDefinitionStack(new dAtomDefinition(fissile.toImmutable_optimized_unsafeLeavesExposedElementalTree()), 1.0));
            particles.putReplace(new cElementalDefinitionStack(new dAtomDefinition(heavy.toImmutable_optimized_unsafeLeavesExposedElementalTree()), 1.0));
            decaysList.add(new cElementalDecay(probability, particles.toImmutable_optimized_unsafeLeavesExposedElementalTree()));
            return true;
        }
        catch (Exception e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private static double[] liquidDropFunction(boolean asymmetric) {
        double[] out = new double[3];
        out[0] = XSTR.XSTR_INSTANCE.nextGaussian();
        if (out[0] < 1.0 && out[0] >= -1.0 && XSTR.XSTR_INSTANCE.nextBoolean()) {
            out[0] = XSTR.XSTR_INSTANCE.nextDouble() * 2.0 - 1.0;
        }
        if (asymmetric && out[0] > XSTR.XSTR_INSTANCE.nextDouble() && XSTR.XSTR_INSTANCE.nextInt(4) == 0) {
            out[0] = -out[0];
        }
        out[0] = out[0] * 0.05 + 0.6;
        if (out[0] < 0.0 || out[0] > 1.0) {
            return dAtomDefinition.liquidDropFunction(asymmetric);
        }
        if (out[0] < 0.5) {
            out[0] = 1.0 - out[0];
        }
        out[2] = 0.012 + XSTR.XSTR_INSTANCE.nextDouble() * 0.01;
        out[1] = asymmetric ? out[0] : out[0] - out[2] * 0.5;
        return out;
    }

    @Override
    public cElementalDecay[] getEnergyInducedDecay(long energyLevel) {
        ArrayList<cElementalDecay> decays;
        if (this.iaeaDefinitionExistsAndHasEnergyLevels && this.iaeaDecay(decays = new ArrayList<cElementalDecay>(4), energyLevel)) {
            return decays.toArray(cElementalDecay.noProduct);
        }
        if (energyLevel < (long)(Math.abs(this.charge) / 3 + this.neutralCount)) {
            return new cElementalDecay[]{new cElementalDecay(1.0, this, eBosonDefinition.boson_Y__)};
        }
        return this.getNaturalDecayInstant();
    }

    @Override
    public double getEnergyDiffBetweenStates(long currentEnergyLevel, long newEnergyLevel) {
        if (this.iaeaDefinitionExistsAndHasEnergyLevels) {
            boolean backwards;
            double result = 0.0;
            boolean bl = backwards = newEnergyLevel < currentEnergyLevel;
            if (backwards) {
                long temp = currentEnergyLevel;
                currentEnergyLevel = newEnergyLevel;
                newEnergyLevel = temp;
            }
            if (currentEnergyLevel <= 0L) {
                if (newEnergyLevel <= 0L) {
                    return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
                }
                result += 25000.0 * (double)(-currentEnergyLevel);
            } else {
                result -= this.iaea.energeticStatesArray[(int)Math.min((long)((long)(this.iaea.energeticStatesArray.length - 1)), (long)currentEnergyLevel)].energy;
            }
            if (newEnergyLevel >= (long)this.iaea.energeticStatesArray.length) {
                if (currentEnergyLevel >= (long)this.iaea.energeticStatesArray.length) {
                    return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
                }
                result += 25000.0 * (double)(newEnergyLevel - (long)this.iaea.energeticStatesArray.length + 1L);
                result += this.iaea.energeticStatesArray[this.iaea.energeticStatesArray.length - 1].energy;
            } else {
                result += this.iaea.energeticStatesArray[(int)Math.max((long)0L, (long)newEnergyLevel)].energy;
            }
            return backwards ? -result : result;
        }
        return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
    }

    @Override
    public boolean usesSpecialEnergeticDecayHandling() {
        return this.iaeaDefinitionExistsAndHasEnergyLevels;
    }

    @Override
    public boolean usesMultipleDecayCalls(long energyLevel) {
        if (!this.iaeaDefinitionExistsAndHasEnergyLevels) {
            return false;
        }
        iaeaNuclide.energeticState state = energyLevel > (long)this.iaea.energeticStatesArray.length ? this.iaea.energeticStatesArray[this.iaea.energeticStatesArray.length - 1] : (energyLevel <= 0L ? this.iaea.energeticStatesArray[0] : this.iaea.energeticStatesArray[(int)energyLevel]);
        for (iaeaNuclide.iaeaDecay decay : state.decaymodes) {
            if (!decay.decayName.contains("F")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean decayMakesEnergy(long energyLevel) {
        return this.iaeaDefinitionExistsAndHasEnergyLevels;
    }

    @Override
    public boolean fusionMakesEnergy(long energyLevel) {
        return this.iaea != null || this.iaeaDefinitionExistsAndHasEnergyLevels;
    }

    @Override
    public cElementalDecay[] getNaturalDecayInstant() {
        ArrayList<cElementalDefinitionStack> decaysInto = new ArrayList<cElementalDefinitionStack>();
        for (cElementalDefinitionStack elementalStack : this.elementalStacks.values()) {
            if (elementalStack.definition.getType() == 1 || elementalStack.definition.getType() == -1) {
                decaysInto.add(elementalStack);
                continue;
            }
            decaysInto.add(new cElementalDefinitionStack(eBosonDefinition.boson_Y__, 2.0));
        }
        return new cElementalDecay[]{new cElementalDecay(0.75, decaysInto.toArray(new cElementalDefinitionStack[0])), eBosonDefinition.deadEnd};
    }

    @Override
    public dAtomDefinition getAnti() {
        cElementalMutableDefinitionStackMap anti = new cElementalMutableDefinitionStackMap();
        for (cElementalDefinitionStack stack : this.elementalStacks.values()) {
            anti.putReplace(new cElementalDefinitionStack(stack.definition.getAnti(), stack.amount));
        }
        try {
            return new dAtomDefinition(anti.toImmutable_optimized_unsafeLeavesExposedElementalTree());
        }
        catch (tElementalException e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public aFluidDequantizationInfo someAmountIntoFluidStack() {
        return dAtomDefinition.TRANSFORMATION_INFO.fluidDequantization.get(this);
    }

    @Override
    public aItemDequantizationInfo someAmountIntoItemsStack() {
        return dAtomDefinition.TRANSFORMATION_INFO.itemDequantization.get(this);
    }

    @Override
    public aOredictDequantizationInfo someAmountIntoOredictStack() {
        return dAtomDefinition.TRANSFORMATION_INFO.oredictDequantization.get(this);
    }

    @Override
    public NBTTagCompound toNBT() {
        return dComplexAspectDefinition.getNbtTagCompound((byte)97, this.elementalStacks);
    }

    public static dAtomDefinition fromNBT(NBTTagCompound nbt) {
        cElementalDefinitionStack[] stacks = new cElementalDefinitionStack[nbt.func_74762_e("i")];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = cElementalDefinitionStack.fromNBT(nbt.func_74775_l(Integer.toString(i)));
        }
        try {
            return new dAtomDefinition(stacks);
        }
        catch (tElementalException e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static void run() {
        block16: {
            block15: {
                double rawLifeTime;
                int izoDiffAbs;
                int izoDiff;
                int element;
                for (Runnable runnable : overrides) {
                    runnable.run();
                }
                for (Map.Entry entry : lifetimeOverrides.entrySet()) {
                    try {
                        lifetimeOverrides.put(new dAtomDefinition(((dAtomDefinition)entry.getKey()).elementalStacks), (Double)entry.getValue());
                    }
                    catch (tElementalException e) {
                        e.printStackTrace();
                    }
                }
                for (element = 1; element < 83; ++element) {
                    for (int i = 0; i < 130; ++i) {
                        xstr.setSeed((long)(element + 1) * (long)(i + 100));
                        int StableIsotope = dAtomDefinition.stableIzoCurve(element);
                        izoDiff = i - StableIsotope;
                        izoDiffAbs = Math.abs(izoDiff);
                        rawLifeTime = dAtomDefinition.calculateLifeTime(izoDiff, izoDiffAbs, element, i, false);
                        iaeaNuclide nuclide = iaeaNuclide.get(element, i);
                        if (!(rawLifeTime >= 1.5E36) && (nuclide == null || !(nuclide.halfTime >= 1.5E36))) continue;
                        TreeSet isotopes = stableIsotopes.computeIfAbsent(element, k -> new TreeSet());
                        isotopes.add(i);
                    }
                }
                for (element = 83; element < 150; ++element) {
                    for (int i = 100; i < 180; ++i) {
                        xstr.setSeed((long)(element + 1) * (long)(i + 100));
                        int Isotope = dAtomDefinition.stableIzoCurve(element);
                        izoDiff = i - Isotope;
                        izoDiffAbs = Math.abs(izoDiff);
                        rawLifeTime = dAtomDefinition.calculateLifeTime(izoDiff, izoDiffAbs, element, i, false);
                        TreeMap isotopes = mostStableUnstableIsotopes.computeIfAbsent(element, k -> new TreeMap());
                        isotopes.put(rawLifeTime, i);
                    }
                }
                try {
                    for (Map.Entry<Integer, TreeSet<Integer>> entry : stableIsotopes.entrySet()) {
                        stableAtoms.put(entry.getKey(), new dAtomDefinition(new cElementalDefinitionStack(dHadronDefinition.hadron_p, entry.getKey().intValue()), new cElementalDefinitionStack(dHadronDefinition.hadron_n, entry.getValue().first().intValue()), new cElementalDefinitionStack(eLeptonDefinition.lepton_e, entry.getKey().intValue())));
                        if (!TecTechConfig.DEBUG_MODE) continue;
                        TecTech.LOGGER.info((Object)("Added Stable Atom:" + entry.getKey() + ' ' + entry.getValue().first() + ' ' + stableAtoms.get(entry.getKey()).getMass()));
                    }
                    for (Map.Entry<Integer, Cloneable> entry : mostStableUnstableIsotopes.entrySet()) {
                        unstableAtoms.put(entry.getKey(), new dAtomDefinition(new cElementalDefinitionStack(dHadronDefinition.hadron_p, entry.getKey().intValue()), new cElementalDefinitionStack(dHadronDefinition.hadron_n, ((Integer)((TreeMap)entry.getValue()).lastEntry().getValue()).intValue()), new cElementalDefinitionStack(eLeptonDefinition.lepton_e, entry.getKey().intValue())));
                        if (!TecTechConfig.DEBUG_MODE) continue;
                        TecTech.LOGGER.info((Object)("Added Unstable Atom:" + entry.getKey() + ' ' + ((TreeMap)entry.getValue()).lastEntry().getValue() + ' ' + unstableAtoms.get(entry.getKey()).getMass()));
                    }
                    deuterium = new dAtomDefinition(dHadronDefinition.hadron_p1, dHadronDefinition.hadron_n1, eLeptonDefinition.lepton_e1).getStackForm(1.0);
                    tritium = new dAtomDefinition(dHadronDefinition.hadron_p1, dHadronDefinition.hadron_n2, eLeptonDefinition.lepton_e1).getStackForm(1.0);
                    helium_3 = new dAtomDefinition(dHadronDefinition.hadron_p2, dHadronDefinition.hadron_n1, eLeptonDefinition.lepton_e2).getStackForm(1.0);
                    alpha = new dAtomDefinition(dHadronDefinition.hadron_p2, dHadronDefinition.hadron_n2).getStackForm(1.0);
                    beryllium_8 = new dAtomDefinition(new cElementalDefinitionStack(dHadronDefinition.hadron_p, 4.0), new cElementalDefinitionStack(dHadronDefinition.hadron_n, 4.0), new cElementalDefinitionStack(eLeptonDefinition.lepton_e, 4.0)).getStackForm(1.0);
                    carbon_14 = new dAtomDefinition(new cElementalDefinitionStack(dHadronDefinition.hadron_p, 6.0), new cElementalDefinitionStack(dHadronDefinition.hadron_n, 8.0), new cElementalDefinitionStack(eLeptonDefinition.lepton_e, 6.0)).getStackForm(1.0);
                    neon_24 = new dAtomDefinition(new cElementalDefinitionStack(dHadronDefinition.hadron_p, 10.0), new cElementalDefinitionStack(dHadronDefinition.hadron_n, 14.0), new cElementalDefinitionStack(eLeptonDefinition.lepton_e, 10.0)).getStackForm(1.0);
                    silicon_34 = new dAtomDefinition(new cElementalDefinitionStack(dHadronDefinition.hadron_p, 14.0), new cElementalDefinitionStack(dHadronDefinition.hadron_n, 20.0), new cElementalDefinitionStack(eLeptonDefinition.lepton_e, 14.0)).getStackForm(1.0);
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block15;
                    e.printStackTrace();
                }
            }
            try {
                cElementalDefinition.addCreatorFromNBT((byte)97, dAtomDefinition.class.getMethod("fromNBT", NBTTagCompound.class), (byte)64);
            }
            catch (Exception e) {
                if (!TecTechConfig.DEBUG_MODE) break block16;
                e.printStackTrace();
            }
        }
        if (TecTechConfig.DEBUG_MODE) {
            TecTech.LOGGER.info((Object)"Registered Elemental Matter Class: Atom 97 64");
        }
    }

    public static void setTransformation() {
        block3: {
            refMass = dAtomDefinition.getFirstStableIsotope(1).getMass() * 8.6718826944E25;
            TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(1), 8.6718826944E25), Materials.Hydrogen.mGas, 144);
            TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(2), 8.6718826944E25), Materials.Helium.mGas, 144);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(3), 8.6718826944E25), OrePrefixes.dust, Materials.Lithium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(4), 8.6718826944E25), OrePrefixes.dust, Materials.Beryllium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(5), 8.6718826944E25), OrePrefixes.dust, Materials.Boron, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(6), 8.6718826944E25), OrePrefixes.dust, Materials.Carbon, 1);
            TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(7), 8.6718826944E25), Materials.Nitrogen.mGas, 144);
            TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(8), 8.6718826944E25), Materials.Oxygen.mGas, 144);
            TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(9), 8.6718826944E25), Materials.Fluorine.mGas, 144);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(11), 8.6718826944E25), OrePrefixes.dust, Materials.Sodium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(12), 8.6718826944E25), OrePrefixes.dust, Materials.Magnesium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(13), 8.6718826944E25), OrePrefixes.dust, Materials.Aluminium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(14), 8.6718826944E25), OrePrefixes.dust, Materials.Silicon, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(15), 8.6718826944E25), OrePrefixes.dust, Materials.Phosphorus, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(16), 8.6718826944E25), OrePrefixes.dust, Materials.Sulfur, 1);
            TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(17), 8.6718826944E25), Materials.Argon.mGas, 144);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(19), 8.6718826944E25), OrePrefixes.dust, Materials.Potassium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(20), 8.6718826944E25), OrePrefixes.dust, Materials.Calcium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(21), 8.6718826944E25), OrePrefixes.dust, Materials.Scandium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(22), 8.6718826944E25), OrePrefixes.dust, Materials.Titanium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(23), 8.6718826944E25), OrePrefixes.dust, Materials.Vanadium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(24), 8.6718826944E25), OrePrefixes.dust, Materials.Chrome, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(25), 8.6718826944E25), OrePrefixes.dust, Materials.Manganese, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(26), 8.6718826944E25), OrePrefixes.dust, Materials.Iron, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(27), 8.6718826944E25), OrePrefixes.dust, Materials.Cobalt, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(28), 8.6718826944E25), OrePrefixes.dust, Materials.Nickel, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(29), 8.6718826944E25), OrePrefixes.dust, Materials.Copper, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(30), 8.6718826944E25), OrePrefixes.dust, Materials.Zinc, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(31), 8.6718826944E25), OrePrefixes.dust, Materials.Gallium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(33), 8.6718826944E25), OrePrefixes.dust, Materials.Arsenic, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(37), 8.6718826944E25), OrePrefixes.dust, Materials.Rubidium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(38), 8.6718826944E25), OrePrefixes.dust, Materials.Strontium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(39), 8.6718826944E25), OrePrefixes.dust, Materials.Yttrium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(41), 8.6718826944E25), OrePrefixes.dust, Materials.Niobium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(42), 8.6718826944E25), OrePrefixes.dust, Materials.Molybdenum, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(46), 8.6718826944E25), OrePrefixes.dust, Materials.Palladium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(47), 8.6718826944E25), OrePrefixes.dust, Materials.Silver, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(48), 8.6718826944E25), OrePrefixes.dust, Materials.Cadmium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(49), 8.6718826944E25), OrePrefixes.dust, Materials.Indium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(50), 8.6718826944E25), OrePrefixes.dust, Materials.Tin, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(51), 8.6718826944E25), OrePrefixes.dust, Materials.Antimony, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(52), 8.6718826944E25), OrePrefixes.dust, Materials.Tellurium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(55), 8.6718826944E25), OrePrefixes.dust, Materials.Caesium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(56), 8.6718826944E25), OrePrefixes.dust, Materials.Barium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(57), 8.6718826944E25), OrePrefixes.dust, Materials.Lanthanum, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(58), 8.6718826944E25), OrePrefixes.dust, Materials.Cerium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(59), 8.6718826944E25), OrePrefixes.dust, Materials.Praseodymium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(60), 8.6718826944E25), OrePrefixes.dust, Materials.Neodymium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(61), 8.6718826944E25), OrePrefixes.dust, Materials.Promethium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(62), 8.6718826944E25), OrePrefixes.dust, Materials.Samarium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(63), 8.6718826944E25), OrePrefixes.dust, Materials.Europium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(64), 8.6718826944E25), OrePrefixes.dust, Materials.Gadolinium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(65), 8.6718826944E25), OrePrefixes.dust, Materials.Terbium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(66), 8.6718826944E25), OrePrefixes.dust, Materials.Dysprosium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(67), 8.6718826944E25), OrePrefixes.dust, Materials.Holmium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(68), 8.6718826944E25), OrePrefixes.dust, Materials.Erbium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(69), 8.6718826944E25), OrePrefixes.dust, Materials.Thulium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(70), 8.6718826944E25), OrePrefixes.dust, Materials.Ytterbium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(71), 8.6718826944E25), OrePrefixes.dust, Materials.Lutetium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(73), 8.6718826944E25), OrePrefixes.dust, Materials.Tantalum, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(74), 8.6718826944E25), OrePrefixes.dust, Materials.Tungsten, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(76), 8.6718826944E25), OrePrefixes.dust, Materials.Osmium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(77), 8.6718826944E25), OrePrefixes.dust, Materials.Iridium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(78), 8.6718826944E25), OrePrefixes.dust, Materials.Platinum, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(79), 8.6718826944E25), OrePrefixes.dust, Materials.Gold, 1);
            TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(80), 8.6718826944E25), Materials.Mercury.mFluid, 144);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getFirstStableIsotope(82), 8.6718826944E25), OrePrefixes.dust, Materials.Lead, 1);
            refUnstableMass = dAtomDefinition.getFirstStableIsotope(82).getMass() * 8.6718826944E25;
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getBestUnstableIsotope(83), 8.6718826944E25), OrePrefixes.dust, Materials.Bismuth, 1);
            TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.getBestUnstableIsotope(86), 8.6718826944E25), Materials.Radon.mGas, 144);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getBestUnstableIsotope(90), 8.6718826944E25), OrePrefixes.dust, Materials.Thorium, 1);
            TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(dAtomDefinition.getBestUnstableIsotope(95), 8.6718826944E25), OrePrefixes.dust, Materials.Americium, 1);
            try {
                TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.deuterium.definition, 8.6718826944E25), Materials.Deuterium.mGas, 144);
                TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.tritium.definition, 8.6718826944E25), Materials.Tritium.mGas, 144);
                TRANSFORMATION_INFO.addFluid(new cElementalDefinitionStack(dAtomDefinition.helium_3.definition, 8.6718826944E25), Materials.Helium_3.mGas, 144);
                dAtomDefinition temp = new dAtomDefinition(new cElementalDefinitionStack(eLeptonDefinition.lepton_e, 92.0), new cElementalDefinitionStack(dHadronDefinition.hadron_p, 92.0), new cElementalDefinitionStack(dHadronDefinition.hadron_n, 146.0));
                TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(temp, 8.6718826944E25), OrePrefixes.dust, Materials.Uranium, 1);
                double tempMass = temp.getMass();
                temp = new dAtomDefinition(new cElementalDefinitionStack(eLeptonDefinition.lepton_e, 92.0), new cElementalDefinitionStack(dHadronDefinition.hadron_p, 92.0), new cElementalDefinitionStack(dHadronDefinition.hadron_n, 143.0));
                TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(temp, 8.6718826944E25), OrePrefixes.dust, Materials.Uranium235, 1);
                TecTech.LOGGER.info((Object)("Diff Mass U : " + (tempMass - temp.getMass())));
                temp = new dAtomDefinition(new cElementalDefinitionStack(eLeptonDefinition.lepton_e, 94.0), new cElementalDefinitionStack(dHadronDefinition.hadron_p, 94.0), new cElementalDefinitionStack(dHadronDefinition.hadron_n, 145.0));
                TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(temp, 8.6718826944E25), OrePrefixes.dust, Materials.Plutonium, 1);
                somethingHeavy = new dAtomDefinition(new cElementalDefinitionStack(eLeptonDefinition.lepton_e, 94.0), new cElementalDefinitionStack(dHadronDefinition.hadron_p, 94.0), new cElementalDefinitionStack(dHadronDefinition.hadron_n, 147.0));
                TRANSFORMATION_INFO.addOredict((iHasElementalDefinition)new cElementalDefinitionStack(somethingHeavy, 8.6718826944E25), OrePrefixes.dust, Materials.Plutonium241, 1);
                TecTech.LOGGER.info((Object)("Diff Mass Pu: " + (somethingHeavy.getMass() - temp.getMass())));
                TecTech.LOGGER.info((Object)("Neutron Mass: " + dHadronDefinition.hadron_n.getMass()));
            }
            catch (tElementalException e) {
                if (!TecTechConfig.DEBUG_MODE) break block3;
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"miscutils")) {
            new GtppAtomLoader().run();
        }
    }

    public static dAtomDefinition getFirstStableIsotope(int element) {
        return stableAtoms.get(element);
    }

    public static dAtomDefinition getBestUnstableIsotope(int element) {
        return unstableAtoms.get(element);
    }

    @Override
    public byte getClassType() {
        return 64;
    }

    public static byte getClassTypeStatic() {
        return 64;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public void addScanShortSymbols(ArrayList<String> lines, int capabilities, long energyLevel) {
        if (Util.areBitsSet(89, capabilities)) {
            lines.add(this.getShortSymbol());
        }
    }

    @Override
    public void addScanResults(ArrayList<String> lines, int capabilities, long energyLevel) {
        if (Util.areBitsSet(2048, capabilities)) {
            lines.add("CLASS = 97 " + this.getClassType());
        }
        if (Util.areBitsSet(89, capabilities)) {
            lines.add("NAME = " + this.getName());
            lines.add("SYMBOL = " + this.getSymbol());
        }
        if (Util.areBitsSet(8, capabilities)) {
            lines.add("CHARGE = " + (double)this.getCharge() / 3.0 + " e");
        }
        if (Util.areBitsSet(256, capabilities)) {
            lines.add(this.getColor() < 0 ? "COLORLESS" : "CARRIES COLOR");
        }
        if (Util.areBitsSet(16, capabilities)) {
            lines.add("MASS = " + this.getMass() + " eV/c\u00b2");
        }
        if (this.iaeaDefinitionExistsAndHasEnergyLevels && Util.areBitsSet(128, capabilities)) {
            for (int i = 1; i < this.iaea.energeticStatesArray.length; ++i) {
                lines.add("E LEVEL " + i + " = " + this.iaea.energeticStatesArray[i].energy + " eV");
            }
        }
        if (Util.areBitsSet(64, capabilities)) {
            lines.add("HALF LIFE = " + this.getRawTimeSpan(energyLevel) + " s");
            lines.add("    At current energy level");
        }
    }

    static {
        xstr = new XSTR();
        stableIsotopes = new HashMap<Integer, TreeSet<Integer>>();
        stableAtoms = new HashMap<Integer, dAtomDefinition>();
        mostStableUnstableIsotopes = new HashMap<Integer, TreeMap<Double, Integer>>();
        unstableAtoms = new HashMap<Integer, dAtomDefinition>();
        lifetimeOverrides = new HashMap();
        overrides = new ArrayList();
    }

    private static final class Nomenclature {
        private static final String[] SYMBOL = new String[]{"Nt", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", "Nh", "Fl", "Mc", "Lv", "Ts", "Og"};
        private static final String[] NAME = new String[]{"Neutronium", "Hydrogen", "Helium", "Lithium", "Beryllium", "Boron", "Carbon", "Nitrogen", "Oxygen", "Fluorine", "Neon", "Sodium", "Magnesium", "Aluminium", "Silicon", "Phosphorus", "Sulfur", "Chlorine", "Argon", "Potassium", "Calcium", "Scandium", "Titanium", "Vanadium", "Chromium", "Manganese", "Iron", "Cobalt", "Nickel", "Copper", "Zinc", "Gallium", "Germanium", "Arsenic", "Selenium", "Bromine", "Krypton", "Rubidium", "Strontium", "Yttrium", "Zirconium", "Niobium", "Molybdenum", "Technetium", "Ruthenium", "Rhodium", "Palladium", "Silver", "Cadmium", "Indium", "Tin", "Antimony", "Tellurium", "Iodine", "Xenon", "Caesium", "Barium", "Lanthanum", "Cerium", "Praseodymium", "Neodymium", "Promethium", "Samarium", "Europium", "Gadolinium", "Terbium", "Dysprosium", "Holmium", "Erbium", "Thulium", "Ytterbium", "Lutetium", "Hafnium", "Tantalum", "Tungsten", "Rhenium", "Osmium", "Iridium", "Platinum", "Gold", "Mercury", "Thallium", "Lead", "Bismuth", "Polonium", "Astatine", "Radon", "Francium", "Radium", "Actinium", "Thorium", "Protactinium", "Uranium", "Neptunium", "Plutonium", "Americium", "Curium", "Berkelium", "Californium", "Einsteinium", "Fermium", "Mendelevium", "Nobelium", "Lawrencium", "Rutherfordium", "Dubnium", "Seaborgium", "Bohrium", "Hassium", "Meitnerium", "Darmstadtium", "Roentgenium", "Copernicium", "Nihonium", "Flerovium", "Moscovium", "Livermorium", "Tennessine", "Oganesson"};
        private static final String[] SYMBOL_IUPAC = new String[]{"n", "u", "b", "t", "q", "p", "h", "s", "o", "e", "N", "U", "B", "T", "Q", "P", "H", "S", "O", "E"};

        private Nomenclature() {
        }
    }
}

