/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.templates;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.tElementalException;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.cElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aFluidDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aItemDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aOredictDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.cPrimitiveDefinition;
import com.github.technus.tectech.thing.item.DebugElementalInstanceContainer_EM;
import com.github.technus.tectech.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.NBTTagCompound;

public abstract class cElementalPrimitive
extends cElementalDefinition {
    public static final byte nbtType = 112;
    private static final Map<Integer, cElementalPrimitive> bindsBO = new HashMap<Integer, cElementalPrimitive>();
    public final String name;
    public final String symbol;
    public final double mass;
    public final byte charge;
    public final byte color;
    public final byte type;
    private cElementalPrimitive anti;
    private cElementalDecay[] elementalDecays;
    private byte naturalDecayInstant;
    private byte energeticDecayInstant;
    private double rawLifeTime;
    public final int ID;

    public static Map<Integer, cElementalPrimitive> getBindsPrimitive() {
        return bindsBO;
    }

    protected cElementalPrimitive(String name, String symbol, int type, double mass, int charge, int color, int ID) {
        this.name = name;
        this.symbol = symbol;
        this.type = (byte)type;
        this.mass = mass;
        this.charge = (byte)charge;
        this.color = (byte)color;
        this.ID = ID;
        if (bindsBO.put(ID, this) != null) {
            Minecraft.func_71410_x().func_71404_a(new CrashReport("Primitive definition", (Throwable)new tElementalException("Duplicate ID")));
        }
        DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(this);
    }

    protected void init(cElementalPrimitive antiParticle, double rawLifeTime, int naturalInstant, int energeticInstant, cElementalDecay ... elementalDecaysArray) {
        this.anti = antiParticle;
        this.rawLifeTime = rawLifeTime;
        this.naturalDecayInstant = (byte)naturalInstant;
        this.energeticDecayInstant = (byte)energeticInstant;
        this.elementalDecays = elementalDecaysArray;
    }

    @Override
    public String getName() {
        return "Undefined: " + this.name;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public String getShortSymbol() {
        return this.symbol;
    }

    @Override
    public iElementalDefinition getAnti() {
        return this.anti;
    }

    @Override
    public int getCharge() {
        return this.charge;
    }

    @Override
    public byte getColor() {
        return this.color;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public cElementalDecay[] getNaturalDecayInstant() {
        if (this.naturalDecayInstant < 0) {
            return this.elementalDecays;
        }
        if (this.naturalDecayInstant >= this.elementalDecays.length) {
            return cElementalDecay.noProduct;
        }
        return new cElementalDecay[]{this.elementalDecays[this.naturalDecayInstant]};
    }

    @Override
    public cElementalDecay[] getEnergyInducedDecay(long energyLevel) {
        if (this.energeticDecayInstant < 0) {
            return this.elementalDecays;
        }
        if (this.energeticDecayInstant >= this.elementalDecays.length) {
            return cElementalDecay.noProduct;
        }
        return new cElementalDecay[]{this.elementalDecays[this.energeticDecayInstant]};
    }

    @Override
    public double getEnergyDiffBetweenStates(long currentEnergyLevel, long newEnergyLevel) {
        return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
    }

    @Override
    public boolean usesSpecialEnergeticDecayHandling() {
        return false;
    }

    @Override
    public boolean usesMultipleDecayCalls(long energyLevel) {
        return false;
    }

    @Override
    public boolean decayMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public boolean fusionMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public cElementalDecay[] getDecayArray() {
        return this.elementalDecays;
    }

    @Override
    public double getRawTimeSpan(long currentEnergy) {
        return this.rawLifeTime;
    }

    @Override
    public final cElementalDefinitionStackMap getSubParticles() {
        return null;
    }

    @Override
    public aFluidDequantizationInfo someAmountIntoFluidStack() {
        return null;
    }

    @Override
    public aItemDequantizationInfo someAmountIntoItemsStack() {
        return null;
    }

    @Override
    public aOredictDequantizationInfo someAmountIntoOredictStack() {
        return null;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public final NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("t", (byte)112);
        nbt.func_74768_a("c", this.ID);
        return nbt;
    }

    public static cElementalPrimitive fromNBT(NBTTagCompound content) {
        cElementalPrimitive primitive = bindsBO.get(content.func_74762_e("c"));
        return primitive == null ? cPrimitiveDefinition.null__ : primitive;
    }

    @Override
    public final byte getClassType() {
        return -128;
    }

    public static byte getClassTypeStatic() {
        return -128;
    }

    @Override
    public void addScanShortSymbols(ArrayList<String> lines, int capabilities, long energyLevel) {
        if (Util.areBitsSet(89, capabilities)) {
            lines.add(this.getShortSymbol());
        }
    }

    @Override
    public void addScanResults(ArrayList<String> lines, int capabilities, long energyLevel) {
        if (Util.areBitsSet(2048, capabilities)) {
            lines.add("CLASS = 112 " + this.getClassType());
        }
        if (Util.areBitsSet(89, capabilities)) {
            lines.add("NAME = " + this.getName());
            lines.add("SYMBOL = " + this.getSymbol());
        }
        if (Util.areBitsSet(8, capabilities)) {
            lines.add("CHARGE = " + (double)this.getCharge() / 3.0 + " e");
        }
        if (Util.areBitsSet(256, capabilities)) {
            lines.add(this.getColor() < 0 ? "COLORLESS" : "CARRIES COLOR");
        }
        if (Util.areBitsSet(16, capabilities)) {
            lines.add("MASS = " + this.getMass() + " eV/c\u00b2");
        }
        if (Util.areBitsSet(64, capabilities)) {
            lines.add((this.isTimeSpanHalfLife() ? "HALF LIFE = " : "LIFE TIME = ") + this.getRawTimeSpan(energyLevel) + " s");
            lines.add("    At current energy level");
        }
    }

    public static void run() {
        block3: {
            try {
                cElementalDefinition.addCreatorFromNBT((byte)112, cElementalPrimitive.class.getMethod("fromNBT", NBTTagCompound.class), (byte)-128);
            }
            catch (Exception e) {
                if (!TecTechConfig.DEBUG_MODE) break block3;
                e.printStackTrace();
            }
        }
        if (TecTechConfig.DEBUG_MODE) {
            TecTech.LOGGER.info((Object)"Registered Elemental Matter Class: Primitive 112 -128");
        }
    }

    @Override
    public final int compareTo(iElementalDefinition o) {
        if (this.getClassType() == o.getClassType()) {
            int oID = ((cElementalPrimitive)o).ID;
            return Integer.compare(this.ID, oID);
        }
        return this.compareClassID(o);
    }

    @Override
    public final int hashCode() {
        return this.ID;
    }
}

