/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.stacks;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDecayResult;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.cElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.cPrimitiveDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eBosonDefinition;
import com.github.technus.tectech.util.DoubleCount;
import com.github.technus.tectech.util.Util;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class cElementalInstanceStack
implements iHasElementalDefinition {
    public static int MIN_MULTIPLE_DECAY_CALLS = 4;
    public static int MAX_MULTIPLE_DECAY_CALLS = 16;
    public static double DECAY_CALL_PER = 6.02214076E23;
    public final iElementalDefinition definition;
    private long energy;
    private byte color;
    public double age;
    public double amount;
    private double lifeTime;
    private double lifeTimeMult;

    public cElementalInstanceStack(cElementalDefinitionStack stackSafe) {
        this(stackSafe.definition, stackSafe.amount, 1.0, 0.0, 0L);
    }

    public cElementalInstanceStack(cElementalDefinitionStack stackSafe, double lifeTimeMult, double age, long energy) {
        this(stackSafe.definition, stackSafe.amount, lifeTimeMult, age, energy);
    }

    public cElementalInstanceStack(iElementalDefinition defSafe, double amount) {
        this(defSafe, amount, 1.0, 0.0, 0L);
    }

    public cElementalInstanceStack(iElementalDefinition defSafe, double amount, double lifeTimeMult, double age, long energy) {
        this.definition = defSafe == null ? cPrimitiveDefinition.null__ : defSafe;
        byte bColor = this.definition.getColor();
        this.color = bColor < 0 || bColor > 2 ? bColor : (byte)TecTech.RANDOM.nextInt(3);
        this.lifeTimeMult = lifeTimeMult;
        this.lifeTime = this.definition.getRawTimeSpan(energy) * this.lifeTimeMult;
        this.setEnergy(energy);
        this.age = age;
        this.amount = amount;
    }

    private cElementalInstanceStack(cElementalInstanceStack stack) {
        this.definition = stack.definition;
        this.color = stack.color;
        this.age = stack.age;
        this.amount = stack.amount;
        this.lifeTime = stack.lifeTime;
        this.lifeTimeMult = stack.lifeTimeMult;
        this.energy = stack.energy;
    }

    @Override
    public cElementalInstanceStack clone() {
        return new cElementalInstanceStack(this);
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    public double getCharge() {
        return (double)this.definition.getCharge() * this.amount;
    }

    @Override
    public double getMass() {
        return this.definition.getMass() * this.amount;
    }

    public long getEnergy() {
        return this.energy;
    }

    public void setEnergy(long newEnergyLevel) {
        this.energy = newEnergyLevel;
        this.setLifeTimeMultiplier(this.getLifeTimeMultiplier());
    }

    public double getEnergySettingCost(long currentEnergyLevel, long newEnergyLevel) {
        return this.definition.getEnergyDiffBetweenStates(currentEnergyLevel, newEnergyLevel) * this.amount;
    }

    public double getEnergySettingCost(long newEnergyLevel) {
        return this.definition.getEnergyDiffBetweenStates(this.energy, newEnergyLevel) * this.amount;
    }

    public cElementalDefinitionStack getDefinitionStack() {
        return new cElementalDefinitionStack(this.definition, this.amount);
    }

    @Override
    public iElementalDefinition getDefinition() {
        return this.definition;
    }

    public byte getColor() {
        return this.color;
    }

    public byte setColor(byte color) {
        if (this.color < 0 || this.color > 2 || color < 0 || color >= 3) {
            return this.color;
        }
        this.color = color;
        return this.color;
    }

    public byte nextColor() {
        if (this.color < 0 || this.color > 2) {
            return this.color;
        }
        this.color = (byte)TecTech.RANDOM.nextInt(3);
        return this.color;
    }

    public double getLifeTime() {
        return this.lifeTime;
    }

    public double setLifeTimeMultiplier(double mult) {
        if (mult <= 0.0) {
            throw new IllegalArgumentException("multiplier must be >0");
        }
        this.lifeTimeMult = mult;
        if (this.definition.getRawTimeSpan(this.energy) <= 0.0) {
            return this.lifeTime;
        }
        this.lifeTime = this.definition.getRawTimeSpan(this.energy) * this.lifeTimeMult;
        return this.lifeTime;
    }

    public double getLifeTimeMultiplier() {
        return this.lifeTimeMult;
    }

    public cElementalDecayResult tickStackByOneSecond(double lifeTimeMult, int postEnergize) {
        return this.tickStack(lifeTimeMult, postEnergize, 1.0);
    }

    public cElementalDecayResult tickStack(double lifeTimeMult, int postEnergize, double seconds) {
        cElementalDecayResult newInstances = this.decay(lifeTimeMult, this.age += seconds, postEnergize);
        if (newInstances == null) {
            this.nextColor();
        } else {
            for (cElementalInstanceStack newInstance : newInstances.getOutput().values()) {
                newInstance.nextColor();
            }
        }
        return newInstances;
    }

    public cElementalDecayResult decay() {
        return this.decay(1.0, this.age, 0L);
    }

    public cElementalDecayResult decay(double apparentAge, long postEnergize) {
        return this.decay(1.0, apparentAge, postEnergize);
    }

    public cElementalDecayResult decay(double lifeTimeMult, double apparentAge, long postEnergize) {
        cElementalDecayResult output;
        long newEnergyLevel = postEnergize + this.energy;
        if (newEnergyLevel > 0L) {
            --newEnergyLevel;
        } else if (newEnergyLevel < 0L) {
            ++newEnergyLevel;
        }
        if (this.definition.usesMultipleDecayCalls(this.energy)) {
            double amountTemp = this.amount;
            int decayCnt = (int)Math.min((double)MAX_MULTIPLE_DECAY_CALLS, Math.max(this.amount / DECAY_CALL_PER, (double)MIN_MULTIPLE_DECAY_CALLS));
            this.amount = DoubleCount.div(this.amount, decayCnt);
            --decayCnt;
            output = this.decayMechanics(lifeTimeMult, apparentAge, newEnergyLevel);
            if (output == null) {
                this.amount = amountTemp;
                return null;
            }
            for (int i = 0; i < decayCnt; ++i) {
                cElementalDecayResult map = this.decayMechanics(lifeTimeMult, apparentAge, newEnergyLevel);
                if (map == null) continue;
                output.getOutput().putUnifyAll(map.getOutput());
                output.setMassDiff(DoubleCount.add(output.getMassDiff(), map.getMassDiff()));
                output.setMassAffected(output.getMassDiff() + map.getMassDiff());
            }
            this.amount = amountTemp;
        } else {
            output = this.decayMechanics(lifeTimeMult, apparentAge, newEnergyLevel);
        }
        if (output != null) {
            output.getOutput().cleanUp();
        }
        return output;
    }

    private cElementalDecayResult decayMechanics(double lifeTimeMult, double apparentAge, long newEnergyLevel) {
        if (this.energy > 0L && !this.definition.usesSpecialEnergeticDecayHandling()) {
            this.setLifeTimeMultiplier(this.getLifeTimeMultiplier());
            return this.decayCompute(this.definition.getEnergyInducedDecay(this.energy), lifeTimeMult, -1.0, newEnergyLevel);
        }
        if (this.definition.getRawTimeSpan(this.energy) < 0.0) {
            return null;
        }
        if (this.definition.isTimeSpanHalfLife()) {
            return this.exponentialDecayCompute(this.energy > 0L ? this.definition.getEnergyInducedDecay(this.energy) : this.definition.getDecayArray(), lifeTimeMult, -1.0, newEnergyLevel);
        }
        if (1.0 > this.lifeTime) {
            return this.decayCompute(this.energy > 0L ? this.definition.getEnergyInducedDecay(this.energy) : this.definition.getNaturalDecayInstant(), lifeTimeMult, 0.0, newEnergyLevel);
        }
        if (apparentAge > this.lifeTime) {
            return this.decayCompute(this.energy > 0L ? this.definition.getEnergyInducedDecay(this.energy) : this.definition.getDecayArray(), lifeTimeMult, 0.0, newEnergyLevel);
        }
        return null;
    }

    private cElementalDecayResult exponentialDecayCompute(cElementalDecay[] decays, double lifeTimeMult, double newProductsAge, long newEnergyLevel) {
        double newAmount = DoubleCount.div(this.amount, Math.pow(2.0, 1.0 / this.lifeTime));
        if (newAmount == this.amount) {
            newAmount -= Math.ulp(newAmount);
        } else if (newAmount < 1.0) {
            return this.decayCompute(decays, lifeTimeMult, newProductsAge, newEnergyLevel);
        }
        double amount = this.amount;
        this.amount -= newAmount;
        cElementalDecayResult products = this.decayCompute(decays, lifeTimeMult, newProductsAge, newEnergyLevel);
        this.amount = newAmount;
        if (products != null) {
            products.getOutput().putUnify(this.clone());
        }
        this.amount = amount;
        return products;
    }

    private cElementalDecayResult decayCompute(cElementalDecay[] decays, double lifeTimeMult, double newProductsAge, long newEnergyLevel) {
        cElementalInstanceStackMap results;
        int i;
        double[] qttyOfDecay;
        if (decays == null) {
            return null;
        }
        boolean makesEnergy = this.definition.decayMakesEnergy(this.energy);
        double mass = this.getMass();
        if (decays.length == 0) {
            return makesEnergy ? null : new cElementalDecayResult(new cElementalInstanceStackMap(), mass, 0.0);
        }
        if (decays.length == 1) {
            if (decays[0] == eBosonDefinition.deadEnd) {
                return makesEnergy ? null : new cElementalDecayResult(decays[0].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, this.amount), mass, 0.0);
            }
            cElementalInstanceStackMap output = decays[0].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, this.amount);
            if (newProductsAge < 0.0) {
                if (output.size() == 1) {
                    if (output.size() == 1 && output.get((int)0).definition.equals(this.definition)) {
                        output.get(0).setEnergy(this.energy);
                        output.get((int)0).age = this.age;
                    }
                } else {
                    for (cElementalInstanceStack stack : output.values()) {
                        if (!stack.definition.equals(this.definition)) continue;
                        stack.age = this.age;
                    }
                }
            } else if (output.size() == 1 && output.get((int)0).definition.equals(this.definition)) {
                output.get(0).setEnergy(this.energy);
            }
            if (this.energy <= 0L && output.getMass() > mass) {
                return null;
            }
            return new cElementalDecayResult(new cElementalInstanceStackMap(), mass, makesEnergy ? output.getMass() - mass : 0.0);
        }
        cElementalDecayResult totalOutput = new cElementalDecayResult(new cElementalInstanceStackMap(), this.getMass(), 0.0);
        cElementalInstanceStackMap output = totalOutput.getOutput();
        int differentDecays = decays.length;
        double[] probabilities = new double[differentDecays];
        for (int i2 = 0; i2 < probabilities.length; ++i2) {
            probabilities[i2] = decays[i2].probability;
        }
        try {
            qttyOfDecay = DoubleCount.distribute(this.amount, probabilities);
        }
        catch (ArithmeticException e) {
            Minecraft.func_71410_x().func_71404_a(new CrashReport("Decay failed for: " + this.toString(), (Throwable)e));
            return null;
        }
        if (this.definition.decayMakesEnergy(this.energy)) {
            for (i = differentDecays - 1; i >= 0; --i) {
                if (decays[i] == eBosonDefinition.deadEnd) {
                    cElementalInstanceStack clone = this.clone();
                    clone.amount = qttyOfDecay[i];
                    output.putUnify(clone);
                    continue;
                }
                results = decays[i].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, qttyOfDecay[i]);
                output.putUnifyAll(results);
                totalOutput.setMassDiff(DoubleCount.add(totalOutput.getMassDiff(), results.getMass() - mass));
            }
        } else {
            for (i = differentDecays - 1; i >= 0; --i) {
                results = decays[i].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, qttyOfDecay[i]);
                output.putUnifyAll(results);
            }
        }
        if (newProductsAge < 0.0) {
            if (output.size() == 1 && output.get((int)0).definition.equals(this.definition)) {
                output.get(0).setEnergy(this.energy);
                output.get((int)0).age = this.age;
            } else {
                for (cElementalInstanceStack stack : output.values()) {
                    if (!stack.definition.equals(this.definition)) continue;
                    stack.age = this.age;
                }
            }
        } else if (output.size() == 1 && output.get((int)0).definition.equals(this.definition)) {
            output.get(0).setEnergy(this.energy);
            output.get((int)0).age = this.age;
        }
        if (this.energy <= 0L && output.getMass() > this.getMass()) {
            return null;
        }
        return totalOutput;
    }

    public cElementalInstanceStack unifyIntoThis(cElementalInstanceStack ... instances) {
        double wholeParts;
        long energy;
        if (instances == null) {
            return this;
        }
        double energyTotal = (double)this.energy * this.amount;
        long maxEnergy = this.energy;
        double lifeTimeMul = this.lifeTimeMult;
        for (cElementalInstanceStack instance : instances) {
            if (instance == null || this.compareTo(instance) != 0) continue;
            this.amount = DoubleCount.add(this.amount, instance.amount);
            energyTotal += (double)instance.energy * instance.amount;
            if (instance.energy > maxEnergy) {
                maxEnergy = instance.energy;
            }
            lifeTimeMul = Math.min(lifeTimeMul, instance.lifeTimeMult);
            this.age = Math.max(this.age, instance.age);
        }
        if (this.amount != 0.0) {
            energyTotal /= Math.abs(this.amount);
        }
        if ((double)(energy = (long)(wholeParts = Math.floor(energyTotal)) + (long)((energyTotal = Math.min(energyTotal - wholeParts, 1.0) + (wholeParts >= 0.0 ? -0.11709966304863834 : 0.11709966304863834)) > TecTech.RANDOM.nextDouble() ? 1 : 0)) * energyTotal < 0.0) {
            energy = 0L;
        }
        this.setEnergy(Math.min(maxEnergy, energy));
        return this;
    }

    public void addScanShortSymbols(ArrayList<String> lines, int[] detailsOnDepthLevels) {
        int capabilities = detailsOnDepthLevels[0];
        this.definition.addScanShortSymbols(lines, capabilities, this.energy);
    }

    public void addScanResults(ArrayList<String> lines, int[] detailsOnDepthLevels) {
        int capabilities = detailsOnDepthLevels[0];
        if (Util.areBitsSet(2, capabilities)) {
            lines.add("DEPTH = 0");
        }
        this.definition.addScanResults(lines, capabilities, this.energy);
        if (Util.areBitsSet(1024, capabilities)) {
            lines.add("TIME MULT = " + this.lifeTimeMult);
            if (Util.areBitsSet(64, capabilities)) {
                lines.add("TIME SPAN = " + this.lifeTime + " s");
            }
        }
        if (Util.areBitsSet(512, capabilities)) {
            lines.add("AGE = " + this.age + " s");
        }
        if (Util.areBitsSet(256, capabilities)) {
            lines.add("COLOR = " + this.color + " RGB or CMY");
        }
        if (Util.areBitsSet(32, capabilities)) {
            lines.add("ENERGY = " + this.energy);
        }
        if (Util.areBitsSet(4, capabilities)) {
            lines.add("AMOUNT = " + this.amount / 6.02214076E23 + " mol");
        }
        this.scanContents(lines, this.definition.getSubParticles(), 1, detailsOnDepthLevels);
    }

    private void scanContents(ArrayList<String> lines, cElementalDefinitionStackMap definitions, int depth, int[] detailsOnDepthLevels) {
        if (definitions != null && depth < detailsOnDepthLevels.length) {
            int deeper = depth + 1;
            for (cElementalDefinitionStack definitionStack : definitions.values()) {
                lines.add("");
                if (Util.areBitsSet(2, detailsOnDepthLevels[depth])) {
                    lines.add("DEPTH = " + depth);
                }
                this.definition.addScanResults(lines, detailsOnDepthLevels[depth], this.energy);
                if (Util.areBitsSet(4, detailsOnDepthLevels[depth])) {
                    lines.add("AMOUNT = " + definitionStack.amount);
                }
                this.scanContents(lines, definitionStack.definition.getSubParticles(), deeper, detailsOnDepthLevels);
            }
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("d", (NBTBase)this.definition.toNBT());
        nbt.func_74780_a("Q", this.amount);
        nbt.func_74772_a("e", this.energy);
        nbt.func_74774_a("c", this.color);
        nbt.func_74780_a("A", this.age);
        nbt.func_74780_a("M", this.lifeTimeMult);
        return nbt;
    }

    public static cElementalInstanceStack fromNBT(NBTTagCompound nbt) {
        NBTTagCompound definition = nbt.func_74775_l("d");
        cElementalInstanceStack instance = new cElementalInstanceStack(cElementalDefinition.fromNBT(definition), (double)nbt.func_74763_f("q") + nbt.func_74769_h("Q"), (double)nbt.func_74760_g("m") + nbt.func_74769_h("M"), (double)nbt.func_74763_f("a") + nbt.func_74769_h("A"), nbt.func_74763_f("e"));
        instance.setColor(nbt.func_74771_c("c"));
        return instance;
    }

    @Override
    public int compareTo(iHasElementalDefinition o) {
        return this.definition.compareTo(o.getDefinition());
    }

    public boolean equals(Object obj) {
        if (obj instanceof iElementalDefinition) {
            return this.definition.compareTo((iElementalDefinition)obj) == 0;
        }
        if (obj instanceof iHasElementalDefinition) {
            return this.definition.compareTo(((iHasElementalDefinition)obj).getDefinition()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public String toString() {
        return this.definition.toString() + '\n' + this.amount / 6.02214076E23 + " mol\n" + this.getMass();
    }
}

