/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core;

import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.util.DoubleCount;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

abstract class cElementalStackMap
implements Comparable<cElementalStackMap> {
    protected TreeMap<iElementalDefinition, cElementalDefinitionStack> map;

    cElementalStackMap() {
    }

    public abstract cElementalStackMap clone();

    @Deprecated
    public abstract TreeMap<iElementalDefinition, cElementalDefinitionStack> getRawMap();

    public final cElementalDefinitionStack getFirst() {
        return this.map.firstEntry().getValue();
    }

    public final cElementalDefinitionStack getLast() {
        return this.map.lastEntry().getValue();
    }

    public final cElementalDefinitionStack getDefinitionStack(iElementalDefinition def) {
        return this.map.get(def);
    }

    public String[] getShortSymbolsInfo() {
        String[] info = new String[this.map.size()];
        int i = 0;
        for (cElementalDefinitionStack instance : this.map.values()) {
            info[i++] = instance.definition.getShortSymbol();
        }
        return info;
    }

    public final String[] getElementalInfo() {
        String[] info = new String[this.map.size() * 3];
        int i = 0;
        for (cElementalDefinitionStack defStack : this.map.values()) {
            info[i] = EnumChatFormatting.BLUE + defStack.definition.getName();
            info[i + 1] = EnumChatFormatting.AQUA + defStack.definition.getSymbol();
            info[i + 2] = "Amount " + EnumChatFormatting.GREEN + defStack.amount;
            i += 3;
        }
        return info;
    }

    public final cElementalDefinitionStack[] values() {
        Collection<cElementalDefinitionStack> var = this.map.values();
        return var.toArray(new cElementalDefinitionStack[0]);
    }

    public final iElementalDefinition[] keys() {
        Set<iElementalDefinition> var = this.map.keySet();
        return var.toArray(new iElementalDefinition[0]);
    }

    public double getCountOfAllAmounts() {
        double sum = 0.0;
        for (cElementalDefinitionStack stack : this.map.values()) {
            sum = DoubleCount.add(sum, stack.amount);
        }
        return sum;
    }

    public final boolean containsDefinition(iElementalDefinition def) {
        return this.map.containsKey(def);
    }

    public final boolean containsDefinitionStack(cElementalDefinitionStack inst) {
        return this.map.containsValue(inst);
    }

    public final int size() {
        return this.map.size();
    }

    public final boolean hasStacks() {
        return !this.map.isEmpty();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final NBTTagCompound getShortSymbolsNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        String[] info = this.getShortSymbolsInfo();
        nbt.func_74768_a("i", info.length);
        for (int i = 0; i < info.length; ++i) {
            nbt.func_74778_a(Integer.toString(i), info[i]);
        }
        return nbt;
    }

    public final NBTTagCompound getInfoNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        String[] info = this.getElementalInfo();
        nbt.func_74768_a("i", info.length);
        for (int i = 0; i < info.length; ++i) {
            nbt.func_74778_a(Integer.toString(i), info[i]);
        }
        return nbt;
    }

    public final NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("i", this.map.size());
        int i = 0;
        for (cElementalDefinitionStack defStack : this.map.values()) {
            nbt.func_74782_a(Integer.toString(i++), (NBTBase)defStack.toNBT());
        }
        return nbt;
    }

    @Override
    public final int compareTo(cElementalStackMap o) {
        int sizeDiff = this.map.size() - o.map.size();
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        cElementalDefinitionStack[] ofThis = this.values();
        cElementalDefinitionStack[] ofO = o.values();
        for (int i = 0; i < ofO.length; ++i) {
            int result = ofThis[i].compareTo(ofO[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof cElementalStackMap) {
            return this.compareTo((cElementalStackMap)obj) == 0;
        }
        if (obj instanceof cElementalInstanceStackMap) {
            return this.compareTo(((cElementalInstanceStackMap)obj).toDefinitionMapForComparison()) == 0;
        }
        return false;
    }

    public final int hashCode() {
        int hash = -(this.map.size() << 4);
        for (cElementalDefinitionStack stack : this.map.values()) {
            hash += stack.definition.hashCode();
        }
        return hash;
    }

    public double getMass() {
        double mass = 0.0;
        for (cElementalDefinitionStack stack : this.map.values()) {
            mass += stack.getMass();
        }
        return mass;
    }

    public long getCharge() {
        long charge = 0L;
        for (cElementalDefinitionStack stack : this.map.values()) {
            charge = (long)((double)charge + stack.getCharge());
        }
        return charge;
    }
}

