/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.data;

import com.github.technus.tectech.loader.NetworkDispatcher;
import com.github.technus.tectech.mechanics.data.PlayerDataMessage;
import com.github.technus.tectech.util.Util;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class PlayerPersistence {
    private final HashMap<UUID, NBTTagCompound> map = new HashMap();
    private final String extension;

    public PlayerPersistence(String extension) {
        this.extension = extension;
    }

    public NBTTagCompound getDataOrSetToNewTag(UUID uuid1, UUID uuid2) {
        NBTTagCompound tag = this.map.get(uuid1);
        if (tag != null) {
            return tag;
        }
        tag = this.map.get(uuid2);
        if (tag != null) {
            return tag;
        }
        tag = Util.getPlayerData(uuid1, uuid2, this.extension);
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        this.map.put(uuid1, tag);
        this.map.put(uuid2, tag);
        return tag;
    }

    public NBTTagCompound getDataOrSetToNewTag(EntityPlayer player) {
        return this.getDataOrSetToNewTag(player.func_110124_au(), UUID.nameUUIDFromBytes(player.func_70005_c_().getBytes(Charset.forName("UTF-8"))));
    }

    public void putDataOrSetToNewTag(UUID uuid1, UUID uuid2, NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        this.map.put(uuid1, tagCompound);
        this.map.put(uuid2, tagCompound);
    }

    public void putDataOrSetToNewTag(EntityPlayer player, NBTTagCompound tagCompound) {
        this.putDataOrSetToNewTag(player.func_110124_au(), UUID.nameUUIDFromBytes(player.func_70005_c_().getBytes(Charset.forName("UTF-8"))), tagCompound);
    }

    public void saveData(EntityPlayer player) {
        Util.savePlayerFile(player, this.extension, this.getDataOrSetToNewTag(player));
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            for (WorldServer worldServer : MinecraftServer.func_71276_C().field_71305_c) {
                for (Object playerEntity : worldServer.field_73010_i) {
                    NetworkDispatcher.INSTANCE.sendTo(new PlayerDataMessage.PlayerDataData((EntityPlayer)playerEntity), (EntityPlayerMP)event.player);
                }
            }
            NetworkDispatcher.INSTANCE.sendToAll(new PlayerDataMessage.PlayerDataData(event.player));
        }
    }

    public void clearData() {
        this.map.clear();
    }
}

