/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.alignment;

import com.github.technus.tectech.mechanics.alignment.IAlignment;
import com.github.technus.tectech.mechanics.alignment.enumerable.ExtendedFacing;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import eu.usrv.yamcore.network.server.AbstractServerMessageHandler;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

@Deprecated
public class AlignmentMessage
implements IMessage {
    int mPosX;
    int mPosY;
    int mPosZ;
    int mPosD;
    int mAlign;

    public AlignmentMessage() {
    }

    private AlignmentMessage(GT_MetaTileEntity_MultiblockBase_EM metaTile) {
        IGregTechTileEntity base = metaTile.getBaseMetaTileEntity();
        this.mPosX = base.getXCoord();
        this.mPosY = base.getYCoord();
        this.mPosZ = base.getZCoord();
        this.mPosD = base.getWorld().field_73011_w.field_76574_g;
        this.mAlign = metaTile.getExtendedFacing().getIndex();
    }

    private AlignmentMessage(World world, int x, int y, int z, IAlignment front) {
        this.mPosX = x;
        this.mPosY = y;
        this.mPosZ = z;
        this.mPosD = world.field_73011_w.field_76574_g;
        this.mAlign = front.getExtendedFacing().getIndex();
    }

    public void fromBytes(ByteBuf pBuffer) {
        NBTTagCompound tTag = ByteBufUtils.readTag((ByteBuf)pBuffer);
        this.mPosX = tTag.func_74762_e("posx");
        this.mPosY = tTag.func_74762_e("posy");
        this.mPosZ = tTag.func_74762_e("posz");
        this.mPosD = tTag.func_74762_e("posd");
        this.mAlign = tTag.func_74762_e("rotf");
    }

    public void toBytes(ByteBuf pBuffer) {
        NBTTagCompound tFXTag = new NBTTagCompound();
        tFXTag.func_74768_a("posx", this.mPosX);
        tFXTag.func_74768_a("posy", this.mPosY);
        tFXTag.func_74768_a("posz", this.mPosZ);
        tFXTag.func_74768_a("posd", this.mPosD);
        tFXTag.func_74768_a("rotf", this.mAlign);
        ByteBufUtils.writeTag((ByteBuf)pBuffer, (NBTTagCompound)tFXTag);
    }

    public static class ServerHandler
    extends AbstractServerMessageHandler<AlignmentQuery> {
        public IMessage handleServerMessage(EntityPlayer pPlayer, AlignmentQuery pMessage, MessageContext pCtx) {
            WorldServer world = DimensionManager.getWorld((int)pMessage.mPosD);
            if (world != null) {
                TileEntity te = world.func_147438_o(pMessage.mPosX, pMessage.mPosY, pMessage.mPosZ);
                if (te instanceof IGregTechTileEntity) {
                    IMetaTileEntity meta = ((IGregTechTileEntity)te).getMetaTileEntity();
                    if (meta instanceof IAlignment) {
                        pMessage.mAlign = ((IAlignment)meta).getExtendedFacing().getIndex();
                        return new AlignmentData(pMessage);
                    }
                } else if (te instanceof IAlignment) {
                    pMessage.mAlign = ((IAlignment)te).getExtendedFacing().getIndex();
                    return new AlignmentData(pMessage);
                }
            }
            return null;
        }
    }

    public static class ClientHandler
    extends AbstractClientMessageHandler<AlignmentData> {
        public IMessage handleClientMessage(EntityPlayer pPlayer, AlignmentData pMessage, MessageContext pCtx) {
            if (pPlayer.field_70170_p.field_73011_w.field_76574_g == pMessage.mPosD) {
                TileEntity te = pPlayer.field_70170_p.func_147438_o(pMessage.mPosX, pMessage.mPosY, pMessage.mPosZ);
                if (te instanceof IGregTechTileEntity) {
                    IMetaTileEntity meta = ((IGregTechTileEntity)te).getMetaTileEntity();
                    if (meta instanceof IAlignment) {
                        ((IAlignment)meta).setExtendedFacing(ExtendedFacing.byIndex(pMessage.mAlign));
                    }
                } else if (te instanceof IAlignment) {
                    ((IAlignment)te).setExtendedFacing(ExtendedFacing.byIndex(pMessage.mAlign));
                }
            }
            return null;
        }
    }

    public static class AlignmentData
    extends AlignmentMessage {
        public AlignmentData() {
        }

        private AlignmentData(AlignmentQuery query) {
            this.mPosX = query.mPosX;
            this.mPosY = query.mPosY;
            this.mPosZ = query.mPosZ;
            this.mPosD = query.mPosD;
            this.mAlign = query.mAlign;
        }

        public AlignmentData(GT_MetaTileEntity_MultiblockBase_EM metaTile) {
            super(metaTile);
        }

        public AlignmentData(World world, int x, int y, int z, IAlignment front) {
            super(world, x, y, z, front);
        }
    }

    public static class AlignmentQuery
    extends AlignmentMessage {
        public AlignmentQuery() {
        }

        public AlignmentQuery(GT_MetaTileEntity_MultiblockBase_EM metaTile) {
            super(metaTile);
        }

        public AlignmentQuery(World world, int x, int y, int z, IAlignment front) {
            super(world, x, y, z, front);
        }
    }
}

