/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.avrClone.registerPackages;

import com.github.technus.avrClone.registerPackages.IRegister;
import com.github.technus.avrClone.registerPackages.IRegisterBit;
import com.github.technus.avrClone.registerPackages.RegisterPackage;

public class CPU_Registers
extends RegisterPackage<CPU_Registers> {
    public final int SREG;
    public final int SP;
    public final int defaultSP;
    public static final int I = RegisterBit.I.getBitMask();
    public static final int _I = ~RegisterBit.I.getBitMask();
    public static final int T = RegisterBit.T.getBitMask();
    public static final int H = RegisterBit.H.getBitMask();
    public static final int S = RegisterBit.S.getBitMask();
    public static final int V = RegisterBit.V.getBitMask();
    public static final int N = RegisterBit.N.getBitMask();
    public static final int Z = RegisterBit.Z.getBitMask();
    public static final int C = RegisterBit.C.getBitMask();
    public static final int U = RegisterBit.U.getBitMask();
    public static final int H1 = RegisterBit.H1.getBitMask();
    public static final int H2 = RegisterBit.H2.getBitMask();
    public static final int H3 = RegisterBit.H3.getBitMask();
    public static final int H4 = RegisterBit.H4.getBitMask();
    public static final int H5 = RegisterBit.H5.getBitMask();
    public static final int H6 = RegisterBit.H6.getBitMask();
    public static final int H7 = RegisterBit.H7.getBitMask();
    public static final int H8 = RegisterBit.H8.getBitMask();

    public CPU_Registers(int offset, int defaultSP) {
        super(offset, 16);
        this.defaultSP = defaultSP;
        this.addRegisters(Register.values());
        this.addBits(RegisterBit.values());
        this.SREG = Register.SREG.getAddress(this);
        this.SP = Register.SP.getAddress(this);
    }

    @Override
    public int[] getDataDefault() {
        int[] dataDefault = new int[this.getSize()];
        dataDefault[Register.SP.relativeOffset] = this.defaultSP;
        return dataDefault;
    }

    public static enum RegisterBit implements IRegisterBit<CPU_Registers>
    {
        C,
        Z,
        N,
        V,
        S,
        H,
        T,
        I,
        H1,
        H2,
        H3,
        H4,
        H5,
        H6,
        H7,
        H8,
        U;

        public final int bit = this.ordinal();
        public final int mask = 1 << this.bit;

        @Override
        public int getOffset(CPU_Registers registers) {
            return Register.SREG.getAddress(registers);
        }

        @Override
        public int getBitPosition() {
            return this.bit;
        }

        @Override
        public int getBitMask() {
            return this.mask;
        }
    }

    public static enum Register implements IRegister<CPU_Registers>
    {
        CCP(4),
        SP(13),
        SREG(15);

        public final int relativeOffset;

        private Register(int relativeOffset) {
            this.relativeOffset = relativeOffset;
        }

        @Override
        public int getAddress(CPU_Registers registers) {
            return this.relativeOffset + registers.getOffset();
        }
    }
}

