/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.util;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.util.CommonValues;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;

public final class Util {
    private Util() {
    }

    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>((e1, e2) -> {
            int res = ((Comparable)e1.getValue()).compareTo(e2.getValue());
            return res != 0 ? res : 1;
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }

    public static int bitStringToInt(String bits) {
        if (bits == null) {
            return 0;
        }
        if (bits.length() > 32) {
            throw new NumberFormatException("Too long!");
        }
        return Integer.parseInt(bits, 2);
    }

    public static int hexStringToInt(String hex) {
        if (hex == null) {
            return 0;
        }
        if (hex.length() > 8) {
            throw new NumberFormatException("Too long!");
        }
        return Integer.parseInt(hex, 16);
    }

    public static double stringToDouble(String str) {
        if (str == null) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    public static double getValue(String in1) {
        String str = in1.toLowerCase();
        try {
            double val;
            if (str.contains("b")) {
                String[] split = str.split("b");
                val = Util.bitStringToInt(split[0].replaceAll("[^-]", "") + split[1].replaceAll("_", ""));
            } else if (str.contains("x")) {
                String[] split = str.split("x");
                val = Util.hexStringToInt(split[0].replaceAll("[^-]", "") + split[1].replaceAll("_", ""));
            } else {
                val = Util.stringToDouble(str);
            }
            return val;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static String intBitsToString(int number) {
        StringBuilder result = new StringBuilder(16);
        for (int i = 31; i >= 0; --i) {
            int mask = 1 << i;
            result.append((number & mask) != 0 ? "1" : "0");
            if (i % 8 != 0) continue;
            result.append(' ');
        }
        result.replace(result.length() - 1, result.length(), "");
        return result.toString();
    }

    public static String intBitsToShortString(int number) {
        StringBuilder result = new StringBuilder(35);
        for (int i = 31; i >= 0; --i) {
            int mask = 1 << i;
            result.append((number & mask) != 0 ? ":" : ".");
            if (i % 8 != 0) continue;
            result.append('|');
        }
        result.replace(result.length() - 1, result.length(), "");
        return result.toString();
    }

    public static String longBitsToShortString(long number) {
        StringBuilder result = new StringBuilder(71);
        for (int i = 63; i >= 0; --i) {
            long mask = 1L << i;
            result.append((number & mask) != 0L ? ":" : ".");
            if (i % 8 != 0) continue;
            result.append('|');
        }
        result.replace(result.length() - 1, result.length(), "");
        return result.toString();
    }

    public static float map(float x, float in_min, float in_max, float out_min, float out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public static boolean isInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, FluidStack[] requiredFluidInputs, ItemStack[] requiredInputs, FluidStack[] givenFluidInputs, ItemStack ... givenInputs) {
        int n;
        int n2;
        FluidStack[] fluidStackArray;
        int amt;
        boolean temp;
        if (!GregTech_API.sPostloadFinished) {
            return false;
        }
        if (requiredFluidInputs.length > 0 && givenFluidInputs == null) {
            return false;
        }
        for (FluidStack fluidStack : requiredFluidInputs) {
            if (fluidStack == null) continue;
            temp = true;
            amt = fluidStack.amount;
            fluidStackArray = givenFluidInputs;
            n2 = fluidStackArray.length;
            for (n = 0; n < n2; ++n) {
                FluidStack aFluid = fluidStackArray[n];
                if (aFluid == null || !aFluid.isFluidEqual(fluidStack)) continue;
                if (aDontCheckStackSizes) {
                    temp = false;
                    break;
                }
                if ((amt -= aFluid.amount) >= 1) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (requiredInputs.length > 0 && givenInputs == null) {
            return false;
        }
        for (FluidStack fluidStack : requiredInputs) {
            if (fluidStack == null) continue;
            amt = fluidStack.field_77994_a;
            temp = true;
            fluidStackArray = givenInputs;
            n2 = fluidStackArray.length;
            for (n = 0; n < n2; ++n) {
                FluidStack aStack = fluidStackArray[n];
                if (!GT_Utility.areUnificationsEqual((ItemStack)aStack, (ItemStack)fluidStack, (boolean)true) && !GT_Utility.areUnificationsEqual((ItemStack)GT_OreDictUnificator.get((boolean)false, (ItemStack)aStack), (ItemStack)fluidStack, (boolean)true)) continue;
                if (aDontCheckStackSizes) {
                    temp = false;
                    break;
                }
                if ((amt -= aStack.field_77994_a) >= 1) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            if (givenFluidInputs != null) {
                block4: for (FluidStack fluidStack : requiredFluidInputs) {
                    if (fluidStack == null) continue;
                    amt = fluidStack.amount;
                    FluidStack[] fluidStackArray2 = givenFluidInputs;
                    int n3 = fluidStackArray2.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        FluidStack aFluid = fluidStackArray2[n2];
                        if (aFluid == null || !aFluid.isFluidEqual(fluidStack)) continue;
                        if (aDontCheckStackSizes) {
                            aFluid.amount -= amt;
                            continue block4;
                        }
                        if (aFluid.amount < amt) {
                            amt -= aFluid.amount;
                            aFluid.amount = 0;
                            continue;
                        }
                        aFluid.amount -= amt;
                        continue block4;
                    }
                }
            }
            if (givenInputs != null) {
                block6: for (FluidStack fluidStack : requiredInputs) {
                    if (fluidStack == null) continue;
                    amt = fluidStack.field_77994_a;
                    for (ItemStack aStack : givenInputs) {
                        if (!GT_Utility.areUnificationsEqual((ItemStack)aStack, (ItemStack)fluidStack, (boolean)true) && !GT_Utility.areUnificationsEqual((ItemStack)GT_OreDictUnificator.get((boolean)false, (ItemStack)aStack), (ItemStack)fluidStack, (boolean)true)) continue;
                        if (aDontCheckStackSizes) {
                            aStack.field_77994_a -= amt;
                            continue block6;
                        }
                        if (aStack.field_77994_a < amt) {
                            amt -= aStack.field_77994_a;
                            aStack.field_77994_a = 0;
                            continue;
                        }
                        aStack.field_77994_a -= amt;
                        continue block6;
                    }
                }
            }
        }
        return true;
    }

    public static String getUniqueIdentifier(ItemStack is) {
        return GameRegistry.findUniqueIdentifierFor((Item)is.func_77973_b()).modId + ':' + is.func_77977_a();
    }

    public static byte getTier(long l) {
        byte b = -1;
        do {
            if ((b = (byte)((byte)(b + 1))) < CommonValues.V.length) continue;
            return b;
        } while (l > CommonValues.V[b]);
        return b;
    }

    public static String[] splitButDifferent(String string, String delimiter) {
        String[] strings = new String[StringUtils.countMatches((CharSequence)string, (CharSequence)delimiter) + 1];
        int lastEnd = 0;
        for (int i = 0; i < strings.length - 1; ++i) {
            int nextEnd = string.indexOf(delimiter, lastEnd);
            strings[i] = string.substring(lastEnd, nextEnd);
            lastEnd = nextEnd + delimiter.length();
        }
        strings[strings.length - 1] = string.substring(lastEnd);
        return strings;
    }

    public static String[] infoFromNBT(NBTTagCompound nbt) {
        String[] strings = new String[nbt.func_74762_e("i")];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = nbt.func_74779_i(Integer.toString(i));
        }
        return strings;
    }

    public static boolean areBitsSet(int setBits, int testedValue) {
        return (testedValue & setBits) == setBits;
    }

    public static void setTier(int tier, Object me) {
        try {
            Field field = GT_MetaTileEntity_TieredMachineBlock.class.getField("mTier");
            field.setAccessible(true);
            field.set(me, (byte)tier);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static StringBuilder receiveString(StringBuilder previousValue, int startIndex, int index, int value) {
        int sizeReq = index - startIndex;
        if (value == 0) {
            previousValue.setLength(Math.min(previousValue.length(), sizeReq));
        } else {
            previousValue.setLength(Math.max(previousValue.length(), sizeReq));
            previousValue.setCharAt(sizeReq, (char)value);
        }
        return previousValue;
    }

    @Deprecated
    public static double receiveDouble(double previousValue, int startIndex, int index, int value) {
        return Double.longBitsToDouble(Util.receiveLong(Double.doubleToLongBits(previousValue), startIndex, index, value));
    }

    public static long receiveLong(long previousValue, int startIndex, int index, int value) {
        value &= 0xFFFF;
        switch (index - startIndex) {
            case 0: {
                previousValue &= 0xFFFFFFFFFFFF0000L;
                previousValue |= (long)value;
                break;
            }
            case 1: {
                previousValue &= 0xFFFFFFFF0000FFFFL;
                previousValue |= (long)(value << 16);
                break;
            }
            case 2: {
                previousValue &= 0xFFFF0000FFFFFFFFL;
                previousValue |= (long)value << 32;
                break;
            }
            case 3: {
                previousValue &= 0xFFFFFFFFFFFFL;
                previousValue |= (long)value << 48;
            }
        }
        return previousValue;
    }

    public static void sendString(StringBuilder string, Container container, ICrafting crafter, int startIndex) {
        for (int i = 0; i < string.length(); ++i) {
            crafter.func_71112_a(container, startIndex++, (int)string.charAt(i));
        }
        crafter.func_71112_a(container, startIndex, 0);
    }

    public static void sendDouble(double value, Container container, ICrafting crafter, int startIndex) {
        Util.sendLong(Double.doubleToLongBits(value), container, crafter, startIndex);
    }

    public static void sendLong(long value, Container container, ICrafting crafter, int startIndex) {
        crafter.func_71112_a(container, startIndex++, (int)(value & 0xFFFFL));
        crafter.func_71112_a(container, startIndex++, (int)((value & 0xFFFF0000L) >>> 16));
        crafter.func_71112_a(container, startIndex++, (int)((value & 0xFFFF00000000L) >>> 32));
        crafter.func_71112_a(container, startIndex, (int)((value & 0xFFFF000000000000L) >>> 48));
    }

    @Deprecated
    public static float receiveFloat(float previousValue, int startIndex, int index, int value) {
        return Float.intBitsToFloat(Util.receiveInteger(Float.floatToIntBits(previousValue), startIndex, index, value));
    }

    public static int receiveInteger(int previousValue, int startIndex, int index, int value) {
        value &= 0xFFFF;
        switch (index - startIndex) {
            case 0: {
                previousValue &= 0xFFFF0000;
                previousValue |= value;
                break;
            }
            case 1: {
                previousValue &= 0xFFFF;
                previousValue |= value << 16;
            }
        }
        return previousValue;
    }

    public static void sendFloat(float value, Container container, ICrafting crafter, int startIndex) {
        Util.sendInteger(Float.floatToIntBits(value), container, crafter, startIndex);
    }

    public static void sendInteger(int value, Container container, ICrafting crafter, int startIndex) {
        crafter.func_71112_a(container, startIndex++, (int)((long)value & 0xFFFFL));
        crafter.func_71112_a(container, startIndex, (value & 0xFFFF0000) >>> 16);
    }

    public static String doubleToString(double value) {
        if (value == (double)((long)value)) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }

    public static boolean checkChunkExist(World world, ChunkCoordIntPair chunk) {
        int x = chunk.func_77273_a();
        int z = chunk.func_77274_b();
        return world.func_72904_c(x, 0, z, x, 0, z);
    }

    public static NBTTagCompound getPlayerData(UUID uuid1, UUID uuid2, String extension) {
        try {
            if (FMLCommonHandler.instance().getEffectiveSide().isServer() && uuid1 != null && uuid2 != null) {
                String id1;
                IPlayerFileData playerNBTManagerObj = MinecraftServer.func_71276_C().func_71218_a(0).func_72860_G().func_75756_e();
                SaveHandler sh = (SaveHandler)playerNBTManagerObj;
                File dir = (File)ObfuscationReflectionHelper.getPrivateValue(SaveHandler.class, (Object)sh, (String[])new String[]{"playersDirectory", "field_75771_c"});
                NBTTagCompound tagCompound = Util.read(new File(dir, (id1 = uuid1.toString()) + "." + extension));
                if (tagCompound != null) {
                    return tagCompound;
                }
                tagCompound = Util.readBackup(new File(dir, id1 + "." + extension + "_bak"));
                if (tagCompound != null) {
                    return tagCompound;
                }
                String id2 = uuid2.toString();
                tagCompound = Util.read(new File(dir, id2 + "." + extension));
                if (tagCompound != null) {
                    return tagCompound;
                }
                tagCompound = Util.readBackup(new File(dir, id2 + "." + extension + "_bak"));
                if (tagCompound != null) {
                    return tagCompound;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new NBTTagCompound();
    }

    public static void savePlayerFile(EntityPlayer player, String extension, NBTTagCompound data) {
        try {
            if (FMLCommonHandler.instance().getEffectiveSide().isServer() && player != null) {
                IPlayerFileData playerNBTManagerObj = MinecraftServer.func_71276_C().func_71218_a(0).func_72860_G().func_75756_e();
                SaveHandler sh = (SaveHandler)playerNBTManagerObj;
                File dir = (File)ObfuscationReflectionHelper.getPrivateValue(SaveHandler.class, (Object)sh, (String[])new String[]{"playersDirectory", "field_75771_c"});
                String id1 = player.func_110124_au().toString();
                Util.write(new File(dir, id1 + "." + extension), data);
                Util.write(new File(dir, id1 + "." + extension + "_bak"), data);
                String id2 = UUID.nameUUIDFromBytes(player.func_70005_c_().getBytes(StandardCharsets.UTF_8)).toString();
                Util.write(new File(dir, id2 + "." + extension), data);
                Util.write(new File(dir, id2 + "." + extension + "_bak"), data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NBTTagCompound read(File file) {
        if (file == null) return null;
        if (!file.exists()) return null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
            return nBTTagCompound;
        }
        catch (Exception var9) {
            TecTech.LOGGER.error((Object)("Cannot read NBT File: " + file.getAbsolutePath()));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NBTTagCompound readBackup(File file) {
        if (file == null) return null;
        if (!file.exists()) return null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
            return nBTTagCompound;
        }
        catch (Exception var9) {
            TecTech.LOGGER.error((Object)("Cannot read NBT File: " + file.getAbsolutePath()));
            return new NBTTagCompound();
        }
    }

    private static void write(File file, NBTTagCompound tagCompound) {
        if (file != null) {
            if (tagCompound == null) {
                if (file.exists()) {
                    file.delete();
                }
            } else {
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    CompressedStreamTools.func_74799_a((NBTTagCompound)tagCompound, (OutputStream)fileOutputStream);
                }
                catch (Exception var9) {
                    TecTech.LOGGER.error((Object)("Cannot write NBT File: " + file.getAbsolutePath()));
                }
            }
        }
    }

    public static AxisAlignedBB fromChunkCoordIntPair(ChunkCoordIntPair chunkCoordIntPair) {
        int x = chunkCoordIntPair.field_77276_a << 4;
        int z = chunkCoordIntPair.field_77275_b << 4;
        return AxisAlignedBB.func_72330_a((double)x, (double)-128.0, (double)z, (double)(x + 16), (double)512.0, (double)(z + 16));
    }

    public static AxisAlignedBB fromChunk(Chunk chunk) {
        int x = chunk.field_76635_g << 4;
        int z = chunk.field_76647_h << 4;
        return AxisAlignedBB.func_72330_a((double)x, (double)-128.0, (double)z, (double)(x + 16), (double)512.0, (double)(z + 16));
    }

    public static class ItemStack_NoNBT
    implements Comparable<ItemStack_NoNBT> {
        public final Item mItem;
        public final int mStackSize;
        public final int mMetaData;

        public ItemStack_NoNBT(Item aItem, long aStackSize, long aMetaData) {
            this.mItem = aItem;
            this.mStackSize = (byte)aStackSize;
            this.mMetaData = (short)aMetaData;
        }

        public ItemStack_NoNBT(ItemStack aStack) {
            if (aStack == null) {
                this.mItem = null;
                this.mMetaData = 0;
                this.mStackSize = 0;
            } else {
                this.mItem = aStack.func_77973_b();
                this.mStackSize = aStack.field_77994_a;
                this.mMetaData = Items.field_151008_G.getDamage(aStack);
            }
        }

        @Override
        public int compareTo(ItemStack_NoNBT o) {
            if (this.mMetaData > o.mMetaData) {
                return 1;
            }
            if (this.mMetaData < o.mMetaData) {
                return -1;
            }
            if (this.mStackSize > o.mStackSize) {
                return 1;
            }
            if (this.mStackSize < o.mStackSize) {
                return -1;
            }
            if (this.mItem != null && o.mItem != null) {
                return this.mItem.func_77658_a().compareTo(o.mItem.func_77658_a());
            }
            if (this.mItem == null && o.mItem == null) {
                return 0;
            }
            if (this.mItem != null) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object aStack) {
            return aStack == this || aStack instanceof ItemStack_NoNBT && (this.mItem == ((ItemStack_NoNBT)aStack).mItem || ((ItemStack_NoNBT)aStack).mItem.func_77658_a().equals(this.mItem.func_77658_a())) && ((ItemStack_NoNBT)aStack).mStackSize == this.mStackSize && ((ItemStack_NoNBT)aStack).mMetaData == this.mMetaData;
        }

        public int hashCode() {
            return (this.mItem != null ? this.mItem.func_77658_a().hashCode() : 0) ^ this.mMetaData << 16 ^ this.mStackSize << 24;
        }

        public String toString() {
            return Integer.toString(this.hashCode()) + ' ' + (this.mItem == null ? "null" : this.mItem.func_77658_a()) + ' ' + this.mMetaData + ' ' + this.mStackSize;
        }
    }
}

