/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core;

import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.util.DoubleCount;

public final class cElementalDecay {
    public static final cElementalDecay[] noDecay = null;
    public static final cElementalDecay[] noProduct = new cElementalDecay[0];
    public final cElementalDefinitionStackMap outputStacks;
    public final double probability;

    public cElementalDecay(iElementalDefinition ... outSafe) {
        this(1.0, outSafe);
    }

    public cElementalDecay(double probability, iElementalDefinition ... outSafe) {
        cElementalDefinitionStack[] outArr = new cElementalDefinitionStack[outSafe.length];
        for (int i = 0; i < outArr.length; ++i) {
            outArr[i] = new cElementalDefinitionStack(outSafe[i], 1.0);
        }
        this.outputStacks = new cElementalDefinitionStackMap(outArr);
        this.probability = probability;
    }

    public cElementalDecay(cElementalDefinitionStack ... outSafe) {
        this(1.0, outSafe);
    }

    public cElementalDecay(double probability, cElementalDefinitionStack ... out) {
        this.outputStacks = new cElementalDefinitionStackMap(out);
        this.probability = probability;
    }

    public cElementalDecay(cElementalDefinitionStackMap tree) {
        this(1.0, tree);
    }

    public cElementalDecay(double probability, cElementalDefinitionStackMap tree) {
        this.outputStacks = tree;
        this.probability = probability;
    }

    public cElementalInstanceStackMap getResults(double lifeMult, double age, long energyTotalForProducts, double amountDecaying) {
        cElementalInstanceStackMap decayResult = new cElementalInstanceStackMap();
        if (this.outputStacks == null) {
            return decayResult;
        }
        double qtty = 0.0;
        for (cElementalDefinitionStack stack : this.outputStacks.values()) {
            qtty = DoubleCount.add(qtty, stack.amount);
        }
        if (qtty <= 0.0) {
            return decayResult;
        }
        for (cElementalDefinitionStack stack : this.outputStacks.values()) {
            decayResult.putUnify(new cElementalInstanceStack(stack.definition, amountDecaying * stack.amount, lifeMult, age, (long)((double)energyTotalForProducts / Math.max(1.0, Math.abs(stack.amount)))));
        }
        return decayResult;
    }
}

