/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.anomaly;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.MainLoader;
import com.github.technus.tectech.loader.NetworkDispatcher;
import com.github.technus.tectech.mechanics.data.ChunkDataHandler;
import com.github.technus.tectech.mechanics.data.ChunkDataMessage;
import com.github.technus.tectech.mechanics.data.IChunkMetaDataHandler;
import com.github.technus.tectech.mechanics.data.PlayerDataMessage;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.dAtomDefinition;
import com.github.technus.tectech.util.Util;
import cpw.mods.fml.common.gameevent.TickEvent;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;

public class AnomalyHandler
implements IChunkMetaDataHandler {
    public static final double SWAP_THRESHOLD = dAtomDefinition.getSomethingHeavy().getMass() * 10000.0;
    public static final int COUNT_DIV = 32;
    public static final double PER_PARTICLE = SWAP_THRESHOLD / 32.0;
    public static final String INTENSITY = "intensity";
    public static final String SPACE_CANCER = "space_cancer";
    public static final String SPACE_CHARGE = "space_charge";
    public static final int MEAN_DELAY = 50;
    private static final float CHARGE_EFFECTIVENESS = 10.0f;
    private static final float CHARGE_EXPLOSIVENESS = 5.0f;
    private boolean fixMe = false;
    private final ArrayList<EntityPlayer> playersWithCharge = new ArrayList();
    private final ArrayList<Chunk> worldDataArrayList = new ArrayList(512);

    @Override
    public String getTagName() {
        return "anomaly";
    }

    @Override
    public void mergeData(NBTTagCompound target, NBTTagCompound loadedData) {
        double intensity = target.func_74769_h(INTENSITY) + loadedData.func_74769_h(INTENSITY);
        target.func_74780_a(INTENSITY, intensity);
    }

    @Override
    public NBTTagCompound createData() {
        return new NBTTagCompound();
    }

    @Override
    public void tickWorld(HashMap<Integer, ChunkDataHandler.ChunkHashMap> data, TickEvent.WorldTickEvent aEvent) {
        if (TecTech.RANDOM.nextInt(50) == 0) {
            int dim = aEvent.world.field_73011_w.field_76574_g;
            data.get(dim).forEach((chunkCoordIntPair, compound) -> {
                if (compound.func_74769_h(INTENSITY) >= SWAP_THRESHOLD) {
                    Chunk chunk = aEvent.world.func_72964_e(chunkCoordIntPair.field_77276_a, chunkCoordIntPair.field_77275_b);
                    if (chunk.field_76636_d) {
                        this.worldDataArrayList.add(chunk);
                    }
                }
            });
            if (this.worldDataArrayList.size() >= 2) {
                Chunk a = this.worldDataArrayList.remove(TecTech.RANDOM.nextInt(this.worldDataArrayList.size()));
                Chunk b = this.worldDataArrayList.remove(TecTech.RANDOM.nextInt(this.worldDataArrayList.size()));
                double avg = 0.5 * (data.get(dim).get(a.func_76632_l()).func_74769_h(INTENSITY) + data.get(dim).get(b.func_76632_l()).func_74769_h(INTENSITY));
                data.get(dim).get(a.func_76632_l()).func_74780_a(INTENSITY, Math.min(SWAP_THRESHOLD, avg * (double)(TecTech.RANDOM.nextFloat() + 0.5f) * 0.5));
                data.get(dim).get(b.func_76632_l()).func_74780_a(INTENSITY, Math.min(SWAP_THRESHOLD, avg * (double)(TecTech.RANDOM.nextFloat() + 0.5f) * 0.5));
                data.get(dim).markForTransmissionToClient(a.func_76632_l());
                data.get(dim).markForTransmissionToClient(b.func_76632_l());
                this.swapSomething(a, b, (float)Math.min(Math.log10(avg), 20.0));
            }
            this.worldDataArrayList.clear();
        }
        for (Object o : aEvent.world.field_73010_i) {
            float charge;
            if (!(o instanceof EntityPlayer) || ((EntityPlayer)o).field_71075_bZ.field_75098_d || (charge = TecTech.playerPersistence.getDataOrSetToNewTag((EntityPlayer)o).func_74760_g(SPACE_CHARGE)) == 0.0f) continue;
            this.playersWithCharge.add((EntityPlayer)o);
        }
        if (this.playersWithCharge.size() > 0) {
            for (EntityPlayer other : this.playersWithCharge) {
                float fieldOther = TecTech.playerPersistence.getDataOrSetToNewTag(other).func_74760_g(SPACE_CHARGE);
                for (EntityPlayer player : this.playersWithCharge) {
                    if (other == player) break;
                    float field = TecTech.playerPersistence.getDataOrSetToNewTag(player).func_74760_g(SPACE_CHARGE);
                    float difference = Math.abs(field - fieldOther);
                    if (difference == 0.0f || !(player.func_70068_e((Entity)other) < 1.0)) continue;
                    float avg = (fieldOther + field) / 2.0f;
                    this.addAnomaly(other.field_70170_p.field_73011_w.field_76574_g, new ChunkCoordIntPair(other.field_70176_ah, other.field_70164_aj), Math.min(SWAP_THRESHOLD, PER_PARTICLE * (double)difference));
                    other.field_70170_p.func_72876_a((Entity)other, other.field_70165_t, other.field_70163_u, other.field_70161_v, Math.min(5.0f * difference, 25.0f), true);
                    player.field_70170_p.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, Math.min(5.0f * difference, 25.0f), true);
                    TecTech.playerPersistence.getDataOrSetToNewTag(player).func_74776_a(SPACE_CHARGE, avg);
                    TecTech.playerPersistence.getDataOrSetToNewTag(other).func_74776_a(SPACE_CHARGE, avg);
                    TecTech.playerPersistence.saveData(player);
                    TecTech.playerPersistence.saveData(other);
                    NetworkDispatcher.INSTANCE.sendToAll(new PlayerDataMessage.PlayerDataData(player));
                    NetworkDispatcher.INSTANCE.sendToAll(new PlayerDataMessage.PlayerDataData(other));
                }
            }
            this.playersWithCharge.clear();
        }
    }

    private void swapSomething(Chunk a, Chunk b, float power) {
        for (int i = 0; i < 64; ++i) {
            int x = TecTech.RANDOM.nextInt(16);
            int y = TecTech.RANDOM.nextInt(a.field_76637_e.func_72940_L());
            int z = TecTech.RANDOM.nextInt(16);
            Block aBlock = a.func_150810_a(x, y, z);
            Block bBlock = a.func_150810_a(x, y, z);
            int aMeta = a.func_76628_c(x, y, z);
            int bMeta = a.func_76628_c(x, y, z);
            if (a.getTileEntityUnsafe(x, y, z) == null && b.getTileEntityUnsafe(x, y, z) == null) {
                a.field_76637_e.func_147465_d((a.field_76635_g << 4) + x, y, (a.field_76647_h << 4) + z, bBlock, bMeta, 3);
                b.field_76637_e.func_147465_d((b.field_76635_g << 4) + x, y, (b.field_76647_h << 4) + z, aBlock, aMeta, 3);
            } else if (a.getTileEntityUnsafe(x, y, z) == null) {
                b.field_76637_e.func_147465_d((b.field_76635_g << 4) + x, y, (b.field_76647_h << 4) + z, aBlock, aMeta, 3);
                a.field_76637_e.func_147468_f((a.field_76635_g << 4) + x, y, (a.field_76647_h << 4) + z);
            } else if (b.getTileEntityUnsafe(x, y, z) == null) {
                a.field_76637_e.func_147465_d((a.field_76635_g << 4) + x, y, (a.field_76647_h << 4) + z, bBlock, bMeta, 3);
                b.field_76637_e.func_147468_f((b.field_76635_g << 4) + x, y, (b.field_76647_h << 4) + z);
            } else {
                a.field_76637_e.func_147468_f((a.field_76635_g << 4) + x, y, (a.field_76647_h << 4) + z);
                b.field_76637_e.func_147468_f((b.field_76635_g << 4) + x, y, (b.field_76647_h << 4) + z);
            }
            if (TecTech.RANDOM.nextBoolean()) {
                a.field_76637_e.func_72876_a(null, (double)((a.field_76635_g << 4) + x) + 0.5, (double)y + 0.5, (double)((a.field_76647_h << 4) + z) + 0.5, power, true);
                GT_Utility.sendSoundToPlayers((World)a.field_76637_e, (String)((String)GregTech_API.sSoundList.get(209)), (float)1.0f, (float)-1.0f, (int)((a.field_76635_g << 4) + x), (int)y, (int)((a.field_76647_h << 4) + z));
            }
            if (!TecTech.RANDOM.nextBoolean()) continue;
            b.field_76637_e.func_72876_a(null, (double)((b.field_76635_g << 4) + x) + 0.5, (double)y + 0.5, (double)((b.field_76647_h << 4) + z) + 0.5, power, true);
            GT_Utility.sendSoundToPlayers((World)b.field_76637_e, (String)((String)GregTech_API.sSoundList.get(209)), (float)1.0f, (float)-1.0f, (int)((b.field_76635_g << 4) + x), (int)y, (int)((b.field_76647_h << 4) + z));
        }
        int x = b.field_76635_g - a.field_76635_g << 4;
        int z = b.field_76635_g - a.field_76635_g << 4;
        List aE = a.field_76637_e.func_72872_a(EntityLivingBase.class, Util.fromChunk(a));
        List bE = b.field_76637_e.func_72872_a(EntityLivingBase.class, Util.fromChunk(b));
        aE.forEach(o -> {
            if (TecTech.RANDOM.nextBoolean()) {
                o.func_70634_a(o.field_70165_t + (double)x, o.field_70163_u, o.field_70161_v + (double)z);
                o.func_70097_a(MainLoader.subspace, (float)(8 + TecTech.RANDOM.nextInt(8)));
                if (o instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)o;
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 1200));
                        player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 1000));
                        player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 800));
                        player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 600));
                        player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 400));
                        player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200));
                        player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100));
                        player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 60));
                        TecTech.playerPersistence.getDataOrSetToNewTag(player).func_74776_a(SPACE_CHARGE, TecTech.playerPersistence.getDataOrSetToNewTag(player).func_74760_g(SPACE_CHARGE) - (float)Math.abs(TecTech.RANDOM.nextGaussian()));
                        TecTech.playerPersistence.saveData(player);
                        NetworkDispatcher.INSTANCE.sendToAll(new PlayerDataMessage.PlayerDataData(player));
                    }
                }
            }
        });
        bE.forEach(o -> {
            if (TecTech.RANDOM.nextBoolean()) {
                o.func_70634_a(o.field_70165_t - (double)x, o.field_70163_u, o.field_70161_v - (double)z);
                o.func_70097_a(MainLoader.subspace, (float)(8 + TecTech.RANDOM.nextInt(8)));
                if (o instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)o;
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 800));
                        player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 600));
                        player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 400));
                        player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 200));
                        player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 100));
                        player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 60));
                        TecTech.playerPersistence.getDataOrSetToNewTag(player).func_74776_a(SPACE_CHARGE, TecTech.playerPersistence.getDataOrSetToNewTag(player).func_74760_g(SPACE_CHARGE) + (float)Math.abs(TecTech.RANDOM.nextGaussian()));
                        TecTech.playerPersistence.saveData(player);
                        NetworkDispatcher.INSTANCE.sendToAll(new PlayerDataMessage.PlayerDataData(player));
                    }
                }
            }
        });
    }

    @Override
    public void tickPlayer(HashMap<Integer, ChunkDataHandler.ChunkHashMap> data, TickEvent.PlayerTickEvent aEvent) {
        if (aEvent.side.isClient()) {
            EntityPlayer player = TecTech.proxy.getPlayer();
            ChunkCoordIntPair pair = new ChunkCoordIntPair(player.field_70176_ah, player.field_70164_aj);
            NBTTagCompound compound = data.get(player.field_70170_p.field_73011_w.field_76574_g).get(pair);
            if (compound != null) {
                int badness = (int)Math.min(32.0, compound.func_74769_h(INTENSITY) / PER_PARTICLE);
                for (int i = 0; i < badness; ++i) {
                    TecTech.proxy.em_particle(player.field_70170_p, player.field_70165_t + TecTech.RANDOM.nextGaussian() * 64.0, player.field_70163_u + TecTech.RANDOM.nextGaussian() * 64.0, player.field_70161_v + TecTech.RANDOM.nextGaussian() * 64.0);
                }
            }
            data.get(player.field_70170_p.field_73011_w.field_76574_g).forEach((chunkCoordIntPair, dat) -> {
                if (Math.abs((double)chunkCoordIntPair.func_77273_a() - player.field_70165_t) + Math.abs((double)chunkCoordIntPair.func_77274_b() - player.field_70161_v) < 256.0) {
                    int pow = (int)Math.min(32.0, dat.func_74769_h(INTENSITY) / PER_PARTICLE);
                    for (int i = 0; i < pow; ++i) {
                        TecTech.proxy.em_particle(player.field_70170_p, (double)chunkCoordIntPair.func_77273_a() + TecTech.RANDOM.nextGaussian() * 32.0, player.field_70163_u + (double)TecTech.RANDOM.nextFloat() * 128.0 - 64.0, (double)chunkCoordIntPair.func_77274_b() + TecTech.RANDOM.nextGaussian() * 32.0);
                    }
                }
            });
        } else if (TecTech.RANDOM.nextInt(50) == 0) {
            EntityPlayer player = aEvent.player;
            ChunkCoordIntPair pair = new ChunkCoordIntPair(player.field_70176_ah, player.field_70164_aj);
            NBTTagCompound compound = data.get(player.field_70170_p.field_73011_w.field_76574_g).get(pair);
            NBTTagCompound playerTag = TecTech.playerPersistence.getDataOrSetToNewTag(player);
            if (player.field_71075_bZ.field_75098_d) {
                playerTag.func_74780_a(SPACE_CANCER, 0.0);
            } else if (compound != null) {
                int badness = (int)Math.min(32.0, compound.func_74769_h(INTENSITY) / PER_PARTICLE);
                if (badness > 0) {
                    playerTag.func_74780_a(SPACE_CANCER, Math.min(2.0, playerTag.func_74769_h(SPACE_CANCER) + (double)(9.765625E-4f * (float)badness)));
                    player.func_70097_a(MainLoader.subspace, Math.max(1.0f, (float)badness / 8.0f));
                }
            } else if (playerTag.func_74769_h(SPACE_CANCER) > 0.0 && !player.field_70128_L) {
                if (playerTag.func_74769_h(SPACE_CANCER) == 0.0 || player.field_70173_aa % 10 != 0) {
                    return;
                }
                playerTag.func_74780_a(SPACE_CANCER, Math.max(0.0, playerTag.func_74769_h(SPACE_CANCER) - 7.62939453125E-5));
            }
            TecTech.playerPersistence.saveData(player);
            NetworkDispatcher.INSTANCE.sendTo(new PlayerDataMessage.PlayerDataData(player), (EntityPlayerMP)player);
        }
    }

    @Override
    public void tickRender(HashMap<Integer, ChunkDataHandler.ChunkHashMap> data, TickEvent.RenderTickEvent aEvent) {
        EntityPlayer player = TecTech.proxy.getPlayer();
        if (player != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                float charge;
                float cancer;
                NBTTagCompound tagCompound = TecTech.playerPersistence.getDataOrSetToNewTag(player);
                if (tagCompound != null && (cancer = tagCompound.func_74760_g(SPACE_CANCER)) > 0.0f) {
                    this.fixMe = TecTech.RANDOM.nextFloat() * 2.0f < cancer;
                    player.func_82142_c(this.fixMe);
                    player.func_70082_c((TecTech.RANDOM.nextFloat() - 0.5f) * 36.0f * cancer, (TecTech.RANDOM.nextFloat() - 0.5f) * 36.0f * cancer);
                    cancer *= cancer / 2.0f;
                    if (cancer > 1.75f) {
                        player.func_70016_h((double)((TecTech.RANDOM.nextFloat() - 0.5f) * cancer), (double)((TecTech.RANDOM.nextFloat() - 0.5f) * cancer), (double)((TecTech.RANDOM.nextFloat() - 0.5f) * cancer));
                    } else {
                        player.func_70024_g((double)((TecTech.RANDOM.nextFloat() - 0.5f) * cancer), (double)((TecTech.RANDOM.nextFloat() - 0.5f) * cancer), (double)((TecTech.RANDOM.nextFloat() - 0.5f) * cancer));
                    }
                }
                if ((charge = TecTech.playerPersistence.getDataOrSetToNewTag(player).func_74760_g(SPACE_CHARGE)) != 0.0f) {
                    for (Object o : player.field_70170_p.field_73010_i) {
                        double distanceSq;
                        float reaction;
                        EntityPlayer otherPlayer;
                        float chargeOther;
                        if (!(o instanceof EntityPlayer) || ((EntityPlayer)o).field_71075_bZ.field_75098_d || (chargeOther = TecTech.playerPersistence.getDataOrSetToNewTag(otherPlayer = (EntityPlayer)o).func_74760_g(SPACE_CHARGE)) == 0.0f || player == o || (reaction = chargeOther * charge) == 0.0f || !((distanceSq = otherPlayer.func_70068_e((Entity)player)) >= 1.0)) continue;
                        double effect = (double)(10.0f * reaction) / (distanceSq * distanceSq * distanceSq);
                        double dX = player.field_70165_t - otherPlayer.field_70165_t;
                        double dY = player.field_70163_u - otherPlayer.field_70163_u;
                        double dZ = player.field_70161_v - otherPlayer.field_70161_v;
                        player.func_70024_g(effect * dX, effect * dY, effect * dZ);
                        otherPlayer.func_70024_g(-effect * dX, -effect * dY, -effect * dZ);
                    }
                }
            }
            if (this.fixMe) {
                player.func_82142_c(false);
                this.fixMe = false;
            }
        }
    }

    @Override
    public void pullData(ChunkEvent.Load aEvent) {
        NetworkDispatcher.INSTANCE.sendToServer(new ChunkDataMessage.ChunkDataQuery(aEvent, this));
    }

    @Override
    public void pushData(World world, ChunkCoordIntPair chunk) {
        NetworkDispatcher.INSTANCE.sendToDimension(new ChunkDataMessage.ChunkDataData(world.field_73011_w.field_76574_g, chunk, this), world.field_73011_w.field_76574_g);
    }

    @Override
    public int pushPayloadSpreadPeriod() {
        return 100;
    }

    public void addAnomaly(IGregTechTileEntity iGregTechTileEntity, double amount) {
        if (iGregTechTileEntity.isServerSide()) {
            World w = iGregTechTileEntity.getWorld();
            this.addAnomaly(w.field_73011_w.field_76574_g, new ChunkCoordIntPair(iGregTechTileEntity.getXCoord() >> 4, iGregTechTileEntity.getZCoord() >> 4), amount);
        }
    }

    public void addAnomaly(int world, ChunkCoordIntPair chunk, double amount) {
        amount = Math.abs(amount);
        NBTTagCompound old = TecTech.chunkDataHandler.getChunkData(this, world, chunk);
        if (old == null) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74780_a(INTENSITY, amount);
            TecTech.chunkDataHandler.putChunkData(this, world, chunk, data);
        } else {
            old.func_74780_a(INTENSITY, old.func_74769_h(INTENSITY) + amount);
        }
        TecTech.chunkDataHandler.getChunkData(this, world).markForTransmissionToClient(chunk);
    }
}

