/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.alignment;

import com.github.technus.tectech.mechanics.alignment.IAlignment;
import com.github.technus.tectech.mechanics.alignment.IAlignmentLimits;
import com.github.technus.tectech.mechanics.alignment.enumerable.ExtendedFacing;
import com.github.technus.tectech.mechanics.alignment.enumerable.Flip;
import com.github.technus.tectech.mechanics.alignment.enumerable.Rotation;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraftforge.common.util.ForgeDirection;

public class AlignmentLimits
implements IAlignmentLimits {
    protected final boolean[] validStates = new boolean[IAlignment.STATES_COUNT];

    public AlignmentLimits() {
        this.allowAll();
    }

    AlignmentLimits allowAll() {
        Arrays.fill(this.validStates, true);
        return this;
    }

    AlignmentLimits denyAll() {
        Arrays.fill(this.validStates, false);
        return this;
    }

    AlignmentLimits randomAll(Random random) {
        for (int i = 0; i < this.validStates.length; ++i) {
            this.validStates[i] = random.nextBoolean();
        }
        return this;
    }

    AlignmentLimits deny(ExtendedFacing ... deny) {
        if (deny != null) {
            for (ExtendedFacing extendedFacing : deny) {
                this.validStates[extendedFacing.getIndex()] = false;
            }
        }
        return this;
    }

    AlignmentLimits allow(ExtendedFacing ... allow) {
        if (allow != null) {
            for (ExtendedFacing extendedFacing : allow) {
                this.validStates[extendedFacing.getIndex()] = false;
            }
        }
        return this;
    }

    AlignmentLimits deny(ForgeDirection ... deny) {
        if (deny != null) {
            block0: for (ExtendedFacing value : ExtendedFacing.VALUES) {
                for (ForgeDirection direction : deny) {
                    if (value.getDirection() != direction) continue;
                    this.validStates[value.getIndex()] = false;
                    continue block0;
                }
            }
        }
        return this;
    }

    AlignmentLimits allow(ForgeDirection ... allow) {
        if (allow != null) {
            block0: for (ExtendedFacing value : ExtendedFacing.VALUES) {
                for (ForgeDirection direction : allow) {
                    if (value.getDirection() != direction) continue;
                    this.validStates[value.getIndex()] = true;
                    continue block0;
                }
            }
        }
        return this;
    }

    AlignmentLimits deny(Rotation ... deny) {
        if (deny != null) {
            block0: for (ExtendedFacing value : ExtendedFacing.VALUES) {
                for (Rotation rotation : deny) {
                    if (value.getRotation() != rotation) continue;
                    this.validStates[value.getIndex()] = false;
                    continue block0;
                }
            }
        }
        return this;
    }

    AlignmentLimits allow(Rotation ... allow) {
        if (allow != null) {
            block0: for (ExtendedFacing value : ExtendedFacing.VALUES) {
                for (Rotation rotation : allow) {
                    if (value.getRotation() != rotation) continue;
                    this.validStates[value.getIndex()] = true;
                    continue block0;
                }
            }
        }
        return this;
    }

    AlignmentLimits deny(Flip ... deny) {
        if (deny != null) {
            block0: for (ExtendedFacing value : ExtendedFacing.VALUES) {
                for (Flip flip : deny) {
                    if (value.getFlip() != flip) continue;
                    this.validStates[value.getIndex()] = false;
                    continue block0;
                }
            }
        }
        return this;
    }

    AlignmentLimits allow(Flip ... allow) {
        if (allow != null) {
            block0: for (ExtendedFacing value : ExtendedFacing.VALUES) {
                for (Flip flip : allow) {
                    if (value.getFlip() != flip) continue;
                    this.validStates[value.getIndex()] = true;
                    continue block0;
                }
            }
        }
        return this;
    }

    AlignmentLimits predicateApply(Function<ExtendedFacing, Optional<Boolean>> predicate) {
        for (ExtendedFacing value : ExtendedFacing.VALUES) {
            predicate.apply(value).ifPresent(bool -> {
                this.validStates[value.getIndex()] = bool;
            });
        }
        return this;
    }

    AlignmentLimits ensureDuplicates() {
        for (ExtendedFacing value : ExtendedFacing.VALUES) {
            if (!this.validStates[value.getIndex()]) continue;
            this.validStates[value.getDuplicate().getIndex()] = true;
        }
        return this;
    }

    AlignmentLimits ensureNoDuplicates(Flip flip) {
        if (flip == Flip.BOTH || flip == Flip.NONE) {
            throw new IllegalArgumentException("Preffered Flip must be Horizontal or Vertical");
        }
        flip = flip.getOpposite();
        for (ExtendedFacing value : ExtendedFacing.VALUES) {
            if (!this.validStates[value.getIndex()] || value.getFlip() != Flip.BOTH && value.getFlip() != flip) continue;
            this.validStates[value.getIndex()] = false;
            this.validStates[value.getDuplicate().getIndex()] = true;
        }
        return this;
    }

    @Override
    public boolean isNewExtendedFacingValid(ForgeDirection direction, Rotation rotation, Flip flip) {
        return this.validStates[IAlignment.getAlignmentIndex(direction, rotation, flip)];
    }
}

