/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.avrClone.memory;

import com.github.technus.avrClone.memory.IDataMemoryDefinition;
import com.github.technus.avrClone.memory.IDataMemoryInstance;

public class RemovableMemory<T extends IDataMemoryDefinition>
implements IDataMemoryInstance {
    private final int[] data;
    private final int offset;
    private T definition;

    public static RemovableMemory make(int offset, int size) {
        if (size <= 0 || offset < 0) {
            return null;
        }
        return new RemovableMemory(size, offset);
    }

    private RemovableMemory(int size, int offset) {
        this.data = new int[size];
        this.offset = offset;
    }

    public static RemovableMemory make(int offset, int[] dataDefault) {
        if (dataDefault == null || dataDefault.length == 0 || offset < 0) {
            return null;
        }
        return new RemovableMemory(dataDefault, offset);
    }

    private RemovableMemory(int[] dataDefault, int offset) {
        this.data = (int[])dataDefault.clone();
        this.offset = offset;
    }

    public static <T extends IDataMemoryDefinition> RemovableMemory<T> makeWithoutCloning(T definition, int ... data) {
        if (definition == null || data == null || data.length != definition.getSize()) {
            return null;
        }
        return new RemovableMemory<T>(definition, data, true);
    }

    private RemovableMemory(T definition, int[] data, boolean exact) {
        this.definition = definition;
        this.offset = definition.getOffset();
        if (exact) {
            this.data = data;
        } else {
            this.data = new int[definition.getSize()];
            System.arraycopy(data, 0, this.data, 0, Math.min(data.length, definition.getSize()));
        }
    }

    public static <T extends IDataMemoryDefinition> RemovableMemory<T> make(T definition, int ... data) {
        if (definition == null || data == null || data.length > definition.getSize()) {
            return null;
        }
        return new RemovableMemory<T>(definition, data);
    }

    private RemovableMemory(T definition, int[] data) {
        this(definition, data, false);
    }

    @Override
    public int getSize() {
        return this.data.length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int[] getDataDefault() {
        return new int[this.data.length];
    }

    @Override
    public int[] getData() {
        return this.data;
    }

    protected RemovableMemory<T> clone() {
        return new RemovableMemory<T>(this.data, this.offset);
    }

    public T getDefinition() {
        return this.definition;
    }
}

