/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.NetworkDispatcher;
import com.github.technus.tectech.mechanics.constructable.IConstructable;
import com.github.technus.tectech.mechanics.spark.RendererMessage;
import com.github.technus.tectech.mechanics.spark.ThaumSpark;
import com.github.technus.tectech.mechanics.structure.Structure;
import com.github.technus.tectech.mechanics.structure.adders.IHatchAdder;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.cover.GT_Cover_TM_TeslaCoil;
import com.github.technus.tectech.thing.cover.GT_Cover_TM_TeslaCoil_Ultimate;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_Capacitor;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_Param;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.thing.metaTileEntity.single.GT_MetaTileEntity_TeslaCoil;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.Util;
import com.github.technus.tectech.util.Vec3Impl;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Frame;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_TM_teslaCoil
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static final HashSet<ThaumSpark> sparkList = new HashSet();
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private int mTier = 0;
    private int maxTier = 6;
    private float energyEfficiency = 1.0f;
    private float overdriveEfficiency = 1.0f;
    private float minEfficiency;
    private float maxEfficiency;
    private float overdriveEfficiencyExtra;
    private Map<IGregTechTileEntity, Integer> eTeslaMap;
    private final ArrayList<GT_MetaTileEntity_Hatch_Capacitor> eCapacitorHatches;
    private int scanTime;
    private long energyCapacity;
    private long outputVoltageMax;
    private int vTier;
    private long outputCurrentMax;
    private byte oldRotation;
    private byte oldOrientation;
    private final Vec3Impl[] scanPosOffsets;
    private Vec3Impl posZap;
    public Vec3Impl posTop;
    private static final String[][] shape;
    private static final Block[] blockType;
    private static final byte[] blockMetaT0;
    private static final byte[] blockMetaT1;
    private static final byte[] blockMetaT2;
    private static final byte[] blockMetaT3;
    private static final byte[] blockMetaT4;
    private static final byte[] blockMetaT5;
    private static final byte[][] blockMetas;
    private static final IHatchAdder<GT_MetaTileEntity_TM_teslaCoil>[] addingMethods;
    private static final short[] casingTextures;
    private static final Block[] blockTypeFallback;
    private static final byte[] blockMetaFallback;
    private static final String[] description;
    protected Parameters.Group.ParameterIn popogaSetting;
    protected Parameters.Group.ParameterIn histLowSetting;
    protected Parameters.Group.ParameterIn histHighSetting;
    protected Parameters.Group.ParameterIn transferRadiusTowerSetting;
    protected Parameters.Group.ParameterIn transferRadiusTransceiverSetting;
    protected Parameters.Group.ParameterIn transferRadiusCoverUltimateSetting;
    protected Parameters.Group.ParameterIn outputVoltageSetting;
    protected Parameters.Group.ParameterIn outputCurrentSetting;
    protected Parameters.Group.ParameterIn scanTimeMinSetting;
    protected Parameters.Group.ParameterIn overDriveSetting;
    protected Parameters.Group.ParameterOut popogaDisplay;
    protected Parameters.Group.ParameterOut transferRadiusTowerDisplay;
    protected Parameters.Group.ParameterOut transferRadiusTransceiverDisplay;
    protected Parameters.Group.ParameterOut transferRadiusCoverUltimateDisplay;
    protected Parameters.Group.ParameterOut outputVoltageDisplay;
    protected Parameters.Group.ParameterOut outputCurrentDisplay;
    protected Parameters.Group.ParameterOut energyCapacityDisplay;
    protected Parameters.Group.ParameterOut energyStoredDisplay;
    protected Parameters.Group.ParameterOut energyFractionDisplay;
    protected Parameters.Group.ParameterOut scanTimeDisplay;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> HYSTERESIS_LOW_SETTING_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> HYSTERESIS_HIGH_SETTING_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> TRANSFER_RADIUS_TOWER_SETTING_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> TRANSFER_RADIUS_TRANSCEIVER_SETTING_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> TRANSFER_RADIUS_COVER_ULTIMATE_SETTING_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> OUTPUT_VOLTAGE_SETTING_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> OUTPUT_CURRENT_SETTING_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> SCAN_TIME_MIN_SETTING_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> OVERDRIVE_SETTING_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> POPOGA_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> TRANSFER_RADIUS_TOWER_DISPLAY_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> TRANSFER_RADIUS_TRANSCEIVER_DISPLAY_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> TRANSFER_RADIUS_COVER_ULTIMATE_DISPLAY_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> OUTPUT_VOLTAGE_DISPLAY_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> OUTPUT_CURRENT_DISPLAY_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> ENERGY_CAPACITY_DISPLAY_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> ENERGY_STORED_DISPLAY_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> ENERGY_FRACTION_DISPLAY_NAME;
    private static final INameFunction<GT_MetaTileEntity_TM_teslaCoil> SCAN_TIME_DISPLAY_NAME;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> HYSTERESIS_LOW_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> HYSTERESIS_HIGH_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> TRANSFER_RADIUS_TOWER_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> TRANSFER_RADIUS_TRANSCEIVER_OR_COVER_ULTIMATE_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> OUTPUT_VOLTAGE_OR_CURRENT_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> SCAN_TIME_MIN_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> OVERDRIVE_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> POPOGA_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> SCAN_TIME_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> POWER_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_TM_teslaCoil> ENERGY_STATUS;

    public GT_MetaTileEntity_TM_teslaCoil(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.minEfficiency = TecTech.configTecTech.TESLA_MULTI_MIN_EFFICIENCY;
        this.maxEfficiency = TecTech.configTecTech.TESLA_MULTI_MAX_EFFICIENCY;
        this.overdriveEfficiencyExtra = TecTech.configTecTech.TESLA_MULTI_OVERDRIVE_LOSS;
        this.eTeslaMap = new HashMap<IGregTechTileEntity, Integer>();
        this.eCapacitorHatches = new ArrayList();
        this.scanTime = 0;
        this.energyCapacity = 0L;
        this.outputVoltageMax = 0L;
        this.vTier = -1;
        this.outputCurrentMax = 0L;
        this.oldRotation = (byte)-1;
        this.oldOrientation = (byte)-1;
        this.scanPosOffsets = new Vec3Impl[10];
        this.posZap = Vec3Impl.NULL_VECTOR;
        this.posTop = Vec3Impl.NULL_VECTOR;
    }

    public GT_MetaTileEntity_TM_teslaCoil(String aName) {
        super(aName);
        this.minEfficiency = TecTech.configTecTech.TESLA_MULTI_MIN_EFFICIENCY;
        this.maxEfficiency = TecTech.configTecTech.TESLA_MULTI_MAX_EFFICIENCY;
        this.overdriveEfficiencyExtra = TecTech.configTecTech.TESLA_MULTI_OVERDRIVE_LOSS;
        this.eTeslaMap = new HashMap<IGregTechTileEntity, Integer>();
        this.eCapacitorHatches = new ArrayList();
        this.scanTime = 0;
        this.energyCapacity = 0L;
        this.outputVoltageMax = 0L;
        this.vTier = -1;
        this.outputCurrentMax = 0L;
        this.oldRotation = (byte)-1;
        this.oldOrientation = (byte)-1;
        this.scanPosOffsets = new Vec3Impl[10];
        this.posZap = Vec3Impl.NULL_VECTOR;
        this.posTop = Vec3Impl.NULL_VECTOR;
    }

    private long getEnergyEfficiency(long voltage, int distance, boolean overDriveToggle) {
        if (overDriveToggle) {
            return (long)((double)(voltage * 2L) - (double)voltage * Math.pow(this.overdriveEfficiency, distance));
        }
        return (long)((double)voltage * Math.pow(this.energyEfficiency, distance));
    }

    private float getRangeMulti(int mTier, int vTier) {
        if (vTier > mTier) {
            return 1.25f;
        }
        return 1.0f;
    }

    private void scanForTransmissionTargets(Vec3Impl coordsMin, Vec3Impl coordsMax) {
        int xMin = Math.min(coordsMin.get0(), coordsMax.get0());
        int yMin = Math.min(coordsMin.get1(), coordsMax.get1());
        int zMin = Math.min(coordsMin.get2(), coordsMax.get2());
        int xMax = Math.max(coordsMin.get0(), coordsMax.get0());
        int yMax = Math.max(coordsMin.get1(), coordsMax.get1());
        int zMax = Math.max(coordsMin.get2(), coordsMax.get2());
        for (int xPos = xMin; xPos <= xMax; ++xPos) {
            for (int yPos = yMin; yPos <= yMax; ++yPos) {
                for (int zPos = zMin; zPos <= zMax; ++zPos) {
                    IMetaTileEntity nodeInside;
                    IGregTechTileEntity node;
                    if (xPos == 0 && yPos == 0 && zPos == 0 || (node = this.getBaseMetaTileEntity().getIGregTechTileEntityOffset(xPos, yPos, zPos)) == null || !((nodeInside = node.getMetaTileEntity()) instanceof GT_MetaTileEntity_TeslaCoil) && (!(nodeInside instanceof GT_MetaTileEntity_TM_teslaCoil) || !node.isActive()) && !(node.getCoverBehaviorAtSide((byte)1) instanceof GT_Cover_TM_TeslaCoil)) continue;
                    this.eTeslaMap.put(node, (int)Math.ceil(Math.sqrt(Math.pow(xPos, 2.0) + Math.pow(yPos, 2.0) + Math.pow(zPos, 2.0))));
                }
            }
        }
    }

    private void thaumLightning(IGregTechTileEntity mte, IGregTechTileEntity node) {
        byte xR = (byte)(node.getXCoord() - this.posTop.get0());
        byte yR = (byte)(node.getYCoord() - this.posTop.get1());
        byte zR = (byte)(node.getZCoord() - this.posTop.get2());
        int wID = mte.getWorld().field_73011_w.field_76574_g;
        sparkList.add(new ThaumSpark(this.posTop.get0(), this.posTop.get1(), this.posTop.get2(), xR, yR, zR, wID));
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TM_teslaCoil(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        for (GT_MetaTileEntity_Hatch_Capacitor cap : this.eCapacitorHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)cap)) continue;
            cap.getBaseMetaTileEntity().setActive(false);
        }
        this.eCapacitorHatches.clear();
        Vec3Impl xyzOffsets = this.getExtendedFacing().getWorldOffset(new Vec3Impl(0, -1, 1));
        this.mTier = iGregTechTileEntity.getMetaIDOffset(xyzOffsets.get0(), xyzOffsets.get1(), xyzOffsets.get2());
        if (this.structureCheck_EM(shape, blockType, blockMetas[this.mTier], addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 3, 16, 0) && this.eCapacitorHatches.size() > 0) {
            for (GT_MetaTileEntity_Hatch_Capacitor cap : this.eCapacitorHatches) {
                if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)cap)) continue;
                cap.getBaseMetaTileEntity().setActive(iGregTechTileEntity.isActive());
            }
            if (this.oldRotation != this.getExtendedFacing().ordinal() || this.oldOrientation != iGregTechTileEntity.getFrontFacing()) {
                this.oldRotation = (byte)this.getExtendedFacing().ordinal();
                this.oldOrientation = iGregTechTileEntity.getFrontFacing();
                this.posZap = this.getExtendedFacing().getWorldOffset(new Vec3Impl(0, 0, 2)).add(this.getBaseMetaTileEntity());
                this.posTop = this.getExtendedFacing().getWorldOffset(new Vec3Impl(0, -14, 2)).add(this.getBaseMetaTileEntity());
                this.scanPosOffsets[0] = this.getExtendedFacing().getWorldOffset(new Vec3Impl(40, 0, 43));
                this.scanPosOffsets[1] = this.getExtendedFacing().getWorldOffset(new Vec3Impl(-40, -4, -37));
                this.scanPosOffsets[2] = this.getExtendedFacing().getWorldOffset(new Vec3Impl(40, -5, 43));
                this.scanPosOffsets[3] = this.getExtendedFacing().getWorldOffset(new Vec3Impl(-40, -8, -37));
                this.scanPosOffsets[4] = this.getExtendedFacing().getWorldOffset(new Vec3Impl(40, -9, 43));
                this.scanPosOffsets[5] = this.getExtendedFacing().getWorldOffset(new Vec3Impl(-40, -12, -37));
                this.scanPosOffsets[6] = this.getExtendedFacing().getWorldOffset(new Vec3Impl(40, -13, 43));
                this.scanPosOffsets[7] = this.getExtendedFacing().getWorldOffset(new Vec3Impl(-40, -16, -37));
                this.scanPosOffsets[8] = this.getExtendedFacing().getWorldOffset(new Vec3Impl(40, -17, 43));
                this.scanPosOffsets[9] = this.getExtendedFacing().getWorldOffset(new Vec3Impl(-40, -20, -37));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        if (!(this.histHighSetting.getStatus((boolean)false).isOk && this.histLowSetting.getStatus((boolean)false).isOk && this.transferRadiusTowerSetting.getStatus((boolean)false).isOk && this.transferRadiusTransceiverSetting.getStatus((boolean)false).isOk && this.transferRadiusCoverUltimateSetting.getStatus((boolean)false).isOk && this.outputVoltageSetting.getStatus((boolean)false).isOk && this.outputCurrentSetting.getStatus((boolean)false).isOk && this.scanTimeMinSetting.getStatus((boolean)false).isOk && this.overDriveSetting.getStatus((boolean)false).isOk)) {
            return false;
        }
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 20;
        this.vTier = -1;
        for (GT_MetaTileEntity_Hatch_Capacitor cap : this.eCapacitorHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)cap) || cap.getCapacitors()[0] <= (long)this.vTier) continue;
            this.vTier = (int)cap.getCapacitors()[0];
        }
        this.energyEfficiency = Util.map(this.mTier + 1, 1.0f, this.maxTier, this.minEfficiency, this.maxEfficiency);
        this.overdriveEfficiency = this.energyEfficiency - this.overdriveEfficiencyExtra;
        this.energyCapacity = 0L;
        this.outputCurrentMax = 0L;
        if (this.vTier < 0) {
            this.outputVoltageMax = 0L;
            return true;
        }
        if (this.vTier > this.mTier && this.getEUVar() > 0L) {
            this.explodeMultiblock();
        }
        this.outputVoltageMax = CommonValues.V[this.vTier + 1];
        for (GT_MetaTileEntity_Hatch_Capacitor cap : this.eCapacitorHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)cap)) continue;
            cap.getBaseMetaTileEntity().setActive(true);
            long[] capacitorData = cap.getCapacitors();
            if (capacitorData[0] < (long)this.vTier) {
                if (this.getEUVar() > 0L && capacitorData[0] != 0L) {
                    cap.getBaseMetaTileEntity().setToFire();
                }
                this.eCapacitorHatches.remove((Object)cap);
                continue;
            }
            this.outputCurrentMax += capacitorData[1];
            this.energyCapacity += capacitorData[2];
        }
        return true;
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.BASS_MARK, StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.desc.0"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.desc.1"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.desc.2")};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/TM_TESLA_TOWER");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/TM_TESLA_TOWER_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][22], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][22]};
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        for (GT_MetaTileEntity_Hatch_Capacitor cap : this.eCapacitorHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)cap)) continue;
            cap.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, true);
        Parameters.Group hatch_1 = this.parametrization.getGroup(1, true);
        Parameters.Group hatch_2 = this.parametrization.getGroup(2, true);
        Parameters.Group hatch_3 = this.parametrization.getGroup(3, true);
        Parameters.Group hatch_4 = this.parametrization.getGroup(4, true);
        Parameters.Group hatch_5 = this.parametrization.getGroup(5, true);
        Parameters.Group hatch_6 = this.parametrization.getGroup(6, true);
        Parameters.Group hatch_7 = this.parametrization.getGroup(7, true);
        Parameters.Group hatch_8 = this.parametrization.getGroup(8, true);
        Parameters.Group hatch_9 = this.parametrization.getGroup(9, true);
        this.histLowSetting = hatch_0.makeInParameter(0, 0.25, HYSTERESIS_LOW_SETTING_NAME, HYSTERESIS_LOW_STATUS);
        this.popogaSetting = hatch_0.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.histHighSetting = hatch_1.makeInParameter(0, 0.75, HYSTERESIS_HIGH_SETTING_NAME, HYSTERESIS_HIGH_STATUS);
        this.popogaSetting = hatch_1.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.transferRadiusTowerSetting = hatch_2.makeInParameter(0, 32.0, TRANSFER_RADIUS_TOWER_SETTING_NAME, TRANSFER_RADIUS_TOWER_STATUS);
        this.popogaSetting = hatch_2.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.transferRadiusTransceiverSetting = hatch_3.makeInParameter(0, 16.0, TRANSFER_RADIUS_TRANSCEIVER_SETTING_NAME, TRANSFER_RADIUS_TRANSCEIVER_OR_COVER_ULTIMATE_STATUS);
        this.transferRadiusCoverUltimateSetting = hatch_3.makeInParameter(1, 16.0, TRANSFER_RADIUS_COVER_ULTIMATE_SETTING_NAME, TRANSFER_RADIUS_TRANSCEIVER_OR_COVER_ULTIMATE_STATUS);
        this.outputVoltageSetting = hatch_4.makeInParameter(0, -1.0, OUTPUT_VOLTAGE_SETTING_NAME, OUTPUT_VOLTAGE_OR_CURRENT_STATUS);
        this.popogaSetting = hatch_4.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.outputCurrentSetting = hatch_5.makeInParameter(0, -1.0, OUTPUT_CURRENT_SETTING_NAME, OUTPUT_VOLTAGE_OR_CURRENT_STATUS);
        this.popogaSetting = hatch_5.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaSetting = hatch_6.makeInParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaSetting = hatch_6.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.scanTimeMinSetting = hatch_7.makeInParameter(0, 100.0, SCAN_TIME_MIN_SETTING_NAME, SCAN_TIME_MIN_STATUS);
        this.popogaSetting = hatch_7.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.overDriveSetting = hatch_8.makeInParameter(0, 0.0, OVERDRIVE_SETTING_NAME, OVERDRIVE_STATUS);
        this.popogaSetting = hatch_8.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaSetting = hatch_9.makeInParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaSetting = hatch_9.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_0.makeOutParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_0.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_1.makeOutParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_1.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.transferRadiusTowerDisplay = hatch_2.makeOutParameter(0, 0.0, TRANSFER_RADIUS_TOWER_DISPLAY_NAME, TRANSFER_RADIUS_TOWER_STATUS);
        this.popogaDisplay = hatch_2.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.transferRadiusTransceiverDisplay = hatch_3.makeOutParameter(0, 0.0, TRANSFER_RADIUS_TRANSCEIVER_DISPLAY_NAME, TRANSFER_RADIUS_TRANSCEIVER_OR_COVER_ULTIMATE_STATUS);
        this.transferRadiusCoverUltimateDisplay = hatch_3.makeOutParameter(1, 0.0, TRANSFER_RADIUS_COVER_ULTIMATE_DISPLAY_NAME, TRANSFER_RADIUS_TRANSCEIVER_OR_COVER_ULTIMATE_STATUS);
        this.outputVoltageDisplay = hatch_4.makeOutParameter(0, 0.0, OUTPUT_VOLTAGE_DISPLAY_NAME, POWER_STATUS);
        this.popogaDisplay = hatch_4.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.outputCurrentDisplay = hatch_5.makeOutParameter(0, 0.0, OUTPUT_CURRENT_DISPLAY_NAME, POWER_STATUS);
        this.energyCapacityDisplay = hatch_5.makeOutParameter(1, 0.0, ENERGY_CAPACITY_DISPLAY_NAME, ENERGY_STATUS);
        this.energyStoredDisplay = hatch_6.makeOutParameter(0, 0.0, ENERGY_STORED_DISPLAY_NAME, ENERGY_STATUS);
        this.energyFractionDisplay = hatch_6.makeOutParameter(1, 0.0, ENERGY_FRACTION_DISPLAY_NAME, ENERGY_STATUS);
        this.scanTimeDisplay = hatch_7.makeOutParameter(0, 0.0, SCAN_TIME_DISPLAY_NAME, SCAN_TIME_STATUS);
        this.popogaDisplay = hatch_7.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_8.makeOutParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_8.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_9.makeOutParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_9.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("eEnergyCapacity", this.energyCapacity);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.energyCapacity = aNBT.func_74763_f("eEnergyCapacity");
    }

    @Override
    public void stopMachine() {
        super.stopMachine();
        for (GT_MetaTileEntity_Hatch_Capacitor cap : this.eCapacitorHatches) {
            cap.getBaseMetaTileEntity().setActive(false);
        }
        this.setEUVar(0L);
        this.energyStoredDisplay.set(0.0);
        this.energyFractionDisplay.set(0.0);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        IMetaTileEntity nodeInside;
        IGregTechTileEntity node;
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        long energyMax = this.maxEUStore() / 2L;
        long energyStored = this.getEUVar();
        float energyFrac = (float)energyStored / (float)energyMax;
        this.energyCapacityDisplay.set(energyMax);
        this.energyStoredDisplay.set(energyStored);
        this.energyFractionDisplay.set(energyFrac);
        if (!this.ePowerPass && (double)energyFrac > this.histHighSetting.get()) {
            this.ePowerPass = true;
        } else if (this.ePowerPass && (double)energyFrac < this.histLowSetting.get()) {
            this.ePowerPass = false;
        }
        for (Map.Entry<IGregTechTileEntity, Integer> Rx : this.eTeslaMap.entrySet()) {
            node = Rx.getKey();
            if (node != null) {
                nodeInside = node.getMetaTileEntity();
                try {
                    if (nodeInside instanceof GT_MetaTileEntity_TM_teslaCoil && node.isActive()) {
                        GT_MetaTileEntity_TM_teslaCoil teslaTower = (GT_MetaTileEntity_TM_teslaCoil)nodeInside;
                        if (teslaTower.maxEUStore() > 0L) {
                            continue;
                        }
                    } else if (nodeInside instanceof GT_MetaTileEntity_TeslaCoil) {
                        GT_MetaTileEntity_TeslaCoil teslaTransceiver = (GT_MetaTileEntity_TeslaCoil)nodeInside;
                        if (teslaTransceiver.mBatteryCount > 0) {
                            continue;
                        }
                    } else if (node.getCoverBehaviorAtSide((byte)1) instanceof GT_Cover_TM_TeslaCoil && node.getEUCapacity() > 0L) {
                        continue;
                    }
                }
                catch (Exception teslaTransceiver) {
                    // empty catch block
                }
            }
            this.eTeslaMap.remove(Rx.getKey());
        }
        switch (this.scanTime) {
            case 0: {
                this.scanTimeDisplay.updateStatus();
                this.scanForTransmissionTargets(this.scanPosOffsets[0], this.scanPosOffsets[1]);
                break;
            }
            case 20: {
                this.scanTimeDisplay.updateStatus();
                this.scanForTransmissionTargets(this.scanPosOffsets[2], this.scanPosOffsets[3]);
                break;
            }
            case 40: {
                this.scanTimeDisplay.updateStatus();
                this.scanForTransmissionTargets(this.scanPosOffsets[4], this.scanPosOffsets[5]);
                break;
            }
            case 60: {
                this.scanTimeDisplay.updateStatus();
                this.scanForTransmissionTargets(this.scanPosOffsets[6], this.scanPosOffsets[7]);
                break;
            }
            case 80: {
                this.scanTimeDisplay.updateStatus();
                this.scanForTransmissionTargets(this.scanPosOffsets[8], this.scanPosOffsets[9]);
                break;
            }
            default: {
                if (this.scanTime != (int)this.scanTimeMinSetting.get() - 1) break;
                this.scanTime = -1;
                for (Map.Entry<IGregTechTileEntity, Integer> Rx : this.eTeslaMap.entrySet()) {
                    node = Rx.getKey();
                    if (node == null) continue;
                    nodeInside = node.getMetaTileEntity();
                    try {
                        if (!(nodeInside instanceof GT_MetaTileEntity_TeslaCoil)) continue;
                        GT_MetaTileEntity_TeslaCoil teslaCoil = (GT_MetaTileEntity_TeslaCoil)nodeInside;
                        int tX = node.getXCoord();
                        short tY = node.getYCoord();
                        int tZ = node.getZCoord();
                        int tXN = this.posZap.get0();
                        int tYN = this.posZap.get1();
                        int tZN = this.posZap.get2();
                        int tOffset = (int)Math.ceil(Math.sqrt(Math.pow(tX - tXN, 2.0) + Math.pow(tY - tYN, 2.0) + Math.pow(tZ - tZN, 2.0)));
                        teslaCoil.eTeslaMap.put(mte, tOffset);
                        for (Map.Entry<IGregTechTileEntity, Integer> entry : this.eTeslaMap.entrySet()) {
                            IGregTechTileEntity nodeN = entry.getKey();
                            if (nodeN == node) continue;
                            tXN = nodeN.getXCoord();
                            tYN = nodeN.getYCoord();
                            tZN = nodeN.getZCoord();
                            tOffset = (int)Math.ceil(Math.sqrt(Math.pow(tX - tXN, 2.0) + Math.pow(tY - tYN, 2.0) + Math.pow(tZ - tZN, 2.0)));
                            if (tOffset > 20) continue;
                            teslaCoil.eTeslaMap.put(nodeN, tOffset);
                        }
                    }
                    catch (Exception e) {
                        this.eTeslaMap.remove(Rx.getKey());
                    }
                }
            }
        }
        ++this.scanTime;
        this.scanTimeDisplay.set(this.scanTime);
        long outputVoltage = this.outputVoltageSetting.get() > 0.0 ? Math.min(this.outputVoltageMax, (long)this.outputVoltageSetting.get()) : this.outputVoltageMax;
        this.outputVoltageDisplay.set(outputVoltage);
        long outputCurrent = this.outputCurrentSetting.get() > 0.0 ? Math.min(this.outputCurrentMax, (long)this.outputCurrentSetting.get()) : this.outputCurrentMax;
        this.outputCurrentDisplay.set(0.0);
        if (this.ePowerPass) {
            float rangeFrac = (float)(-0.5 * Math.pow(energyFrac, 2.0) + 1.5 * (double)energyFrac);
            int transferRadiusTower = (int)(this.transferRadiusTowerSetting.get() * (double)this.getRangeMulti(this.mTier, this.vTier) * (double)rangeFrac);
            this.transferRadiusTowerDisplay.set(transferRadiusTower);
            int transferRadiusTransceiver = (int)(this.transferRadiusTransceiverSetting.get() * (double)this.getRangeMulti(this.mTier, this.vTier) * (double)rangeFrac);
            this.transferRadiusTransceiverDisplay.set(transferRadiusTransceiver);
            int transferRadiusCoverUltimate = (int)(this.transferRadiusCoverUltimateSetting.get() * (double)this.getRangeMulti(this.mTier, this.vTier) * (double)rangeFrac);
            this.transferRadiusCoverUltimateDisplay.set(transferRadiusCoverUltimate);
            for (Map.Entry<IGregTechTileEntity, Integer> Rx : this.eTeslaMap.entrySet()) {
                IGregTechTileEntity node2 = Rx.getKey();
                if (node2 != null) {
                    IMetaTileEntity nodeInside2 = node2.getMetaTileEntity();
                    try {
                        GT_MetaTileEntity_TeslaCoil teslaCoil;
                        GT_MetaTileEntity_TM_teslaCoil teslaTower;
                        if (nodeInside2 instanceof GT_MetaTileEntity_TM_teslaCoil && node2.isActive() ? (teslaTower = (GT_MetaTileEntity_TM_teslaCoil)nodeInside2).maxEUStore() > 0L : (nodeInside2 instanceof GT_MetaTileEntity_TeslaCoil ? (teslaCoil = (GT_MetaTileEntity_TeslaCoil)nodeInside2).getStoredEnergy()[1] > 0L : node2.getCoverBehaviorAtSide((byte)1) instanceof GT_Cover_TM_TeslaCoil && node2.getEUCapacity() > 0L)) {
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.eTeslaMap.remove(Rx.getKey());
            }
            long sparks = outputCurrent;
            while (sparks > 0L) {
                boolean overdriveToggle = this.overDriveSetting.get() > 0.0;
                boolean idle = true;
                for (Map.Entry<Object, Integer> entry : Util.entriesSortedByValues(this.eTeslaMap)) {
                    if (energyStored >= (overdriveToggle ? outputVoltage * 2L : outputVoltage)) {
                        Object nodeTesla;
                        long outputVoltageConsumption;
                        long outputVoltageInjectable;
                        IGregTechTileEntity node3 = (IGregTechTileEntity)entry.getKey();
                        IMetaTileEntity nodeInside3 = node3.getMetaTileEntity();
                        if (overdriveToggle) {
                            outputVoltageInjectable = outputVoltage;
                            outputVoltageConsumption = this.getEnergyEfficiency(outputVoltage, entry.getValue(), true);
                        } else {
                            outputVoltageInjectable = this.getEnergyEfficiency(outputVoltage, entry.getValue(), false);
                            outputVoltageConsumption = outputVoltage;
                        }
                        if (nodeInside3 instanceof GT_MetaTileEntity_TM_teslaCoil && entry.getValue() <= transferRadiusTower) {
                            nodeTesla = (GT_MetaTileEntity_TM_teslaCoil)nodeInside3;
                            if (!((GT_MetaTileEntity_TM_teslaCoil)nodeTesla).ePowerPass && nodeTesla.getEUVar() + outputVoltageInjectable <= ((GT_MetaTileEntity_TM_teslaCoil)nodeTesla).maxEUStore() / 2L) {
                                this.setEUVar(this.getEUVar() - outputVoltageConsumption);
                                node3.increaseStoredEnergyUnits(outputVoltageConsumption, true);
                                this.thaumLightning(mte, node3);
                                --sparks;
                                idle = false;
                            }
                        } else if (nodeInside3 instanceof GT_MetaTileEntity_TeslaCoil && entry.getValue() <= transferRadiusTransceiver) {
                            nodeTesla = (GT_MetaTileEntity_TeslaCoil)nodeInside3;
                            if (!((GT_MetaTileEntity_TeslaCoil)((Object)nodeTesla)).powerPassToggle && node3.injectEnergyUnits((byte)6, outputVoltageInjectable, 1L) > 0L) {
                                this.setEUVar(this.getEUVar() - outputVoltageConsumption);
                                this.thaumLightning(mte, node3);
                                --sparks;
                                idle = false;
                            }
                        } else if (node3.getCoverBehaviorAtSide((byte)1) instanceof GT_Cover_TM_TeslaCoil_Ultimate && entry.getValue() <= transferRadiusCoverUltimate && node3.injectEnergyUnits((byte)1, outputVoltageInjectable, 1L) > 0L) {
                            this.setEUVar(this.getEUVar() - outputVoltageConsumption);
                            this.thaumLightning(mte, node3);
                            --sparks;
                            idle = false;
                        }
                        if (sparks != 0L) continue;
                        break;
                    }
                    idle = true;
                    break;
                }
                if (!idle) continue;
                break;
            }
            this.outputCurrentDisplay.set(outputCurrent - sparks);
            if (this.scanTime % 60 == 0 && !sparkList.isEmpty()) {
                NetworkDispatcher.INSTANCE.sendToAllAround(new RendererMessage.RendererData(sparkList), mte.getWorld().field_73011_w.field_76574_g, mte.getXCoord(), mte.getYCoord(), mte.getZCoord(), 256.0);
            }
            sparkList.clear();
        } else {
            this.outputCurrentDisplay.set(0.0);
        }
        return true;
    }

    @Override
    public long maxEUStore() {
        return this.energyCapacity * 2L;
    }

    private boolean addCapacitorToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Capacitor) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eCapacitorHatches.add((GT_MetaTileEntity_Hatch_Capacitor)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eEnergyMulti.add((GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eDynamoMulti.add((GT_MetaTileEntity_Hatch_DynamoMulti)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Param) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eParamHatches.add((GT_MetaTileEntity_Hatch_Param)aMetaTileEntity);
        }
        return false;
    }

    private boolean addFrameToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return aTileEntity != null && aTileEntity.getMetaTileEntity() instanceof GT_MetaPipeEntity_Frame;
    }

    @Override
    public void construct(ItemStack stackSize, boolean hintsOnly) {
        Structure.builder(shape, blockType, blockMetas[(stackSize.field_77994_a - 1) % 6], 3, 16, 0, this.getBaseMetaTileEntity(), this.getExtendedFacing(), hintsOnly);
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    static {
        shape = new String[][]{{"\u000f", "A  .  "}, {"", "B000", "B000", "B000", "\u0001", "B000", "", "B000", "", "B000", "", "B000", "\u0001", "B111", " 22222 "}, {"B000", "A00000", "A00000", "A00000", "B000", "", "A0A!A0", "", "A0A!A0", "", "A0A!A0", "", "A0A!A0", "\u0001", "A1C1", " 21112 "}, {"B000", "A00000", "A00000", "A00000", "B030", "C3", "A0!3!0", "C3", "A0!3!0", "C3", "A0!3!0", "C3", "A0!3!0", "C3", "C3", "A1A3A1", " 21212 "}, {"B000", "A00000", "A00000", "A00000", "B000", "", "A0A!A0", "", "A0A!A0", "", "A0A!A0", "", "A0A!A0", "\u0001", "A1C1", " 21112 "}, {"", "B000", "B000", "B000", "\u0001", "B000", "", "B000", "", "B000", "", "B000", "\u0001", "B111", " 22222 "}, {"\u000f", "A     "}};
        blockType = new Block[]{TT_Container_Casings.sBlockCasingsBA0, TT_Container_Casings.sBlockCasingsBA0, TT_Container_Casings.sBlockCasingsBA0, TT_Container_Casings.sBlockCasingsBA0};
        blockMetaT0 = new byte[]{7, 0, 6, 8};
        blockMetaT1 = new byte[]{7, 1, 6, 8};
        blockMetaT2 = new byte[]{7, 2, 6, 8};
        blockMetaT3 = new byte[]{7, 3, 6, 8};
        blockMetaT4 = new byte[]{7, 4, 6, 8};
        blockMetaT5 = new byte[]{7, 5, 6, 8};
        blockMetas = new byte[][]{blockMetaT0, blockMetaT1, blockMetaT2, blockMetaT3, blockMetaT4, blockMetaT5};
        addingMethods = Structure.adders(GT_MetaTileEntity_TM_teslaCoil::addCapacitorToMachineList, GT_MetaTileEntity_TM_teslaCoil::addFrameToMachineList);
        casingTextures = new short[]{1046, 0};
        blockTypeFallback = new Block[]{TT_Container_Casings.sBlockCasingsBA0, null};
        blockMetaFallback = new byte[]{6, 0};
        description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.hint.1")};
        HYSTERESIS_LOW_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.0");
        HYSTERESIS_HIGH_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.1");
        TRANSFER_RADIUS_TOWER_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.2");
        TRANSFER_RADIUS_TRANSCEIVER_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.3");
        TRANSFER_RADIUS_COVER_ULTIMATE_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.4");
        OUTPUT_VOLTAGE_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.5");
        OUTPUT_CURRENT_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.6");
        SCAN_TIME_MIN_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.7");
        OVERDRIVE_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.8");
        POPOGA_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.9");
        TRANSFER_RADIUS_TOWER_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.0");
        TRANSFER_RADIUS_TRANSCEIVER_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.1");
        TRANSFER_RADIUS_COVER_ULTIMATE_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.2");
        OUTPUT_VOLTAGE_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.3");
        OUTPUT_CURRENT_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.4");
        ENERGY_CAPACITY_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.5");
        ENERGY_STORED_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.6");
        ENERGY_FRACTION_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.7");
        SCAN_TIME_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.8");
        HYSTERESIS_LOW_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if (value <= 0.05) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value > base.histHighSetting.get()) {
                return LedStatus.STATUS_TOO_HIGH;
            }
            return LedStatus.STATUS_OK;
        };
        HYSTERESIS_HIGH_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if (value <= base.histLowSetting.get()) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value > 0.95) {
                return LedStatus.STATUS_TOO_HIGH;
            }
            return LedStatus.STATUS_OK;
        };
        TRANSFER_RADIUS_TOWER_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) < 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value > 40.0) {
                return LedStatus.STATUS_TOO_HIGH;
            }
            if (value < 32.0) {
                return LedStatus.STATUS_LOW;
            }
            return LedStatus.STATUS_OK;
        };
        TRANSFER_RADIUS_TRANSCEIVER_OR_COVER_ULTIMATE_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) < 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value > 20.0) {
                return LedStatus.STATUS_TOO_HIGH;
            }
            if (value < 16.0) {
                return LedStatus.STATUS_LOW;
            }
            return LedStatus.STATUS_OK;
        };
        OUTPUT_VOLTAGE_OR_CURRENT_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((long)value)) == -1.0) {
                return LedStatus.STATUS_OK;
            }
            if (value <= 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            return LedStatus.STATUS_OK;
        };
        SCAN_TIME_MIN_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) < 100.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value == 100.0) {
                return LedStatus.STATUS_OK;
            }
            return LedStatus.STATUS_HIGH;
        };
        OVERDRIVE_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) < 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value == 0.0) {
                return LedStatus.STATUS_LOW;
            }
            return LedStatus.STATUS_HIGH;
        };
        POPOGA_STATUS = (base, p) -> {
            if (base.getBaseMetaTileEntity().getWorld().func_72911_I()) {
                return LedStatus.STATUS_WTF;
            }
            return LedStatus.STATUS_NEUTRAL;
        };
        SCAN_TIME_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) == 0.0 || value == 20.0 || value == 40.0 || value == 60.0 || value == 80.0) {
                return LedStatus.STATUS_HIGH;
            }
            return LedStatus.STATUS_LOW;
        };
        POWER_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((long)value)) > 0.0) {
                return LedStatus.STATUS_OK;
            }
            return LedStatus.STATUS_LOW;
        };
        ENERGY_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if (base.energyFractionDisplay.get() > base.histHighSetting.get()) {
                return LedStatus.STATUS_HIGH;
            }
            if (base.energyFractionDisplay.get() < base.histLowSetting.get()) {
                return LedStatus.STATUS_LOW;
            }
            return LedStatus.STATUS_OK;
        };
    }
}

