/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.mechanics.constructable.IConstructable;
import com.github.technus.tectech.mechanics.structure.Structure;
import com.github.technus.tectech.mechanics.structure.adders.IHatchAdder;
import com.github.technus.tectech.recipe.TT_recipe;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_Holder;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.util.CommonValues;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GT_MetaTileEntity_EM_research
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private final ArrayList<GT_MetaTileEntity_Hatch_Holder> eHolders = new ArrayList();
    private GT_Recipe.GT_Recipe_AssemblyLine tRecipe;
    private TT_recipe.TT_assLineRecipe aRecipe;
    private String machineType;
    private ItemStack holdItem;
    private long computationRemaining;
    private long computationRequired;
    private static LinkedHashMap<String, String> lServerNames;
    private String clientLocale = "en_US";
    private static final String[][] shape;
    private static final Block[] blockType;
    private static final byte[] blockMeta;
    private static final IHatchAdder<GT_MetaTileEntity_EM_research>[] addingMethods;
    private static final short[] casingTextures;
    private static final Block[] blockTypeFallback;
    private static final byte[] blockMetaFallback;
    private static final String[] description;

    public GT_MetaTileEntity_EM_research(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_research(String aName) {
        super(aName);
    }

    private void makeStick() {
        int i;
        int i2;
        this.mInventory[1].func_77982_d(new NBTTagCompound());
        this.mInventory[1].func_151001_c(GT_LanguageManager.getTranslation((String)this.tRecipe.mOutput.func_82833_r()) + " Construction Data");
        GT_Utility.ItemNBT.setBookTitle((ItemStack)this.mInventory[1], (String)(GT_LanguageManager.getTranslation((String)this.tRecipe.mOutput.func_82833_r()) + " Construction Data"));
        NBTTagCompound tNBT = this.mInventory[1].func_77978_p();
        tNBT.func_74782_a("output", (NBTBase)this.tRecipe.mOutput.func_77955_b(new NBTTagCompound()));
        tNBT.func_74768_a("time", this.tRecipe.mDuration);
        tNBT.func_74768_a("eu", this.tRecipe.mEUt);
        for (i2 = 0; i2 < this.tRecipe.mInputs.length; ++i2) {
            tNBT.func_74782_a(String.valueOf(i2), (NBTBase)this.tRecipe.mInputs[i2].func_77955_b(new NBTTagCompound()));
        }
        for (i2 = 0; i2 < this.tRecipe.mFluidInputs.length; ++i2) {
            tNBT.func_74782_a("f" + i2, (NBTBase)this.tRecipe.mFluidInputs[i2].writeToNBT(new NBTTagCompound()));
        }
        tNBT.func_74778_a("author", EnumChatFormatting.BLUE + "Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.WHITE + " Assembling Line Recipe Generator");
        NBTTagList tNBTList = new NBTTagList();
        tNBTList.func_74742_a((NBTBase)new NBTTagString("Construction plan for " + this.tRecipe.mOutput.field_77994_a + ' ' + GT_LanguageManager.getTranslation((String)this.tRecipe.mOutput.func_82833_r()) + ". Needed EU/t: " + this.tRecipe.mEUt + " Production time: " + this.tRecipe.mDuration / 20));
        for (i = 0; i < this.tRecipe.mInputs.length; ++i) {
            if (this.tRecipe.mInputs[i] == null) continue;
            tNBTList.func_74742_a((NBTBase)new NBTTagString("Input Bus " + (i + 1) + ": " + this.tRecipe.mInputs[i].field_77994_a + ' ' + GT_LanguageManager.getTranslation((String)this.tRecipe.mInputs[i].func_82833_r())));
        }
        for (i = 0; i < this.tRecipe.mFluidInputs.length; ++i) {
            if (this.tRecipe.mFluidInputs[i] == null) continue;
            tNBTList.func_74742_a((NBTBase)new NBTTagString("Input Hatch " + (i + 1) + ": " + this.tRecipe.mFluidInputs[i].amount + "L " + GT_LanguageManager.getTranslation((String)this.tRecipe.mFluidInputs[i].getLocalizedName())));
        }
        tNBT.func_74782_a("pages", (NBTBase)tNBTList);
    }

    private void makeStick2() {
        int i;
        int i2;
        String s = this.tRecipe.mOutput.func_82833_r();
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (lServerNames != null) {
                s = lServerNames.get(this.tRecipe.mOutput.func_82833_r());
                if (s == null) {
                    s = this.tRecipe.mOutput.func_82833_r();
                }
            } else {
                s = this.tRecipe.mOutput.func_82833_r();
            }
        }
        this.mInventory[1].func_77982_d(new NBTTagCompound());
        this.mInventory[1].func_151001_c(s + " Construction Data");
        GT_Utility.ItemNBT.setBookTitle((ItemStack)this.mInventory[1], (String)(s + " Construction Data"));
        NBTTagCompound tNBT = this.mInventory[1].func_77978_p();
        tNBT.func_74782_a("output", (NBTBase)this.tRecipe.mOutput.func_77955_b(new NBTTagCompound()));
        tNBT.func_74768_a("time", this.tRecipe.mDuration);
        tNBT.func_74768_a("eu", this.tRecipe.mEUt);
        for (i2 = 0; i2 < this.tRecipe.mInputs.length; ++i2) {
            tNBT.func_74782_a("" + i2, (NBTBase)this.tRecipe.mInputs[i2].func_77955_b(new NBTTagCompound()));
        }
        for (i2 = 0; i2 < this.tRecipe.mOreDictAlt.length; ++i2) {
            if (this.tRecipe.mOreDictAlt[i2] == null || this.tRecipe.mOreDictAlt[i2].length <= 0) continue;
            tNBT.func_74768_a("a" + i2, this.tRecipe.mOreDictAlt[i2].length);
            for (int j = 0; j < this.tRecipe.mOreDictAlt[i2].length; ++j) {
                tNBT.func_74782_a("a" + i2 + ":" + j, (NBTBase)this.tRecipe.mOreDictAlt[i2][j].func_77955_b(new NBTTagCompound()));
            }
        }
        for (i2 = 0; i2 < this.tRecipe.mFluidInputs.length; ++i2) {
            tNBT.func_74782_a("f" + i2, (NBTBase)this.tRecipe.mFluidInputs[i2].writeToNBT(new NBTTagCompound()));
        }
        tNBT.func_74778_a("author", EnumChatFormatting.BLUE + "Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.WHITE + ' ' + this.machineType + " Recipe Generator");
        NBTTagList tNBTList = new NBTTagList();
        s = this.tRecipe.mOutput.func_82833_r();
        if (this.getBaseMetaTileEntity().isServerSide() && (s = lServerNames.get(this.tRecipe.mOutput.func_82833_r())) == null) {
            s = this.tRecipe.mOutput.func_82833_r();
        }
        tNBTList.func_74742_a((NBTBase)new NBTTagString("Construction plan for " + this.tRecipe.mOutput.field_77994_a + " " + s + ". Needed EU/t: " + this.tRecipe.mEUt + " Production time: " + this.tRecipe.mDuration / 20));
        for (i = 0; i < this.tRecipe.mInputs.length; ++i) {
            if (this.tRecipe.mOreDictAlt[i] != null) {
                int count = 0;
                StringBuilder tBuilder = new StringBuilder("Input Bus " + (i + 1) + ": ");
                for (ItemStack tStack : this.tRecipe.mOreDictAlt[i]) {
                    if (tStack == null) continue;
                    s = tStack.func_82833_r();
                    if (this.getBaseMetaTileEntity().isServerSide() && (s = lServerNames.get(tStack.func_82833_r())) == null) {
                        s = tStack.func_82833_r();
                    }
                    tBuilder.append(count == 0 ? "" : "\nOr ").append(tStack.field_77994_a).append(" ").append(s);
                    ++count;
                }
                if (count <= 0) continue;
                tNBTList.func_74742_a((NBTBase)new NBTTagString(tBuilder.toString()));
                continue;
            }
            if (this.tRecipe.mInputs[i] == null) continue;
            s = this.tRecipe.mInputs[i].func_82833_r();
            if (this.getBaseMetaTileEntity().isServerSide() && (s = lServerNames.get(this.tRecipe.mInputs[i].func_82833_r())) == null) {
                s = this.tRecipe.mInputs[i].func_82833_r();
            }
            tNBTList.func_74742_a((NBTBase)new NBTTagString("Input Bus " + (i + 1) + ": " + this.tRecipe.mInputs[i].field_77994_a + " " + s));
        }
        for (i = 0; i < this.tRecipe.mFluidInputs.length; ++i) {
            if (this.tRecipe.mFluidInputs[i] == null) continue;
            s = this.tRecipe.mFluidInputs[i].getLocalizedName();
            if (this.getBaseMetaTileEntity().isServerSide() && (s = lServerNames.get(this.tRecipe.mFluidInputs[i].getLocalizedName())) == null) {
                s = this.tRecipe.mFluidInputs[i].getLocalizedName();
            }
            tNBTList.func_74742_a((NBTBase)new NBTTagString("Input Hatch " + (i + 1) + ": " + this.tRecipe.mFluidInputs[i].amount + "L " + s));
        }
        tNBT.func_74782_a("pages", (NBTBase)tNBTList);
        this.mInventory[1].func_77982_d(tNBT);
    }

    private boolean iterateRecipes() {
        for (GT_Recipe ttRecipe : TT_recipe.GT_Recipe_MapTT.sResearchableFakeRecipes.mRecipeList) {
            if (!GT_Utility.areStacksEqual((ItemStack)ttRecipe.mInputs[0], (ItemStack)this.holdItem, (boolean)true)) continue;
            this.computationRequired = this.computationRemaining = (long)ttRecipe.mDuration * 20L;
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            this.eRequiredData = (short)(ttRecipe.mSpecialValue >>> 16);
            this.eAmpereFlow = (short)(ttRecipe.mSpecialValue & 0xFFFF);
            this.mEUt = ttRecipe.mEUt;
            this.eHolders.get(0).getBaseMetaTileEntity().setActive(true);
            return true;
        }
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_research(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        for (GT_MetaTileEntity_Hatch_Holder rack : this.eHolders) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(false);
        }
        this.eHolders.clear();
        if (!this.structureCheck_EM(shape, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 3, 4)) {
            return false;
        }
        for (GT_MetaTileEntity_Hatch_Holder rack : this.eHolders) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(iGregTechTileEntity.isActive());
        }
        return this.eHolders.size() == 1;
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        this.tRecipe = null;
        this.aRecipe = null;
        if (!this.eHolders.isEmpty() && this.eHolders.get((int)0).mInventory[0] != null) {
            this.holdItem = this.eHolders.get((int)0).mInventory[0].func_77946_l();
            if (ItemList.Tool_DataStick.isStackEqual((Object)itemStack, false, true)) {
                for (GT_Recipe.GT_Recipe_AssemblyLine assRecipe : TT_recipe.GT_Recipe_MapTT.sAssemblylineRecipes) {
                    if (!GT_Utility.areStacksEqual((ItemStack)assRecipe.mResearchItem, (ItemStack)this.holdItem, (boolean)true)) continue;
                    this.tRecipe = assRecipe;
                    if (!this.iterateRecipes()) continue;
                    return true;
                }
            } else if (ItemList.Tool_DataOrb.isStackEqual((Object)itemStack, false, true)) {
                for (TT_recipe.TT_assLineRecipe assRecipeTT : TT_recipe.TT_Recipe_Map.sMachineRecipes.recipeList()) {
                    if (!GT_Utility.areStacksEqual((ItemStack)assRecipeTT.mResearchItem, (ItemStack)this.holdItem, (boolean)true)) continue;
                    this.aRecipe = assRecipeTT;
                    this.machineType = "EM Machinery";
                    if (!this.iterateRecipes()) continue;
                    return true;
                }
                for (TT_recipe.TT_assLineRecipe assRecipeTT : TT_recipe.TT_Recipe_Map.sCrafterRecipes.recipeList()) {
                    if (!GT_Utility.areStacksEqual((ItemStack)assRecipeTT.mResearchItem, (ItemStack)this.holdItem, (boolean)true)) continue;
                    this.aRecipe = assRecipeTT;
                    this.machineType = "EM Crafting";
                    if (!this.iterateRecipes()) continue;
                    return true;
                }
            }
        }
        this.holdItem = null;
        this.computationRemaining = 0L;
        this.computationRequired = 0L;
        for (GT_MetaTileEntity_Hatch_Holder r : this.eHolders) {
            r.getBaseMetaTileEntity().setActive(false);
        }
        return false;
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (!this.eHolders.isEmpty()) {
            if (this.tRecipe != null && ItemList.Tool_DataStick.isStackEqual((Object)this.mInventory[1], false, true)) {
                this.eHolders.get(0).getBaseMetaTileEntity().setActive(false);
                this.eHolders.get((int)0).mInventory[0] = null;
                if (lServerNames == null) {
                    this.makeStick();
                } else {
                    try {
                        this.makeStick2();
                    }
                    catch (NoSuchFieldError e) {
                        this.makeStick();
                    }
                }
            } else if (this.aRecipe != null && ItemList.Tool_DataOrb.isStackEqual((Object)this.mInventory[1], false, true)) {
                this.eHolders.get(0).getBaseMetaTileEntity().setActive(false);
                this.eHolders.get((int)0).mInventory[0] = null;
                this.mInventory[1].func_151001_c(GT_LanguageManager.getTranslation((String)this.aRecipe.mOutputs[0].func_82833_r()) + ' ' + this.machineType + " Construction Data");
                NBTTagCompound tNBT = this.mInventory[1].func_77978_p();
                tNBT.func_74778_a("eMachineType", this.machineType);
                GameRegistry.UniqueIdentifier uid = GameRegistry.findUniqueIdentifierFor((Item)this.aRecipe.mOutputs[0].func_77973_b());
                tNBT.func_74778_a("eRecipeID", uid + ":" + this.aRecipe.mOutputs[0].func_77960_j());
                tNBT.func_74778_a("author", EnumChatFormatting.BLUE + "Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.WHITE + ' ' + this.machineType + " Recipe Generator");
            }
        }
        this.computationRemaining = 0L;
        this.computationRequired = 0L;
        this.tRecipe = null;
        this.aRecipe = null;
        this.holdItem = null;
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.0"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.0")};
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (Object tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        for (Object tHatch : this.eEnergyMulti) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.Energy_Hatches", (Object[])new Object[]{this.clientLocale}) + ":", EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + maxEnergy + EnumChatFormatting.RESET + " EU", (this.mEUt <= 0 ? StatCollector.func_74837_a((String)"tt.keyphrase.Probably_uses", (Object[])new Object[]{this.clientLocale}) + ": " : StatCollector.func_74837_a((String)"tt.keyphrase.Probably_makes", (Object[])new Object[]{this.clientLocale}) + ": ") + EnumChatFormatting.RED + Math.abs(this.mEUt) + EnumChatFormatting.RESET + " EU/t " + StatCollector.func_74837_a((String)"tt.keyword.at", (Object[])new Object[]{this.clientLocale}) + " " + EnumChatFormatting.RED + this.eAmpereFlow + EnumChatFormatting.RESET + " A", StatCollector.func_74837_a((String)"tt.keyphrase.Tier_Rating", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.YELLOW + CommonValues.VN[this.getMaxEnergyInputTier_EM()] + EnumChatFormatting.RESET + " / " + EnumChatFormatting.GREEN + CommonValues.VN[this.getMinEnergyInputTier_EM()] + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyphrase.Amp_Rating", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.GREEN + this.eMaxAmpereFlow + EnumChatFormatting.RESET + " A", StatCollector.func_74837_a((String)"tt.keyword.Problems", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyword.Efficiency", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74837_a((String)"tt.keyword.PowerPass", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.BLUE + this.ePowerPass + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyword.SafeVoid", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.BLUE + this.eSafeVoid, StatCollector.func_74837_a((String)"tt.keyphrase.Computation_Available", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.GREEN + this.eAvailableData + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + this.eRequiredData + EnumChatFormatting.RESET, StatCollector.func_74837_a((String)"tt.keyphrase.Computation_Remaining", (Object[])new Object[]{this.clientLocale}) + ":", EnumChatFormatting.GREEN + Long.toString(this.computationRemaining / 20L) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + this.computationRequired / 20L};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? GT_MetaTileEntity_MultiblockBase_EM.ScreenON : GT_MetaTileEntity_MultiblockBase_EM.ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3]};
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        for (GT_MetaTileEntity_Hatch_Holder r : this.eHolders) {
            r.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    protected void extraExplosions_EM() {
        for (MetaTileEntity metaTileEntity : this.eHolders) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(CommonValues.V[9]);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("eComputationRemaining", this.computationRemaining);
        aNBT.func_74772_a("eComputationRequired", this.computationRequired);
        if (this.holdItem != null) {
            aNBT.func_74782_a("eHold", (NBTBase)this.holdItem.func_77955_b(new NBTTagCompound()));
        } else {
            aNBT.func_82580_o("eHold");
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.computationRemaining = aNBT.func_74763_f("eComputationRemaining");
        this.computationRequired = aNBT.func_74763_f("eComputationRequired");
        this.holdItem = aNBT.func_74764_b("eHold") ? ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("eHold")) : null;
    }

    @Override
    public void stopMachine() {
        super.stopMachine();
        for (GT_MetaTileEntity_Hatch_Holder r : this.eHolders) {
            r.getBaseMetaTileEntity().setActive(false);
        }
        this.computationRemaining = 0L;
        this.computationRequired = 0L;
        this.tRecipe = null;
        this.aRecipe = null;
        this.holdItem = null;
    }

    @Override
    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isServerSide() && this.computationRemaining > 0L) {
            this.aRecipe = null;
            this.tRecipe = null;
            if (this.holdItem != null) {
                if (ItemList.Tool_DataStick.isStackEqual((Object)this.mInventory[1], false, true)) {
                    for (GT_Recipe.GT_Recipe_AssemblyLine tRecipe : TT_recipe.GT_Recipe_MapTT.sAssemblylineRecipes) {
                        if (!GT_Utility.areStacksEqual((ItemStack)tRecipe.mResearchItem, (ItemStack)this.holdItem, (boolean)true)) continue;
                        this.tRecipe = tRecipe;
                        break;
                    }
                } else if (ItemList.Tool_DataOrb.isStackEqual((Object)this.mInventory[1], false, true)) {
                    for (TT_recipe.TT_assLineRecipe assRecipeTT : TT_recipe.TT_Recipe_Map.sMachineRecipes.recipeList()) {
                        if (!GT_Utility.areStacksEqual((ItemStack)assRecipeTT.mResearchItem, (ItemStack)this.holdItem, (boolean)true)) continue;
                        this.aRecipe = assRecipeTT;
                        this.machineType = "EM Machinery";
                        break;
                    }
                    if (this.aRecipe == null) {
                        for (TT_recipe.TT_assLineRecipe assRecipeTT : TT_recipe.TT_Recipe_Map.sCrafterRecipes.recipeList()) {
                            if (!GT_Utility.areStacksEqual((ItemStack)assRecipeTT.mResearchItem, (ItemStack)this.holdItem, (boolean)true)) continue;
                            this.aRecipe = assRecipeTT;
                            this.machineType = "EM Crafting";
                            break;
                        }
                    }
                }
            }
            if (this.tRecipe == null && this.aRecipe == null) {
                this.holdItem = null;
                this.computationRemaining = 0L;
                this.computationRequired = 0L;
                this.mMaxProgresstime = 0;
                this.mEfficiencyIncrease = 0;
                for (GT_MetaTileEntity_Hatch_Holder r : this.eHolders) {
                    r.getBaseMetaTileEntity().setActive(false);
                }
            }
        }
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.computationRemaining <= 0L) {
            this.computationRemaining = 0L;
            this.mProgresstime = this.mMaxProgresstime;
            return true;
        }
        this.computationRemaining -= this.eAvailableData;
        this.mProgresstime = 1;
        return super.onRunningTick(aStack);
    }

    public final boolean addHolderToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Holder) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eHolders.add((GT_MetaTileEntity_Hatch_Holder)aMetaTileEntity);
        }
        return false;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        super.onRightclick(aBaseMetaTileEntity, aPlayer);
        if (!aBaseMetaTileEntity.isClientSide() && aPlayer instanceof EntityPlayerMP) {
            try {
                EntityPlayerMP player = (EntityPlayerMP)aPlayer;
                this.clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
            }
            catch (Exception e) {
                this.clientLocale = "en_US";
            }
        } else {
            return true;
        }
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void construct(ItemStack stackSize, boolean hintsOnly) {
        Structure.builder(shape, blockType, blockMeta, 1, 3, 4, this.getBaseMetaTileEntity(), this.getExtendedFacing(), hintsOnly);
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    static {
        shape = new String[][]{{"", "000", "", "", "", "000"}, {"A0", "010", "A1", "A!", "A1", "010", "A0"}, {"A0", "010", "", "", "", "010", "A0"}, {"000", "010", "", "", "", "010", "000"}, {"000", "212", "010", "0.0", "010", "212", "000"}, {"000", "212", "111", "111", "111", "212", "000"}, {"000", "222", "   ", "   ", "   ", "222", "000"}};
        blockType = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMeta = new byte[]{1, 3, 2};
        addingMethods = Structure.adders(GT_MetaTileEntity_MultiblockBase_EM::addClassicToMachineList, GT_MetaTileEntity_EM_research::addHolderToMachineList);
        casingTextures = new short[]{1025, 1027};
        blockTypeFallback = new Block[]{TT_Container_Casings.sBlockCasingsTT, Blocks.field_150350_a};
        blockMetaFallback = new byte[]{1, 0};
        description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.hint.1")};
        try {
            Class<?> GT_Assemblyline_Server = Class.forName("gregtech.api.util.GT_Assemblyline_Server");
            lServerNames = (LinkedHashMap)GT_Assemblyline_Server.getField("lServerNames").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            lServerNames = null;
        }
    }
}

