/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.constructable.IConstructable;
import com.github.technus.tectech.mechanics.dataTransport.QuantumDataPacket;
import com.github.technus.tectech.mechanics.structure.Structure;
import com.github.technus.tectech.mechanics.structure.adders.IHatchAdder;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_InputData;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OutputData;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_Rack;
import com.github.technus.tectech.thing.metaTileEntity.multi.GT_MetaTileEntity_EM_switch;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.Util;
import com.github.technus.tectech.util.Vec3Impl;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_EM_computer
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private final ArrayList<GT_MetaTileEntity_Hatch_Rack> eRacks = new ArrayList();
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private static final String[][] front;
    private static final String[][] terminator;
    private static final String[][] cap;
    private static final String[][] slice;
    private static final Block[] blockType;
    private static final byte[] blockMeta;
    private static final IHatchAdder<GT_MetaTileEntity_EM_computer>[] addingMethods;
    private static final short[] casingTextures;
    private static final Block[] blockTypeFallback;
    private static final byte[] blockMetaFallback;
    private static final String[] description;
    protected Parameters.Group.ParameterIn overclock;
    protected Parameters.Group.ParameterIn overvolt;
    protected Parameters.Group.ParameterOut maxCurrentTemp;
    protected Parameters.Group.ParameterOut availableData;
    private static final INameFunction<GT_MetaTileEntity_EM_computer> OC_NAME;
    private static final INameFunction<GT_MetaTileEntity_EM_computer> OV_NAME;
    private static final INameFunction<GT_MetaTileEntity_EM_computer> MAX_TEMP_NAME;
    private static final INameFunction<GT_MetaTileEntity_EM_computer> COMPUTE_NAME;
    private static final IStatusFunction<GT_MetaTileEntity_EM_computer> OC_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_EM_computer> OV_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_EM_computer> MAX_TEMP_STATUS;
    private static final IStatusFunction<GT_MetaTileEntity_EM_computer> COMPUTE_STATUS;

    public GT_MetaTileEntity_EM_computer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.eCertainMode = (byte)5;
        this.eCertainStatus = (byte)-128;
    }

    public GT_MetaTileEntity_EM_computer(String aName) {
        super(aName);
        this.eCertainMode = (byte)5;
        this.eCertainStatus = (byte)-128;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_computer(this.mName);
    }

    @Override
    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0);
        this.overclock = hatch_0.makeInParameter(0, 1.0, OC_NAME, OC_STATUS);
        this.overvolt = hatch_0.makeInParameter(1, 1.0, OV_NAME, OV_STATUS);
        this.maxCurrentTemp = hatch_0.makeOutParameter(0, 0.0, MAX_TEMP_NAME, MAX_TEMP_STATUS);
        this.availableData = hatch_0.makeOutParameter(1, 0.0, COMPUTE_NAME, COMPUTE_STATUS);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        int offset;
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(false);
        }
        this.eRacks.clear();
        if (!this.structureCheck_EM(front, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 2, 0)) {
            return false;
        }
        if (!this.structureCheck_EM(cap, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 2, -1)) {
            return false;
        }
        int totalLen = 4;
        for (offset = -2; offset > -16 && this.structureCheck_EM(slice, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 2, offset); offset = (int)((byte)(offset - 1))) {
            totalLen = (byte)(totalLen + 1);
        }
        if (totalLen > 16) {
            return false;
        }
        if (!this.structureCheck_EM(cap, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 2, offset = (int)((byte)(offset + 1)))) {
            return false;
        }
        if (!this.structureCheck_EM(terminator, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 2, offset = (int)((byte)(offset - 1)))) {
            return false;
        }
        this.eCertainMode = (byte)Math.min(totalLen / 3, 5);
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(iGregTechTileEntity.isActive());
        }
        return this.eUncertainHatches.size() == 1;
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        this.parametrization.setToDefaults(false, true);
        this.eAvailableData = 0L;
        double maxTemp = 0.0;
        double overClockRatio = this.overclock.get();
        double overVoltageRatio = this.overvolt.get();
        if (Double.isNaN(overClockRatio) || Double.isNaN(overVoltageRatio)) {
            return false;
        }
        if (this.overclock.getStatus((boolean)true).isOk && this.overvolt.getStatus((boolean)true).isOk) {
            float eut = (float)CommonValues.V[8] * (float)overVoltageRatio * (float)overClockRatio;
            if (!(eut < 2.1474836E9f)) {
                this.mEUt = -((int)CommonValues.V[8]);
                return false;
            }
            this.mEUt = -((int)eut);
            int thingsActive = 0;
            for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
                int rackComputation;
                if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
                if ((double)rack.heat > maxTemp) {
                    maxTemp = rack.heat;
                }
                if ((rackComputation = rack.tickComponents((float)overClockRatio, (float)overVoltageRatio)) > 0) {
                    this.eAvailableData += (long)rackComputation;
                    thingsActive = (short)(thingsActive + 4);
                }
                rack.getBaseMetaTileEntity().setActive(true);
            }
            for (GT_MetaTileEntity_Hatch_InputData di : this.eInputData) {
                if (di.q == null) continue;
                thingsActive = (short)(thingsActive + 1);
            }
            if (thingsActive > 0 && this.eCertainStatus == 0) {
                thingsActive = (short)(thingsActive + this.eOutputData.size());
                this.eAmpereFlow = 1 + (thingsActive >> 2);
                this.mMaxProgresstime = 20;
                this.mEfficiencyIncrease = 10000;
                this.maxCurrentTemp.set(maxTemp);
                this.availableData.set(this.eAvailableData);
                return true;
            }
            this.eAvailableData = 0L;
            this.mEUt = -((int)CommonValues.V[8]);
            this.eAmpereFlow = 1L;
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            this.maxCurrentTemp.set(maxTemp);
            this.availableData.set(this.eAvailableData);
            return true;
        }
        return false;
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (!this.eOutputData.isEmpty()) {
            Vec3Impl pos = new Vec3Impl(this.getBaseMetaTileEntity());
            QuantumDataPacket pack = new QuantumDataPacket(this.eAvailableData / (long)this.eOutputData.size()).unifyTraceWith(pos);
            if (pack == null) {
                return;
            }
            for (GT_MetaTileEntity_Hatch_InputData hatch : this.eInputData) {
                if (hatch.q == null || ((QuantumDataPacket)hatch.q).contains(pos) || (pack = pack.unifyPacketWith((QuantumDataPacket)hatch.q)) != null) continue;
                return;
            }
            for (GT_MetaTileEntity_Hatch_OutputData o : this.eOutputData) {
                o.q = pack;
            }
        }
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, Util.intBitsToString(TecTech.RANDOM.nextInt()), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.desc")};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_COMPUTER");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_COMPUTER_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3]};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getActivitySound() {
        return GT_MetaTileEntity_EM_switch.activitySound;
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    protected void extraExplosions_EM() {
        for (MetaTileEntity metaTileEntity : this.eRacks) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(CommonValues.V[9]);
        }
    }

    @Override
    protected long getAvailableData_EM() {
        return this.eAvailableData;
    }

    @Override
    public void stopMachine() {
        super.stopMachine();
        this.eAvailableData = 0L;
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    protected void afterRecipeCheckFailed() {
        super.afterRecipeCheckFailed();
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(false);
        }
    }

    public final boolean addRackToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Rack) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eRacks.add((GT_MetaTileEntity_Hatch_Rack)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public void construct(ItemStack stackSize, boolean hintsOnly) {
        IGregTechTileEntity igt = this.getBaseMetaTileEntity();
        Structure.builder(front, blockType, blockMeta, 1, 2, 0, igt, this.getExtendedFacing(), hintsOnly);
        Structure.builder(cap, blockType, blockMeta, 1, 2, -1, igt, this.getExtendedFacing(), hintsOnly);
        int offset = -2;
        for (int rackSlices = Math.min(stackSize.field_77994_a, 12); rackSlices > 0; --rackSlices) {
            int n = offset;
            offset = (byte)(offset - 1);
            Structure.builder(slice, blockType, blockMeta, 1, 2, n, igt, this.getExtendedFacing(), hintsOnly);
        }
        int n = offset;
        offset = (byte)(offset - 1);
        Structure.builder(cap, blockType, blockMeta, 1, 2, n, igt, this.getExtendedFacing(), hintsOnly);
        Structure.builder(terminator, blockType, blockMeta, 1, 2, offset, igt, this.getExtendedFacing(), hintsOnly);
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    static {
        front = new String[][]{{"A  ", "A  ", "A. ", "A  "}};
        terminator = new String[][]{{"A  ", "A  ", "A  ", "A  "}};
        cap = new String[][]{{"-01", "A22", "A22", "-01"}};
        slice = new String[][]{{"-01", "A!2", "A!2", "-01"}};
        blockType = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMeta = new byte[]{2, 1, 3};
        addingMethods = Structure.adders(GT_MetaTileEntity_MultiblockBase_EM::addToMachineList, GT_MetaTileEntity_EM_computer::addRackToMachineList);
        casingTextures = new short[]{1025, 1027};
        blockTypeFallback = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMetaFallback = new byte[]{1, 3};
        description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.hint.1")};
        OC_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgi.0");
        OV_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgi.1");
        MAX_TEMP_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgo.0");
        COMPUTE_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgo.1");
        OC_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 0.0, 1.0, 1.0, 3.0, new double[0]);
        OV_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 0.7, 0.8, 1.2, 2.0, new double[0]);
        MAX_TEMP_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), -10000.0, 0.0, 0.0, 5000.0, new double[0]);
        COMPUTE_STATUS = (base, p) -> {
            if (base.eAvailableData < 0L) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (base.eAvailableData == 0L) {
                return LedStatus.STATUS_NEUTRAL;
            }
            return LedStatus.STATUS_OK;
        };
    }
}

