/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.structure;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.alignment.enumerable.ExtendedFacing;
import com.github.technus.tectech.mechanics.structure.IBlockPosConsumer;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import com.github.technus.tectech.mechanics.structure.IStructureElementChain;
import com.github.technus.tectech.mechanics.structure.IStructureElementDeferred;
import com.github.technus.tectech.mechanics.structure.IStructureElementNoPlacement;
import com.github.technus.tectech.mechanics.structure.IStructureNavigate;
import com.github.technus.tectech.mechanics.structure.adders.IBlockAdder;
import com.github.technus.tectech.mechanics.structure.adders.IHatchAdder;
import com.github.technus.tectech.mechanics.structure.adders.ITileAdder;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.util.Vec3Impl;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class StructureUtility {
    private static final String NICE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz=|!@#$%&()[]{};:<>/?_,.*^'`";
    private static final Map<Vec3Impl, IStructureNavigate> STEP = new HashMap<Vec3Impl, IStructureNavigate>();
    private static final IStructureElement AIR = new IStructureElement(){

        public boolean check(Object t, World world, int x, int y, int z) {
            return world.func_147439_a(x, y, z).func_149688_o() == Material.field_151579_a;
        }

        public boolean spawnHint(Object o, World world, int x, int y, int z, ItemStack trigger) {
            TecTech.proxy.hint_particle(world, x, y, z, TT_Container_Casings.sHintCasingsTT, 13);
            return true;
        }

        public boolean placeBlock(Object o, World world, int x, int y, int z, ItemStack trigger) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            return false;
        }
    };
    private static final IStructureElement NOT_AIR = new IStructureElement(){

        public boolean check(Object t, World world, int x, int y, int z) {
            return world.func_147439_a(x, y, z).func_149688_o() != Material.field_151579_a;
        }

        public boolean spawnHint(Object o, World world, int x, int y, int z, ItemStack trigger) {
            TecTech.proxy.hint_particle(world, x, y, z, TT_Container_Casings.sHintCasingsTT, 14);
            return true;
        }

        public boolean placeBlock(Object o, World world, int x, int y, int z, ItemStack trigger) {
            world.func_147465_d(x, y, z, TT_Container_Casings.sHintCasingsTT, 14, 2);
            return true;
        }
    };
    private static final IStructureElement ERROR = new IStructureElement(){

        public boolean check(Object t, World world, int x, int y, int z) {
            return false;
        }

        public boolean spawnHint(Object o, World world, int x, int y, int z, ItemStack trigger) {
            TecTech.proxy.hint_particle(world, x, y, z, TT_Container_Casings.sHintCasingsTT, 15);
            return true;
        }

        public boolean placeBlock(Object o, World world, int x, int y, int z, ItemStack trigger) {
            return true;
        }
    };

    private StructureUtility() {
    }

    public static <T> IStructureElement<T> isAir() {
        return AIR;
    }

    public static <T> IStructureElement<T> notAir() {
        return NOT_AIR;
    }

    public static <T> IStructureElement<T> error() {
        return ERROR;
    }

    public static <T> IStructureElementNoPlacement<T> ofHint(int dots) {
        final int meta = dots - 1;
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, TT_Container_Casings.sHintCasingsTT, meta);
                return false;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofHintDeferred(final Supplier<IIcon[]> icons) {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, (IIcon[])icons.get());
                return false;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofHintDeferred(final Supplier<IIcon[]> icons, final short[] RGBa) {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle_tinted(world, x, y, z, (IIcon[])icons.get(), RGBa);
                return false;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofBlocksFlatHint(final Map<Block, Integer> blocsMap, final Block hintBlock, final int hintMeta) {
        if (blocsMap == null || blocsMap.isEmpty() || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return blocsMap.getOrDefault(world.func_147439_a(x, y, z), -1).intValue() == world.func_72805_g(x, y, z);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofBlocksMapHint(final Map<Block, Set<Integer>> blocsMap, final Block hintBlock, final int hintMeta) {
        if (blocsMap == null || blocsMap.isEmpty() || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        for (Set<Integer> value : blocsMap.values()) {
            if (!value.isEmpty()) continue;
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return blocsMap.getOrDefault(world.func_147439_a(x, y, z), Collections.emptySet()).contains(world.func_72805_g(x, y, z));
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofBlockHint(final Block block, final int meta, final Block hintBlock, final int hintMeta) {
        if (block == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return block == world.func_147439_a(x, y, z) && meta == world.func_72805_g(x, y, z);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofBlockHint(Block block, int meta) {
        return StructureUtility.ofBlockHint(block, meta, block, meta);
    }

    public static <T> IStructureElementNoPlacement<T> ofBlockAdderHint(final IBlockAdder<T> iBlockAdder, final Block hintBlock, final int hintMeta) {
        if (iBlockAdder == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return iBlockAdder.apply(t, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlocksFlat(final Map<Block, Integer> blocsMap, final Block defaultBlock, final int defaultMeta) {
        if (blocsMap == null || blocsMap.isEmpty() || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return blocsMap.getOrDefault(world.func_147439_a(x, y, z), -1).intValue() == world.func_72805_g(x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, defaultBlock, defaultMeta, 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, defaultBlock, defaultMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlocksMap(final Map<Block, Set<Integer>> blocsMap, final Block defaultBlock, final int defaultMeta) {
        if (blocsMap == null || blocsMap.isEmpty() || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        for (Set<Integer> value : blocsMap.values()) {
            if (!value.isEmpty()) continue;
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return blocsMap.getOrDefault(world.func_147439_a(x, y, z), Collections.emptySet()).contains(world.func_72805_g(x, y, z));
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, defaultBlock, defaultMeta, 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, defaultBlock, defaultMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlock(final Block block, final int meta, final Block defaultBlock, final int defaultMeta) {
        if (block == null || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return block == world.func_147439_a(x, y, z) && meta == world.func_72805_g(x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, defaultBlock, defaultMeta, 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, defaultBlock, defaultMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlock(Block block, int meta) {
        return StructureUtility.ofBlock(block, meta, block, meta);
    }

    public static <T> IStructureElement<T> ofBlockAdder(final IBlockAdder<T> iBlockAdder, final Block defaultBlock, final int defaultMeta) {
        if (iBlockAdder == null || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return iBlockAdder.apply(t, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, defaultBlock, defaultMeta, 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, defaultBlock, defaultMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlockAdder(IBlockAdder<T> iBlockAdder, int dots) {
        return StructureUtility.ofBlockAdder(iBlockAdder, TT_Container_Casings.sHintCasingsTT, dots - 1);
    }

    public static <T> IStructureElementNoPlacement<T> ofTileAdder(final ITileAdder<T> iTileAdder, final Block hintBlock, final int hintMeta) {
        if (iTileAdder == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return tileEntity instanceof IGregTechTileEntity && iTileAdder.apply(t, tileEntity);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofHatchAdder(IHatchAdder<T> iHatchAdder, int textureIndex, int dots) {
        return StructureUtility.ofHatchAdder(iHatchAdder, textureIndex, TT_Container_Casings.sHintCasingsTT, dots - 1);
    }

    public static <T> IStructureElementNoPlacement<T> ofHatchAdder(final IHatchAdder<T> iHatchAdder, final int textureIndex, final Block hintBlock, final int hintMeta) {
        if (iHatchAdder == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return tileEntity instanceof IGregTechTileEntity && iHatchAdder.apply(t, (IGregTechTileEntity)tileEntity, (short)textureIndex);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofHatchAdderOptional(IHatchAdder<T> iHatchAdder, int textureIndex, int dots, Block placeCasing, int placeCasingMeta) {
        return StructureUtility.ofHatchAdderOptional(iHatchAdder, textureIndex, TT_Container_Casings.sHintCasingsTT, dots - 1, placeCasing, placeCasingMeta);
    }

    public static <T> IStructureElement<T> ofHatchAdderOptional(final IHatchAdder<T> iHatchAdder, final int textureIndex, final Block hintBlock, final int hintMeta, final Block placeCasing, final int placeCasingMeta) {
        if (iHatchAdder == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return tileEntity instanceof IGregTechTileEntity && iHatchAdder.apply(t, (IGregTechTileEntity)tileEntity, (short)textureIndex) || world.func_147439_a(x, y, z) == placeCasing && world.func_72805_g(x, y, z) == placeCasingMeta;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                TecTech.proxy.hint_particle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, placeCasing, placeCasingMeta, 2);
                return true;
            }
        };
    }

    public static <B extends IStructureElement<T>, T> IStructureElement<T> onElementPass(final Consumer<T> onCheckPass, final B element) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                boolean check = element.check(t, world, x, y, z);
                if (check) {
                    onCheckPass.accept(t);
                }
                return check;
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return element.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return element.spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <B extends IStructureElement<T>, T> IStructureElement<T> onElementFail(final Consumer<T> onFail, final B element) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                boolean check = element.check(t, world, x, y, z);
                if (!check) {
                    onFail.accept(t);
                }
                return check;
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return element.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return element.spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    @SafeVarargs
    public static <T> IStructureElementChain<T> ofChain(IStructureElement<T> ... elementChain) {
        if (elementChain == null || elementChain.length == 0) {
            throw new IllegalArgumentException();
        }
        for (IStructureElement<T> iStructureElement : elementChain) {
            if (iStructureElement != null) continue;
            throw new IllegalArgumentException();
        }
        return () -> elementChain;
    }

    public static <T> IStructureElementChain<T> ofChain(List<IStructureElement<T>> elementChain) {
        return StructureUtility.ofChain(elementChain.toArray(new IStructureElement[0]));
    }

    public static <T> IStructureElementDeferred<T> defer(final Supplier<IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)to.get()).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.get()).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.get()).spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <T> IStructureElementDeferred<T> defer(final Function<T, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)to.apply(t)).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t)).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t)).spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <T, K> IStructureElementDeferred<T> defer(final Function<T, K> keyExtractor, final Map<K, IStructureElement<T>> map) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)map.get(keyExtractor.apply(t))).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)map.get(keyExtractor.apply(t))).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)map.get(keyExtractor.apply(t))).spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <T, K> IStructureElementDeferred<T> defer(final Function<T, K> keyExtractor, final Map<K, IStructureElement<T>> map, final IStructureElement<T> defaultElem) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return map.getOrDefault(keyExtractor.apply(t), defaultElem).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return map.getOrDefault(keyExtractor.apply(t), defaultElem).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return map.getOrDefault(keyExtractor.apply(t), defaultElem).spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    @SafeVarargs
    public static <T> IStructureElementDeferred<T> defer(final Function<T, Integer> keyExtractor, final IStructureElement<T> ... array) {
        if (keyExtractor == null || array == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return array[(Integer)keyExtractor.apply(t)].check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return array[(Integer)keyExtractor.apply(t)].placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return array[(Integer)keyExtractor.apply(t)].spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <T> IStructureElementDeferred<T> defer(Function<T, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.defer(keyExtractor, array.toArray(new IStructureElement[0]));
    }

    public static <T> IStructureElementDeferred<T> defer(final BiFunction<T, ItemStack, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)to.apply(t, null)).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <T, K> IStructureElementDeferred<T> defer(final BiFunction<T, ItemStack, K> keyExtractor, final Map<K, IStructureElement<T>> map) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)map.get(keyExtractor.apply(t, null))).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)map.get(keyExtractor.apply(t, trigger))).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)map.get(keyExtractor.apply(t, trigger))).spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <T, K> IStructureElementDeferred<T> defer(final BiFunction<T, ItemStack, K> keyExtractor, final Map<K, IStructureElement<T>> map, final IStructureElement<T> defaultElem) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return map.getOrDefault(keyExtractor.apply(t, null), defaultElem).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return map.getOrDefault(keyExtractor.apply(t, trigger), defaultElem).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return map.getOrDefault(keyExtractor.apply(t, trigger), defaultElem).spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    @SafeVarargs
    public static <T> IStructureElementDeferred<T> defer(final BiFunction<T, ItemStack, Integer> keyExtractor, final IStructureElement<T> ... array) {
        if (keyExtractor == null || array == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return array[(Integer)keyExtractor.apply(t, null)].check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return array[(Integer)keyExtractor.apply(t, trigger)].placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return array[(Integer)keyExtractor.apply(t, trigger)].spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <T> IStructureElementDeferred<T> defer(BiFunction<T, ItemStack, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.defer(keyExtractor, array.toArray(new IStructureElement[0]));
    }

    public static <T> IStructureElementDeferred<T> defer(final Function<T, IStructureElement<T>> toCheck, final BiFunction<T, ItemStack, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)toCheck.apply(t)).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <T, K> IStructureElementDeferred<T> defer(final Function<T, K> keyExtractorCheck, final BiFunction<T, ItemStack, K> keyExtractor, final Map<K, IStructureElement<T>> map) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)map.get(keyExtractorCheck.apply(t))).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)map.get(keyExtractor.apply(t, trigger))).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)map.get(keyExtractor.apply(t, trigger))).spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <T, K> IStructureElementDeferred<T> defer(final Function<T, K> keyExtractorCheck, final BiFunction<T, ItemStack, K> keyExtractor, final Map<K, IStructureElement<T>> map, final IStructureElement<T> defaultElem) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return map.getOrDefault(keyExtractorCheck.apply(t), defaultElem).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return map.getOrDefault(keyExtractor.apply(t, trigger), defaultElem).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return map.getOrDefault(keyExtractor.apply(t, trigger), defaultElem).spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    @SafeVarargs
    public static <T> IStructureElementDeferred<T> defer(final Function<T, Integer> keyExtractorCheck, final BiFunction<T, ItemStack, Integer> keyExtractor, final IStructureElement<T> ... array) {
        if (keyExtractor == null || array == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return array[(Integer)keyExtractorCheck.apply(t)].check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return array[(Integer)keyExtractor.apply(t, trigger)].placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return array[(Integer)keyExtractor.apply(t, trigger)].spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    public static <T> IStructureElementDeferred<T> defer(Function<T, Integer> keyExtractorCheck, BiFunction<T, ItemStack, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.defer(keyExtractorCheck, keyExtractor, array.toArray(new IStructureElement[0]));
    }

    public static <T> IStructureNavigate<T> step(int a, int b, int c) {
        return StructureUtility.step(new Vec3Impl(a, b, c));
    }

    public static <T> IStructureNavigate<T> step(Vec3Impl step) {
        if (step == null || step.get0() < 0 || step.get1() < 0 || step.get2() < 0) {
            throw new IllegalArgumentException();
        }
        return STEP.computeIfAbsent(step, vec3 -> {
            if (vec3.get2() > 0) {
                return StructureUtility.stepC(vec3.get0(), vec3.get1(), vec3.get2());
            }
            if (vec3.get1() > 0) {
                return StructureUtility.stepB(vec3.get0(), vec3.get1(), vec3.get2());
            }
            return StructureUtility.stepA(vec3.get0(), vec3.get1(), vec3.get2());
        });
    }

    private static <T> IStructureNavigate<T> stepA(final int a, final int b, final int c) {
        return new IStructureNavigate<T>(){

            @Override
            public int getStepA() {
                return a;
            }

            @Override
            public int getStepB() {
                return b;
            }

            @Override
            public int getStepC() {
                return c;
            }
        };
    }

    private static <T> IStructureNavigate<T> stepB(final int a, final int b, final int c) {
        return new IStructureNavigate<T>(){

            @Override
            public int getStepA() {
                return a;
            }

            @Override
            public int getStepB() {
                return b;
            }

            @Override
            public int getStepC() {
                return c;
            }

            @Override
            public boolean resetA() {
                return true;
            }
        };
    }

    private static <T> IStructureNavigate<T> stepC(final int a, final int b, final int c) {
        return new IStructureNavigate<T>(){

            @Override
            public int getStepA() {
                return a;
            }

            @Override
            public int getStepB() {
                return b;
            }

            @Override
            public int getStepC() {
                return c;
            }

            @Override
            public boolean resetA() {
                return true;
            }

            @Override
            public boolean resetB() {
                return true;
            }
        };
    }

    public static String getPseudoJavaCode(World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, int sizeA, int sizeB, int sizeC, boolean transpose) {
        char c;
        TreeMap blocks = new TreeMap(Comparator.comparing(Block::func_149739_a));
        TreeSet<Class> tiles = new TreeSet<Class>(Comparator.comparing(Class::getCanonicalName));
        TreeSet<Class> gtTiles = new TreeSet<Class>(Comparator.comparing(Class::getCanonicalName));
        StructureUtility.iterate(world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, sizeA, sizeB, sizeC, (w, x, y, z) -> {
            TileEntity tileEntity = w.func_147438_o(x, y, z);
            if (tileEntity == null) {
                Block block = w.func_147439_a(x, y, z);
                if (block != null && block != Blocks.field_150350_a) {
                    blocks.compute(block, (b, set) -> {
                        if (set == null) {
                            set = new TreeSet<Integer>();
                        }
                        set.add(world.func_72805_g(x, y, z));
                        return set;
                    });
                }
            } else if (tileEntity instanceof IGregTechTileEntity) {
                IMetaTileEntity meta = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
                if (meta != null) {
                    gtTiles.add(meta.getClass());
                } else {
                    tiles.add(tileEntity.getClass());
                }
            } else {
                tiles.add(tileEntity.getClass());
            }
        });
        HashMap<String, Character> map = new HashMap<String, Character>();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        builder.append("\n\nStructure:\n").append("\nBlocks:\n");
        for (Map.Entry entry : blocks.entrySet()) {
            Block block = (Block)entry.getKey();
            Set set = (Set)entry.getValue();
            for (Integer meta : set) {
                c = NICE_CHARS.charAt(i++);
                if (i > NICE_CHARS.length()) {
                    return "Too complicated for nice chars";
                }
                map.put(block.func_149739_a() + '\u0000' + meta, Character.valueOf(c));
                builder.append(c).append(" -> ofBlock...(").append(block.func_149739_a()).append(", ").append(meta).append(", ...);\n");
            }
        }
        builder.append("\nTiles:\n");
        for (Class tile : tiles) {
            c = NICE_CHARS.charAt(i++);
            if (i > NICE_CHARS.length()) {
                return "Too complicated for nice chars";
            }
            map.put(tile.getCanonicalName(), Character.valueOf(c));
            builder.append(c).append(" -> ofTileAdder(").append(tile.getCanonicalName()).append(", ...);\n");
        }
        builder.append("\nMeta:\n");
        for (Class gtTile : gtTiles) {
            c = NICE_CHARS.charAt(i++);
            if (i > NICE_CHARS.length()) {
                return "Too complicated for nice chars";
            }
            map.put(gtTile.getCanonicalName(), Character.valueOf(c));
            builder.append(c).append(" -> ofHatchAdder(").append(gtTile.getCanonicalName()).append(", textureId, ...);\n");
        }
        builder.append("\nOffsets:\n").append(basePositionA).append(' ').append(basePositionB).append(' ').append(basePositionC).append('\n');
        if (transpose) {
            builder.append("\nTransposed Scan:\n").append("new String[][]{\n").append("    {\"");
            StructureUtility.iterate(world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, true, sizeA, sizeB, sizeC, (w, x, y, z) -> {
                TileEntity tileEntity = w.func_147438_o(x, y, z);
                if (tileEntity == null) {
                    Block block = w.func_147439_a(x, y, z);
                    if (block != null && block != Blocks.field_150350_a) {
                        builder.append(map.get(block.func_149739_a() + '\u0000' + world.func_72805_g(x, y, z)));
                    } else {
                        builder.append(' ');
                    }
                } else if (tileEntity instanceof IGregTechTileEntity) {
                    IMetaTileEntity meta = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
                    if (meta != null) {
                        builder.append(map.get(meta.getClass().getCanonicalName()));
                    } else {
                        builder.append(map.get(tileEntity.getClass().getCanonicalName()));
                    }
                } else {
                    builder.append(map.get(tileEntity.getClass().getCanonicalName()));
                }
            }, () -> builder.append("\",\""), () -> {
                builder.setLength(builder.length() - 2);
                builder.append("},\n    {\"");
            });
            builder.setLength(builder.length() - 8);
            builder.append("\n}\n\n");
        } else {
            builder.append("\nNormal Scan:\n").append("new String[][]{{\n").append("    \"");
            StructureUtility.iterate(world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, false, sizeA, sizeB, sizeC, (w, x, y, z) -> {
                TileEntity tileEntity = w.func_147438_o(x, y, z);
                if (tileEntity == null) {
                    Block block = w.func_147439_a(x, y, z);
                    if (block != null && block != Blocks.field_150350_a) {
                        builder.append(map.get(block.func_149739_a() + '\u0000' + world.func_72805_g(x, y, z)));
                    } else {
                        builder.append(' ');
                    }
                } else if (tileEntity instanceof IGregTechTileEntity) {
                    IMetaTileEntity meta = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
                    if (meta != null) {
                        builder.append(map.get(meta.getClass().getCanonicalName()));
                    } else {
                        builder.append(map.get(tileEntity.getClass().getCanonicalName()));
                    }
                } else {
                    builder.append(map.get(tileEntity.getClass().getCanonicalName()));
                }
            }, () -> builder.append("\",\n").append("    \""), () -> {
                builder.setLength(builder.length() - 7);
                builder.append("\n").append("},{\n").append("    \"");
            });
            builder.setLength(builder.length() - 8);
            builder.append("}\n\n");
        }
        return builder.toString().replaceAll("\"\"", "E");
    }

    public static void iterate(World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, int sizeA, int sizeB, int sizeC, IBlockPosConsumer iBlockPosConsumer) {
        sizeA -= basePositionA;
        sizeB -= basePositionB;
        sizeC -= basePositionC;
        int[] abc = new int[3];
        int[] xyz = new int[3];
        abc[2] = -basePositionC;
        while (abc[2] < sizeC) {
            abc[1] = -basePositionB;
            while (abc[1] < sizeB) {
                abc[0] = -basePositionA;
                while (abc[0] < sizeA) {
                    extendedFacing.getWorldOffset(abc, xyz);
                    iBlockPosConsumer.consume(world, xyz[0] + basePositionX, xyz[1] + basePositionY, xyz[2] + basePositionZ);
                    abc[0] = abc[0] + 1;
                }
                abc[1] = abc[1] + 1;
            }
            abc[2] = abc[2] + 1;
        }
    }

    public static void iterate(World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean transpose, int sizeA, int sizeB, int sizeC, IBlockPosConsumer iBlockPosConsumer, Runnable nextB, Runnable nextC) {
        sizeA -= basePositionA;
        sizeB -= basePositionB;
        sizeC -= basePositionC;
        int[] abc = new int[3];
        int[] xyz = new int[3];
        if (transpose) {
            abc[1] = -basePositionB;
            while (abc[1] < sizeB) {
                abc[2] = -basePositionC;
                while (abc[2] < sizeC) {
                    abc[0] = -basePositionA;
                    while (abc[0] < sizeA) {
                        extendedFacing.getWorldOffset(abc, xyz);
                        iBlockPosConsumer.consume(world, xyz[0] + basePositionX, xyz[1] + basePositionY, xyz[2] + basePositionZ);
                        abc[0] = abc[0] + 1;
                    }
                    nextB.run();
                    abc[2] = abc[2] + 1;
                }
                nextC.run();
                abc[1] = abc[1] + 1;
            }
        } else {
            abc[2] = -basePositionC;
            while (abc[2] < sizeC) {
                abc[1] = -basePositionB;
                while (abc[1] < sizeB) {
                    abc[0] = -basePositionA;
                    while (abc[0] < sizeA) {
                        extendedFacing.getWorldOffset(abc, xyz);
                        iBlockPosConsumer.consume(world, xyz[0] + basePositionX, xyz[1] + basePositionY, xyz[2] + basePositionZ);
                        abc[0] = abc[0] + 1;
                    }
                    nextB.run();
                    abc[1] = abc[1] + 1;
                }
                nextC.run();
                abc[2] = abc[2] + 1;
            }
        }
    }

    public static String[][] transpose(String[][] structurePiece) {
        String[][] shape = new String[structurePiece[0].length][structurePiece.length];
        for (int i = 0; i < structurePiece.length; ++i) {
            for (int j = 0; j < structurePiece[i].length; ++j) {
                shape[j][i] = structurePiece[i][j];
            }
        }
        return shape;
    }
}

