/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.structure;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.alignment.enumerable.ExtendedFacing;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public interface IStructureDefinition<T> {
    public IStructureElement<T>[] getStructureFor(String var1);

    default public boolean check(T object, String piece, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean forceCheckAllBlocks) {
        return IStructureDefinition.iterate(object, null, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, false, forceCheckAllBlocks);
    }

    default public boolean hints(T object, ItemStack trigger, String piece, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC) {
        return IStructureDefinition.iterate(object, trigger, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, true, null);
    }

    default public boolean build(T object, ItemStack trigger, String piece, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC) {
        return IStructureDefinition.iterate(object, trigger, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, false, null);
    }

    default public boolean buildOrHints(T object, ItemStack trigger, String piece, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean hintsOnly) {
        return IStructureDefinition.iterate(object, trigger, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, hintsOnly, null);
    }

    public static <T> boolean iterate(T object, ItemStack trigger, IStructureElement<T>[] elements, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean hintsOnly, Boolean checkBlocksIfNotNullForceCheckAllIfTrue) {
        if (world.field_72995_K ^ hintsOnly) {
            return false;
        }
        basePositionA = -basePositionA;
        basePositionB = -basePositionB;
        basePositionC = -basePositionC;
        int[] abc = new int[]{basePositionA, basePositionB, basePositionC};
        int[] xyz = new int[3];
        if (checkBlocksIfNotNullForceCheckAllIfTrue != null) {
            if (checkBlocksIfNotNullForceCheckAllIfTrue.booleanValue()) {
                for (IStructureElement<T> element : elements) {
                    if (element.isNavigating()) {
                        abc[0] = (element.resetA() ? basePositionA : abc[0]) + element.getStepA();
                        abc[1] = (element.resetB() ? basePositionB : abc[1]) + element.getStepB();
                        abc[2] = (element.resetC() ? basePositionC : abc[2]) + element.getStepC();
                        continue;
                    }
                    extendedFacing.getWorldOffset(abc, xyz);
                    xyz[0] = xyz[0] + basePositionX;
                    xyz[1] = xyz[1] + basePositionY;
                    xyz[2] = xyz[2] + basePositionZ;
                    if (world.func_72899_e(xyz[0], xyz[1], xyz[2])) {
                        if (!element.check(object, world, xyz[0], xyz[1], xyz[2])) {
                            if (TecTechConfig.DEBUG_MODE) {
                                TecTech.LOGGER.info((Object)("Multi [" + basePositionX + ", " + basePositionY + ", " + basePositionZ + "] failed @ " + Arrays.toString(xyz) + " " + Arrays.toString(abc)));
                            }
                            return false;
                        }
                    } else {
                        if (TecTechConfig.DEBUG_MODE) {
                            TecTech.LOGGER.info((Object)("Multi [" + basePositionX + ", " + basePositionY + ", " + basePositionZ + "] !blockExists @ " + Arrays.toString(xyz) + " " + Arrays.toString(abc)));
                        }
                        return false;
                    }
                    abc[0] = abc[0] + 1;
                }
            } else {
                for (IStructureElement<T> element : elements) {
                    if (element.isNavigating()) {
                        abc[0] = (element.resetA() ? basePositionA : abc[0]) + element.getStepA();
                        abc[1] = (element.resetB() ? basePositionB : abc[1]) + element.getStepB();
                        abc[2] = (element.resetC() ? basePositionC : abc[2]) + element.getStepC();
                        continue;
                    }
                    extendedFacing.getWorldOffset(abc, xyz);
                    xyz[0] = xyz[0] + basePositionX;
                    xyz[1] = xyz[1] + basePositionY;
                    xyz[2] = xyz[2] + basePositionZ;
                    if (world.func_72899_e(xyz[0], xyz[1], xyz[2])) {
                        if (!element.check(object, world, xyz[0], xyz[1], xyz[2])) {
                            if (TecTechConfig.DEBUG_MODE) {
                                TecTech.LOGGER.info((Object)("Multi [" + basePositionX + ", " + basePositionY + ", " + basePositionZ + "] failed @ " + Arrays.toString(xyz) + " " + Arrays.toString(abc)));
                            }
                            return false;
                        }
                    } else if (TecTechConfig.DEBUG_MODE) {
                        TecTech.LOGGER.info((Object)("Multi [" + basePositionX + ", " + basePositionY + ", " + basePositionZ + "] !blockExists @ " + Arrays.toString(xyz) + " " + Arrays.toString(abc)));
                    }
                    abc[0] = abc[0] + 1;
                }
            }
        } else if (hintsOnly) {
            for (IStructureElement<T> element : elements) {
                if (element.isNavigating()) {
                    abc[0] = (element.resetA() ? basePositionA : abc[0]) + element.getStepA();
                    abc[1] = (element.resetB() ? basePositionB : abc[1]) + element.getStepB();
                    abc[2] = (element.resetC() ? basePositionC : abc[2]) + element.getStepC();
                    continue;
                }
                extendedFacing.getWorldOffset(abc, xyz);
                xyz[0] = xyz[0] + basePositionX;
                xyz[1] = xyz[1] + basePositionY;
                xyz[2] = xyz[2] + basePositionZ;
                element.spawnHint(object, world, xyz[0], xyz[1], xyz[2], trigger);
                abc[0] = abc[0] + 1;
            }
        } else {
            for (IStructureElement<T> element : elements) {
                if (element.isNavigating()) {
                    abc[0] = (element.resetA() ? basePositionA : abc[0]) + element.getStepA();
                    abc[1] = (element.resetB() ? basePositionB : abc[1]) + element.getStepB();
                    abc[2] = (element.resetC() ? basePositionC : abc[2]) + element.getStepC();
                    continue;
                }
                extendedFacing.getWorldOffset(abc, xyz);
                xyz[0] = xyz[0] + basePositionX;
                xyz[1] = xyz[1] + basePositionY;
                xyz[2] = xyz[2] + basePositionZ;
                if (world.func_72899_e(xyz[0], xyz[1], xyz[2])) {
                    element.placeBlock(object, world, xyz[0], xyz[1], xyz[2], trigger);
                }
                abc[0] = abc[0] + 1;
            }
        }
        return true;
    }
}

